/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.DataTypeConverter;
import com.prosysopc.ua.ModelException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.UaAddressSpace;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaNodeFactoryException;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.server.BrowseContinuationPoint;
import com.prosysopc.ua.server.ExternalNodeManager;
import com.prosysopc.ua.server.HistoryContinuationPoint;
import com.prosysopc.ua.server.HistoryManager;
import com.prosysopc.ua.server.HistoryResult;
import com.prosysopc.ua.server.InstanceDeclarationHierarchyCache;
import com.prosysopc.ua.server.IoManager;
import com.prosysopc.ua.server.ModelParser;
import com.prosysopc.ua.server.MonitoredDataItem;
import com.prosysopc.ua.server.MonitoredEventItem;
import com.prosysopc.ua.server.MonitoredItem;
import com.prosysopc.ua.server.NodeManager;
import com.prosysopc.ua.server.NodeManagerRoot;
import com.prosysopc.ua.server.NodeManagerTableListener;
import com.prosysopc.ua.server.PredefinedIdPair;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.StructureInfoCache;
import com.prosysopc.ua.server.Subscription;
import com.prosysopc.ua.server.UaServer;
import com.prosysopc.ua.server.nodes.UaExternalNode;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.ExtensionObject;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.common.IdentifierDescriptions;
import org.opcfoundation.ua.common.NamespaceTable;
import org.opcfoundation.ua.common.ServerTable;
import org.opcfoundation.ua.common.ServiceFaultException;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.AccessLevel;
import org.opcfoundation.ua.core.AddNodesItem;
import org.opcfoundation.ua.core.AddReferencesItem;
import org.opcfoundation.ua.core.AggregateFilterResult;
import org.opcfoundation.ua.core.Argument;
import org.opcfoundation.ua.core.BrowseDirection;
import org.opcfoundation.ua.core.BrowsePathTarget;
import org.opcfoundation.ua.core.BrowseResultMask;
import org.opcfoundation.ua.core.DataTypeAttributes;
import org.opcfoundation.ua.core.EventFilter;
import org.opcfoundation.ua.core.EventFilterResult;
import org.opcfoundation.ua.core.HistoryReadDetails;
import org.opcfoundation.ua.core.HistoryUpdateDetails;
import org.opcfoundation.ua.core.HistoryUpdateResult;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.MethodAttributes;
import org.opcfoundation.ua.core.MonitoringFilter;
import org.opcfoundation.ua.core.MonitoringParameters;
import org.opcfoundation.ua.core.NodeAttributes;
import org.opcfoundation.ua.core.NodeClass;
import org.opcfoundation.ua.core.ObjectAttributes;
import org.opcfoundation.ua.core.ObjectTypeAttributes;
import org.opcfoundation.ua.core.QueryFirstRequest;
import org.opcfoundation.ua.core.QueryFirstResponse;
import org.opcfoundation.ua.core.QueryNextRequest;
import org.opcfoundation.ua.core.QueryNextResponse;
import org.opcfoundation.ua.core.ReferenceDescription;
import org.opcfoundation.ua.core.ReferenceTypeAttributes;
import org.opcfoundation.ua.core.RelativePath;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.core.TimestampsToReturn;
import org.opcfoundation.ua.core.VariableAttributes;
import org.opcfoundation.ua.core.VariableTypeAttributes;
import org.opcfoundation.ua.core.ViewAttributes;
import org.opcfoundation.ua.core.ViewDescription;
import org.opcfoundation.ua.encoding.DecodingException;
import org.opcfoundation.ua.encoding.EncoderContext;
import org.opcfoundation.ua.encoding.EncodingException;
import org.opcfoundation.ua.utils.NumericRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class NodeManagerTable
implements UaAddressSpace {
    private static final Logger logger = LoggerFactory.getLogger(NodeManagerTable.class);
    private DataTypeConverter fn;
    private final ExternalNodeManager jy;
    private final InstanceDeclarationHierarchyCache jz = new InstanceDeclarationHierarchyCache();
    private NodeManagerTableListener jA = null;
    private boolean jB;
    private final Map<Integer, NodeManager> jC = new ConcurrentSkipListMap<Integer, NodeManager>();
    private final UaServer cp;
    private final StructureInfoCache jD = new StructureInfoCache();

    public NodeManagerTable(UaServer uaServer) {
        this.cp = uaServer;
        this.jy = new ExternalNodeManager(this);
    }

    @Override
    public void addNode(UaNode uaNode) {
        NodeManager nodeManager = this.jC.get(uaNode.getNodeId().getNamespaceIndex());
        if (nodeManager != null) {
            try {
                nodeManager.addNode(uaNode);
                return;
            }
            catch (StatusException statusException) {
                logger.error("Could not add node", (Throwable)statusException);
            }
        }
    }

    public int addNodeManager(int n2, NodeManager nodeManager) {
        String string = nodeManager.getNamespaceUri();
        int n3 = this.getNamespaceTable().getIndex(string);
        if (n3 == -1) {
            n3 = this.getNamespaceTable().add(n2, string);
        }
        this.jC.put(n3, nodeManager);
        if (this.cp.isRunning()) {
            this.cp.updateNamespaceArray();
        }
        return n3;
    }

    public void close() {
        for (NodeManager nodeManager : this.jC.values()) {
            nodeManager.close();
        }
    }

    @Override
    public UaNode findNode(NodeId nodeId) {
        if (NodeId.isNull((NodeId)nodeId)) {
            return null;
        }
        try {
            return this.getNodeManager(nodeId).findNode(nodeId);
        }
        catch (StatusException statusException) {
            return null;
        }
    }

    @Override
    public DataTypeConverter getDataTypeConverter() {
        if (this.fn == null) {
            this.fn = new DataTypeConverter(this);
        }
        return this.fn;
    }

    @Override
    public EncoderContext getEncoderContext() {
        return this.cp.getEncoderContext();
    }

    public UaNode getExternalNode(NodeId nodeId) throws StatusException {
        return this.jy.getNode(nodeId);
    }

    public ExternalNodeManager getExternalNodeManager() {
        return this.jy;
    }

    public HistoryManager getHistoryManager(NodeId object) throws StatusException {
        if ((object = this.getNodeManager((NodeId)object).getHistoryManager()) == null) {
            throw new StatusException(StatusCodes.Bad_NotSupported);
        }
        return object;
    }

    public InstanceDeclarationHierarchyCache getInstanceDeclarationHierarchyCache() {
        return this.jz;
    }

    public IoManager getIoManager(NodeId object) throws StatusException {
        if ((object = this.getNodeManager((NodeId)object).getIoManager()) == null) {
            throw new StatusException(StatusCodes.Bad_NotSupported);
        }
        return object;
    }

    public NodeManagerTableListener getListener() {
        return this.jA;
    }

    @Override
    public NamespaceTable getNamespaceTable() {
        return this.getServer().getNamespaceTable();
    }

    public UaNode getNode(NodeId nodeId) throws StatusException {
        if (NodeId.isNull((NodeId)nodeId)) {
            throw new StatusException("nodeId==null", StatusCodes.Bad_NodeIdUnknown);
        }
        NodeManager nodeManager = this.getNodeManager(nodeId);
        UaNode uaNode = nodeManager.findNode(nodeId);
        if ((uaNode == null || uaNode instanceof UaExternalNode) && nodeManager.requireUaNode() || !nodeManager.hasNode(nodeId)) {
            logger.debug("getNode: nodeId={} nodeManager={}", (Object)nodeId, (Object)nodeManager);
            throw new StatusException("nodeId=" + nodeId, StatusCodes.Bad_NodeIdUnknown);
        }
        return uaNode;
    }

    public NodeClass getNodeClass(ExpandedNodeId expandedNodeId, UaNode uaNode) {
        try {
            return this.getNodeManager(expandedNodeId).getNodeClass(expandedNodeId, uaNode);
        }
        catch (StatusException statusException) {
            return NodeClass.Unspecified;
        }
    }

    public NodeClass getNodeClass(NodeId nodeId, UaNode uaNode) {
        try {
            return this.getNodeManager(nodeId).getNodeClass(nodeId, uaNode);
        }
        catch (StatusException statusException) {
            return NodeClass.Unspecified;
        }
    }

    public boolean getNodeManagementEnabled() {
        return this.jB;
    }

    public NodeManager getNodeManager(ExpandedNodeId expandedNodeId) throws StatusException {
        int n2 = expandedNodeId.getNamespaceIndex();
        if (n2 == 0) {
            try {
                n2 = this.getNamespaceTable().toNodeId(expandedNodeId).getNamespaceIndex();
            }
            catch (ServiceResultException serviceResultException) {
                throw new StatusException(serviceResultException);
            }
        }
        return this.getNodeManager(n2);
    }

    public NodeManager getNodeManager(int n2) throws StatusException {
        NodeManager nodeManager = this.jC.get(n2);
        if (nodeManager == null) {
            throw new StatusException(StatusCodes.Bad_NodeIdUnknown);
        }
        return nodeManager;
    }

    public NodeManager getNodeManager(NodeId nodeId) throws StatusException {
        return this.getNodeManager(nodeId.getNamespaceIndex());
    }

    public NodeManager getNodeManager(String string) throws StatusException {
        return this.getNodeManager(this.getNamespaceTable().getIndex(string));
    }

    public NodeManagerRoot getNodeManagerRoot() {
        return this.cp.getNodeManagerRoot();
    }

    public UaNode getNodeOrExternal(NodeId nodeId) throws StatusException {
        try {
            UaNode uaNode = this.getNodeManager(nodeId).findNode(nodeId);
            if (uaNode == null) {
                return this.getExternalNode(nodeId);
            }
            return uaNode;
        }
        catch (StatusException statusException) {
            return this.jy.getNode(nodeId);
        }
    }

    public UaServer getServer() {
        return this.cp;
    }

    public ServerTable getServerTable() {
        return this.getEncoderContext().getServerTable();
    }

    public StructureInfoCache getStructureInfoCache() {
        return this.jD;
    }

    public UaType getType(NodeId nodeId) throws StatusException {
        return (UaType)this.getNode(nodeId);
    }

    public boolean hasNode(NodeId nodeId) {
        try {
            return this.getNodeManager(nodeId).hasNode(nodeId);
        }
        catch (StatusException statusException) {
            return false;
        }
    }

    public boolean hasNodeManager(String string) {
        return this.jC.get(this.getNamespaceTable().getIndex(string)) != null;
    }

    public HistoryResult historyRead(ServiceContext serviceContext, Object object, TimestampsToReturn timestampsToReturn, NodeId nodeId, NumericRange numericRange, HistoryContinuationPoint historyContinuationPoint, HistoryReadDetails historyReadDetails, int n2) throws StatusException {
        return this.getHistoryManager(nodeId).historyRead(serviceContext, object, timestampsToReturn, nodeId, numericRange, historyContinuationPoint, historyReadDetails, n2);
    }

    public void historyUpdate(ServiceContext serviceContext, Object object, HistoryUpdateDetails historyUpdateDetails, HistoryUpdateResult historyUpdateResult) throws StatusException {
        this.getHistoryManager(historyUpdateDetails.getNodeId()).historyUpdate(serviceContext, object, historyUpdateDetails, historyUpdateResult);
    }

    public boolean isTypeOf(NodeId nodeId, UaType uaType, NodeId nodeId2, UaType uaType2) throws StatusException {
        return this.getNodeManager(nodeId).getIsOfType(nodeId, uaType, nodeId2, uaType2);
    }

    @Override
    public void loadModel(InputStream inputStream) throws SAXException, IOException, ModelException {
        this.loadModel(inputStream, null, false);
    }

    public void loadModel(InputStream inputStream, Collection<ExpandedNodeId> collection, boolean bl) throws SAXException, ModelException, IOException {
        logger.info("Loading model from inputStream");
        ModelParser modelParser = new ModelParser(this);
        modelParser.setIgnoredNodes(collection);
        logger.debug("loadModel: Parsing XML");
        modelParser.parseFile(inputStream);
        logger.debug("loadModel: Creating model");
        try {
            modelParser.createModel(bl);
            logger.debug("loadModel: Completed");
            return;
        }
        catch (ServiceException serviceException) {
            logger.warn("Failed to load model from stream", (Throwable)serviceException);
            throw new RuntimeException(serviceException);
        }
    }

    @Override
    public void loadModel(URI uRI) throws SAXException, IOException, ModelException {
        this.loadModel(uRI, null, false);
    }

    public synchronized void loadModel(URI uRI, Collection<ExpandedNodeId> collection, boolean bl) throws SAXException, IOException, ModelException {
        logger.info("Loading model from {}", (Object)uRI);
        ModelParser modelParser = new ModelParser(this);
        modelParser.setIgnoredNodes(collection);
        logger.debug("loadModel: Parsing XML");
        modelParser.parseFile(uRI);
        logger.debug("loadModel: Creating model");
        try {
            modelParser.createModel(bl);
            logger.debug("loadModel: Completed");
            return;
        }
        catch (ServiceException serviceException) {
            logger.warn("Failed to load model from " + uRI, (Throwable)serviceException);
            throw new RuntimeException(serviceException);
        }
    }

    public void loadNodesFromXml(URL uRL, URL uRL2, Map<String, ModelParserForUaDefinedTypes.ParentDefinition> map) throws NumberFormatException, IllegalArgumentException, IOException, IllegalAccessException {
        this.loadNodesFromXml(uRL, uRL2, map, null);
    }

    public synchronized void loadNodesFromXml(URL uRL, URL object, Map<String, ModelParserForUaDefinedTypes.ParentDefinition> object2, String object3) throws NumberFormatException, IllegalArgumentException, IOException, IllegalAccessException {
        object = new ModelParserForUaDefinedTypes(this, uRL, object == null ? ModelParserForUaDefinedTypes.getStandardIds() : ModelParserForUaDefinedTypes.getCsvIds((URL)object), this.getNamespaceTable(), (Map<String, ModelParserForUaDefinedTypes.ParentDefinition>)object2);
        ((ModelParserForUaDefinedTypes)object).setTargetNamespace((String)object3);
        object2 = ((ModelParserForUaDefinedTypes)object).parseFile();
        object3 = object2.iterator();
        while (object3.hasNext()) {
            Exception exception = (Exception)object3.next();
            logger.error("Parsing error - " + uRL + " - ", (Throwable)exception);
        }
        if (object2.isEmpty()) {
            try {
                ((ModelParserForUaDefinedTypes)object).createModel();
                return;
            }
            catch (ServiceFaultException serviceFaultException) {
                logger.error("Model creation failed due to ServiceFaultException - " + uRL + " - ", (Throwable)serviceFaultException);
                return;
            }
            catch (ServiceResultException serviceResultException) {
                logger.error("Model creation failed due to ServiceResultException - " + uRL + " - ", (Throwable)serviceResultException);
                return;
            }
            catch (StatusException statusException) {
                logger.error("Model creation failed due to StatusException - " + uRL + " - ", (Throwable)statusException);
                return;
            }
        }
    }

    public NodeManager removeNodeManager(int n2) {
        this.getNamespaceTable().remove(n2);
        return this.jC.remove(n2);
    }

    public void setListener(NodeManagerTableListener nodeManagerTableListener) {
        this.jA = nodeManagerTableListener;
    }

    public void setNodeManagementEnabled(boolean bl) {
        this.jB = bl;
    }

    public BrowsePathTarget[] translateBrowsePathToNodeIds(NodeId nodeId, RelativePath relativePath) throws StatusException, ServiceException {
        return this.translateBrowsePath(ServiceContext.INTERNAL_OPERATION_CONTEXT, nodeId, relativePath);
    }

    protected NodeId addNode(ServiceContext serviceContext, AddNodesItem addNodesItem) throws StatusException {
        NodeAttributes nodeAttributes;
        ExpandedNodeId expandedNodeId = addNodesItem.getRequestedNewNodeId();
        NodeId nodeId = null;
        try {
            try {
                nodeId = this.getNamespaceTable().toNodeId(expandedNodeId);
            }
            catch (ServiceResultException serviceResultException) {
                logger.debug("addNode: NodeManager for namespace {} not found: trying to create", (Object)expandedNodeId.getNamespaceUri());
                this.createNewNodeManager(serviceContext, expandedNodeId.getNamespaceUri());
                nodeId = this.getNamespaceTable().toNodeId(expandedNodeId);
            }
        }
        catch (ServiceResultException serviceResultException) {
            logger.error("addNode: ", (Throwable)serviceResultException);
            throw new StatusException(StatusCodes.Bad_NodeIdInvalid);
        }
        try {
            expandedNodeId = this.getNamespaceTable().toNodeId(addNodesItem.getParentNodeId());
        }
        catch (ServiceResultException serviceResultException) {
            logger.error("addNode: ", (Throwable)serviceResultException);
            throw new StatusException(StatusCodes.Bad_ParentNodeIdInvalid);
        }
        try {
            nodeAttributes = (NodeAttributes)addNodesItem.getNodeAttributes().decode(this.getEncoderContext());
        }
        catch (DecodingException decodingException) {
            logger.error("addNode: ", (Throwable)decodingException);
            throw new StatusException(StatusCodes.Bad_NodeAttributesInvalid);
        }
        ExpandedNodeId expandedNodeId2 = addNodesItem.getTypeDefinition();
        QualifiedName qualifiedName = addNodesItem.getBrowseName();
        NodeClass nodeClass = addNodesItem.getNodeClass();
        addNodesItem = addNodesItem.getReferenceTypeId();
        return this.addNode(serviceContext, nodeId, (NodeId)expandedNodeId, qualifiedName, nodeClass, expandedNodeId2, nodeAttributes, (NodeId)addNodesItem);
    }

    protected NodeId addNode(ServiceContext object, NodeId nodeId, NodeId nodeId2, QualifiedName qualifiedName, NodeClass nodeClass, ExpandedNodeId expandedNodeId, NodeAttributes nodeAttributes, NodeId nodeId3) throws StatusException {
        try {
            return this.getNodeManager(nodeId).addNode((ServiceContext)object, nodeId, nodeId2, qualifiedName, nodeClass, expandedNodeId, nodeAttributes, nodeId3);
        }
        catch (StatusException statusException) {
            object = statusException;
            statusException.printStackTrace();
            throw object;
        }
    }

    protected void addReference(ServiceContext object, AddReferencesItem object2) throws StatusException {
        String string;
        NodeId nodeId = object2.getSourceNodeId();
        ExpandedNodeId expandedNodeId = object2.getTargetNodeId();
        NodeId nodeId2 = object2.getReferenceTypeId();
        boolean bl = object2.getIsForward();
        NodeClass nodeClass = object2.getTargetNodeClass();
        String string2 = string = object2.getTargetServerUri();
        string = nodeClass;
        boolean bl2 = bl;
        NodeId nodeId3 = nodeId2;
        nodeId2 = expandedNodeId;
        expandedNodeId = nodeId;
        nodeId = object2;
        object2 = object;
        object = this;
        ((NodeManagerTable)object).getNodeManager(nodeId.getSourceNodeId()).addReference((ServiceContext)object2, (NodeId)expandedNodeId, (ExpandedNodeId)nodeId2, nodeId3, bl2, (NodeClass)string, string2);
    }

    protected void afterCreateMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, MonitoredDataItem monitoredDataItem) throws StatusException {
        this.getNodeManager(monitoredDataItem.getNodeId()).afterCreateMonitoredDataItem(serviceContext, subscription, monitoredDataItem);
    }

    protected void afterCreateMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, MonitoredEventItem monitoredEventItem) throws StatusException {
        this.getNodeManager(monitoredEventItem.getNodeId()).afterCreateMonitoredEventItem(serviceContext, subscription, monitoredEventItem);
    }

    protected void afterDeleteMonitoredItem(ServiceContext serviceContext, Subscription subscription, MonitoredItem monitoredItem) throws StatusException {
        this.getNodeManager(monitoredItem.getNodeId()).afterDeleteMonitoredItem(serviceContext, subscription, monitoredItem);
    }

    protected void afterModifyMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, MonitoredDataItem monitoredDataItem) throws StatusException {
        this.getNodeManager(monitoredDataItem.getNodeId()).afterModifyMonitoredDataItem(serviceContext, subscription, monitoredDataItem);
    }

    protected void afterModifyMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, MonitoredEventItem monitoredEventItem) throws StatusException {
        this.getNodeManager(monitoredEventItem.getNodeId()).afterModifyMonitoredEventItem(serviceContext, subscription, monitoredEventItem);
    }

    protected BrowseContinuationPoint browseNode(ServiceContext serviceContext, List<ReferenceDescription> list, NodeId nodeId, int n2, BrowseDirection browseDirection, NodeId nodeId2, Boolean bl, QualifiedName qualifiedName, EnumSet<NodeClass> enumSet, EnumSet<BrowseResultMask> enumSet2, ViewDescription viewDescription, int n3) throws ServiceException, StatusException {
        return this.getNodeManager(nodeId).browseNode(serviceContext, list, nodeId, n2, browseDirection, nodeId2, bl, qualifiedName, enumSet, enumSet2, viewDescription, n3);
    }

    protected Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, NodeId nodeId2, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        logger.debug("callMethod: objectId={}; methodId={}", (Object)nodeId, (Object)nodeId2);
        logger.debug(" inputArguments={}", (Object)Arrays.toString(variantArray));
        return this.getNodeManager(nodeId).callMethod(serviceContext, nodeId, nodeId2, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    protected void checkNodeManagementEnabled() throws ServiceException {
        if (!this.getNodeManagementEnabled()) {
            throw new ServiceException(StatusCodes.Bad_ServiceUnsupported);
        }
    }

    protected void createMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, NodeId nodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, MonitoringParameters monitoringParameters, MonitoringFilter monitoringFilter, AggregateFilterResult aggregateFilterResult) throws StatusException {
        this.getNodeManager(nodeId).createMonitoredDataItem(serviceContext, subscription, nodeId, unsignedInteger, numericRange, monitoringParameters, monitoringFilter, aggregateFilterResult);
    }

    protected void createMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, NodeId nodeId, EventFilter eventFilter, EventFilterResult eventFilterResult) throws StatusException {
        this.getNodeManager(nodeId).createMonitoredEventItem(serviceContext, subscription, nodeId, eventFilter, eventFilterResult);
    }

    protected void createNewNodeManager(ServiceContext object, String string) throws StatusException {
        if (((ServiceContext)object).isInternal() || this.getNodeManagementEnabled()) {
            if ((object = this.cp.createNewNodeManager((ServiceContext)object, string)) == null) {
                throw new StatusException(StatusCodes.Bad_NodeIdRejected);
            }
        } else {
            throw new StatusException(StatusCodes.Bad_NodeIdRejected);
        }
        int n2 = ((NodeManager)object).getNamespaceIndex();
        this.addNodeManager(n2, (NodeManager)object);
        this.cp.updateNamespaceArray();
        logger.debug("createNewNodeManager: newNodeManager={}", object);
    }

    protected void deleteMonitoredItem(ServiceContext serviceContext, Subscription subscription, MonitoredItem monitoredItem) throws StatusException {
        this.getNodeManager(monitoredItem.getNodeId()).deleteMonitoredItem(serviceContext, subscription, monitoredItem);
    }

    protected void deleteNode(ServiceContext serviceContext, ExpandedNodeId expandedNodeId, boolean bl) throws StatusException {
        NodeId nodeId;
        try {
            nodeId = this.getNamespaceTable().toNodeId(expandedNodeId);
        }
        catch (ServiceResultException serviceResultException) {
            throw new StatusException(StatusCodes.Bad_NodeIdInvalid);
        }
        this.getNodeManager(expandedNodeId).deleteNode(serviceContext, nodeId, bl);
    }

    protected void deleteNode(ServiceContext serviceContext, NodeId nodeId, Boolean bl) throws StatusException {
        this.getNodeManager(nodeId).deleteNode(serviceContext, nodeId, bl);
    }

    protected void deleteReference(ServiceContext serviceContext, NodeId nodeId, ExpandedNodeId expandedNodeId, NodeId nodeId2, Boolean bl, Boolean bl2) throws StatusException {
        this.getNodeManager(nodeId).deleteReference(serviceContext, nodeId, expandedNodeId, nodeId2, bl, bl2);
        if (!this.getNamespaceTable().namespaceEquals(nodeId, expandedNodeId)) {
            this.getNodeManager(expandedNodeId).deleteReference(serviceContext, nodeId, expandedNodeId, nodeId2, bl, bl2);
        }
    }

    protected void init() throws StatusException, UaNodeFactoryException {
        for (NodeManager nodeManager : this.jC.values()) {
            logger.debug("Initializing NodeManager: {}", (Object)nodeManager);
            nodeManager.init();
        }
    }

    protected void initializeMonitoredDataItem(ServiceContext serviceContext, MonitoredDataItem monitoredDataItem, DataValue dataValue) throws StatusException {
        this.getIoManager(monitoredDataItem.getNodeId()).initializeMonitoredDataItem(serviceContext, monitoredDataItem, dataValue);
    }

    protected void modifyMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, MonitoredDataItem monitoredDataItem, MonitoringParameters monitoringParameters, MonitoringFilter monitoringFilter, AggregateFilterResult aggregateFilterResult) throws StatusException {
        this.getNodeManager(monitoredDataItem.getNodeId()).modifyMonitoredDataItem(serviceContext, subscription, monitoredDataItem, monitoringParameters, monitoringFilter, aggregateFilterResult);
    }

    protected void modifyMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, MonitoredEventItem monitoredEventItem, EventFilter eventFilter, EventFilterResult eventFilterResult) throws StatusException {
        this.getNodeManager(monitoredEventItem.getNodeId()).modifyMonitoredEventItem(serviceContext, subscription, monitoredEventItem, eventFilter, eventFilterResult);
    }

    protected void queryFirst(ServiceContext serviceContext, QueryFirstRequest queryFirstRequest, QueryFirstResponse queryFirstResponse) throws ServiceException {
        if (this.jA == null) {
            throw new ServiceException(StatusCodes.Bad_NotImplemented);
        }
        this.jA.queryFirst(serviceContext, queryFirstRequest, queryFirstResponse);
    }

    protected void queryNext(ServiceContext serviceContext, QueryNextRequest queryNextRequest, QueryNextResponse queryNextResponse) throws ServiceException {
        if (this.jA == null) {
            throw new ServiceException(StatusCodes.Bad_NotImplemented);
        }
        this.jA.queryNext(serviceContext, queryNextRequest, queryNextResponse);
    }

    protected void readAttribute(ServiceContext serviceContext, Object object, NodeId nodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, TimestampsToReturn timestampsToReturn, DateTime dateTime, DataValue dataValue) throws StatusException {
        this.getIoManager(nodeId).readAttribute(serviceContext, object, nodeId, unsignedInteger, numericRange, timestampsToReturn, dateTime, dataValue);
    }

    protected NodeId registerNode(ServiceContext serviceContext, NodeId nodeId) throws StatusException {
        return this.getNodeManager(nodeId).registerNode(serviceContext, nodeId);
    }

    protected void releaseHistoryContinuationPoint(ServiceContext serviceContext, NodeId nodeId, byte[] byArray) throws StatusException {
        this.getHistoryManager(nodeId).releaseHistoryContinuationPoint(serviceContext, nodeId, byArray);
    }

    protected void start() throws StatusException, UaNodeFactoryException {
        for (NodeManager nodeManager : this.jC.values()) {
            nodeManager.start();
        }
    }

    protected BrowsePathTarget[] translateBrowsePath(ServiceContext serviceContext, NodeId nodeId, RelativePath relativePath) throws StatusException, ServiceException {
        return this.getNodeManager(nodeId).translateBrowsePath(serviceContext, nodeId, relativePath);
    }

    protected void unregisterNode(ServiceContext serviceContext, NodeId nodeId) throws StatusException {
        this.getNodeManager(nodeId).unregisterNode(serviceContext, nodeId);
    }

    protected boolean writeAttribute(ServiceContext serviceContext, Object object, NodeId nodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, DataValue dataValue) throws StatusException {
        return this.getIoManager(nodeId).writeAttribute(serviceContext, object, nodeId, unsignedInteger, numericRange, dataValue);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class ModelParserForUaDefinedTypes
    extends DefaultHandler {
        private static final ExpandedNodeId hU = new ExpandedNodeId(Identifiers.PropertyType);
        private static Map<String, PredefinedIdPair> hV = null;
        private static final Logger logger = LoggerFactory.getLogger(ModelParserForUaDefinedTypes.class);
        private static Map<Object, String> hW = null;
        private List<Argument> hX;
        private String hY;
        private AddReferencesItem hZ;
        private Locale defaultLocale;
        private List<a> ia;
        private final EncoderContext bg;
        private final NodeManagerTable ib;
        private String ic;
        private final NamespaceTable namespaceTable;
        private List<NodeAttributes> id;
        private List<AddNodesItem> ie;
        private List<AddNodesItem> if;
        private Map<String, ParentDefinition> ig;
        private final List<Exception> ih;
        private final Map<String, PredefinedIdPair> ii;
        private String eo;
        private boolean ep;
        private List<AddReferencesItem> ij;
        private List<String> ik;
        private String il;
        private final URL im;

        public static Map<String, PredefinedIdPair> getCsvIds(URL object) throws NumberFormatException, IllegalArgumentException, IOException {
            String[] stringArray;
            HashMap<String, PredefinedIdPair> hashMap = new HashMap<String, PredefinedIdPair>();
            object = new BufferedReader(new InputStreamReader(((URL)object).openStream()));
            while ((stringArray = ((BufferedReader)object).readLine()) != null) {
                stringArray = stringArray.split(",");
                try {
                    hashMap.put(stringArray[0], new PredefinedIdPair(new UnsignedInteger(Integer.parseInt(stringArray[1])), NodeClass.valueOf((String)stringArray[2])));
                }
                catch (NumberFormatException numberFormatException) {
                    hashMap.put(stringArray[0], new PredefinedIdPair(stringArray[1], NodeClass.valueOf((String)stringArray[2])));
                }
            }
            return hashMap;
        }

        public static synchronized Map<String, PredefinedIdPair> getIdentifierPairs() {
            if (hV == null) {
                hV = new ConcurrentHashMap<String, PredefinedIdPair>();
                Field[] fieldArray = Identifiers.class;
                Field[] fieldArray2 = Identifiers.class.getFields();
                fieldArray = fieldArray2;
                fieldArray = fieldArray2;
                int n2 = fieldArray2.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Object object;
                    Field field = fieldArray[i2];
                    try {
                        object = field.get(null);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        continue;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        continue;
                    }
                    if (!(object instanceof NodeId)) continue;
                    hV.put(field.getName(), new PredefinedIdPair(((NodeId)object).getValue(), NodeClass.Unspecified));
                }
            }
            return hV;
        }

        public static synchronized Map<Object, String> getReverseIdentifierPairs() {
            if (hW == null) {
                hW = new ConcurrentHashMap<Object, String>();
                Field[] fieldArray = Identifiers.class;
                Field[] fieldArray2 = Identifiers.class.getFields();
                fieldArray = fieldArray2;
                fieldArray = fieldArray2;
                int n2 = fieldArray2.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Object object;
                    Field field = fieldArray[i2];
                    try {
                        object = field.get(null);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        continue;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        continue;
                    }
                    if (!(object instanceof NodeId)) continue;
                    hW.put(((NodeId)object).getValue(), field.getName());
                }
            }
            return hW;
        }

        public static Map<String, PredefinedIdPair> getStandardIds() throws IOException, IllegalArgumentException, IllegalAccessException {
            return ModelParserForUaDefinedTypes.getIdentifierPairs();
        }

        public ModelParserForUaDefinedTypes(NodeManagerTable nodeManagerTable, URL uRL, Map<String, PredefinedIdPair> map, NamespaceTable namespaceTable) {
            this.ib = nodeManagerTable;
            this.bg = nodeManagerTable.getEncoderContext();
            this.im = uRL;
            this.ii = map;
            this.namespaceTable = namespaceTable;
            this.ih = new ArrayList<Exception>();
        }

        public ModelParserForUaDefinedTypes(NodeManagerTable nodeManagerTable, URL uRL, Map<String, PredefinedIdPair> map, NamespaceTable namespaceTable, Map<String, ParentDefinition> map2) {
            this(nodeManagerTable, uRL, map, namespaceTable);
            this.ig = map2;
        }

        @Override
        public void characters(char[] cArray, int n2, int n3) throws SAXException {
            if (this.ep) {
                this.eo = this.eo + new String(cArray, n2, n3);
            }
        }

        public void createModel() throws ServiceResultException, StatusException {
            ArrayList<AddNodesItem> arrayList = new ArrayList<AddNodesItem>();
            for (AddNodesItem addNodesItem : this.if) {
                if (addNodesItem.getNodeClass().equals((Object)NodeClass.ReferenceType)) {
                    this.ib.addNode(ServiceContext.INTERNAL_OPERATION_CONTEXT, addNodesItem);
                    continue;
                }
                arrayList.add(addNodesItem);
            }
            for (AddNodesItem addNodesItem : arrayList) {
                this.ib.addNode(ServiceContext.INTERNAL_OPERATION_CONTEXT, addNodesItem);
            }
            for (AddReferencesItem addReferencesItem : this.ij) {
                this.ib.addReference(ServiceContext.INTERNAL_OPERATION_CONTEXT, addReferencesItem);
            }
        }

        @Override
        public void endElement(String object, String object2, String object3) throws SAXException {
            object = a.valueOf((String)object2);
            switch (1.jv[((Enum)object).ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    if (object == a.P && this.ep && this.ie.size() != 0) {
                        object = this.h(this.eo);
                        try {
                            this.hZ.setReferenceTypeId(this.namespaceTable.toNodeId((ExpandedNodeId)object));
                        }
                        catch (ServiceResultException serviceResultException) {
                            this.a((Exception)((Object)serviceResultException));
                        }
                        this.ep = false;
                        break;
                    }
                    if (((Enum)object).equals((Object)a.D) || ((Enum)object).equals((Object)a.L)) {
                        object = this.hX.toArray(new Argument[0]);
                        ((VariableAttributes)this.ba()).setValue(new Variant(object));
                        ((VariableAttributes)this.ba()).setValueRank(Integer.valueOf(1));
                        ((VariableAttributes)this.ba()).setArrayDimensions(new UnsignedInteger[]{new UnsignedInteger(((Object)object).length)});
                    }
                    object = null;
                    try {
                        object = ExtensionObject.binaryEncode((Structure)this.ba(), (EncoderContext)this.bg);
                    }
                    catch (EncodingException encodingException) {
                        this.a((Exception)((Object)encodingException));
                    }
                    this.bb().setNodeAttributes((ExtensionObject)object);
                    object = this;
                    object3 = ((ModelParserForUaDefinedTypes)object).bb();
                    if (object3 != null) {
                        ((ModelParserForUaDefinedTypes)object).ie.remove(object3);
                    }
                    if (a.valueOf((String)object2) == a.M) {
                        object3.setTypeDefinition(this.namespaceTable.toExpandedNodeId(Identifiers.PropertyType));
                    }
                    this.if.add((AddNodesItem)object3);
                    object2 = object = this;
                    object3 = ((ModelParserForUaDefinedTypes)object).ik.size() != 0 ? ((ModelParserForUaDefinedTypes)object2).ik.get(((ModelParserForUaDefinedTypes)object2).ik.size() - 1) : null;
                    if (object3 != null) {
                        ((ModelParserForUaDefinedTypes)object).ik.remove(object3);
                    }
                    if ((object3 = ((ModelParserForUaDefinedTypes)(object = this)).ba()) == null) break;
                    ((ModelParserForUaDefinedTypes)object).id.remove(object3);
                    break;
                }
                case 12: {
                    if (this.ep) {
                        this.bb().setBrowseName(new QualifiedName(this.eo));
                    }
                    this.ep = false;
                    break;
                }
                case 13: {
                    if (this.ep) {
                        this.ba().setDisplayName(new LocalizedText(this.eo, this.defaultLocale));
                    }
                    this.ep = false;
                    break;
                }
                case 14: {
                    this.ep = false;
                    break;
                }
                case 15: {
                    if (this.ep) {
                        ((ReferenceTypeAttributes)this.ba()).setInverseName(new LocalizedText(this.eo, this.defaultLocale));
                    }
                    this.ep = false;
                    break;
                }
                case 16: {
                    if (this.ep) {
                        int n2 = 2;
                        object = this;
                        if ((((ModelParserForUaDefinedTypes)object).ia.size() >= 2 ? ((ModelParserForUaDefinedTypes)object).ia.get(((ModelParserForUaDefinedTypes)object).ia.size() - 2) : null).equals((Object)a.q)) {
                            object = this;
                            (((ModelParserForUaDefinedTypes)object).hX.size() != 0 ? ((ModelParserForUaDefinedTypes)object).hX.get(((ModelParserForUaDefinedTypes)object).hX.size() - 1) : null).setDescription(new LocalizedText(this.eo, this.defaultLocale));
                        } else {
                            this.ba().setDescription(new LocalizedText(this.eo, this.defaultLocale));
                        }
                    }
                    this.ep = false;
                    break;
                }
                case 17: {
                    object = this.bb().getRequestedNewNodeId();
                    object3 = this.hZ.getTargetNodeId();
                    object2 = this.hZ.clone();
                    try {
                        logger.debug("sourceId={}", object);
                        object2.setSourceNodeId(this.toNodeId((ExpandedNodeId)object));
                    }
                    catch (ServiceResultException serviceResultException) {
                        this.a((Exception)((Object)serviceResultException));
                        break;
                    }
                    object2.setTargetNodeId((ExpandedNodeId)object3);
                    this.ij.add((AddReferencesItem)object2);
                    break;
                }
                case 18: {
                    if (!this.ep) break;
                    this.hZ.setTargetNodeId(this.h(this.eo));
                    this.ep = false;
                    break;
                }
                case 19: {
                    break;
                }
                case 20: {
                    if (!this.ep) break;
                    try {
                        object3 = this.eo;
                        object = this;
                        ((ModelParserForUaDefinedTypes)object).namespaceTable.add(-1, object3);
                    }
                    catch (Exception exception) {
                        this.a(exception);
                    }
                    this.ep = false;
                }
            }
            object2 = object = this;
            object3 = ((ModelParserForUaDefinedTypes)object).ia.size() != 0 ? ((ModelParserForUaDefinedTypes)object2).ia.get(((ModelParserForUaDefinedTypes)object2).ia.size() - 1) : null;
            if (object3 != null) {
                ((ModelParserForUaDefinedTypes)object).ia.remove(object3);
            }
        }

        public List<Exception> parseFile() {
            InputStreamReader inputStreamReader;
            XMLReader xMLReader;
            this.hX = new ArrayList<Argument>();
            this.if = new ArrayList<AddNodesItem>();
            this.ij = new ArrayList<AddReferencesItem>();
            this.ia = new ArrayList<a>();
            this.id = new ArrayList<NodeAttributes>();
            this.ie = new ArrayList<AddNodesItem>();
            this.ik = new ArrayList<String>();
            this.defaultLocale = Locale.ENGLISH;
            if (this.il == null) {
                this.il = "http://opcfoundation.org/UA/";
            }
            new ArrayList();
            try {
                xMLReader = XMLReaderFactory.createXMLReader();
            }
            catch (Exception exception) {
                this.a(exception);
                return this.ih;
            }
            logger.debug("XMLReader class: {}", xMLReader.getClass());
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
            try {
                inputStreamReader = new InputStreamReader(this.im.openStream());
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.a(fileNotFoundException);
                return this.ih;
            }
            catch (IOException iOException) {
                this.a(iOException);
                return this.ih;
            }
            try {
                xMLReader.parse(new InputSource(inputStreamReader));
            }
            catch (Exception exception) {
                logger.error("Exception while parsing", (Throwable)exception);
                return this.ih;
            }
            return this.ih;
        }

        public void setTargetNamespace(String string) {
            this.il = string;
        }

        @Override
        public void startElement(String object, String object2, String object3, Attributes object4) throws SAXException {
            object3 = object = a.valueOf((String)object2);
            object2 = this;
            ((ModelParserForUaDefinedTypes)object2).ia.add((a)((Object)object3));
            switch (1.jv[((Enum)object).ordinal()]) {
                case 1: {
                    object3 = object4;
                    object2 = this;
                    object = new ObjectTypeAttributes();
                    for (int i2 = 0; i2 < object3.getLength(); ++i2) {
                        if (!object3.getLocalName(i2).equalsIgnoreCase("IsAbstract")) continue;
                        object.setIsAbstract(Boolean.valueOf(Boolean.parseBoolean(object3.getValue(i2))));
                    }
                    super.a((NodeAttributes)object, (Attributes)object3);
                    this.a((Attributes)object4, (NodeAttributes)object, NodeClass.ObjectType);
                    return;
                }
                case 2: {
                    this.a((Attributes)object4, (NodeAttributes)this.n((Attributes)object4), NodeClass.VariableType);
                    return;
                }
                case 3: {
                    if (this.bb() != null) {
                        this.ar();
                        return;
                    }
                    this.a((Attributes)object4, (NodeAttributes)this.m((Attributes)object4), NodeClass.ReferenceType);
                    return;
                }
                case 4: {
                    this.a((Attributes)object4, (NodeAttributes)this.i((Attributes)object4), NodeClass.DataType);
                    return;
                }
                case 5: {
                    this.a((Attributes)object4, (NodeAttributes)this.j((Attributes)object4), NodeClass.Method);
                    return;
                }
                case 6: {
                    this.a((Attributes)object4, (NodeAttributes)this.l((Attributes)object4), NodeClass.Object);
                    return;
                }
                case 7: {
                    object = this.h((Attributes)object4);
                    this.a((Attributes)object4, (NodeAttributes)object, NodeClass.Variable);
                    return;
                }
                case 8: {
                    object = this.h((Attributes)object4);
                    this.a((Attributes)object4, (NodeAttributes)object, NodeClass.Variable, hU);
                    return;
                }
                case 9: {
                    this.a((Attributes)object4, (NodeAttributes)this.o((Attributes)object4), NodeClass.View);
                    return;
                }
                case 12: {
                    this.ar();
                    return;
                }
                case 13: {
                    this.ar();
                    return;
                }
                case 14: {
                    this.ar();
                    return;
                }
                case 15: {
                    this.ar();
                    return;
                }
                case 16: {
                    this.ar();
                    return;
                }
                case 17: {
                    this.hZ = this.e((Attributes)object4);
                    return;
                }
                case 18: {
                    this.ar();
                    return;
                }
                case 19: {
                    for (int i3 = 0; i3 < object4.getLength(); ++i3) {
                        if (!object4.getLocalName(i3).equalsIgnoreCase("TargetNamespace")) continue;
                        this.il = object4.getValue(i3);
                    }
                    return;
                }
                case 20: {
                    this.k((Attributes)object4);
                    this.ar();
                    return;
                }
                case 10: {
                    object2 = this;
                    object3 = new VariableAttributes();
                    object3.setDataType(Identifiers.Argument);
                    super.a((NodeAttributes)object3);
                    object = super.bb().getRequestedNewNodeId();
                    object4 = super.aZ() + "_InputArguments";
                    object3 = new ExpandedNodeId(new UnsignedInteger(0), ((ModelParserForUaDefinedTypes)object2).il, ((ModelParserForUaDefinedTypes)object2).ii.get(object4).getId());
                    object4 = ((ModelParserForUaDefinedTypes)object2).namespaceTable.toExpandedNodeId(Identifiers.PropertyType);
                    NodeId nodeId = Identifiers.HasProperty;
                    object = new AddNodesItem((ExpandedNodeId)object, nodeId, (ExpandedNodeId)object3, new QualifiedName(0, "InputArguments"), NodeClass.Variable, null, (ExpandedNodeId)object4);
                    super.a((AddNodesItem)object);
                    super.i(((ModelParserForUaDefinedTypes)object2).ic);
                    this.hX.clear();
                    return;
                }
                case 11: {
                    object2 = this;
                    object3 = new VariableAttributes();
                    object3.setDataType(Identifiers.Argument);
                    super.a((NodeAttributes)object3);
                    object = super.bb().getRequestedNewNodeId();
                    object4 = super.bb().getBrowseName().getName() + "_OutputArguments";
                    object3 = new ExpandedNodeId(new UnsignedInteger(0), ((ModelParserForUaDefinedTypes)object2).il, ((ModelParserForUaDefinedTypes)object2).ii.get(object4).getId());
                    object4 = ((ModelParserForUaDefinedTypes)object2).namespaceTable.toExpandedNodeId(Identifiers.PropertyType);
                    NodeId nodeId = Identifiers.HasProperty;
                    object = new AddNodesItem((ExpandedNodeId)object, nodeId, (ExpandedNodeId)object3, new QualifiedName(0, "OutputArguments"), NodeClass.Variable, null, (ExpandedNodeId)object4);
                    super.a((AddNodesItem)object);
                    super.i(((ModelParserForUaDefinedTypes)object2).ic);
                    this.hX.clear();
                    return;
                }
                case 21: {
                    this.d((Attributes)object4);
                }
            }
        }

        private void a(Exception exception) {
            this.ih.add(exception);
        }

        private void d(Attributes object) {
            Argument argument;
            String string = null;
            String string2 = null;
            for (int i2 = 0; i2 < object.getLength(); ++i2) {
                if (object.getLocalName(i2).equalsIgnoreCase("Name")) {
                    string = object.getValue(i2);
                }
                if (!object.getLocalName(i2).equalsIgnoreCase("DataType")) continue;
                string2 = object.getValue(i2);
            }
            try {
                argument = new Argument(string, this.namespaceTable.toNodeId(this.h(string2)), Integer.valueOf(-1), null, null);
            }
            catch (ServiceResultException serviceResultException) {
                this.ih.add(new Exception("Unable to get a data type for argument=" + string + ", data type=" + string2));
                return;
            }
            string = argument;
            object = this;
            ((ModelParserForUaDefinedTypes)object).hX.add((Argument)string);
        }

        private void a(Attributes attributes, NodeAttributes nodeAttributes, NodeClass nodeClass) {
            Attributes attributes2 = attributes;
            ModelParserForUaDefinedTypes modelParserForUaDefinedTypes = this;
            String string = null;
            for (int i2 = 0; i2 < attributes2.getLength(); ++i2) {
                String string2 = attributes2.getLocalName(i2);
                if (!string2.equalsIgnoreCase("TypeDefinition")) continue;
                string = attributes2.getValue(i2);
            }
            modelParserForUaDefinedTypes = string == null ? null : modelParserForUaDefinedTypes.h(string);
            this.a(attributes, nodeAttributes, nodeClass, (ExpandedNodeId)modelParserForUaDefinedTypes);
        }

        private void a(Attributes attributes, NodeAttributes nodeAttributes, NodeClass nodeClass, ExpandedNodeId expandedNodeId) {
            Object object;
            if (nodeAttributes == null) {
                return;
            }
            this.a(nodeAttributes);
            ExpandedNodeId expandedNodeId2 = this.a(nodeClass, attributes);
            ExpandedNodeId expandedNodeId3 = this.g(attributes);
            ExpandedNodeId expandedNodeId4 = expandedNodeId;
            NodeClass nodeClass2 = nodeClass;
            Object object2 = this;
            if (((ModelParserForUaDefinedTypes)object2).ig != null && (object2 = ((ModelParserForUaDefinedTypes)object2).ig.get(((ModelParserForUaDefinedTypes)object2).ic)) != null && (object2 = ((ParentDefinition)object2).getParentReferenceType()) != null) {
                object = object2;
            } else {
                NodeClass nodeClass3 = nodeClass2;
                nodeClass2 = expandedNodeId4;
                object2 = nodeClass3;
                if (hU.equals((Object)nodeClass2)) {
                    object = Identifiers.HasProperty;
                } else {
                    switch (1.dm[object2.ordinal()]) {
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            object = Identifiers.HasSubtype;
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            object = Identifiers.HasComponent;
                            break;
                        }
                        case 8: {
                            object = Identifiers.Organizes;
                            break;
                        }
                        default: {
                            object = null;
                        }
                    }
                }
            }
            object2 = object;
            try {
                nodeAttributes = ExtensionObject.binaryEncode((Structure)nodeAttributes, (EncoderContext)this.bg);
            }
            catch (EncodingException encodingException) {
                logger.error("EncodingException: ", (Throwable)encodingException);
                nodeAttributes = null;
            }
            nodeAttributes = new AddNodesItem(expandedNodeId2, (NodeId)object2, expandedNodeId3, ModelParserForUaDefinedTypes.f(attributes), nodeClass, (ExtensionObject)nodeAttributes, expandedNodeId);
            this.a((AddNodesItem)nodeAttributes);
            this.i(this.ic);
        }

        private AddReferencesItem e(Attributes attributes) {
            boolean bl = false;
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                if (attributes.getLocalName(i2).equalsIgnoreCase("IsInverse")) {
                    bl = Boolean.parseBoolean(attributes.getValue(i2));
                }
                if (!attributes.getLocalName(i2).equalsIgnoreCase("IsOneWay")) continue;
                Boolean.parseBoolean(attributes.getValue(i2));
            }
            AddReferencesItem addReferencesItem = new AddReferencesItem(null, null, Boolean.valueOf(!bl), null, null, null);
            return addReferencesItem;
        }

        private NodeId b(NodeClass nodeClass) {
            switch (nodeClass) {
                case Object: {
                    return Identifiers.ObjectsFolder;
                }
                case Variable: {
                    this.a(new Exception("No default parent id for Variables"));
                    return NodeId.NULL;
                }
                case Method: {
                    return Identifiers.ObjectTypesFolder;
                }
                case ObjectType: {
                    return Identifiers.BaseObjectType;
                }
                case VariableType: {
                    return Identifiers.BaseVariableType;
                }
                case ReferenceType: {
                    return Identifiers.ReferenceTypesFolder;
                }
                case DataType: {
                    return Identifiers.DataTypesFolder;
                }
                case View: {
                    return Identifiers.ViewsFolder;
                }
            }
            return NodeId.NULL;
        }

        private static QualifiedName f(Attributes stringArray) {
            for (int i2 = 0; i2 < stringArray.getLength(); ++i2) {
                if (!stringArray.getLocalName(i2).equalsIgnoreCase("SymbolicName")) continue;
                stringArray = stringArray.getValue(i2).split(":");
                return new QualifiedName(stringArray[stringArray.length - 1]);
            }
            return new QualifiedName("");
        }

        private NodeId a(int n2, String object) {
            if ((object = this.ii.get(object).getId()) instanceof UnsignedInteger) {
                return new NodeId(n2, (UnsignedInteger)object);
            }
            if (object instanceof String) {
                return new NodeId(n2, (String)object);
            }
            throw new RuntimeException("Other Id types than UnsignedIntegers and Strings are not yet supported");
        }

        private ExpandedNodeId g(Attributes object) {
            if ((object = object.getValue("", "SymbolicName")) == null) {
                return ExpandedNodeId.NULL;
            }
            object = object.split(":");
            object = object[((String[])object).length - 1];
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < this.ie.size(); ++i2) {
                Object object2 = this.ik.get(i2).split(":");
                object2 = object2[((String[])object2).length - 1];
                stringBuilder.append((String)object2);
                stringBuilder.append("_");
            }
            stringBuilder.append((String)object);
            String string = stringBuilder.toString();
            try {
                return new ExpandedNodeId(UnsignedInteger.ZERO, this.il, this.ii.get(string).getId());
            }
            catch (Exception exception) {
                this.a(new RuntimeException("NodeId not found for designId=" + string, exception));
                return null;
            }
        }

        private ExpandedNodeId a(NodeClass object, Attributes attributes) {
            ParentDefinition parentDefinition;
            ExpandedNodeId expandedNodeId = null;
            if (this.ig != null && (parentDefinition = this.ig.get(this.ic)) != null && (parentDefinition = parentDefinition.getParent()) != null) {
                return this.namespaceTable.toExpandedNodeId((NodeId)parentDefinition);
            }
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                if (!attributes.getLocalName(i2).equalsIgnoreCase("BaseType")) continue;
                String string = attributes.getValue(i2).replaceAll("tns:", "");
                expandedNodeId = this.namespaceTable.toExpandedNodeId(this.a(0, string));
                break;
            }
            if (expandedNodeId != null) {
                return expandedNodeId;
            }
            if (this.ie.size() > 0) {
                expandedNodeId = this.bb().getRequestedNewNodeId();
            }
            if (expandedNodeId != null) {
                return expandedNodeId;
            }
            Object object2 = this.ic.split("_");
            if (((String[])object2).length > 1) {
                object2 = this.ic.replaceAll("_" + object2[((String[])object2).length - 1], "").replaceAll("tns:", "");
                try {
                    expandedNodeId = new ExpandedNodeId(this.a(0, (String)object2));
                }
                catch (Exception exception) {
                    try {
                        new ExpandedNodeId(this.a(0, (String)object2 + "Type"));
                    }
                    catch (Exception exception2) {
                        this.a(new Exception("Unable to find implicit parent " + (String)object2));
                        expandedNodeId = this.namespaceTable.toExpandedNodeId(this.b(this.bb().getNodeClass()));
                    }
                }
            }
            if (expandedNodeId != null) {
                return expandedNodeId;
            }
            attributes = object;
            object = this;
            object = object.b((NodeClass)attributes);
            expandedNodeId = new ExpandedNodeId(new UnsignedInteger(0), object.getNamespaceIndex(), object.getValue());
            return expandedNodeId;
        }

        private String aZ() {
            if (this.ik.size() != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i2 = 0; i2 < this.ik.size(); ++i2) {
                    Object object = this.ik.get(i2).split(":");
                    object = object[((String[])object).length - 1];
                    if (i2 > 0) {
                        stringBuilder.append("_");
                    }
                    stringBuilder.append((String)object);
                }
                return stringBuilder.toString();
            }
            return null;
        }

        private ExpandedNodeId h(String string) {
            String[] stringArray = string.split(":");
            if (stringArray.length == 1) {
                return new ExpandedNodeId(this.a(this.namespaceTable.getIndex(this.il), string));
            }
            if (stringArray.length == 2) {
                if (stringArray[0].equals("ua") || stringArray[0].equals("tns")) {
                    string = IdentifierDescriptions.toNodeId((String)stringArray[1]);
                    return new ExpandedNodeId(new UnsignedInteger(0), "http://opcfoundation.org/UA/", string.getValue());
                }
                return new ExpandedNodeId(this.a(this.namespaceTable.getIndex(this.il), stringArray[1]));
            }
            return ExpandedNodeId.NULL;
        }

        private VariableAttributes h(Attributes object) {
            try {
                Attributes attributes = object;
                object = this;
                VariableAttributes variableAttributes = new VariableAttributes();
                Object object2 = null;
                for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                    if (attributes.getLocalName(i2).equalsIgnoreCase("DataType")) {
                        variableAttributes.setDataType(((ModelParserForUaDefinedTypes)object).namespaceTable.toNodeId(super.h(attributes.getValue(i2))));
                    }
                    if (attributes.getLocalName(i2).equalsIgnoreCase("Historizing")) {
                        variableAttributes.setHistorizing(Boolean.valueOf(Boolean.parseBoolean(attributes.getValue(i2))));
                    }
                    if (attributes.getLocalName(i2).equalsIgnoreCase("MinimumSamplingInterval")) {
                        variableAttributes.setMinimumSamplingInterval(Double.valueOf(Double.parseDouble(attributes.getValue(i2))));
                    }
                    if (!attributes.getLocalName(i2).equalsIgnoreCase("DefaultValue")) continue;
                    object2 = attributes.getValue(i2);
                }
                NodeId nodeId = variableAttributes.getDataType();
                if (object2 != null && nodeId != null) {
                    NodeId nodeId2 = nodeId;
                    nodeId = object2;
                    object2 = object;
                    variableAttributes.setValue(((ModelParserForUaDefinedTypes)object2).ib.getNodeManagerRoot().getDataTypeConverter().parseVariant((String)nodeId, nodeId2));
                } else {
                    variableAttributes.setValue(new Variant(object2));
                }
                super.a((NodeAttributes)variableAttributes, attributes);
                object = variableAttributes;
            }
            catch (ServiceResultException serviceResultException) {
                logger.error("ServiceResultException: ", (Throwable)serviceResultException);
                return null;
            }
            if (object.getAccessLevel() == null || object.getAccessLevel().intValue() == 0) {
                object.setAccessLevel(AccessLevel.getMask((AccessLevel[])new AccessLevel[]{AccessLevel.CurrentRead}));
            }
            return object;
        }

        private NodeAttributes ba() {
            if (this.id.size() != 0) {
                return this.id.get(this.id.size() - 1);
            }
            return null;
        }

        private AddNodesItem bb() {
            if (this.ie.size() != 0) {
                return this.ie.get(this.ie.size() - 1);
            }
            return null;
        }

        private void ar() {
            this.ep = true;
            this.eo = "";
        }

        private void a(NodeAttributes nodeAttributes) {
            this.id.add(nodeAttributes);
        }

        private void a(AddNodesItem addNodesItem) {
            this.bb();
            this.ie.add(addNodesItem);
        }

        private void i(String string) {
            this.ik.add(string);
        }

        private DataTypeAttributes i(Attributes attributes) {
            DataTypeAttributes dataTypeAttributes = new DataTypeAttributes();
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                if (!attributes.getLocalName(i2).equalsIgnoreCase("IsAbstract")) continue;
                dataTypeAttributes.setIsAbstract(Boolean.valueOf(Boolean.parseBoolean(attributes.getValue(i2))));
            }
            this.a((NodeAttributes)dataTypeAttributes, attributes);
            return dataTypeAttributes;
        }

        private MethodAttributes j(Attributes attributes) {
            MethodAttributes methodAttributes = new MethodAttributes();
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                if (!attributes.getLocalName(i2).equalsIgnoreCase("NonExecutable")) continue;
                methodAttributes.setExecutable(Boolean.valueOf(!Boolean.parseBoolean(attributes.getValue(i2))));
            }
            this.a((NodeAttributes)methodAttributes, attributes);
            return methodAttributes;
        }

        private void k(Attributes attributes) {
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                if (!attributes.getLocalName(i2).equalsIgnoreCase("Name")) continue;
                this.hY = attributes.getValue(i2);
            }
        }

        private void a(NodeAttributes nodeAttributes, Attributes attributes) {
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                if (attributes.getLocalName(i2).equalsIgnoreCase("SymbolicName")) {
                    this.ic = attributes.getValue(i2);
                }
                if (!attributes.getLocalName(i2).equalsIgnoreCase("WriteAccess")) continue;
                nodeAttributes.setWriteMask(new UnsignedInteger(Long.parseLong(attributes.getValue(i2))));
            }
        }

        private ObjectAttributes l(Attributes attributes) {
            ObjectAttributes objectAttributes = new ObjectAttributes();
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            }
            this.a((NodeAttributes)objectAttributes, attributes);
            return objectAttributes;
        }

        private ReferenceTypeAttributes m(Attributes attributes) {
            ReferenceTypeAttributes referenceTypeAttributes = new ReferenceTypeAttributes();
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                if (attributes.getLocalName(i2).equalsIgnoreCase("IsAbstract")) {
                    referenceTypeAttributes.setIsAbstract(Boolean.valueOf(Boolean.parseBoolean(attributes.getValue(i2))));
                }
                if (!attributes.getLocalName(i2).equalsIgnoreCase("Symmetric")) continue;
                referenceTypeAttributes.setSymmetric(Boolean.valueOf(Boolean.parseBoolean(attributes.getValue(i2))));
            }
            this.a((NodeAttributes)referenceTypeAttributes, attributes);
            return referenceTypeAttributes;
        }

        private VariableTypeAttributes n(Attributes attributes) {
            VariableTypeAttributes variableTypeAttributes = new VariableTypeAttributes();
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                if (!attributes.getLocalName(i2).equalsIgnoreCase("AccessLevel")) continue;
                variableTypeAttributes.setIsAbstract(Boolean.valueOf(Boolean.parseBoolean(attributes.getValue(i2))));
            }
            this.a((NodeAttributes)variableTypeAttributes, attributes);
            return variableTypeAttributes;
        }

        private ViewAttributes o(Attributes attributes) {
            ViewAttributes viewAttributes = new ViewAttributes();
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                if (!attributes.getLocalName(i2).equalsIgnoreCase("ContainsNoLoops")) continue;
                viewAttributes.setContainsNoLoops(Boolean.valueOf(Boolean.parseBoolean(attributes.getValue(i2))));
            }
            this.a((NodeAttributes)viewAttributes, attributes);
            return viewAttributes;
        }

        private NodeId toNodeId(ExpandedNodeId object) throws ServiceResultException {
            try {
                return this.namespaceTable.toNodeId(object);
            }
            catch (ServiceResultException serviceResultException) {
                object = serviceResultException;
                throw serviceResultException;
            }
        }

        private static enum a {
            q,
            r,
            s,
            t,
            u,
            v,
            w,
            x,
            y,
            z,
            A,
            B,
            C,
            D,
            E,
            F,
            G,
            H,
            I,
            J,
            K,
            L,
            M,
            N,
            O,
            P,
            Q,
            R,
            S,
            T;

        }

        public static class ParentDefinition {
            private final NodeId hu;
            private final NodeId hv;

            public ParentDefinition(NodeId nodeId, NodeId nodeId2) {
                this.hu = nodeId;
                this.hv = nodeId2;
            }

            public NodeId getParent() {
                return this.hu;
            }

            public NodeId getParentReferenceType() {
                return this.hv;
            }
        }
    }
}

