/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.DataTypeConverter;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaDataType;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaNodeFactoryException;
import com.prosysopc.ua.nodes.UaObjectType;
import com.prosysopc.ua.nodes.UaReferenceType;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.nodes.UaVariableType;
import com.prosysopc.ua.server.ModelChangeType;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.UaServer;
import com.prosysopc.ua.types.opcua.FolderType;
import com.prosysopc.ua.types.opcua.GeneralModelChangeEventType;
import com.prosysopc.ua.types.opcua.SemanticChangeEventType;
import com.prosysopc.ua.types.opcua.server.GeneralModelChangeEventTypeNode;
import com.prosysopc.ua.types.opcua.server.SemanticChangeEventTypeNode;
import com.prosysopc.ua.types.opcua.server.ServerTypeNode;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.common.NamespaceTable;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.NodeAttributes;
import org.opcfoundation.ua.core.NodeClass;
import org.opcfoundation.ua.core.StatusCodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeManagerRoot
extends NodeManagerUaNode {
    private static Logger logger = LoggerFactory.getLogger(NodeManagerRoot.class);
    private final AtomicInteger hi = new AtomicInteger(0);
    private final AtomicReference<GeneralModelChangeEventTypeNode> hj = new AtomicReference<Object>(null);
    private final AtomicInteger hk = new AtomicInteger(0);
    private final AtomicReference<SemanticChangeEventTypeNode> hl = new AtomicReference<Object>(null);

    public NodeManagerRoot(UaServer uaServer) {
        super(uaServer, NamespaceTable.OPCUA_NAMESPACE);
    }

    public final void addModelChange(NodeId nodeId, NodeId nodeId2, ModelChangeType ... modelChangeTypeArray) {
        GeneralModelChangeEventTypeNode generalModelChangeEventTypeNode = this.hj.get();
        if (generalModelChangeEventTypeNode != null) {
            generalModelChangeEventTypeNode.addChange(nodeId, nodeId2, modelChangeTypeArray);
        }
    }

    public final void addModelChange(UaNode uaNode, ModelChangeType ... modelChangeTypeArray) {
        GeneralModelChangeEventTypeNode generalModelChangeEventTypeNode = this.hj.get();
        if (generalModelChangeEventTypeNode != null && uaNode.getNodeVersion() != null) {
            generalModelChangeEventTypeNode.addChange(uaNode, modelChangeTypeArray);
        }
    }

    public final void addSemanticChange(UaNode uaNode) {
        SemanticChangeEventTypeNode semanticChangeEventTypeNode = this.hl.get();
        if (semanticChangeEventTypeNode != null) {
            semanticChangeEventTypeNode.addChange(uaNode);
        }
    }

    public final void beginModelChange() {
        this.hi.incrementAndGet();
        GeneralModelChangeEventType generalModelChangeEventType = this.hj.get();
        if (generalModelChangeEventType == null) {
            generalModelChangeEventType = this.createEvent(GeneralModelChangeEventTypeNode.class);
            this.hj.compareAndSet(null, (GeneralModelChangeEventTypeNode)generalModelChangeEventType);
        }
    }

    public final void beginSemanticChange() {
        this.hk.incrementAndGet();
        SemanticChangeEventType semanticChangeEventType = this.hl.get();
        if (semanticChangeEventType == null) {
            semanticChangeEventType = this.createEvent(SemanticChangeEventTypeNode.class);
            this.hl.compareAndSet(null, (SemanticChangeEventTypeNode)semanticChangeEventType);
        }
    }

    public final void endModelChange() {
        int n2 = this.hi.decrementAndGet();
        if (n2 == 0) {
            byte[] byArray;
            Object object = null;
            object = this;
            GeneralModelChangeEventTypeNode generalModelChangeEventTypeNode = ((NodeManagerRoot)object).hj.get();
            if (!generalModelChangeEventTypeNode.hasChanges()) {
                byArray = null;
            } else {
                generalModelChangeEventTypeNode = ((NodeManagerRoot)object).hj.getAndSet(null);
                byte[] byArray2 = generalModelChangeEventTypeNode.triggerEvent(DateTime.currentTime(), null, null);
                byArray = byArray2;
                object = byArray2;
            }
            return;
        }
        if (n2 < 0) {
            throw new RuntimeException("endModelChange() called more times than beginModelChange()");
        }
    }

    public final byte[] endSemanticChange() {
        int n2 = this.hk.decrementAndGet();
        if (n2 == 0) {
            Object object = null;
            object = this;
            object = ((NodeManagerRoot)object).hl.getAndSet(null);
            if (((SemanticChangeEventTypeNode)object).getChanges().length == 0) {
                return null;
            }
            byte[] byArray = ((SemanticChangeEventTypeNode)object).triggerEvent(DateTime.currentTime(), null, null);
            object = byArray;
            return byArray;
        }
        if (n2 < 0) {
            throw new RuntimeException("endSemanticChange() called more times than beginModelChange()");
        }
        return null;
    }

    public final DataTypeConverter getDataTypeConverter() {
        return this.getNodeManagerTable().getDataTypeConverter();
    }

    public final FolderType getDataTypesFolder() {
        return this.e(Identifiers.DataTypesFolder);
    }

    public final FolderType getEventTypesFolder() {
        return this.e(Identifiers.EventTypesFolder);
    }

    public final GeneralModelChangeEventTypeNode getModelChangeEvent() {
        return this.hj.get();
    }

    @Override
    public final int getNamespaceIndex() {
        return 0;
    }

    public final FolderType getObjectsFolder() {
        return this.e(Identifiers.ObjectsFolder);
    }

    public final FolderType getObjectTypesFolder() {
        return this.e(Identifiers.ObjectTypesFolder);
    }

    public final FolderType getReferenceTypesFolder() {
        return this.e(Identifiers.ReferenceTypesFolder);
    }

    public final FolderType getRoot() {
        return this.e(Identifiers.RootFolder);
    }

    public final SemanticChangeEventType getSemanticChangeEvent() {
        return this.hl.get();
    }

    public final ServerTypeNode getServerData() {
        try {
            return (ServerTypeNode)this.getNode(Identifiers.Server);
        }
        catch (StatusException statusException) {
            throw new RuntimeException(statusException);
        }
    }

    public final FolderType getTypesFolder() {
        return this.e(Identifiers.TypesFolder);
    }

    public final FolderType getVariableTypesFolder() {
        return this.e(Identifiers.VariableTypesFolder);
    }

    public final FolderType getViewsFolder() {
        return this.e(Identifiers.ViewsFolder);
    }

    private FolderType e(NodeId nodeId) {
        try {
            return (FolderType)this.getNode(nodeId);
        }
        catch (StatusException statusException) {
            throw new RuntimeException(statusException);
        }
    }

    private void a(NodeId object, int n2, int n3) {
        try {
            Object object2;
            object = this.getNode((NodeId)object);
            if (object instanceof UaVariable) {
                object2 = ((UaVariable)object).getValueRank();
                if (object2 == null || n2 == (Integer)object2) {
                    ((UaVariable)object).setValueRank(n3);
                }
            } else if (object instanceof UaVariableType && ((object2 = ((UaVariableType)object).getValueRank()) == null || n2 == (Integer)object2)) {
                ((UaVariableType)object).setValueRank(n3);
            }
            for (UaNode uaNode : object.getComponents()) {
                this.a(uaNode.getNodeId(), n2, n3);
            }
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException(statusException);
        }
    }

    private void aY() {
        this.a(Identifiers.ServerStatusType, -2, -1);
        this.a(Identifiers.Server_ServerStatus, -2, -1);
        this.a(Identifiers.SessionSecurityDiagnosticsType, -2, -1);
        this.a(Identifiers.SessionDiagnosticsVariableType, -2, -1);
        this.a(Identifiers.SubscriptionDiagnosticsType, -2, -1);
        this.a(Identifiers.SessionDiagnosticsObjectType, -2, -1);
        this.a(Identifiers.Server_ServerDiagnostics_ServerDiagnosticsSummary, -2, -1);
        this.a(Identifiers.ServerDiagnosticsSummaryType, -2, -1);
        this.getServerData().afterCreate();
    }

    @Override
    protected final NodeId addNode(ServiceContext serviceContext, NodeId nodeId, NodeId nodeId2, QualifiedName qualifiedName, NodeClass nodeClass, ExpandedNodeId expandedNodeId, NodeAttributes nodeAttributes, NodeId nodeId3) throws StatusException {
        if (!serviceContext.isInternal()) {
            throw new StatusException(StatusCodes.Bad_UserAccessDenied);
        }
        return super.addNode(serviceContext, nodeId, nodeId2, qualifiedName, nodeClass, expandedNodeId, nodeAttributes, nodeId3);
    }

    @Override
    protected final void addReference(ServiceContext serviceContext, NodeId nodeId, ExpandedNodeId expandedNodeId, NodeId nodeId2, boolean bl, NodeClass nodeClass, String string) throws StatusException {
        super.addReference(serviceContext, nodeId, expandedNodeId, nodeId2, bl, nodeClass, string);
    }

    @Override
    protected final void deleteNode(ServiceContext serviceContext, NodeId nodeId, Boolean bl) throws StatusException {
        if (!serviceContext.isInternal()) {
            throw new StatusException(StatusCodes.Bad_UserAccessDenied);
        }
        super.deleteNode(serviceContext, nodeId, bl);
    }

    @Override
    protected final void deleteReference(ServiceContext serviceContext, NodeId nodeId, ExpandedNodeId expandedNodeId, NodeId nodeId2, Boolean bl, Boolean bl2) throws StatusException {
        super.deleteReference(serviceContext, nodeId, expandedNodeId, nodeId2, bl, bl2);
    }

    protected final UaDataType getBaseDataType() {
        try {
            return (UaDataType)this.getType(Identifiers.BaseDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException(statusException);
        }
    }

    protected final UaVariableType getBaseDataVariableType() {
        try {
            return (UaVariableType)this.getType(Identifiers.BaseDataVariableType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException(statusException);
        }
    }

    protected final UaObjectType getBaseObjectType() {
        try {
            return (UaObjectType)this.getType(Identifiers.BaseObjectType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException(statusException);
        }
    }

    protected final UaReferenceType getBaseReferenceType() {
        try {
            return (UaReferenceType)this.getType(Identifiers.References);
        }
        catch (StatusException statusException) {
            throw new RuntimeException(statusException);
        }
    }

    protected final UaVariableType getBaseVariableType() {
        try {
            return (UaVariableType)this.getType(Identifiers.BaseVariableType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException(statusException);
        }
    }

    @Override
    protected final void init() throws RuntimeException {
        logger.debug("init");
        if (!this.isInitialized()) {
            try {
                NodeManagerRoot nodeManagerRoot = this;
                try {
                    URL uRL = NodeManagerRoot.class.getResource("Opc.Ua.NodeSet2.xml");
                    if (uRL == null) {
                        throw new RuntimeException("Cannot find Opc.Ua.NodeSet2.xml, cannot continue");
                    }
                    nodeManagerRoot.getNodeManagerTable().loadModel(uRL.toURI(), null, true);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new RuntimeException(uRISyntaxException);
                }
                this.aY();
                super.init();
                return;
            }
            catch (Exception exception) {
                logger.error("init: exception", (Throwable)exception);
                throw new RuntimeException("NodeManagerRoot", exception);
            }
        }
    }

    protected final void shutdown(int n2, LocalizedText localizedText) {
        logger.debug("shutdown");
        this.getServerData().shutdown(n2, localizedText);
    }

    @Override
    protected final void start() throws StatusException, UaNodeFactoryException {
        logger.debug("start");
        super.start();
        this.getServerData().start();
    }
}

