/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaNodeFactoryException;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaReferenceType;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.nodes.UaValueNode;
import com.prosysopc.ua.server.BrowseContinuationPoint;
import com.prosysopc.ua.server.EventManager;
import com.prosysopc.ua.server.HistoryManager;
import com.prosysopc.ua.server.IoManager;
import com.prosysopc.ua.server.MethodManager;
import com.prosysopc.ua.server.MethodManagerUaNode;
import com.prosysopc.ua.server.MonitoredDataItem;
import com.prosysopc.ua.server.MonitoredEventItem;
import com.prosysopc.ua.server.MonitoredItem;
import com.prosysopc.ua.server.NodeManagerListener;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.ServiceManagerBase;
import com.prosysopc.ua.server.Subscription;
import com.prosysopc.ua.server.UaServer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.common.NamespaceTable;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.AggregateFilterResult;
import org.opcfoundation.ua.core.BrowseDirection;
import org.opcfoundation.ua.core.BrowsePathTarget;
import org.opcfoundation.ua.core.BrowseResultMask;
import org.opcfoundation.ua.core.EventFilter;
import org.opcfoundation.ua.core.EventFilterResult;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.MonitoringFilter;
import org.opcfoundation.ua.core.MonitoringParameters;
import org.opcfoundation.ua.core.NodeAttributes;
import org.opcfoundation.ua.core.NodeClass;
import org.opcfoundation.ua.core.QueryFirstRequest;
import org.opcfoundation.ua.core.QueryFirstResponse;
import org.opcfoundation.ua.core.QueryNextRequest;
import org.opcfoundation.ua.core.QueryNextResponse;
import org.opcfoundation.ua.core.ReferenceDescription;
import org.opcfoundation.ua.core.RelativePath;
import org.opcfoundation.ua.core.RelativePathElement;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.core.ViewDescription;
import org.opcfoundation.ua.utils.NumericRange;
import org.opcfoundation.ua.utils.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NodeManager
extends ServiceManagerBase {
    private static Logger logger = LoggerFactory.getLogger(NodeManager.class);
    private Locale defaultLocale = LocalizedText.NO_LOCALE;
    private EventManager hz;
    private HistoryManager hA;
    private IoManager hB;
    private final List<NodeManagerListener> listeners = new CopyOnWriteArrayList<NodeManagerListener>();
    private MethodManager hC;
    private final int namespaceIndex;
    private final String namespaceUri;
    protected boolean initialized = false;
    protected boolean started = false;

    public NodeManager(UaServer uaServer, String string) {
        super(uaServer);
        this.namespaceUri = string;
        this.namespaceIndex = this.getNodeManagerTable().addNodeManager(-1, this);
    }

    public void addListener(NodeManagerListener nodeManagerListener) {
        if (!this.hasListener(nodeManagerListener)) {
            this.listeners.add(nodeManagerListener);
        }
    }

    public UaNode addNode(UaNode uaNode) throws StatusException {
        throw new StatusException(StatusCodes.Bad_NotSupported);
    }

    public UaNode findNode(NodeId nodeId) {
        if (this.supportsUaNode()) {
            throw new Error("NodeManager findNode(NodeId) not implemented, even though the manager supportsUaNode: " + this.getClass());
        }
        return null;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public EventManager getEventManager() {
        return this.hz;
    }

    public HistoryManager getHistoryManager() {
        return this.hA;
    }

    public IoManager getIoManager() {
        return this.hB;
    }

    public MethodManager getMethodManager() throws StatusException {
        if (this.hC == null) {
            throw new StatusException(StatusCodes.Bad_NotSupported);
        }
        return this.hC;
    }

    public int getNamespaceIndex() {
        return this.namespaceIndex;
    }

    public NamespaceTable getNamespaceTable() {
        return this.getNodeManagerTable().getNamespaceTable();
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public UaNode getNode(ExpandedNodeId expandedNodeId) throws StatusException {
        try {
            return this.getNode(this.getNamespaceTable().toNodeId(expandedNodeId));
        }
        catch (ServiceResultException serviceResultException) {
            throw new StatusException(StatusCodes.Bad_ServerIndexInvalid, (Throwable)serviceResultException);
        }
    }

    public NodeId getNodeId(String string, String string2) {
        int n2 = this.getNamespaceTable().getIndex(string);
        return NodeId.parseNodeId((String)String.format("ns=%d;%s", n2, string2));
    }

    public QualifiedName getQualifiedName(String string, String string2) {
        int n2 = this.getNamespaceTable().getIndex(string);
        return new QualifiedName(n2, string2);
    }

    public UaReference[] getReferences(NodeId nodeId) {
        return this.getReferences(nodeId, this.findNode(nodeId));
    }

    public abstract NodeId getVariableDataType(NodeId var1, UaValueNode var2) throws StatusException;

    public boolean hasListener(NodeManagerListener nodeManagerListener) {
        if (nodeManagerListener == null) {
            throw new NullPointerException("null listener not allowed");
        }
        return this.listeners.contains(nodeManagerListener);
    }

    public abstract boolean hasNode(NodeId var1);

    public boolean isInitialized() {
        return this.initialized;
    }

    public final boolean isOfType(NodeId nodeId, UaType uaType, NodeId nodeId2, UaType uaType2) throws StatusException {
        if (this.hasNode(nodeId)) {
            return this.getIsOfType(nodeId, uaType, nodeId2, uaType2);
        }
        return this.getNodeManagerTable().isTypeOf(nodeId, uaType, nodeId2, uaType2);
    }

    public boolean isStarted() {
        return this.started;
    }

    public void removeListener(NodeManagerListener nodeManagerListener) {
        this.listeners.remove(nodeManagerListener);
    }

    public void setDefaultLocale(Locale locale) {
        this.defaultLocale = locale;
    }

    public void setEventManager(EventManager eventManager) {
        if (this.hC instanceof MethodManagerUaNode) {
            MethodManagerUaNode methodManagerUaNode = (MethodManagerUaNode)this.hC;
            methodManagerUaNode.addCallListener(eventManager);
            methodManagerUaNode.removeCallListener(this.hz);
        }
        this.hz = eventManager;
    }

    public void setHistoryManager(HistoryManager historyManager) {
        this.hA = historyManager;
    }

    public void setIoManager(IoManager ioManager) {
        this.hB = ioManager;
    }

    public void setMethodManager(MethodManager methodManager) {
        if (this.hC instanceof MethodManagerUaNode) {
            ((MethodManagerUaNode)this.hC).removeCallListener(this.hz);
        }
        if (methodManager instanceof MethodManagerUaNode) {
            ((MethodManagerUaNode)methodManager).addCallListener(this.hz);
        }
        this.hC = methodManager;
    }

    public boolean supportsUaNode() {
        return false;
    }

    public String toString() {
        return this.getClass() + " namespaceUri=" + this.namespaceUri + " namespaceIndex=" + this.namespaceIndex;
    }

    protected NodeId addNode(ServiceContext serviceContext, NodeId nodeId, NodeId nodeId2, QualifiedName qualifiedName, NodeClass nodeClass, ExpandedNodeId expandedNodeId, NodeAttributes nodeAttributes, NodeId object) throws StatusException {
        object = this.getReferenceType((NodeId)object);
        this.fireAddNode(serviceContext, nodeId2, null, nodeId, null, nodeClass, qualifiedName, nodeAttributes, (UaReferenceType)object, expandedNodeId, null);
        throw new StatusException(StatusCodes.Bad_NotImplemented);
    }

    protected void addReference(ServiceContext serviceContext, NodeId nodeId, ExpandedNodeId expandedNodeId, NodeId nodeId2, boolean bl, NodeClass nodeClass, String string) throws StatusException {
        this.fireAddReference(serviceContext, nodeId, null, expandedNodeId, null, nodeId2, null, bl, null, string);
        throw new StatusException(StatusCodes.Bad_NotImplemented);
    }

    protected void afterCreateMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, MonitoredDataItem monitoredDataItem) {
        this.fireAfterCreateMonitoredDataItem(serviceContext, subscription, monitoredDataItem);
    }

    protected void afterCreateMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, MonitoredEventItem monitoredEventItem) {
        EventManager eventManager = this.getEventManager(monitoredEventItem.getNodeId());
        if (eventManager != null) {
            eventManager.afterCreateMonitoredEventItem(serviceContext, subscription, monitoredEventItem);
        }
    }

    protected void afterDeleteMonitoredItem(ServiceContext serviceContext, Subscription subscription, MonitoredItem monitoredItem) {
        this.fireAfterDeleteMonitoredItem(serviceContext, subscription, monitoredItem);
    }

    protected void afterModifyMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, MonitoredDataItem monitoredDataItem) {
        this.fireAfterModifyMonitoredDataItem(serviceContext, subscription, monitoredDataItem);
    }

    protected void afterModifyMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, MonitoredEventItem monitoredEventItem) {
        EventManager eventManager = this.getEventManager(monitoredEventItem.getNodeId());
        if (eventManager != null) {
            eventManager.afterModifyMonitoredEventItem(serviceContext, subscription, monitoredEventItem);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected BrowseContinuationPoint browseNode(ServiceContext object, List<ReferenceDescription> list, NodeId nodeId, int n2, BrowseDirection browseDirection, NodeId nodeId2, Boolean bl, QualifiedName qualifiedName, EnumSet<NodeClass> enumSet, EnumSet<BrowseResultMask> enumSet2, ViewDescription viewDescription, int n3) throws ServiceException, StatusException {
        logger.debug("browseNode: ReferenceTypeId={}", (Object)nodeId2);
        logger.debug("browseNode: NodeId={}", (Object)nodeId);
        logger.debug("browseNode: nodeClassSet={}", enumSet);
        logger.debug("browseNode: includeSubTypes={}", (Object)bl);
        logger.debug("browseNode: browseDirection={}", (Object)browseDirection);
        UaReferenceType uaReferenceType = NodeId.isNull((NodeId)nodeId2) ? null : this.getReferenceType(nodeId2);
        logger.debug("browseNode: referenceType={}", (Object)uaReferenceType);
        UaNode uaNode = this.getNode(nodeId);
        logger.debug("browseNode: node={}", (Object)uaNode);
        Object object2 = this.getReferences(nodeId, uaNode);
        if (object2 != null) {
            void var17_20;
            NodeClass nodeClass;
            UaNode uaNode2;
            NodeManager nodeManager;
            ExpandedNodeId expandedNodeId;
            boolean bl2;
            object2 = Arrays.asList(object2);
            for (NodeManagerListener object32 : this.listeners) {
                object32.onGetReferences((ServiceContext)object, viewDescription, nodeId, uaNode, (List<UaReference>)object2);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("browseNode: references of node={}", (Object)Arrays.toString(object2.toArray()));
            }
            ArrayList arrayList = new ArrayList();
            Iterator i2 = object2.iterator();
            while (i2.hasNext()) {
                object2 = (UaReference)i2.next();
                bl2 = ((UaReference)object2).getIsInverse(nodeId);
                ExpandedNodeId expandedNodeId2 = expandedNodeId = bl2 ? ((UaReference)object2).getSourceId() : ((UaReference)object2).getTargetId();
                nodeManager = this.getNodeManagerTable().getNodeManager(expandedNodeId);
                if (!nodeManager.referenceMatchesRequest((UaReference)object2, browseDirection, nodeId2, uaReferenceType, bl, qualifiedName, nodeId)) continue;
                uaNode2 = nodeManager.getNode(expandedNodeId);
                nodeClass = nodeManager.getNodeClass(expandedNodeId, uaNode2);
                logger.debug("browseNode: match found targetId={}; target={}; nodeClassSet={}; resultSet={}", new Object[]{expandedNodeId, uaNode2, enumSet, enumSet2});
                if (!nodeClass.equals((Object)NodeClass.Unspecified) && (!enumSet.contains(nodeClass) || !this.fireBrowseNode((ServiceContext)object, viewDescription, nodeId, uaNode, (UaReference)object2))) continue;
                arrayList.add(object2);
            }
            int n4 = n3;
            while (var17_20 < arrayList.size()) {
                object2 = (UaReference)arrayList.get((int)var17_20);
                bl2 = ((UaReference)object2).getIsInverse(nodeId);
                expandedNodeId = bl2 ? ((UaReference)object2).getSourceId() : ((UaReference)object2).getTargetId();
                nodeManager = this.getNodeManagerTable().getNodeManager(expandedNodeId);
                uaNode2 = nodeManager.getNode(expandedNodeId);
                nodeClass = nodeManager.getNodeClass(expandedNodeId, uaNode2);
                qualifiedName = nodeManager.createReferenceDescription(((UaReference)object2).getReferenceTypeId(), expandedNodeId, uaNode2, bl2, nodeClass, enumSet2);
                logger.debug("browseNode: reference accepted");
                list.add((ReferenceDescription)qualifiedName);
                if (list.size() == n2 && var17_20 + true < arrayList.size()) {
                    object = new BrowseContinuationPoint((ServiceContext)object);
                    ((BrowseContinuationPoint)object).setBrowseDirection(browseDirection);
                    ((BrowseContinuationPoint)object).setIncludeSubtypes(bl);
                    ((BrowseContinuationPoint)object).setIndex((int)(var17_20 + true));
                    ((BrowseContinuationPoint)object).setMaxResultsToReturn(n2);
                    ((BrowseContinuationPoint)object).setNodeClassMask(enumSet);
                    ((BrowseContinuationPoint)object).setNode(nodeId);
                    ((BrowseContinuationPoint)object).setResultMask(enumSet2);
                    ((BrowseContinuationPoint)object).setReferenceTypeId(nodeId2);
                    ((BrowseContinuationPoint)object).setView(viewDescription);
                    return object;
                }
                ++var17_20;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("browseNode: returning referenceDescriptions={}", (Object)list.size());
        }
        return null;
    }

    protected Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, NodeId nodeId2, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.getMethodManager() != null) {
            return this.getMethodManager().callMethod(serviceContext, nodeId, nodeId2, variantArray, statusCodeArray, diagnosticInfoArray);
        }
        return null;
    }

    protected void close() {
        this.initialized = false;
    }

    protected void createMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, NodeId nodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, MonitoringParameters monitoringParameters, MonitoringFilter monitoringFilter, AggregateFilterResult aggregateFilterResult) throws StatusException {
        this.fireCreateMonitoredDataItem(serviceContext, subscription, nodeId, null, unsignedInteger, numericRange, monitoringParameters, monitoringFilter, aggregateFilterResult);
    }

    protected void createMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, NodeId nodeId, EventFilter eventFilter, EventFilterResult eventFilterResult) throws StatusException {
        EventManager eventManager = this.getEventManager(nodeId);
        if (eventManager != null) {
            eventManager.createMonitoredEventItem(serviceContext, subscription, nodeId, eventFilter, eventFilterResult);
        }
    }

    protected ReferenceDescription createReferenceDescription(NodeId nodeId, ExpandedNodeId expandedNodeId, UaNode uaNode, boolean bl, NodeClass nodeClass, EnumSet<BrowseResultMask> enumSet) {
        ReferenceDescription referenceDescription = new ReferenceDescription();
        referenceDescription.setNodeId(expandedNodeId);
        if (enumSet.contains(BrowseResultMask.ReferenceTypeId)) {
            referenceDescription.setReferenceTypeId(nodeId);
        } else {
            referenceDescription.setReferenceTypeId(NodeId.NULL);
        }
        if (enumSet.contains(BrowseResultMask.IsForward)) {
            referenceDescription.setIsForward(Boolean.valueOf(!bl));
        } else {
            referenceDescription.setIsForward(Boolean.valueOf(false));
        }
        if (enumSet.contains(BrowseResultMask.NodeClass)) {
            referenceDescription.setNodeClass(nodeClass);
        }
        if (enumSet.contains(BrowseResultMask.BrowseName)) {
            referenceDescription.setBrowseName(this.getBrowseName(expandedNodeId, uaNode));
        }
        if (enumSet.contains(BrowseResultMask.DisplayName)) {
            referenceDescription.setDisplayName(this.getDisplayName(expandedNodeId, uaNode, null));
        }
        if (enumSet.contains(BrowseResultMask.TypeDefinition)) {
            referenceDescription.setTypeDefinition(this.getTypeDefinition(expandedNodeId, uaNode));
        }
        return referenceDescription;
    }

    protected void deleteMonitoredItem(ServiceContext serviceContext, Subscription subscription, MonitoredItem monitoredItem) throws StatusException {
        this.fireDeleteMonitoredItem(serviceContext, subscription, monitoredItem);
    }

    protected void deleteNode(ServiceContext serviceContext, NodeId nodeId, Boolean bl) throws StatusException {
        UaNode uaNode = this.findNode(nodeId);
        this.fireDeleteNode(serviceContext, nodeId, uaNode, bl);
    }

    protected void deleteReference(ServiceContext serviceContext, NodeId nodeId, ExpandedNodeId expandedNodeId, NodeId nodeId2, Boolean bl, Boolean bl2) throws StatusException {
        UaNode uaNode = this.findNode(nodeId);
        UaReferenceType uaReferenceType = null;
        try {
            uaReferenceType = (UaReferenceType)this.getNode(nodeId2);
        }
        catch (StatusException statusException) {
        }
        catch (ClassCastException classCastException) {
            throw new StatusException(StatusCodes.Bad_ReferenceTypeIdInvalid);
        }
        this.fireDeleteReference(serviceContext, nodeId, uaNode, expandedNodeId, null, nodeId2, uaReferenceType, bl, bl2);
    }

    protected UaNode findNode(ExpandedNodeId expandedNodeId) throws ServiceResultException {
        return this.findNode(this.getNamespaceTable().toNodeId(expandedNodeId));
    }

    protected NodeClass findNodeClass(ExpandedNodeId expandedNodeId, UaNode uaNode) {
        return this.getNodeManagerTable().getNodeClass(expandedNodeId, uaNode);
    }

    protected void fireAddNode(ServiceContext serviceContext, NodeId nodeId, UaNode uaNode, NodeId nodeId2, UaNode uaNode2, NodeClass nodeClass, QualifiedName qualifiedName, NodeAttributes nodeAttributes, UaReferenceType uaReferenceType, ExpandedNodeId expandedNodeId, UaNode uaNode3) throws StatusException {
        for (NodeManagerListener nodeManagerListener : this.listeners) {
            try {
                nodeManagerListener.onAddNode(serviceContext, nodeId, uaNode, nodeId2, uaNode2, nodeClass, qualifiedName, nodeAttributes, uaReferenceType, expandedNodeId, uaNode3);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onAddNode", nodeManagerListener, runtimeException);
            }
        }
    }

    protected void fireAddReference(ServiceContext serviceContext, NodeId nodeId, UaNode uaNode, ExpandedNodeId expandedNodeId, UaNode uaNode2, NodeId nodeId2, UaReferenceType uaReferenceType, boolean bl, UaNode object, String object22) throws StatusException {
        for (NodeManagerListener nodeManagerListener : this.listeners) {
            if (nodeManagerListener == null) continue;
            try {
                nodeManagerListener.onAddReference(serviceContext, nodeId, uaNode, expandedNodeId, uaNode2, nodeId2, uaReferenceType, bl);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onAddReference", nodeManagerListener, runtimeException);
            }
        }
    }

    protected void fireAfterCreateMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, MonitoredDataItem monitoredDataItem) {
        for (NodeManagerListener nodeManagerListener : this.listeners) {
            if (nodeManagerListener == null) continue;
            try {
                nodeManagerListener.onAfterCreateMonitoredDataItem(serviceContext, subscription, monitoredDataItem);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onAfterCreateMonitoredDataItem", nodeManagerListener, runtimeException);
            }
        }
    }

    protected void fireAfterDeleteMonitoredItem(ServiceContext serviceContext, Subscription subscription, MonitoredItem monitoredItem) {
        if (monitoredItem instanceof MonitoredEventItem) {
            EventManager eventManager = this.getEventManager(monitoredItem.getNodeId());
            if (eventManager != null) {
                eventManager.afterDeleteMonitoredEventItem(serviceContext, subscription, (MonitoredEventItem)monitoredItem);
            }
            return;
        }
        for (NodeManagerListener nodeManagerListener : this.listeners) {
            if (nodeManagerListener == null) continue;
            try {
                nodeManagerListener.onAfterDeleteMonitoredDataItem(serviceContext, subscription, (MonitoredDataItem)monitoredItem);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onAfterDeleteMonitoredDataItem", nodeManagerListener, runtimeException);
            }
        }
    }

    protected void fireAfterModifyMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, MonitoredDataItem monitoredDataItem) {
        for (NodeManagerListener nodeManagerListener : this.listeners) {
            if (nodeManagerListener == null) continue;
            try {
                nodeManagerListener.onAfterModifyMonitoredDataItem(serviceContext, subscription, monitoredDataItem);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onAfterModifyMonitoredDataItem", nodeManagerListener, runtimeException);
            }
        }
    }

    protected boolean fireBrowseNode(ServiceContext serviceContext, ViewDescription viewDescription, NodeId nodeId, UaNode uaNode, UaReference uaReference) {
        logger.debug("fireBrowseNode");
        for (NodeManagerListener nodeManagerListener : this.listeners) {
            if (nodeManagerListener == null) continue;
            try {
                if (nodeManagerListener.onBrowseNode(serviceContext, viewDescription, nodeId, uaNode, uaReference)) continue;
                return false;
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onBrowseNode", nodeManagerListener, runtimeException);
            }
        }
        return true;
    }

    protected void fireCreateMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, NodeId nodeId, UaNode uaNode, UnsignedInteger unsignedInteger, NumericRange numericRange, MonitoringParameters monitoringParameters, MonitoringFilter monitoringFilter, AggregateFilterResult aggregateFilterResult) throws StatusException {
        for (NodeManagerListener nodeManagerListener : this.listeners) {
            if (nodeManagerListener == null) continue;
            try {
                nodeManagerListener.onCreateMonitoredDataItem(serviceContext, subscription, nodeId, uaNode, unsignedInteger, numericRange, monitoringParameters, monitoringFilter, aggregateFilterResult);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onCreateMonitoredDataItem", nodeManagerListener, runtimeException);
            }
        }
    }

    protected void fireDeleteMonitoredItem(ServiceContext serviceContext, Subscription subscription, MonitoredItem monitoredItem) {
        if (monitoredItem instanceof MonitoredEventItem) {
            EventManager eventManager = this.getEventManager(monitoredItem.getNodeId());
            if (eventManager != null) {
                eventManager.deleteMonitoredEventItem(serviceContext, subscription, (MonitoredEventItem)monitoredItem);
            }
            return;
        }
        for (NodeManagerListener nodeManagerListener : this.listeners) {
            if (nodeManagerListener == null) continue;
            try {
                nodeManagerListener.onDeleteMonitoredDataItem(serviceContext, subscription, (MonitoredDataItem)monitoredItem);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onDeleteMonitoredDataItem", nodeManagerListener, runtimeException);
            }
        }
    }

    protected void fireDeleteNode(ServiceContext serviceContext, NodeId nodeId, UaNode uaNode, boolean bl) throws StatusException {
        for (NodeManagerListener nodeManagerListener : this.listeners) {
            if (nodeManagerListener == null) continue;
            try {
                nodeManagerListener.onDeleteNode(serviceContext, nodeId, uaNode, bl);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onDeleteNode", nodeManagerListener, runtimeException);
            }
        }
    }

    protected void fireDeleteReference(ServiceContext serviceContext, NodeId nodeId, UaNode uaNode, ExpandedNodeId expandedNodeId, UaNode uaNode2, NodeId nodeId2, UaReferenceType uaReferenceType, boolean bl, boolean bl2) throws StatusException {
        for (NodeManagerListener nodeManagerListener : this.listeners) {
            if (nodeManagerListener == null) continue;
            try {
                nodeManagerListener.onDeleteReference(serviceContext, nodeId, uaNode, expandedNodeId, uaNode2, nodeId2, uaReferenceType, bl, bl2);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onDeleteReference", nodeManagerListener, runtimeException);
            }
        }
    }

    protected void fireModifyMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, MonitoredDataItem monitoredDataItem, UaNode uaNode, MonitoringParameters monitoringParameters, MonitoringFilter monitoringFilter, AggregateFilterResult aggregateFilterResult) throws StatusException {
        for (NodeManagerListener nodeManagerListener : this.listeners) {
            if (nodeManagerListener == null) continue;
            try {
                nodeManagerListener.onModifyMonitoredDataItem(serviceContext, subscription, monitoredDataItem, uaNode, monitoringParameters, monitoringFilter, aggregateFilterResult);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onModifyMonitoredDataItem", nodeManagerListener, runtimeException);
            }
        }
    }

    protected abstract QualifiedName getBrowseName(ExpandedNodeId var1, UaNode var2);

    protected abstract LocalizedText getDisplayName(ExpandedNodeId var1, UaNode var2, Locale var3);

    protected EventManager getEventManager(NodeId nodeId) {
        return this.hz;
    }

    protected boolean getIsOfType(NodeId nodeId, UaType uaType, NodeId nodeId2, UaType uaType2) throws StatusException {
        if (nodeId == null) {
            logger.debug("isOfType: typeDefinitionId == null: return=false");
            return false;
        }
        if (nodeId2 == null) {
            logger.debug("isOfType: expectedTypeId == null: return=false");
            return false;
        }
        if (nodeId.equals((Object)nodeId2)) {
            logger.debug("isOfType: typeDefinitionId equals expectedTypeId: return=true");
            return true;
        }
        if (uaType2 != null && uaType != null) {
            if (uaType.inheritsFrom(uaType2)) {
                logger.debug("isOfType: typeDefinition inherits expectedType: return=true");
                return true;
            }
        } else {
            UaReference[] uaReferenceArray = this.getReferences(nodeId, uaType);
            if (uaReferenceArray != null) {
                for (UaReference uaReference : uaReferenceArray) {
                    if (!uaReference.getIsInverse(nodeId) || !uaReference.getReferenceTypeId().equals((Object)Identifiers.HasSubtype)) continue;
                    try {
                        return this.isOfType(this.getNamespaceTable().toNodeId(uaReference.getSourceId()), uaType, nodeId2, uaType2);
                    }
                    catch (ServiceResultException serviceResultException) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("isOfType: cannot convert SourceId of reference inverse HasSubtype reference ({}) to NodeId: return=false", (Object)uaReference.getSourceId());
                        }
                        return false;
                    }
                }
            }
        }
        logger.debug("isOfType: return=false");
        return false;
    }

    protected NodeClass getNodeClass(ExpandedNodeId expandedNodeId, UaNode uaNode) {
        if (uaNode != null) {
            return this.getNodeClass(uaNode.getNodeId(), uaNode);
        }
        try {
            return this.getNodeClass(this.getNamespaceTable().toNodeId(expandedNodeId), uaNode);
        }
        catch (ServiceResultException serviceResultException) {
            return NodeClass.Unspecified;
        }
    }

    protected abstract NodeClass getNodeClass(NodeId var1, UaNode var2);

    protected abstract UaReference[] getReferences(NodeId var1, UaNode var2);

    protected UaReferenceType getReferenceType(NodeId nodeId) throws StatusException {
        UaReferenceType uaReferenceType;
        try {
            uaReferenceType = (UaReferenceType)this.getNode(nodeId);
            if (uaReferenceType == null && !NodeClass.ReferenceType.equals((Object)(nodeId = this.getNodeClass(nodeId, null)))) {
                throw new StatusException(StatusCodes.Bad_ReferenceTypeIdInvalid);
            }
        }
        catch (StatusException statusException) {
            logger.debug("Failed to get the ReferenceType", (Throwable)statusException);
            throw new StatusException(StatusCodes.Bad_ReferenceTypeIdInvalid, (Throwable)statusException);
        }
        catch (ClassCastException classCastException) {
            logger.debug("Failed to get the ReferenceType", (Throwable)classCastException);
            throw new StatusException(StatusCodes.Bad_ReferenceTypeIdInvalid, (Throwable)classCastException);
        }
        return uaReferenceType;
    }

    protected abstract ExpandedNodeId getTypeDefinition(ExpandedNodeId var1, UaNode var2);

    protected void init() throws StatusException, UaNodeFactoryException {
        this.initialized = true;
    }

    protected void modifyMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, MonitoredDataItem monitoredDataItem, MonitoringParameters monitoringParameters, MonitoringFilter monitoringFilter, AggregateFilterResult aggregateFilterResult) throws StatusException {
        UaNode uaNode = this.getNode(monitoredDataItem.getNodeId());
        this.fireModifyMonitoredDataItem(serviceContext, subscription, monitoredDataItem, uaNode, monitoringParameters, monitoringFilter, aggregateFilterResult);
    }

    protected void modifyMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, MonitoredEventItem monitoredEventItem, EventFilter eventFilter, EventFilterResult eventFilterResult) throws StatusException {
        EventManager eventManager = this.getEventManager(monitoredEventItem.getNodeId());
        if (eventManager != null) {
            eventManager.modifyMonitoredEventItem(serviceContext, subscription, monitoredEventItem, eventFilter, eventFilterResult);
        }
    }

    protected void queryFirst(ServiceContext serviceContext, QueryFirstRequest queryFirstRequest, QueryFirstResponse queryFirstResponse) throws ServiceException {
        throw new ServiceException(StatusCodes.Bad_NotImplemented);
    }

    protected void queryNext(ServiceContext serviceContext, QueryNextRequest queryNextRequest, QueryNextResponse queryNextResponse) throws ServiceException {
        throw new ServiceException(StatusCodes.Bad_NotImplemented);
    }

    protected boolean referenceMatchesRequest(UaReference object, BrowseDirection browseDirection, NodeId object2, UaReferenceType object3, Boolean bl, QualifiedName qualifiedName, NodeId nodeId) {
        logger.debug("referenceMatchesRequest: n={}", object);
        logger.debug("referenceMatchesRequest: referenceType={}", object3);
        if (object3 != null && !object3.getNodeId().equals((Object)((UaReference)object).getReferenceTypeId())) {
            try {
                object2 = this.getReferenceType(((UaReference)object).getReferenceTypeId());
                logger.debug("referenceMatchesRequest: r={}", object2);
                if (bl != false ? !object2.inheritsFrom((UaType)object3) : !object2.equals(object3)) {
                    return false;
                }
            }
            catch (StatusException statusException) {
                return false;
            }
        }
        if (browseDirection == BrowseDirection.Forward && ((UaReference)object).getIsInverse(nodeId)) {
            return false;
        }
        if (browseDirection == BrowseDirection.Inverse && !((UaReference)object).getIsInverse(nodeId)) {
            return false;
        }
        if (!QualifiedName.isNull((QualifiedName)qualifiedName)) {
            object2 = browseDirection == BrowseDirection.Forward ? ((UaReference)object).getTargetId() : ((UaReference)object).getSourceId();
            try {
                object3 = this.getNodeManagerTable().getNodeManager((ExpandedNodeId)object2);
            }
            catch (StatusException statusException) {
                logger.debug("referenceMatchesRequest: targetNodeManager not found for targetId={}", object2);
                return false;
            }
            object = browseDirection == BrowseDirection.Forward ? ((UaReference)object).getTargetNode() : ((UaReference)object).getSourceNode();
            object = ((NodeManager)object3).getBrowseName((ExpandedNodeId)object2, (UaNode)object);
            if (!qualifiedName.equals(object)) {
                return false;
            }
        }
        logger.debug("referenceMatchesRequest: true");
        return true;
    }

    protected NodeId registerNode(ServiceContext serviceContext, NodeId nodeId) throws StatusException {
        this.getNode(nodeId);
        return nodeId;
    }

    protected void start() throws StatusException, UaNodeFactoryException {
        if (!this.initialized) {
            this.init();
        }
        this.started = true;
    }

    protected BrowsePathTarget[] translateBrowsePath(ServiceContext serviceContext, NodeId nodeId, RelativePath relativePath) throws StatusException, ServiceException {
        if (logger.isDebugEnabled()) {
            logger.debug("translateBrowsePath: startingNodeId={}", (Object)nodeId);
            logger.debug("translateBrowsePath: relativePath={}", (Object)ObjectUtils.toString((Object)relativePath));
        }
        BrowsePathTarget[] browsePathTargetArray = new BrowsePathTarget[1];
        BrowsePathTarget[] browsePathTargetArray2 = browsePathTargetArray;
        browsePathTargetArray[0] = new BrowsePathTarget();
        try {
            for (int i2 = 0; i2 < relativePath.getElements().length; ++i2) {
                RelativePathElement relativePathElement = relativePath.getElements()[i2];
                Object object = relativePathElement.getIsInverse() != false ? BrowseDirection.Inverse : BrowseDirection.Forward;
                ReferenceDescription referenceDescription2 = new ArrayList();
                NodeManager nodeManager = this.getNodeManagerTable().getNodeManager(nodeId);
                try {
                    nodeManager.browseNode(serviceContext, (List<ReferenceDescription>)referenceDescription2, nodeId, 1000, (BrowseDirection)object, relativePathElement.getReferenceTypeId(), relativePathElement.getIncludeSubtypes(), relativePathElement.getTargetName(), NodeClass.ALL, EnumSet.of(BrowseResultMask.BrowseName), null, 0);
                }
                catch (StatusException statusException) {
                    object = statusException;
                    if (statusException.getStatusCode().getValue().equals((Object)StatusCodes.Bad_ReferenceTypeIdInvalid)) {
                        throw new StatusException("Reference Type Invalid", StatusCodes.Bad_NoMatch);
                    }
                    throw object;
                }
                if (referenceDescription2.size() == 0) {
                    throw new StatusException("Target not found: " + relativePathElement.getTargetName(), StatusCodes.Bad_NoMatch);
                }
                for (ReferenceDescription referenceDescription2 : referenceDescription2) {
                    if (relativePathElement.getTargetName() != null && !relativePathElement.getTargetName().equals((Object)referenceDescription2.getBrowseName())) continue;
                    try {
                        nodeId = this.getNamespaceTable().toNodeId(referenceDescription2.getNodeId());
                        browsePathTargetArray2[0].setTargetId(referenceDescription2.getNodeId());
                    }
                    catch (ServiceResultException serviceResultException) {
                        throw new a(this, i2);
                    }
                }
                browsePathTargetArray2[0].setRemainingPathIndex(UnsignedInteger.MAX_VALUE);
            }
        }
        catch (a a2) {
            browsePathTargetArray2[0].setRemainingPathIndex(a2.getRemainingPathIndex());
        }
        return browsePathTargetArray2;
    }

    protected void unregisterNode(ServiceContext serviceContext, NodeId nodeId) {
    }

    final class a
    extends Exception {
        private final UnsignedInteger bs;

        public a(NodeManager nodeManager, int n2) {
            this.bs = UnsignedInteger.valueOf((long)n2);
        }

        public final UnsignedInteger getRemainingPathIndex() {
            return this.bs;
        }
    }
}

