/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaNodeFactoryException;
import com.prosysopc.ua.nodes.UaView;
import com.prosysopc.ua.server.BrowseContinuationPoint;
import com.prosysopc.ua.server.NodeManagerTable;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.ServiceHandler;
import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.server.SessionManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.ServiceRequest;
import org.opcfoundation.ua.builtintypes.ServiceResponse;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.common.ServiceFaultException;
import org.opcfoundation.ua.core.AddNodesItem;
import org.opcfoundation.ua.core.AddNodesRequest;
import org.opcfoundation.ua.core.AddNodesResponse;
import org.opcfoundation.ua.core.AddNodesResult;
import org.opcfoundation.ua.core.AddReferencesItem;
import org.opcfoundation.ua.core.AddReferencesRequest;
import org.opcfoundation.ua.core.AddReferencesResponse;
import org.opcfoundation.ua.core.BrowseDirection;
import org.opcfoundation.ua.core.BrowseNextRequest;
import org.opcfoundation.ua.core.BrowseNextResponse;
import org.opcfoundation.ua.core.BrowsePathResult;
import org.opcfoundation.ua.core.BrowsePathTarget;
import org.opcfoundation.ua.core.BrowseRequest;
import org.opcfoundation.ua.core.BrowseResponse;
import org.opcfoundation.ua.core.BrowseResult;
import org.opcfoundation.ua.core.BrowseResultMask;
import org.opcfoundation.ua.core.CallMethodResult;
import org.opcfoundation.ua.core.CallRequest;
import org.opcfoundation.ua.core.CallResponse;
import org.opcfoundation.ua.core.DeleteNodesItem;
import org.opcfoundation.ua.core.DeleteNodesRequest;
import org.opcfoundation.ua.core.DeleteNodesResponse;
import org.opcfoundation.ua.core.DeleteReferencesItem;
import org.opcfoundation.ua.core.DeleteReferencesRequest;
import org.opcfoundation.ua.core.DeleteReferencesResponse;
import org.opcfoundation.ua.core.MethodServiceSetHandler;
import org.opcfoundation.ua.core.NodeClass;
import org.opcfoundation.ua.core.NodeManagementServiceSetHandler;
import org.opcfoundation.ua.core.QueryFirstRequest;
import org.opcfoundation.ua.core.QueryFirstResponse;
import org.opcfoundation.ua.core.QueryNextRequest;
import org.opcfoundation.ua.core.QueryNextResponse;
import org.opcfoundation.ua.core.ReferenceDescription;
import org.opcfoundation.ua.core.RegisterNodesRequest;
import org.opcfoundation.ua.core.RegisterNodesResponse;
import org.opcfoundation.ua.core.RelativePath;
import org.opcfoundation.ua.core.RelativePathElement;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.core.TranslateBrowsePathsToNodeIdsRequest;
import org.opcfoundation.ua.core.TranslateBrowsePathsToNodeIdsResponse;
import org.opcfoundation.ua.core.UnregisterNodesRequest;
import org.opcfoundation.ua.core.UnregisterNodesResponse;
import org.opcfoundation.ua.core.ViewDescription;
import org.opcfoundation.ua.transport.endpoint.EndpointServiceRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeManagementServiceHandler
extends ServiceHandler
implements MethodServiceSetHandler,
NodeManagementServiceSetHandler {
    private static Logger logger = LoggerFactory.getLogger(NodeManagementServiceHandler.class);
    private int bn = 10000;

    public NodeManagementServiceHandler(SessionManager sessionManager, NodeManagerTable nodeManagerTable) {
        super(sessionManager, nodeManagerTable);
    }

    public int getMaxNodesPerBrowse() {
        return this.getOperationLimits().getMaxNodesPerBrowse().intValue();
    }

    public int getMaxNodesPerMethodCall() {
        return this.getOperationLimits().getMaxNodesPerMethodCall().intValue();
    }

    public int getMaxNodesPerNodeManagement() {
        return this.getOperationLimits().getMaxNodesPerNodeManagement().intValue();
    }

    public int getMaxNodesPerRegisterNodes() {
        return this.getOperationLimits().getMaxNodesPerRegisterNodes().intValue();
    }

    public int getMaxNodesPerTranslateBrowsePathsToNodeIds() {
        return this.getOperationLimits().getMaxNodesPerTranslateBrowsePathsToNodeIds().intValue();
    }

    public int getMaxReferencesPerNode() {
        return this.bn;
    }

    public final void onAddNodes(EndpointServiceRequest<AddNodesRequest, AddNodesResponse> endpointServiceRequest) throws ServiceFaultException {
        AddNodesRequest addNodesRequest = (AddNodesRequest)endpointServiceRequest.getRequest();
        AddNodesResponse addNodesResponse = new AddNodesResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest((ServiceRequest)addNodesRequest, endpointServiceRequest.getChannel());
            this.addNodes(serviceContext, addNodesRequest, addNodesResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException((ServiceResponse)addNodesResponse, serviceException);
        }
        this.validateResponse((ServiceRequest)addNodesRequest, (ServiceResponse)addNodesResponse, serviceContext);
        endpointServiceRequest.sendResponse((ServiceResponse)addNodesResponse);
    }

    public final void onAddReferences(EndpointServiceRequest<AddReferencesRequest, AddReferencesResponse> endpointServiceRequest) throws ServiceFaultException {
        AddReferencesRequest addReferencesRequest = (AddReferencesRequest)endpointServiceRequest.getRequest();
        AddReferencesResponse addReferencesResponse = new AddReferencesResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest((ServiceRequest)addReferencesRequest, endpointServiceRequest.getChannel());
            this.addReferences(serviceContext, addReferencesRequest, addReferencesResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException((ServiceResponse)addReferencesResponse, serviceException);
        }
        this.validateResponse((ServiceRequest)addReferencesRequest, (ServiceResponse)addReferencesResponse, serviceContext);
        endpointServiceRequest.sendResponse((ServiceResponse)addReferencesResponse);
    }

    public final void onBrowse(EndpointServiceRequest<BrowseRequest, BrowseResponse> endpointServiceRequest) throws ServiceFaultException {
        BrowseRequest browseRequest = (BrowseRequest)endpointServiceRequest.getRequest();
        BrowseResponse browseResponse = new BrowseResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest((ServiceRequest)browseRequest, endpointServiceRequest.getChannel());
            this.browse(serviceContext, browseRequest, browseResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException((ServiceResponse)browseResponse, serviceException);
        }
        browseResponse.setDiagnosticInfos(this.validateResponse((ServiceRequest)browseRequest, (ServiceResponse)browseResponse, serviceContext, browseResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse((ServiceResponse)browseResponse);
    }

    public final void onBrowseNext(EndpointServiceRequest<BrowseNextRequest, BrowseNextResponse> endpointServiceRequest) throws ServiceFaultException {
        BrowseNextRequest browseNextRequest = (BrowseNextRequest)endpointServiceRequest.getRequest();
        BrowseNextResponse browseNextResponse = new BrowseNextResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest((ServiceRequest)browseNextRequest, endpointServiceRequest.getChannel());
            this.browseNext(serviceContext, browseNextRequest, browseNextResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException((ServiceResponse)browseNextResponse, serviceException);
        }
        browseNextResponse.setDiagnosticInfos(this.validateResponse((ServiceRequest)browseNextRequest, (ServiceResponse)browseNextResponse, serviceContext, browseNextResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse((ServiceResponse)browseNextResponse);
    }

    public final void onCall(EndpointServiceRequest<CallRequest, CallResponse> endpointServiceRequest) throws ServiceFaultException {
        CallRequest callRequest = (CallRequest)endpointServiceRequest.getRequest();
        CallResponse callResponse = new CallResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest((ServiceRequest)callRequest, endpointServiceRequest.getChannel());
            this.call(serviceContext, callRequest, callResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException((ServiceResponse)callResponse, serviceException);
        }
        callResponse.setDiagnosticInfos(this.validateResponse((ServiceRequest)callRequest, (ServiceResponse)callResponse, serviceContext, callResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse((ServiceResponse)callResponse);
    }

    public final void onDeleteNodes(EndpointServiceRequest<DeleteNodesRequest, DeleteNodesResponse> endpointServiceRequest) throws ServiceFaultException {
        DeleteNodesRequest deleteNodesRequest = (DeleteNodesRequest)endpointServiceRequest.getRequest();
        DeleteNodesResponse deleteNodesResponse = new DeleteNodesResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest((ServiceRequest)deleteNodesRequest, endpointServiceRequest.getChannel());
            this.deleteNodes(serviceContext, deleteNodesRequest, deleteNodesResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException((ServiceResponse)deleteNodesResponse, serviceException);
        }
        this.validateResponse((ServiceRequest)deleteNodesRequest, (ServiceResponse)deleteNodesResponse, serviceContext);
        endpointServiceRequest.sendResponse((ServiceResponse)deleteNodesResponse);
    }

    public final void onDeleteReferences(EndpointServiceRequest<DeleteReferencesRequest, DeleteReferencesResponse> endpointServiceRequest) throws ServiceFaultException {
        DeleteReferencesRequest deleteReferencesRequest = (DeleteReferencesRequest)endpointServiceRequest.getRequest();
        DeleteReferencesResponse deleteReferencesResponse = new DeleteReferencesResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest((ServiceRequest)deleteReferencesRequest, endpointServiceRequest.getChannel());
            this.deleteReferences(serviceContext, deleteReferencesRequest, deleteReferencesResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException((ServiceResponse)deleteReferencesResponse, serviceException);
        }
        this.validateResponse((ServiceRequest)deleteReferencesRequest, (ServiceResponse)deleteReferencesResponse, serviceContext);
        endpointServiceRequest.sendResponse((ServiceResponse)deleteReferencesResponse);
    }

    public final void onQueryFirst(EndpointServiceRequest<QueryFirstRequest, QueryFirstResponse> endpointServiceRequest) throws ServiceFaultException {
        QueryFirstRequest queryFirstRequest = (QueryFirstRequest)endpointServiceRequest.getRequest();
        QueryFirstResponse queryFirstResponse = new QueryFirstResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest((ServiceRequest)queryFirstRequest, endpointServiceRequest.getChannel());
            this.queryFirst(serviceContext, queryFirstRequest, queryFirstResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException((ServiceResponse)queryFirstResponse, serviceException);
        }
        this.validateResponse((ServiceRequest)queryFirstRequest, (ServiceResponse)queryFirstResponse, serviceContext);
        endpointServiceRequest.sendResponse((ServiceResponse)queryFirstResponse);
    }

    public final void onQueryNext(EndpointServiceRequest<QueryNextRequest, QueryNextResponse> endpointServiceRequest) throws ServiceFaultException {
        QueryNextRequest queryNextRequest = (QueryNextRequest)endpointServiceRequest.getRequest();
        QueryNextResponse queryNextResponse = new QueryNextResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest((ServiceRequest)queryNextRequest, endpointServiceRequest.getChannel());
            this.queryNext(serviceContext, queryNextRequest, queryNextResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException((ServiceResponse)queryNextResponse, serviceException);
        }
        this.validateResponse((ServiceRequest)queryNextRequest, (ServiceResponse)queryNextResponse, serviceContext);
        endpointServiceRequest.sendResponse((ServiceResponse)queryNextResponse);
    }

    public final void onRegisterNodes(EndpointServiceRequest<RegisterNodesRequest, RegisterNodesResponse> endpointServiceRequest) throws ServiceFaultException {
        RegisterNodesRequest registerNodesRequest = (RegisterNodesRequest)endpointServiceRequest.getRequest();
        RegisterNodesResponse registerNodesResponse = new RegisterNodesResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest((ServiceRequest)registerNodesRequest, endpointServiceRequest.getChannel());
            this.registerNodes(serviceContext, registerNodesRequest, registerNodesResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException((ServiceResponse)registerNodesResponse, serviceException);
        }
        this.validateResponse((ServiceRequest)registerNodesRequest, (ServiceResponse)registerNodesResponse, serviceContext);
        endpointServiceRequest.sendResponse((ServiceResponse)registerNodesResponse);
    }

    public final void onTranslateBrowsePathsToNodeIds(EndpointServiceRequest<TranslateBrowsePathsToNodeIdsRequest, TranslateBrowsePathsToNodeIdsResponse> endpointServiceRequest) throws ServiceFaultException {
        TranslateBrowsePathsToNodeIdsRequest translateBrowsePathsToNodeIdsRequest = (TranslateBrowsePathsToNodeIdsRequest)endpointServiceRequest.getRequest();
        TranslateBrowsePathsToNodeIdsResponse translateBrowsePathsToNodeIdsResponse = new TranslateBrowsePathsToNodeIdsResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest((ServiceRequest)translateBrowsePathsToNodeIdsRequest, endpointServiceRequest.getChannel());
            this.translateBrowsePathsToNodeIds(serviceContext, translateBrowsePathsToNodeIdsRequest, translateBrowsePathsToNodeIdsResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException((ServiceResponse)translateBrowsePathsToNodeIdsResponse, serviceException);
        }
        this.validateResponse((ServiceRequest)translateBrowsePathsToNodeIdsRequest, (ServiceResponse)translateBrowsePathsToNodeIdsResponse, serviceContext);
        translateBrowsePathsToNodeIdsResponse.setDiagnosticInfos(NodeManagementServiceHandler.validateOperationalDiagnostics((ServiceRequest)translateBrowsePathsToNodeIdsRequest, translateBrowsePathsToNodeIdsResponse.getDiagnosticInfos()));
        if (translateBrowsePathsToNodeIdsResponse.getDiagnosticInfos() != null) {
            translateBrowsePathsToNodeIdsResponse.getResponseHeader().setStringTable(stringTable);
        }
        endpointServiceRequest.sendResponse((ServiceResponse)translateBrowsePathsToNodeIdsResponse);
    }

    public final void onUnregisterNodes(EndpointServiceRequest<UnregisterNodesRequest, UnregisterNodesResponse> endpointServiceRequest) throws ServiceFaultException {
        UnregisterNodesRequest unregisterNodesRequest = (UnregisterNodesRequest)endpointServiceRequest.getRequest();
        UnregisterNodesResponse unregisterNodesResponse = new UnregisterNodesResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest((ServiceRequest)unregisterNodesRequest, endpointServiceRequest.getChannel());
            this.unregisterNodes(serviceContext, unregisterNodesRequest, unregisterNodesResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException((ServiceResponse)unregisterNodesResponse, serviceException);
        }
        this.validateResponse((ServiceRequest)unregisterNodesRequest, (ServiceResponse)unregisterNodesResponse, serviceContext);
        endpointServiceRequest.sendResponse((ServiceResponse)unregisterNodesResponse);
    }

    public void setMaxNodesPerBrowse(int n2) {
        this.getOperationLimits().setMaxNodesPerBrowse(UnsignedInteger.valueOf((long)n2));
    }

    public void setMaxNodesPerMethodCall(int n2) {
        this.getOperationLimits().setMaxNodesPerMethodCall(UnsignedInteger.valueOf((long)n2));
    }

    public void setMaxNodesPerNodeManagement(int n2) {
        this.getOperationLimits().setMaxNodesPerNodeManagement(UnsignedInteger.valueOf((long)n2));
    }

    public void setMaxNodesPerRegisterNodes(int n2) {
        this.getOperationLimits().setMaxNodesPerRegisterNodes(UnsignedInteger.valueOf((long)n2));
    }

    public void setMaxNodesPerTranslateBrowsePathsToNodeIds(int n2) {
        this.getOperationLimits().setMaxNodesPerTranslateBrowsePathsToNodeIds(UnsignedInteger.valueOf((long)n2));
    }

    public void setMaxReferencesPerNode(int n2) {
        this.bn = n2;
    }

    public void start() throws StatusException, UaNodeFactoryException {
        this.getNodeManagerTable().start();
    }

    protected NodeId addNode(ServiceContext serviceContext, AddNodesItem addNodesItem) throws StatusException, ServiceException, UaNodeFactoryException {
        return this.getNodeManagerTable().addNode(serviceContext, addNodesItem);
    }

    protected void addNodes(ServiceContext serviceContext, AddNodesRequest objectArray, AddNodesResponse addNodesResponse) throws ServiceException {
        AddNodesResult[] addNodesResultArray = this;
        this.getNodeManagerTable().checkNodeManagementEnabled();
        objectArray = objectArray.getNodesToAdd();
        this.checkRequestLength(objectArray, this.getMaxNodesPerNodeManagement());
        addNodesResultArray = new AddNodesResult[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            addNodesResultArray[i2] = new AddNodesResult();
            try {
                NodeId nodeId = this.addNode(serviceContext, (AddNodesItem)objectArray[i2]);
                addNodesResultArray[i2].setAddedNodeId(nodeId);
                addNodesResultArray[i2].setStatusCode(StatusCode.GOOD);
                continue;
            }
            catch (StatusException statusException) {
                logger.warn("StatusException: ", (Throwable)statusException);
                addNodesResultArray[i2].setStatusCode(statusException.getStatusCode());
                diagnosticInfoArray[i2] = statusException.getDiagnosticInfo();
                continue;
            }
            catch (UaNodeFactoryException uaNodeFactoryException) {
                logger.error("UaNodeFactoryException: ", (Throwable)uaNodeFactoryException);
                addNodesResultArray[i2].setStatusCode(new StatusCode(StatusCodes.Bad_NodeClassInvalid));
            }
        }
        addNodesResponse.setResults(addNodesResultArray);
        addNodesResponse.setDiagnosticInfos(diagnosticInfoArray);
    }

    protected void addReference(ServiceContext serviceContext, AddReferencesItem addReferencesItem) throws StatusException, ServiceException {
        this.getNodeManagerTable().addReference(serviceContext, addReferencesItem);
    }

    protected void addReferences(ServiceContext serviceContext, AddReferencesRequest objectArray, AddReferencesResponse addReferencesResponse) throws ServiceException {
        StatusCode[] statusCodeArray = this;
        this.getNodeManagerTable().checkNodeManagementEnabled();
        objectArray = objectArray.getReferencesToAdd();
        this.checkRequestLength(objectArray, this.getMaxNodesPerNodeManagement());
        statusCodeArray = new StatusCode[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            try {
                this.addReference(serviceContext, (AddReferencesItem)objectArray[i2]);
                statusCodeArray[i2] = StatusCode.GOOD;
                continue;
            }
            catch (StatusException statusException) {
                logger.warn("StatusException: ", (Throwable)statusException);
                statusCodeArray[i2] = statusException.getStatusCode();
                diagnosticInfoArray[i2] = statusException.getDiagnosticInfo();
            }
        }
        addReferencesResponse.setResults(statusCodeArray);
        addReferencesResponse.setDiagnosticInfos(diagnosticInfoArray);
    }

    protected void browse(ServiceContext serviceContext, BrowseRequest browseRequest, BrowseResponse browseResponse) throws ServiceException {
        Object[] objectArray = browseRequest.getNodesToBrowse();
        this.checkRequestLength(objectArray, this.getMaxNodesPerBrowse());
        ViewDescription viewDescription = browseRequest.getView();
        BrowseResult[] browseResultArray = viewDescription == null || NodeId.isNull((NodeId)viewDescription.getViewId()) ? null : this.getView(viewDescription.getViewId(), viewDescription.getViewVersion(), viewDescription.getTimestamp());
        logger.debug("browse: view={}", browseResultArray);
        int n2 = browseRequest.getRequestedMaxReferencesPerNode().getValue() < (long)this.bn ? browseRequest.getRequestedMaxReferencesPerNode().intValue() : this.bn;
        browseResultArray = new BrowseResult[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            try {
                EnumSet enumSet;
                browseResultArray[i2] = new BrowseResult();
                ArrayList<ReferenceDescription> arrayList = new ArrayList<ReferenceDescription>();
                Object object = objectArray[i2];
                EnumSet enumSet2 = object.getNodeClassMask().getValue() == 0L ? NodeClass.ALL : NodeClass.getSet((UnsignedInteger)object.getNodeClassMask());
                EnumSet enumSet3 = enumSet = object.getResultMask().getValue() == 0L ? BrowseResultMask.NONE : BrowseResultMask.getSet((UnsignedInteger)object.getResultMask());
                if (object.getBrowseDirection() == null) {
                    throw new StatusException("BrowseDirection==null", StatusCodes.Bad_BrowseDirectionInvalid);
                }
                if ((object = this.browseNode(serviceContext, arrayList, object.getNodeId(), n2, object.getBrowseDirection(), object.getReferenceTypeId(), object.getIncludeSubtypes(), enumSet2, enumSet, viewDescription, 0)) != null) {
                    browseResultArray[i2].setContinuationPoint(serviceContext.getSession().addBrowseContinuationPoint((BrowseContinuationPoint)object));
                }
                browseResultArray[i2].setReferences(arrayList.toArray(new ReferenceDescription[arrayList.size()]));
                browseResultArray[i2].setStatusCode(StatusCode.GOOD);
                continue;
            }
            catch (ServiceException serviceException) {
                logger.debug("ServiceException: ", (Throwable)serviceException);
                browseResultArray[i2].setStatusCode(serviceException.getServiceResult());
                diagnosticInfoArray[i2] = serviceException.getDiagnosticInfo();
                browseResponse.setDiagnosticInfos(diagnosticInfoArray);
                continue;
            }
            catch (StatusException statusException) {
                logger.debug("StatusException: ", (Throwable)statusException);
                browseResultArray[i2].setStatusCode(statusException.getStatusCode());
                diagnosticInfoArray[i2] = statusException.getDiagnosticInfo();
                browseResponse.setDiagnosticInfos(diagnosticInfoArray);
            }
        }
        browseResponse.setResults(browseResultArray);
    }

    protected void browseNext(ServiceContext serviceContext, BrowseNextRequest browseNextRequest, BrowseNextResponse browseNextResponse) throws ServiceException {
        byte[][] byArray = browseNextRequest.getContinuationPoints();
        this.checkRequestLength((Object[])byArray, this.getMaxNodesPerBrowse());
        logger.debug("browseNext: continuationPoints={} releaseContinuationPoints={}", (Object)Arrays.toString((Object[])byArray), (Object)browseNextRequest.getReleaseContinuationPoints());
        BrowseResult[] browseResultArray = new BrowseResult[byArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            try {
                browseResultArray[i2] = new BrowseResult();
                Session session = serviceContext.getSession();
                BrowseContinuationPoint browseContinuationPoint = session.getBrowseContinuationPoint(byArray[i2]);
                if (!browseNextRequest.getReleaseContinuationPoints().booleanValue()) {
                    logger.debug("browseNext: c={}", (Object)browseContinuationPoint);
                    ArrayList<ReferenceDescription> arrayList = new ArrayList<ReferenceDescription>();
                    browseContinuationPoint = this.browseNode(serviceContext, arrayList, browseContinuationPoint.getNodeId(), browseContinuationPoint.getMaxResultsToReturn(), browseContinuationPoint.getBrowseDirection(), browseContinuationPoint.getReferenceTypeId(), browseContinuationPoint.isIncludeSubtypes(), browseContinuationPoint.getNodeClassMask(), browseContinuationPoint.getResultMask(), browseContinuationPoint.getView(), browseContinuationPoint.getIndex());
                    if (browseContinuationPoint != null) {
                        browseResultArray[i2].setContinuationPoint(session.addBrowseContinuationPoint(browseContinuationPoint));
                    }
                    browseResultArray[i2].setReferences(arrayList.toArray(new ReferenceDescription[arrayList.size()]));
                }
                browseResultArray[i2].setStatusCode(StatusCode.GOOD);
                continue;
            }
            catch (StatusException statusException) {
                logger.debug("StatusException: ", (Throwable)statusException);
                browseResultArray[i2].setStatusCode(statusException.getStatusCode());
                diagnosticInfoArray[i2] = statusException.getDiagnosticInfo();
            }
        }
        browseNextResponse.setResults(browseResultArray);
        browseNextResponse.setDiagnosticInfos(diagnosticInfoArray);
    }

    protected BrowseContinuationPoint browseNode(ServiceContext serviceContext, List<ReferenceDescription> list, NodeId nodeId, int n2, BrowseDirection browseDirection, NodeId nodeId2, Boolean bl, EnumSet<NodeClass> enumSet, EnumSet<BrowseResultMask> enumSet2, ViewDescription viewDescription, int n3) throws ServiceException, StatusException {
        return this.getNodeManagerTable().browseNode(serviceContext, list, nodeId, n2, browseDirection, nodeId2, bl, null, enumSet, enumSet2, viewDescription, n3);
    }

    protected void call(ServiceContext serviceContext, CallRequest objectArray, CallResponse callResponse) throws ServiceException {
        objectArray = objectArray.getMethodsToCall();
        this.checkRequestLength(objectArray, this.getMaxNodesPerMethodCall());
        CallMethodResult[] callMethodResultArray = new CallMethodResult[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object object = objectArray[i2];
            Variant[] variantArray = object.getInputArguments();
            callMethodResultArray[i2] = new CallMethodResult();
            int n2 = variantArray == null ? 0 : variantArray.length;
            StatusCode[] statusCodeArray = variantArray == null ? null : new StatusCode[n2];
            DiagnosticInfo[] diagnosticInfoArray2 = variantArray == null ? null : new DiagnosticInfo[n2];
            try {
                callMethodResultArray[i2].setOutputArguments(this.callMethod(serviceContext, object.getObjectId(), object.getMethodId(), variantArray, statusCodeArray, diagnosticInfoArray2));
                callMethodResultArray[i2].setStatusCode(StatusCode.GOOD);
            }
            catch (StatusException statusException) {
                logger.debug("Call failed", (Throwable)statusException);
                callMethodResultArray[i2].setStatusCode(statusException.getStatusCode());
                diagnosticInfoArray[i2] = statusException.getDiagnosticInfo();
            }
            callMethodResultArray[i2].setInputArgumentResults(statusCodeArray);
            callMethodResultArray[i2].setInputArgumentDiagnosticInfos(diagnosticInfoArray2);
        }
        callResponse.setResults(callMethodResultArray);
        callResponse.setDiagnosticInfos(diagnosticInfoArray);
    }

    protected Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, NodeId nodeId2, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return this.getNodeManagerTable().callMethod(serviceContext, nodeId, nodeId2, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    protected void deleteNode(ServiceContext serviceContext, DeleteNodesItem deleteNodesItem) throws StatusException {
        this.getNodeManagerTable().deleteNode(serviceContext, deleteNodesItem.getNodeId(), deleteNodesItem.getDeleteTargetReferences());
    }

    protected void deleteNodes(ServiceContext serviceContext, DeleteNodesRequest objectArray, DeleteNodesResponse deleteNodesResponse) throws ServiceException {
        StatusCode[] statusCodeArray = this;
        this.getNodeManagerTable().checkNodeManagementEnabled();
        objectArray = objectArray.getNodesToDelete();
        this.checkRequestLength(objectArray, this.getMaxNodesPerNodeManagement());
        statusCodeArray = new StatusCode[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            try {
                this.deleteNode(serviceContext, (DeleteNodesItem)objectArray[i2]);
                statusCodeArray[i2] = StatusCode.GOOD;
                continue;
            }
            catch (StatusException statusException) {
                logger.warn("StatusException: ", (Throwable)statusException);
                statusCodeArray[i2] = statusException.getStatusCode();
                diagnosticInfoArray[i2] = statusException.getDiagnosticInfo();
            }
        }
        deleteNodesResponse.setResults(statusCodeArray);
        deleteNodesResponse.setDiagnosticInfos(diagnosticInfoArray);
    }

    protected void deleteReference(ServiceContext serviceContext, DeleteReferencesItem deleteReferencesItem) throws StatusException {
        this.getNodeManagerTable().deleteReference(serviceContext, deleteReferencesItem.getSourceNodeId(), deleteReferencesItem.getTargetNodeId(), deleteReferencesItem.getReferenceTypeId(), deleteReferencesItem.getIsForward(), deleteReferencesItem.getDeleteBidirectional());
    }

    protected void deleteReferences(ServiceContext serviceContext, DeleteReferencesRequest objectArray, DeleteReferencesResponse deleteReferencesResponse) throws ServiceException {
        StatusCode[] statusCodeArray = this;
        this.getNodeManagerTable().checkNodeManagementEnabled();
        objectArray = objectArray.getReferencesToDelete();
        this.checkRequestLength(objectArray, this.getMaxNodesPerNodeManagement());
        statusCodeArray = new StatusCode[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            try {
                this.deleteReference(serviceContext, (DeleteReferencesItem)objectArray[i2]);
                statusCodeArray[i2] = StatusCode.GOOD;
                continue;
            }
            catch (StatusException statusException) {
                logger.warn("StatusException: ", (Throwable)statusException);
                statusCodeArray[i2] = statusException.getStatusCode();
                diagnosticInfoArray[i2] = statusException.getDiagnosticInfo();
            }
        }
        deleteReferencesResponse.setResults(statusCodeArray);
        deleteReferencesResponse.setDiagnosticInfos(diagnosticInfoArray);
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    protected UaView getView(NodeId nodeId, UnsignedInteger unsignedInteger, DateTime dateTime) throws ServiceException {
        throw new ServiceException(StatusCodes.Bad_ViewIdUnknown);
    }

    protected void queryFirst(ServiceContext serviceContext, QueryFirstRequest queryFirstRequest, QueryFirstResponse queryFirstResponse) throws ServiceException {
        this.getNodeManagerTable().queryFirst(serviceContext, queryFirstRequest, queryFirstResponse);
    }

    protected void queryNext(ServiceContext serviceContext, QueryNextRequest queryNextRequest, QueryNextResponse queryNextResponse) throws ServiceException {
        this.getNodeManagerTable().queryNext(serviceContext, queryNextRequest, queryNextResponse);
    }

    protected NodeId registerNode(ServiceContext serviceContext, NodeId nodeId) throws StatusException {
        return this.getNodeManagerTable().registerNode(serviceContext, nodeId);
    }

    protected void registerNodes(ServiceContext serviceContext, RegisterNodesRequest objectArray, RegisterNodesResponse registerNodesResponse) throws ServiceException {
        objectArray = objectArray.getNodesToRegister();
        this.checkRequestLength(objectArray, this.getMaxNodesPerRegisterNodes());
        NodeId[] nodeIdArray = new NodeId[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            try {
                nodeIdArray[i2] = this.registerNode(serviceContext, (NodeId)objectArray[i2]);
                continue;
            }
            catch (StatusException statusException) {
                logger.debug("StatusException: ", (Throwable)statusException);
                nodeIdArray[i2] = objectArray[i2];
            }
        }
        registerNodesResponse.setRegisteredNodeIds(nodeIdArray);
    }

    protected BrowsePathTarget[] translateBrowsePath(ServiceContext serviceContext, NodeId nodeId, RelativePath relativePath) throws StatusException {
        try {
            return this.getNodeManagerTable().translateBrowsePath(serviceContext, nodeId, relativePath);
        }
        catch (ServiceException serviceException) {
            throw new StatusException(serviceException.getServiceResult());
        }
    }

    protected void translateBrowsePathsToNodeIds(ServiceContext serviceContext, TranslateBrowsePathsToNodeIdsRequest objectArray, TranslateBrowsePathsToNodeIdsResponse translateBrowsePathsToNodeIdsResponse) throws ServiceException {
        objectArray = objectArray.getBrowsePaths();
        this.checkRequestLength(objectArray, this.getMaxNodesPerTranslateBrowsePathsToNodeIds());
        BrowsePathResult[] browsePathResultArray = new BrowsePathResult[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            browsePathResultArray[i2] = new BrowsePathResult();
            try {
                RelativePathElement[] relativePathElementArray = objectArray[i2].getRelativePath().getElements();
                if (relativePathElementArray == null || relativePathElementArray.length == 0) {
                    throw new StatusException("no elements", StatusCodes.Bad_NothingToDo);
                }
                for (RelativePathElement relativePathElement : relativePathElementArray) {
                    if (!QualifiedName.isNull((QualifiedName)(relativePathElement = relativePathElement.getTargetName())) && !relativePathElement.getName().isEmpty()) continue;
                    throw new StatusException(StatusCodes.Bad_BrowseNameInvalid);
                }
                browsePathResultArray[i2].setTargets(this.translateBrowsePath(serviceContext, objectArray[i2].getStartingNode(), objectArray[i2].getRelativePath()));
                browsePathResultArray[i2].setStatusCode(StatusCode.GOOD);
                continue;
            }
            catch (StatusException statusException) {
                logger.debug("StatusException: ", (Throwable)statusException);
                browsePathResultArray[i2].setStatusCode(statusException.getStatusCode());
                diagnosticInfoArray[i2] = statusException.getDiagnosticInfo();
            }
        }
        translateBrowsePathsToNodeIdsResponse.setResults(browsePathResultArray);
        translateBrowsePathsToNodeIdsResponse.setDiagnosticInfos(diagnosticInfoArray);
    }

    protected void unregisterNode(ServiceContext serviceContext, NodeId nodeId) throws StatusException {
        this.getNodeManagerTable().unregisterNode(serviceContext, nodeId);
    }

    protected void unregisterNodes(ServiceContext serviceContext, UnregisterNodesRequest objectArray, UnregisterNodesResponse unregisterNodesResponse) throws ServiceException {
        objectArray = objectArray.getNodesToUnregister();
        this.checkRequestLength(objectArray, this.getMaxNodesPerRegisterNodes());
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            try {
                this.unregisterNode(serviceContext, (NodeId)objectArray[i2]);
                continue;
            }
            catch (StatusException statusException) {
                logger.debug("StatusException: ", (Throwable)statusException);
            }
        }
    }

    final void init() throws StatusException, UaNodeFactoryException {
        this.getNodeManagerTable().init();
    }
}

