/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaInstance;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.server.ExternalReferenceDeclaration;
import com.prosysopc.ua.server.GeneratedNode;
import com.prosysopc.ua.server.InstanceDeclaration;
import com.prosysopc.ua.server.InstanceDeclarationHierarchy;
import com.prosysopc.ua.server.InstanceReferenceDeclaration;
import com.prosysopc.ua.server.InstantiationParameters;
import com.prosysopc.ua.server.InstantiationStrategy;
import com.prosysopc.ua.server.InvalidTypeNodeException;
import com.prosysopc.ua.server.ModellingRule;
import com.prosysopc.ua.server.NodeBuilderException;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.UaNodeBuilderConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.NodeAttributes;
import org.opcfoundation.ua.core.VariableAttributes;
import org.opcfoundation.ua.core.VariableTypeAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeBuilder<T extends UaInstance> {
    private static final InstantiationStrategy DEFAULT_INSTANTIATION_STRATEGY = UaNodeBuilderConfiguration.DEFAULT_INSTANTIATION_STRATEGY;
    private static final Logger logger = LoggerFactory.getLogger(NodeBuilder.class);
    private static Set<NodeId> hn;
    private QualifiedName cC;
    private final UaNodeBuilderConfiguration ho;
    private int hp = -1;
    private LocalizedText eL;
    private String name;
    private NodeId nodeId;
    private final NodeManagerUaNode nodeManager;
    private final UaType hq;

    protected static boolean isTypeOnlyReference(ExternalReferenceDeclaration externalReferenceDeclaration) {
        return hn.contains(externalReferenceDeclaration.getReferenceType().getNodeId());
    }

    public NodeBuilder(NodeManagerUaNode nodeManagerUaNode, UaNodeBuilderConfiguration uaNodeBuilderConfiguration, UaType uaType) throws InvalidTypeNodeException {
        hn = new HashSet<NodeId>();
        hn.add(Identifiers.HasModellingRule);
        hn.add(Identifiers.GeneratesEvent);
        if (nodeManagerUaNode == null) {
            throw new NullPointerException("NodeBuilder: nodeManager");
        }
        if (uaNodeBuilderConfiguration == null) {
            throw new NullPointerException("NodeBuilder: configuration");
        }
        if (uaType == null) {
            throw new NullPointerException("NodeBuilder: type");
        }
        this.nodeManager = nodeManagerUaNode;
        this.hq = uaType;
        this.ho = uaNodeBuilderConfiguration;
        switch (uaType.getNodeClass()) {
            case ObjectType: {
                return;
            }
            case VariableType: {
                return;
            }
        }
        throw new InvalidTypeNodeException("NodeBuilder: Invalid NodeClass of type node.");
    }

    public final synchronized T build() throws NodeBuilderException {
        Object object;
        Object object2 = this;
        if (((NodeBuilder)object2).cC == null && ((NodeBuilder)object2).name != null && ((NodeBuilder)object2).hp >= 0) {
            ((NodeBuilder)object2).setBrowseName(new QualifiedName(((NodeBuilder)object2).hp, ((NodeBuilder)object2).name));
        }
        if (((NodeBuilder)object2).eL == null && ((NodeBuilder)object2).name != null) {
            ((NodeBuilder)object2).eL = new LocalizedText(((NodeBuilder)object2).name, "");
            ((NodeBuilder)object2).setDisplayName(((NodeBuilder)object2).eL);
        }
        if (((NodeBuilder)object2).nodeId == null && ((NodeBuilder)object2).name != null && ((NodeBuilder)object2).hp >= 0) {
            ((NodeBuilder)object2).setNodeId(new NodeId(((NodeBuilder)object2).hp, ((NodeBuilder)object2).name));
        }
        if (((NodeBuilder)object2).cC == null) {
            throw new NodeBuilderException("Browse name is not set.");
        }
        if (((NodeBuilder)object2).eL == null) {
            throw new NodeBuilderException("Display name is not set.");
        }
        if (((NodeBuilder)object2).nodeId == null) {
            throw new NodeBuilderException("Node id is not set.");
        }
        logger.debug("build: browseName={} type={}", (Object)this.cC, (Object)this.hq);
        Iterator<Object> iterator = this.nodeManager.getNodeManagerTable().getInstanceDeclarationHierarchyCache().getForType(this.hq);
        iterator = ((InstanceDeclarationHierarchy)((Object)iterator)).getRoot();
        Object object3 = this.ho.getInstantiationStrategy(new UaNodeBuilderConfiguration.InstantiationStrategySearchParameters((InstanceDeclaration)((Object)iterator), this.nodeManager.getNamespaceTable(), new InstanceDeclaration[0]));
        if (object3 == null) {
            object3 = DEFAULT_INSTANTIATION_STRATEGY;
        }
        logger.debug("build: rootStrategy={}", object3);
        Object object4 = new InstantiationParameters((InstanceDeclaration)((Object)iterator), this.nodeManager, this.nodeId, null, this.cC, this.eL);
        object4 = (UaInstance)object3.createInstance((InstantiationParameters)object4);
        UaNode uaNode = this.hq;
        Object object52 = object4;
        object2 = this;
        object2 = object52.getAttributes();
        uaNode = uaNode.getAttributes().clone();
        object2.setDescription(uaNode.getDescription());
        object2.setUserWriteMask(uaNode.getUserWriteMask());
        object2.setWriteMask(uaNode.getWriteMask());
        if (object2 instanceof VariableAttributes && uaNode instanceof VariableTypeAttributes) {
            object = (VariableTypeAttributes)uaNode;
            uaNode = (VariableAttributes)object2;
            uaNode.setArrayDimensions(object.getArrayDimensions());
            uaNode.setValueRank(object.getValueRank());
            uaNode.setDataType(object.getDataType());
            uaNode.setValue(object.getValue());
        }
        object52.setAttributes((NodeAttributes)object2);
        object4.setTypeDefinition(this.hq);
        if (logger.isDebugEnabled()) {
            logger.debug("build: rootStrategy.createsCompleteHierarchy()={}", (Object)object3.createsCompleteHierarchy());
        }
        if (object3.createsCompleteHierarchy()) {
            return (T)object4;
        }
        object3 = new HashMap();
        object2 = new HashMap();
        object2.put(iterator, object4);
        this.a((InstanceDeclaration)((Object)iterator), new InstanceDeclaration[]{iterator}, (Map<InstanceDeclaration, UaNode>)object2, (UaNode)object4, (Map<InstanceDeclaration, InstantiationParameters>)object3);
        for (InstanceDeclaration instanceDeclaration : object2.keySet()) {
            uaNode = (UaNode)object2.get(instanceDeclaration);
            if (uaNode == instanceDeclaration.getNode()) continue;
            logger.trace("build: references for node={}", (Object)uaNode);
            for (ExternalReferenceDeclaration externalReferenceDeclaration : instanceDeclaration.getExternalReferences()) {
                if (NodeBuilder.isTypeOnlyReference(externalReferenceDeclaration)) continue;
                logger.trace("build: externalReference={}", (Object)externalReferenceDeclaration);
                uaNode.addReference(externalReferenceDeclaration.getTarget(), externalReferenceDeclaration.getReferenceType().getNodeId(), false);
            }
            for (InstanceReferenceDeclaration instanceReferenceDeclaration : instanceDeclaration.getInstanceReferences()) {
                if (!object2.containsKey(instanceReferenceDeclaration.getInstance())) continue;
                logger.trace("build: instanceReference={}", (Object)instanceReferenceDeclaration);
                uaNode.addReference((UaNode)object2.get(instanceReferenceDeclaration.getInstance()), instanceReferenceDeclaration.getReferenceType().getNodeId(), false);
            }
        }
        for (Map.Entry entry : object2.entrySet()) {
            uaNode = (UaNode)entry.getValue();
            if (uaNode == object4 || uaNode == ((InstanceDeclaration)entry.getKey()).getNode()) continue;
            logger.trace("build: attributes for node={}", (Object)uaNode);
            object = (InstantiationParameters)object3.get(entry.getKey());
            uaNode.setAttributes(((InstantiationParameters)object).getNodeAttributes());
        }
        if (object4 instanceof GeneratedNode) {
            ((GeneratedNode)object4).afterCreate();
        }
        this.clear();
        return (T)object4;
    }

    public final void clear() {
        this.cC = null;
        this.hp = -1;
        this.eL = null;
        this.name = null;
        this.nodeId = null;
    }

    public final NodeBuilder<T> setBrowseName(QualifiedName qualifiedName) {
        this.cC = qualifiedName;
        return this;
    }

    public final NodeBuilder<T> setDefaultNameSpaceIndex(int n2) {
        this.hp = n2;
        return this;
    }

    public final NodeBuilder<T> setDisplayName(LocalizedText localizedText) {
        this.eL = localizedText;
        return this;
    }

    public final NodeBuilder<T> setName(String string) {
        this.name = string;
        return this;
    }

    public final NodeBuilder<T> setNodeId(NodeId nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    private void a(InstanceDeclaration iterator, InstanceDeclaration[] instanceDeclarationArray, Map<InstanceDeclaration, UaNode> map, UaNode uaNode, Map<InstanceDeclaration, InstantiationParameters> map2) throws NodeBuilderException {
        iterator = iterator.getNextDeclarations();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            InstanceDeclaration instanceDeclaration = iterator.next();
            if (map.get(instanceDeclaration) != null) continue;
            Object object = this.ho.getInstantiationStrategy(new UaNodeBuilderConfiguration.InstantiationStrategySearchParameters(instanceDeclaration, this.nodeManager.getNamespaceTable(), instanceDeclarationArray));
            logger.debug("createNodes: instanceDeclaration={} instantiationStrategy={}", (Object)instanceDeclaration, object);
            if (object == null && instanceDeclaration.getModellingRule() != ModellingRule.Mandatory) {
                logger.debug("createNodes: skipped");
                continue;
            }
            if (object == null) {
                object = DEFAULT_INSTANTIATION_STRATEGY;
            }
            InstanceDeclaration[] instanceDeclarationArray2 = this.nodeManager.createNodeId(uaNode, instanceDeclaration.getNode().getBrowseName());
            instanceDeclarationArray2 = new InstantiationParameters(instanceDeclaration, (NodeId)instanceDeclarationArray2, this.nodeManager, uaNode);
            UaNode uaNode2 = object.createInstance((InstantiationParameters)instanceDeclarationArray2);
            map.put(instanceDeclaration, uaNode2);
            map2.put(instanceDeclaration, (InstantiationParameters)instanceDeclarationArray2);
            if (uaNode2 == instanceDeclaration.getNode()) continue;
            UaNode uaNode3 = uaNode2;
            instanceDeclarationArray2 = this;
            if (uaNode3 == null) {
                throw new NodeBuilderException("Nodebuilder.addNode, node cannot be null");
            }
            try {
                instanceDeclarationArray2.nodeManager.addNode(uaNode3);
            }
            catch (StatusException statusException) {
                throw new NodeBuilderException("Could not add node " + uaNode3 + " to NodeManager", statusException);
            }
            if (object.createsCompleteHierarchy()) continue;
            object = new ArrayList();
            instanceDeclarationArray2 = instanceDeclarationArray;
            int n2 = instanceDeclarationArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                InstanceDeclaration instanceDeclaration2 = instanceDeclarationArray2[i2];
                ((ArrayList)object).add(instanceDeclaration2);
            }
            ((ArrayList)object).add(instanceDeclaration);
            this.a(instanceDeclaration, ((ArrayList)object).toArray(new InstanceDeclaration[0]), map, uaNode2, map2);
        }
    }
}

