/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.MonitoredItemBase;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.Subscription;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.MonitoringFilter;
import org.opcfoundation.ua.core.MonitoringFilterResult;
import org.opcfoundation.ua.core.MonitoringMode;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.core.TimestampsToReturn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MonitoredItem
extends MonitoredItemBase {
    private static final Logger logger = LoggerFactory.getLogger(MonitoredItem.class);
    private ServiceContext serviceContext;
    private volatile TimestampsToReturn ex = TimestampsToReturn.Both;
    protected List<MonitoredItem> links;
    protected UaNode node;
    protected final Subscription subscription;

    public static int getMaxQueueSize() {
        return maxQueueSize;
    }

    public static void setMaxQueueSize(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxQueueSize must be bigger than 0");
        }
        MonitoredItemBase.maxQueueSize = n2;
    }

    public MonitoredItem(ServiceContext serviceContext, Subscription subscription, UnsignedInteger unsignedInteger, NodeId nodeId, UnsignedInteger unsignedInteger2, MonitoringMode monitoringMode) {
        super(null, unsignedInteger, nodeId, unsignedInteger2, monitoringMode);
        this.serviceContext = serviceContext;
        this.subscription = subscription;
    }

    @Override
    public void close() {
        logger.debug("close: ItemId={}", (Object)this.getMonitoredItemId());
        this.unPlugNodeListener();
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            object = (MonitoredItem)object;
            return this.subscription == ((MonitoredItem)object).subscription;
        }
        return false;
    }

    public synchronized UaNode getNode() {
        return this.node;
    }

    public ServiceContext getServiceContext() {
        return this.serviceContext;
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    public TimestampsToReturn getTimestampsToReturn() {
        return this.ex;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    protected synchronized void addLink(MonitoredItem monitoredItem) {
        if (this.links == null) {
            this.links = new CopyOnWriteArrayList<MonitoredItem>();
        }
        this.links.add(monitoredItem);
    }

    protected void plugNodeListener() {
    }

    protected synchronized void removeLink(MonitoredItem monitoredItem) throws StatusException {
        if (this.links != null && this.links.remove(monitoredItem)) {
            return;
        }
        throw new StatusException(new StatusCode(StatusCodes.Bad_MonitoredItemIdInvalid));
    }

    protected void setClientHandle(UnsignedInteger unsignedInteger) {
        this.clientHandle = unsignedInteger;
    }

    @Override
    protected final void setFilter(MonitoringFilter monitoringFilter) throws ServiceException {
        logger.debug("setFilter: {}", (Object)monitoringFilter);
        super.setFilter(monitoringFilter);
    }

    @Override
    protected void setFilterResult(MonitoringFilterResult monitoringFilterResult) {
        super.setFilterResult(monitoringFilterResult);
    }

    protected synchronized void setNode(UaNode uaNode) {
        if (this.node != uaNode) {
            this.unPlugNodeListener();
            this.node = uaNode;
            this.plugNodeListener();
        }
    }

    protected void setServiceContext(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    protected void setTimestampsToReturn(TimestampsToReturn timestampsToReturn) {
        this.ex = timestampsToReturn == null ? TimestampsToReturn.Neither : timestampsToReturn;
    }

    protected void unPlugNodeListener() {
    }
}

