/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.EventData;
import com.prosysopc.ua.EventListener;
import com.prosysopc.ua.MonitoredItemBase;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.ContentFilterDefinition;
import com.prosysopc.ua.server.EventManager;
import com.prosysopc.ua.server.MonitoredItem;
import com.prosysopc.ua.server.NodeManagerRoot;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.Subscription;
import com.prosysopc.ua.server.a;
import com.prosysopc.ua.server.nodes.ServerNode;
import com.prosysopc.ua.types.opcua.server.BaseEventTypeNodeBase;
import com.prosysopc.ua.types.opcua.server.EventQueueOverflowEventTypeNode;
import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingDeque;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.Attributes;
import org.opcfoundation.ua.core.EventFieldList;
import org.opcfoundation.ua.core.EventFilter;
import org.opcfoundation.ua.core.EventFilterResult;
import org.opcfoundation.ua.core.MonitoringFilter;
import org.opcfoundation.ua.core.MonitoringFilterResult;
import org.opcfoundation.ua.core.MonitoringMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoredEventItem
extends MonitoredItem {
    private static final Logger logger = LoggerFactory.getLogger(MonitoredEventItem.class);
    private final List<List<QualifiedName>> V = new CopyOnWriteArrayList<List<QualifiedName>>();
    private volatile boolean W;
    private BlockingDeque<EventFieldList> X;
    private final ContentFilterDefinition Y = new ContentFilterDefinition();
    protected EventListener eventListener = new a(this);

    @Deprecated
    public static int getMaxQueueSize() {
        return maxQueueSize;
    }

    @Deprecated
    public static void setMaxQueueSize(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxQueueSize must be bigger than 0");
        }
        MonitoredItemBase.maxQueueSize = n2;
    }

    public MonitoredEventItem(ServiceContext serviceContext, Subscription subscription, UnsignedInteger unsignedInteger, NodeId nodeId, EventFilter eventFilter, EventFilterResult eventFilterResult) throws StatusException {
        super(serviceContext, subscription, unsignedInteger, nodeId, Attributes.EventNotifier, MonitoringMode.Reporting);
        this.setEventFilterResult(eventFilterResult);
        try {
            this.setEventFilter(eventFilter);
        }
        catch (ServiceException serviceException) {
            throw new StatusException(serviceException.getServiceResult());
        }
        this.queueSize = 0L;
    }

    public boolean filter(EventData eventData) {
        return this.filter(eventData, false);
    }

    public Boolean filter(EventData object, Boolean bl) {
        if ((object = this.Y.evaluate((EventData)object, bl)) == null) {
            return bl;
        }
        return object;
    }

    public int getCurrentQueueSize() {
        if (this.X == null) {
            return 0;
        }
        return this.X.size();
    }

    public EventFilter getEventFilter() {
        return (EventFilter)this.getFilter();
    }

    public EventFilterResult getEventFilterResult() {
        return (EventFilterResult)this.getFilterResult();
    }

    public boolean isMonitored(UaNode uaNode) {
        return this.filter(new EventData(uaNode, null), true);
    }

    public void notifyEvent(EventData eventData) {
        this.notifyEvent(eventData, true);
    }

    public void notifyEvent(EventData object, boolean bl) {
        logger.debug("notifyEvent");
        if (this.getMonitoringMode().equals((Object)MonitoringMode.Reporting) && object != null && (!bl || this.filter((EventData)object))) {
            EventData eventData = object;
            object = this;
            logger.debug("addNewEvent: eventData={} ClientHandle={}", (Object)eventData, (Object)((MonitoredEventItem)object).clientHandle);
            eventData = new EventFieldList(((MonitoredEventItem)object).clientHandle, eventData.getFieldValues(((MonitoredEventItem)object).V));
            super.a((EventFieldList)eventData);
        }
    }

    @Deprecated
    public void onEvent(UaNode uaNode, EventData eventData) {
        this.notifyEvent(eventData);
    }

    private void a(EventFieldList eventFieldList) {
        logger.debug("addNewEvent: queue={}", this.X);
        if (this.X != null) {
            while (!this.X.offer(eventFieldList)) {
                logger.warn("addNewEvent: queue overflow: SubscriptionId={} ItemId={} QueueSize={}", new Object[]{this.subscription.getSubscriptionId(), this.getMonitoredItemId(), this.getQueueSize()});
                this.W = true;
                if (!this.discardOldest) break;
                this.X.pollFirst();
            }
        }
        this.subscription.newEventAvailable(this);
    }

    @Override
    protected long getDefaultQueueSize() {
        return maxQueueSize;
    }

    protected void getEvents(List<EventFieldList> list) {
        if (this.X != null && this.X.size() > 0) {
            logger.debug("getEvents: queue.size={}", (Object)this.X.size());
            this.X.drainTo(list);
            if (this.W) {
                Object object = this.getNodeManagerRoot().createEvent(EventQueueOverflowEventTypeNode.class);
                DateTime dateTime = DateTime.currentTime();
                ((BaseEventTypeNodeBase)object).setTime(dateTime);
                ((BaseEventTypeNodeBase)object).setEventId(EventManager.createFullEventId(null));
                object = new EventData((UaNode)object, null);
                object = new EventFieldList(this.clientHandle, ((EventData)object).getFieldValues(this.V));
                if (this.discardOldest) {
                    list.add(0, (EventFieldList)object);
                } else {
                    list.add((EventFieldList)object);
                }
                this.W = false;
            }
        }
    }

    protected NodeManagerRoot getNodeManagerRoot() {
        return this.getSubscription().getSubscriptionManager().getNodeManagerTable().getNodeManagerRoot();
    }

    @Override
    protected void plugNodeListener() {
        logger.debug("plugNodeListener: {}", (Object)this.getNode());
        if (this.getNode() instanceof ServerNode) {
            logger.debug("ok");
            ((ServerNode)this.getNode()).addEventListener(this.eventListener);
        }
    }

    protected final void setEventFilter(EventFilter eventFilter) throws ServiceException {
        this.setFilter((MonitoringFilter)eventFilter);
    }

    protected void setEventFilterResult(EventFilterResult eventFilterResult) {
        this.setFilterResult((MonitoringFilterResult)eventFilterResult);
    }

    @Override
    protected void unPlugNodeListener() {
        logger.debug("unPlugNodeListener {} {}", (Object)this.subscription, (Object)this);
        UaNode uaNode = this.getNode();
        if (uaNode instanceof ServerNode) {
            ((ServerNode)uaNode).removeEventListener(this.eventListener);
        }
    }

    @Override
    protected void updateFilter() {
        ContentFilterDefinition.parseEventFilter(this.getNodeManagerRoot(), this.getEventFilter(), this.V, this.Y, this.getEventFilterResult());
    }

    @Override
    protected void updateQueue() {
        logger.debug("updateQueue: MonitoredItem={}", (Object)this);
        BlockingDeque<EventFieldList> blockingDeque = this.X;
        boolean bl = this.getMonitoringMode().equals((Object)MonitoringMode.Disabled);
        BlockingDeque<Object> blockingDeque2 = this.X = bl || this.queueSize <= 0L ? null : new LinkedBlockingDeque((int)this.queueSize);
        if (logger.isDebugEnabled()) {
            logger.debug("updateQueue: making queue of size: " + (this.X == null ? "null" : Long.valueOf(this.queueSize)));
        }
        if (blockingDeque != null) {
            logger.debug("updateQueue: oldQueue={}", blockingDeque);
            if (this.X != null) {
                while (!blockingDeque.isEmpty()) {
                    this.a(blockingDeque.poll());
                }
            } else {
                blockingDeque.clear();
            }
        }
        logger.debug("updateQueue done. Active size={}", (Object)(this.X == null ? 0 : this.X.size()));
    }
}

