/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.DataChangeListener;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.server.IoManager;
import com.prosysopc.ua.server.MonitoredEventItem;
import com.prosysopc.ua.server.MonitoredItem;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.server.Subscription;
import com.prosysopc.ua.server.i;
import com.prosysopc.ua.server.j;
import com.prosysopc.ua.server.nodes.ServerNode;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.AccessLevel;
import org.opcfoundation.ua.core.Attributes;
import org.opcfoundation.ua.core.DataChangeFilter;
import org.opcfoundation.ua.core.DataChangeTrigger;
import org.opcfoundation.ua.core.DeadbandType;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.MonitoringFilter;
import org.opcfoundation.ua.core.MonitoringMode;
import org.opcfoundation.ua.core.Range;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.utils.MultiDimensionArrayUtils;
import org.opcfoundation.ua.utils.NumericRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoredDataItem
extends MonitoredItem {
    private static final StatusCode gH = new StatusCode(StatusCodes.Bad_WaitingForInitialData);
    private static final Logger logger = LoggerFactory.getLogger(MonitoredDataItem.class);
    private volatile Boolean gI;
    private Range gl;
    private UaProperty gJ;
    private NumericRange bP;
    private volatile boolean gK = false;
    private volatile DataValue gL = null;
    private volatile DataValue gM = null;
    private BlockingDeque<DataValue> X = null;
    private final DataChangeListener gN = new i(this);
    private volatile double bQ = -1.0;
    protected DataChangeListener dataChangeListener = new j(this);

    public MonitoredDataItem(ServiceContext serviceContext, Subscription subscription, UnsignedInteger unsignedInteger, NodeId nodeId, UnsignedInteger unsignedInteger2, NumericRange numericRange, MonitoringMode monitoringMode) {
        super(serviceContext, subscription, unsignedInteger, nodeId, unsignedInteger2, monitoringMode);
        this.queueSize = 0L;
        this.setIndexRange(numericRange);
    }

    public DataChangeFilter getDataChangeFilter() {
        return (DataChangeFilter)this.getFilter();
    }

    public DataChangeTrigger getDataChangeTrigger() {
        DataChangeFilter dataChangeFilter = this.getDataChangeFilter();
        if (dataChangeFilter == null) {
            return DataChangeTrigger.StatusValue;
        }
        return dataChangeFilter.getTrigger();
    }

    public DeadbandType getDeadbandType() {
        DataChangeFilter dataChangeFilter = this.getDataChangeFilter();
        if (dataChangeFilter == null) {
            return DeadbandType.None;
        }
        return DeadbandType.valueOf((int)this.getDataChangeFilter().getDeadbandType().intValue());
    }

    public double getDeadbandValue() {
        DataChangeFilter dataChangeFilter = this.getDataChangeFilter();
        if (dataChangeFilter == null) {
            return 0.0;
        }
        return this.getDataChangeFilter().getDeadbandValue();
    }

    public Range getEuRange() {
        return this.gl;
    }

    public UaProperty getEuRangeProperty() {
        return this.gJ;
    }

    @Override
    public NumericRange getIndexRange() {
        return this.bP;
    }

    public DataValue getLastValue() {
        return this.gL;
    }

    @Override
    public double getSamplingInterval() {
        return this.bQ;
    }

    public synchronized boolean hasMoreSamples() {
        if (this.X == null) {
            return !this.gK;
        }
        return !this.X.isEmpty();
    }

    public void notifyDataChange(DataValue dataValue) {
        this.notifyDataChange(dataValue, true);
    }

    /*
     * Unable to fully structure code
     */
    public void notifyDataChange(DataValue var1_1, boolean var2_2) {
        block8: {
            block10: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block9: {
                                        MonitoredDataItem.logger.debug("notifyDataChange: SubscriptionId={} ItemId={}", (Object)this.subscription.getSubscriptionId(), (Object)this.getMonitoredItemId());
                                        if (this.getMonitoringMode().equals((Object)MonitoringMode.Disabled) || !this.isAccessible()) break block8;
                                        var5_3 = var1_1;
                                        var4_4 = this;
                                        if (var4_4.gM == null || var4_4.gL == null || var4_4.X == null || var5_3.getSourceTimestamp() == null || var4_4.gM.getSourceTimestamp() == null || var4_4.gL.getSourceTimestamp() == null) ** GOTO lbl-1000
                                        var6_5 = var5_3.getSourceTimestamp().getTimeInMillis();
                                        var8_7 = var4_4.gL.getSourceTimestamp().getTimeInMillis();
                                        var10_9 = var4_4.gM.getSourceTimestamp().getTimeInMillis();
                                        var12_11 = var6_5 - var8_7;
                                        var14_12 = var6_5 - var10_9;
                                        var16_13 = var8_7 - var10_9;
                                        var18_14 = var4_4.getSamplingInterval();
                                        MonitoredDataItem.logger.trace("mayReplaceLastSample: dt={} dt2={} dt_last={} samplingInterval={}", new Object[]{var12_11, var14_12, var16_13, var18_14});
                                        if (var12_11 < var18_14 && var14_12 < var18_14 * 2.0 && var16_13 < var18_14) {
                                            MonitoredDataItem.logger.trace("mayReplaceLastSample: yes");
                                            v0 = true;
                                        } else lbl-1000:
                                        // 2 sources

                                        {
                                            MonitoredDataItem.logger.trace("mayReplaceLastSample: no");
                                            v0 = var3_15 = false;
                                        }
                                        if (var2_2) {
                                            var1_1 = this.applyIndexRange(var1_1);
                                        }
                                        var7_16 = var3_15;
                                        var6_6 = var1_1;
                                        var5_3 = this.getLastValue();
                                        var4_4 = this;
                                        MonitoredDataItem.logger.debug("filter: value={}; lastValue={}", (Object)var6_6, (Object)var5_3);
                                        if (var5_3 != null) break block9;
                                        v1 = true;
                                        break block10;
                                    }
                                    if (!var5_3.isNull() || var6_6 == null || var6_6.isNull()) break block11;
                                    v1 = true;
                                    break block10;
                                }
                                if (var5_3.isNull() || var6_6 != null && !var6_6.isNull()) break block12;
                                v1 = true;
                                break block10;
                            }
                            if (var5_3.getStatusCode().equals((Object)var6_6.getStatusCode())) break block13;
                            v1 = true;
                            break block10;
                        }
                        var8_8 = var4_4.getDataChangeTrigger();
                        MonitoredDataItem.logger.debug("filter: trigger={}", (Object)var8_8);
                        if (!var8_8.equals((Object)DataChangeTrigger.Status)) break block14;
                        v1 = false;
                        break block10;
                    }
                    if (!var8_8.equals((Object)DataChangeTrigger.StatusValueTimestamp) || DeadbandType.None != var4_4.getDeadbandType()) ** GOTO lbl-1000
                    var9_17 = var5_3.getSourceTimestamp();
                    var10_10 = var6_6.getSourceTimestamp();
                    if (var9_17 != null) break block15;
                    if (var10_10 == null) ** GOTO lbl-1000
                    v1 = true;
                    break block10;
                }
                if (!var9_17.equals((Object)var10_10)) {
                    v1 = true;
                } else if (var5_3.isNull()) {
                    v1 = false;
                } else {
                    var9_17 = var7_16 == false && Number.class.isAssignableFrom(var5_3.getValue().getCompositeClass()) != false ? var4_4.getDeadbandType() : DeadbandType.None;
                    v1 = var4_4.checkDeadband(var5_3, var6_6, (DeadbandType)var9_17);
                }
            }
            if (v1) {
                this.addNewSample(var1_1, var3_15);
            }
        }
    }

    @Deprecated
    public void onDataChange(UaNode uaNode, DataValue dataValue, DataValue dataValue2) {
        this.notifyDataChange(dataValue2);
    }

    public void setEuRange(Range range) {
        logger.debug("setEuRange: {}", (Object)range);
        this.gl = range;
    }

    public void setEuRangeProperty(UaProperty uaProperty) {
        if (this.gJ != uaProperty) {
            logger.debug("setEuRangeProperty: euRangeProperty={}", (Object)uaProperty);
            this.assignEuRange(uaProperty.getValue());
            if (this.gJ instanceof ServerNode) {
                ((ServerNode)((Object)this.gJ)).removeDataChangeListener(this.gN);
            }
            if (uaProperty instanceof ServerNode) {
                ((ServerNode)((Object)uaProperty)).addDataChangeListener(this.gN);
            }
            this.gJ = uaProperty;
        }
    }

    public void setSamplingInterval(double d2) {
        this.bQ = d2 < 0.0 ? this.getSubscription().getPublishingInterval() : d2;
    }

    private DataValue aS() {
        if (this.subscription.isClosed()) {
            return null;
        }
        DataValue dataValue = new DataValue(gH);
        try {
            this.subscription.getSubscriptionManager().getNodeManagerTable().initializeMonitoredDataItem(this.getServiceContext(), this, dataValue);
        }
        catch (StatusException statusException) {
            logger.debug("StatusException: ", (Throwable)statusException);
            dataValue.setStatusCode(statusException.getStatusCode());
        }
        catch (Exception exception) {
            logger.error("Unexpected error: subscription=" + this.subscription + " subscriptionManager=" + this.subscription.getSubscriptionManager(), (Throwable)exception);
        }
        UnsignedInteger unsignedInteger = dataValue.getStatusCode().getValue();
        this.gI = !unsignedInteger.equals((Object)StatusCodes.Bad_NotReadable) && !unsignedInteger.equals((Object)StatusCodes.Bad_UserAccessDenied);
        logger.debug("initialValue: {}", (Object)dataValue);
        return dataValue;
    }

    private void a(UaVariable uaPropertyArray) {
        if ((uaPropertyArray = uaPropertyArray.getProperties()) != null) {
            for (UaProperty uaProperty : uaPropertyArray) {
                if (!Identifiers.Range.equals((Object)uaProperty.getDataTypeId()) || !uaProperty.getBrowseName().getName().equalsIgnoreCase("EURange")) continue;
                this.setEuRangeProperty(uaProperty);
                return;
            }
        }
    }

    private boolean a(Object object, Object object2) {
        int[] nArray;
        int[] nArray2 = MultiDimensionArrayUtils.getArrayLengths((Object)object);
        if (!Arrays.equals(nArray2, nArray = MultiDimensionArrayUtils.getArrayLengths((Object)object2))) {
            logger.debug("checkDeadband: array lengths are not equal. Left={}, Right={}.", (Object)(nArray2 == null ? "null" : Arrays.toString(nArray2)), (Object)(nArray == null ? "null" : Arrays.toString(nArray)));
            return true;
        }
        if (object instanceof byte[] && object2 == null) {
            return true;
        }
        if (object2 instanceof byte[] && object == null) {
            return true;
        }
        if (object instanceof byte[] && object2 instanceof byte[]) {
            return !Arrays.equals((byte[])object, (byte[])object2);
        }
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            if (!this.a(Array.get(object, i2), Array.get(object2, i2))) continue;
            return true;
        }
        return false;
    }

    private DataValue b(DataValue dataValue) {
        if (dataValue == null) {
            return null;
        }
        switch (this.getTimestampsToReturn()) {
            case Neither: {
                dataValue = new DataValue(dataValue.getValue(), dataValue.getStatusCode(), DateTime.MIN_VALUE, DateTime.MIN_VALUE);
                break;
            }
            case Server: {
                dataValue = new DataValue(dataValue.getValue(), dataValue.getStatusCode(), DateTime.MIN_VALUE, DateTime.currentTime());
                break;
            }
            case Source: {
                dataValue = new DataValue(dataValue.getValue(), dataValue.getStatusCode(), dataValue.getSourceTimestamp(), DateTime.MIN_VALUE);
                break;
            }
            case Both: {
                dataValue = new DataValue(dataValue.getValue(), dataValue.getStatusCode(), dataValue.getSourceTimestamp(), DateTime.currentTime());
            }
        }
        return dataValue;
    }

    private static DataValue c(DataValue dataValue) {
        return new DataValue(dataValue.getValue(), StatusCode.getFromBits((int)(dataValue.getStatusCode().getValueAsIntBits() | 0x480)), dataValue.getSourceTimestamp(), dataValue.getSourcePicoseconds(), dataValue.getServerTimestamp(), dataValue.getServerPicoseconds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNewSample(DataValue dataValue, boolean bl) {
        logger.debug("addNewSample: value={} subscriptionId={} mayReplaceLastSample={}", new Object[]{dataValue, this.subscription.getSubscriptionId(), bl});
        if (this.subscription.isPublishingEnabled() && dataValue != null) {
            MonitoredDataItem monitoredDataItem = this;
            synchronized (monitoredDataItem) {
                logger.trace("addNewSample: queue={}", this.X);
                boolean bl2 = this.getQueueSize() > 1L;
                Object object2 = dataValue;
                if (this.X != null) {
                    logger.trace("addNewSample: queue.size={} QueueSize={} prevValue={}", new Object[]{this.X.size(), this.getQueueSize(), this.gM});
                    if (bl) {
                        DataValue dataValue2 = (DataValue)this.X.pollLast();
                        logger.trace("addNewSample: replacing the last sample; last={}", (Object)dataValue2);
                        if (dataValue2 != null && dataValue2.getStatusCode().isOverflow()) {
                            object2 = MonitoredDataItem.c(dataValue);
                        }
                        bl2 = false;
                    }
                    while (!this.X.offer((DataValue)object2)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("addNewSample: queue overflow: SubscriptionId={} ItemId={} discardOldest={}", new Object[]{this.subscription.getSubscriptionId(), this.getMonitoredItemId(), this.discardOldest});
                        }
                        if (this.discardOldest) {
                            this.X.pollFirst();
                            if (this.getQueueSize() <= 1L) continue;
                            this.X.addFirst(MonitoredDataItem.c((DataValue)this.X.pollFirst()));
                            continue;
                        }
                        this.X.pollLast();
                        if (this.getQueueSize() <= 1L) continue;
                        object2 = MonitoredDataItem.c(dataValue);
                    }
                }
                this.setLastValue(dataValue, bl2);
                if (this.subscription.isPublishingEnabled()) {
                    if (this.getMonitoringMode().equals((Object)MonitoringMode.Reporting)) {
                        this.subscription.newSampleAvailable(this, (DataValue)object2);
                    }
                    if (this.links != null && !this.links.isEmpty()) {
                        logger.debug("Link list is not empty, checking if need to trigger");
                        boolean bl3 = false;
                        boolean bl4 = false;
                        for (Object object2 : this.links) {
                            if (object2.getMonitoringMode() != MonitoringMode.Sampling) continue;
                            if (!bl3 && object2 instanceof MonitoredDataItem && ((MonitoredDataItem)object2).hasMoreSamples()) {
                                logger.debug("hasMoreSamples true for item={}", object2);
                                bl3 = true;
                            }
                            if (bl4 || !(object2 instanceof MonitoredEventItem) || ((MonitoredEventItem)object2).getCurrentQueueSize() <= 0) continue;
                            logger.debug("getCurrentQueueSize larger than 0 for item={}", object2);
                            bl4 = true;
                        }
                        this.subscription.needTrigger(this, bl3, bl4);
                    }
                }
                return;
            }
        }
    }

    protected DataValue applyIndexRange(DataValue dataValue) {
        if (!NumericRange.isNullOrEmpty((NumericRange)this.getIndexRange())) {
            logger.debug("applyIndexRange: value={} indexRange={}", (Object)dataValue, (Object)this.getIndexRange());
            dataValue = (DataValue)dataValue.clone();
            try {
                IoManager.applyIndexRangeToReadValue(dataValue, this.getIndexRange());
                logger.debug("applyIndexRange: new value={}", (Object)dataValue);
            }
            catch (StatusException statusException) {
                logger.info("Failed to apply IndexRange " + this.getIndexRange() + " to " + dataValue.getValue(), (Throwable)statusException);
                dataValue.setStatusCode(statusException.getStatusCode());
            }
        }
        return dataValue;
    }

    protected void assignEuRange(DataValue dataValue) {
        if (dataValue != null && !dataValue.isNull()) {
            try {
                this.setEuRange((Range)dataValue.getValue().getValue());
                return;
            }
            catch (ClassCastException classCastException) {
                logger.warn("initRange: Cannot cast current value of a range property to Range");
            }
        }
        this.setEuRange(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean checkDeadband(DataValue object, DataValue object2, DeadbandType object3) {
        int[] nArray;
        int[] nArray2;
        object = object.getValue();
        object2 = object2.getValue();
        logger.debug("checkDeadband: lastVariantValue={}", object);
        logger.debug("checkDeadband: variantValue={}", object2);
        if (object2.isArray() || object.isArray()) {
            int[] nArray3 = MultiDimensionArrayUtils.getArrayLengths((Object)object2.getValue());
            if (!Arrays.equals(nArray3, MultiDimensionArrayUtils.getArrayLengths((Object)object.getValue()))) {
                logger.debug("checkDeadband: array lengths are not equal {}", (Object)Arrays.toString(nArray3));
                return true;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("checkDeadband: arrayLengths={}", (Object)Arrays.toString(nArray3));
            }
            object2 = MultiDimensionArrayUtils.arrayIterator((Object)object2.getValue(), (int[])nArray3);
            object = MultiDimensionArrayUtils.arrayIterator((Object)object.getValue(), (int[])nArray3);
            do {
                if (!object2.hasNext()) return false;
            } while (!this.checkDeadband((DeadbandType)object3, object2.next(), object.next()));
            logger.debug("checkDeadband: elements differ");
            return true;
        }
        if (object2.getCompositeClass().equals(byte[].class) && object.getCompositeClass().equals(byte[].class)) {
            return this.a(object2.getValue(), object.getValue());
        }
        if (!object2.getCompositeClass().equals(String.class)) return this.checkDeadband((DeadbandType)object3, object.getValue(), object2.getValue());
        if (!object.getCompositeClass().equals(String.class)) return this.checkDeadband((DeadbandType)object3, object.getValue(), object2.getValue());
        object3 = object.getValue();
        object2 = object2.getValue();
        object = this;
        if (object2 == null) {
            if (object3 == null) return false;
        }
        if (!Arrays.equals(nArray2 = MultiDimensionArrayUtils.getArrayLengths((Object)object2), nArray = MultiDimensionArrayUtils.getArrayLengths((Object)object3))) {
            logger.debug("checkDeadband: array lengths are not equal. Left={}, Right={}.", (Object)(nArray2 == null ? "null" : Arrays.toString(nArray2)), (Object)(nArray == null ? "null" : Arrays.toString(nArray)));
            return true;
        }
        if (object2 instanceof String) {
            if (object2.equals(object3)) return false;
            return true;
        }
        if (object3 instanceof String) {
            if (object3.equals(object2)) return false;
            return true;
        }
        int n2 = 0;
        while (n2 < nArray2.length) {
            if (super.a(Array.get(object2, n2), Array.get(object3, n2))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean checkDeadband(DeadbandType deadbandType, Object object, Object object2) {
        double d2;
        double d3;
        logger.debug("checkDeadband: deadbandType={} lastValue={} value={}", new Object[]{deadbandType, object, object2});
        if (object == null) {
            return object2 != null;
        }
        if (object2 == null) {
            return true;
        }
        if (deadbandType == DeadbandType.None) {
            d3 = 0.0;
        } else {
            try {
                d2 = ((Number)object).doubleValue();
                double d4 = ((Number)object2).doubleValue();
                d3 = Math.abs(d2 - d4);
            }
            catch (ClassCastException classCastException) {
                logger.warn("checkDeadband: value " + object2 + " of class " + object2 == null ? "null" : object2.getClass() + " is not a Number, even though deadband is " + deadbandType, (Throwable)classCastException);
                return true;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("checkDeadband: deadbandValue=" + this.getDeadbandValue() + " diff=" + d3 + (deadbandType == DeadbandType.Percent ? " valueRange=" + this.getValueRange() : ""));
        }
        switch (deadbandType) {
            case None: {
                return !object.equals(object2);
            }
            case Absolute: {
                return d3 > this.getDeadbandValue();
            }
            case Percent: {
                d2 = this.getDeadbandValue() / 100.0 * this.getValueRange();
                return d3 > d2;
            }
        }
        return false;
    }

    protected synchronized void clearQueue() {
        logger.debug("clearQueue");
        if (this.X != null) {
            this.X.clear();
        }
    }

    @Override
    protected long getDefaultQueueSize() {
        return 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataValue getNextSample(boolean bl) {
        logger.trace("getNextSample: queue={}", this.X);
        DataValue dataValue = null;
        if (this.getMonitoringMode().equals((Object)MonitoringMode.Reporting) || bl) {
            MonitoredDataItem monitoredDataItem = this;
            synchronized (monitoredDataItem) {
                if (this.X != null) {
                    dataValue = this.X.poll();
                    logger.debug("getNextSample: sample from queue={}", (Object)dataValue);
                    return this.b(dataValue);
                }
                if (!this.gK) {
                    dataValue = this.getLastValue();
                    this.gK = true;
                }
            }
            dataValue = this.b(dataValue);
            logger.debug("getNextSample: sample={}", (Object)dataValue);
        } else if (logger.isDebugEnabled()) {
            logger.debug("getNextSample: Skipping MonitoredDataItem={} as it is in mode={}", (Object)this, (Object)this.getMonitoringMode());
        }
        return dataValue;
    }

    protected double getValueRange() {
        if (this.gl == null) {
            return 0.0;
        }
        return this.gl.getHigh() - this.gl.getLow();
    }

    protected boolean isAccessible() {
        block7: {
            if (this.gI == null) {
                try {
                    if (this.getServiceContext().getSession().isActive()) {
                        IoManager ioManager;
                        try {
                            ioManager = this.getSubscription().getSubscriptionManager().getNodeManagerTable().getIoManager(this.getNodeId());
                            if (ioManager == null) {
                                this.gI = true;
                                return this.gI;
                            }
                        }
                        catch (StatusException statusException) {
                            this.gI = true;
                            return this.gI;
                        }
                        UaNode uaNode = ioManager.getNode(this.nodeId);
                        ioManager.checkIsValueNode(uaNode);
                        uaNode = (UaVariable)uaNode;
                        ioManager.checkAccessLevel(this.getServiceContext(), null, this.getNodeId(), (UaVariable)uaNode, AccessLevel.CurrentRead);
                        this.gI = true;
                        break block7;
                    }
                    this.gI = false;
                }
                catch (StatusException statusException) {
                    this.gI = false;
                }
            }
        }
        return this.gI;
    }

    @Override
    protected void plugNodeListener() {
        if (this.getAttributeId().equals((Object)Attributes.Value)) {
            UaNode uaNode = this.getNode();
            if (uaNode instanceof UaVariable) {
                ((UaVariable)uaNode).addDataChangeListener(this.dataChangeListener);
            }
            if (uaNode instanceof UaVariable && this.getDataChangeFilter() != null && DeadbandType.Percent == DeadbandType.valueOf((UnsignedInteger)this.getDataChangeFilter().getDeadbandType())) {
                this.a((UaVariable)uaNode);
            }
        }
    }

    protected void setDataChangeFilter(DataChangeFilter dataChangeFilter) throws ServiceException {
        this.setFilter((MonitoringFilter)dataChangeFilter);
    }

    protected void setIndexRange(NumericRange numericRange) {
        this.bP = numericRange;
    }

    protected void setLastValue(DataValue dataValue, boolean bl) {
        int n2;
        logger.trace("setLastValue: updatePrevValue={} lastValue={}", (Object)bl, (Object)this.gL);
        if (dataValue != null && ((n2 = dataValue.getStatusCode().getValueAsIntBits()) & 0xFFFF) != 0) {
            dataValue = new DataValue(dataValue.getValue(), StatusCode.getFromBits((int)(n2 & 0xFFFF0000)), dataValue.getSourceTimestamp(), dataValue.getSourcePicoseconds(), dataValue.getServerTimestamp(), dataValue.getServerPicoseconds());
        }
        if (bl) {
            this.gM = this.gL;
        }
        this.gL = dataValue;
        this.gK = false;
    }

    protected void startSampling() {
        if (!this.getMonitoringMode().equals((Object)MonitoringMode.Disabled)) {
            logger.debug("startSampling");
            this.addNewSample(this.aS(), false);
        }
    }

    @Override
    protected void unPlugNodeListener() {
        logger.debug("unPlugNodeListener {} {}", (Object)this.subscription, (Object)this);
        UaNode uaNode = this.getNode();
        if (uaNode instanceof ServerNode) {
            ((ServerNode)uaNode).removeDataChangeListener(this.dataChangeListener);
        }
        this.assignEuRange(null);
    }

    protected void updateAccessible(Session session) {
        logger.debug("updateAccessible: session={}", (Object)session);
        if (session != null) {
            logger.debug("updateAccessible: session.userIdentity={}", (Object)session.getUserIdentity());
        }
        this.gI = null;
    }

    @Override
    protected void updateFilter() {
        logger.debug("updateFilter: {}", (Object)this.getFilter());
        if (this.getNode() instanceof UaVariable && this.getDataChangeFilter() != null && DeadbandType.Percent == DeadbandType.valueOf((UnsignedInteger)this.getDataChangeFilter().getDeadbandType())) {
            this.a((UaVariable)this.getNode());
            return;
        }
        this.assignEuRange(null);
    }

    @Override
    protected synchronized void updateQueue() {
        logger.debug("updateQueue");
        BlockingDeque<DataValue> blockingDeque = this.X;
        boolean bl = this.getMonitoringMode().equals((Object)MonitoringMode.Disabled);
        BlockingDeque<Object> blockingDeque2 = this.X = bl || this.queueSize <= 1L ? null : new LinkedBlockingDeque((int)this.queueSize);
        if (logger.isDebugEnabled()) {
            logger.debug("updateQueue: making queue of size: " + (this.X == null ? "null" : Long.valueOf(this.queueSize)));
        }
        if (blockingDeque != null) {
            logger.debug("updateQueue: oldQueue={}", blockingDeque);
            if (this.X != null) {
                while (!blockingDeque.isEmpty()) {
                    this.addNewSample(blockingDeque.poll(), false);
                }
            } else {
                blockingDeque.clear();
            }
        } else {
            this.startSampling();
        }
        logger.debug("updateQueue done. Active size={}", (Object)(this.X == null ? 0 : this.X.size()));
    }
}

