/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.UaNodeUtils;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.NamingRuleType;

public final class ModellingRule {
    public static final ModellingRule ExposesItsArray = new ModellingRule(Identifiers.ModellingRule_ExposesItsArray, NamingRuleType.Constraint);
    public static final ModellingRule Mandatory = new ModellingRule(Identifiers.ModellingRule_Mandatory, NamingRuleType.Mandatory);
    public static final ModellingRule MandatoryPlaceholder = new ModellingRule(Identifiers.ModellingRule_MandatoryPlaceholder, NamingRuleType.Constraint);
    public static final ModellingRule MandatoryShared = new ModellingRule(Identifiers.ModellingRule_MandatoryShared, NamingRuleType.Mandatory);
    public static final ModellingRule Optional = new ModellingRule(Identifiers.ModellingRule_Optional, NamingRuleType.Optional);
    public static final ModellingRule OptionalPlaceholder = new ModellingRule(Identifiers.ModellingRule_OptionalPlaceholder, NamingRuleType.Constraint);
    public static final ModellingRule[] values = new ModellingRule[]{Mandatory, Optional, ExposesItsArray, MandatoryShared, OptionalPlaceholder, MandatoryPlaceholder};
    private final NamingRuleType cz;
    private final NodeId nodeId;

    public static ModellingRule byInstanceDeclaration(UaNode uaNode) {
        if (uaNode == null) {
            return null;
        }
        if ((uaNode = UaNodeUtils.getModellingRule(uaNode)) == null) {
            return null;
        }
        return ModellingRule.byModellingRuleNode(uaNode);
    }

    public static ModellingRule byModellingRuleNode(UaNode uaNode) {
        if (!UaNodeUtils.isModellingRule(uaNode)) {
            throw new IllegalArgumentException("Node is not a modelling rule");
        }
        ModellingRule modellingRule = ModellingRule.a(uaNode.getNodeId());
        if (modellingRule == null) {
            return new ModellingRule(uaNode);
        }
        return modellingRule;
    }

    private static ModellingRule a(NodeId nodeId) {
        ModellingRule[] modellingRuleArray = values;
        int n2 = values.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            ModellingRule modellingRule = modellingRuleArray[i2];
            if (!modellingRule.nodeId.equals((Object)nodeId)) continue;
            return modellingRule;
        }
        return null;
    }

    private ModellingRule(NodeId nodeId, NamingRuleType namingRuleType) {
        this.nodeId = nodeId;
        this.cz = namingRuleType;
    }

    private ModellingRule(UaNode uaNode) {
        this.nodeId = uaNode.getNodeId();
        this.cz = UaNodeUtils.getNamingRule(uaNode);
    }

    public final NamingRuleType getNamingRule() {
        return this.cz;
    }

    public final NodeId getNodeId() {
        return this.nodeId;
    }
}

