/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.ModelParserBase;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.NodeManagerTable;
import com.prosysopc.ua.server.ServiceContext;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.common.NamespaceTable;
import org.opcfoundation.ua.common.ServerTable;
import org.opcfoundation.ua.core.AddNodesItem;
import org.opcfoundation.ua.core.AddReferencesItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelParser
extends ModelParserBase {
    private static final Logger logger = LoggerFactory.getLogger(ModelParser.class);
    private final NodeManagerTable nodeManagerTable;

    public ModelParser(NodeManagerTable nodeManagerTable) {
        super(nodeManagerTable.getServer());
        this.nodeManagerTable = nodeManagerTable;
    }

    @Override
    protected void addNamespaceUri(String string) {
        super.addNamespaceUri(string);
        if (!this.nodeManagerTable.hasNodeManager(string)) {
            try {
                this.nodeManagerTable.createNewNodeManager(ServiceContext.INTERNAL_OPERATION_CONTEXT, string);
                return;
            }
            catch (StatusException statusException) {
                throw new RuntimeException(statusException);
            }
        }
    }

    @Override
    protected void afterCreate(AddNodesItem addNodesItem) {
    }

    @Override
    protected NodeId doAddNode(AddNodesItem addNodesItem) throws StatusException {
        logger.debug("doAddNode: {}", (Object)addNodesItem);
        return this.nodeManagerTable.addNode(ServiceContext.INTERNAL_OPERATION_CONTEXT, addNodesItem);
    }

    @Override
    protected void doAddReference(AddReferencesItem addReferencesItem) throws StatusException {
        this.nodeManagerTable.addReference(ServiceContext.INTERNAL_OPERATION_CONTEXT, addReferencesItem);
    }

    @Override
    protected NamespaceTable getNamespaceTable() {
        return this.nodeManagerTable.getNamespaceTable();
    }

    @Override
    protected UaNode getNode(NodeId nodeId) throws StatusException {
        return this.nodeManagerTable.getNode(nodeId);
    }

    @Override
    protected ServerTable getServerTable() {
        return this.nodeManagerTable.getServerTable();
    }
}

