/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.MethodArgumentException;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.CallableListener;
import com.prosysopc.ua.server.MethodManager;
import com.prosysopc.ua.server.NodeManager;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.nodes.UaCallable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.core.Argument;
import org.opcfoundation.ua.core.StatusCodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodManagerUaNode
extends MethodManager {
    private static final Logger logger = LoggerFactory.getLogger(MethodManagerUaNode.class);
    private List<CallableListener> listeners;

    public MethodManagerUaNode(NodeManager nodeManager) {
        super(nodeManager);
    }

    public void addCallListener(CallableListener callableListener) {
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArrayList<CallableListener>();
        }
        this.listeners.add(callableListener);
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId object, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        Variant[] variantArray2;
        UaMethod uaMethod;
        logger.debug("callMethod: objectId={}; methodId={}", object, (Object)nodeId);
        UaNode uaNode = this.getNode((NodeId)object);
        logger.debug(" node: {}", (Object)uaNode);
        try {
            uaMethod = (UaMethod)this.getNode(nodeId);
            logger.debug(" method: {}", (Object)uaMethod);
        }
        catch (ClassCastException classCastException) {
            logger.debug("MethodId does not correspond to a method object");
            throw new StatusException(StatusCodes.Bad_MethodInvalid);
        }
        try {
            Argument[] argumentArray = uaMethod.getOutputArguments();
            variantArray2 = argumentArray == null ? null : new Variant[argumentArray.length];
        }
        catch (MethodArgumentException methodArgumentException) {
            throw new StatusException(StatusCodes.Bad_InvalidArgument);
        }
        this.checkInputArguments(variantArray, statusCodeArray, diagnosticInfoArray, uaMethod);
        boolean bl = this.fireCall(serviceContext, variantArray, statusCodeArray, diagnosticInfoArray, (NodeId)object, uaNode, nodeId, uaMethod, variantArray2);
        logger.debug(" handled: {}", (Object)bl);
        if (!bl) {
            block11: {
                if (uaNode instanceof UaCallable) {
                    try {
                        variantArray2 = ((UaCallable)((Object)uaNode)).callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
                        bl = true;
                    }
                    catch (StatusException statusException) {
                        object = statusException;
                        if (statusException.getStatusCode().isStatusCode(StatusCodes.Bad_MethodInvalid)) break block11;
                        throw object;
                    }
                }
            }
            if (!bl) {
                if (uaMethod instanceof UaCallable) {
                    variantArray2 = ((UaCallable)((Object)uaMethod)).callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
                } else {
                    throw new StatusException(StatusCodes.Bad_MethodInvalid);
                }
            }
        }
        this.checkOutputArguments(variantArray2, uaMethod);
        return variantArray2;
    }

    public void removeCallListener(CallableListener callableListener) {
        this.listeners.remove(callableListener);
    }

    protected void checkInputArguments(Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray, UaMethod argumentArray) throws StatusException {
        try {
            argumentArray = argumentArray.getInputArguments();
        }
        catch (MethodArgumentException methodArgumentException) {
            argumentArray = null;
        }
        int n2 = variantArray == null ? 0 : variantArray.length;
        int n3 = argumentArray == null ? 0 : argumentArray.length;
        logger.debug("checkInputArguments: methodInputs={}; inputArguments={}", (Object)n3, (Object)n2);
        if (n2 < n3) {
            throw new StatusException(StatusCodes.Bad_ArgumentsMissing);
        }
        if (n2 > n3) {
            throw new StatusException(StatusCodes.Bad_InvalidArgument);
        }
        n2 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            variantArray[i2] = this.getNodeManager().getIoManager().autoConvert(variantArray[i2], argumentArray[i2].getDataType());
            boolean bl = this.dataTypeEquals(variantArray[i2], argumentArray[i2].getDataType());
            boolean bl2 = this.arrayDimensionsMatch(variantArray[i2], argumentArray[i2].getValueRank(), argumentArray[i2].getArrayDimensions());
            if (bl && bl2) {
                statusCodeArray[i2] = StatusCode.GOOD;
                continue;
            }
            if (!bl) {
                Object object;
                statusCodeArray[i2] = new StatusCode(StatusCodes.Bad_TypeMismatch);
                try {
                    object = this.getNode(argumentArray[i2].getDataType());
                }
                catch (StatusException statusException) {
                    object = null;
                }
                object = object != null ? object.toString() : argumentArray[i2].getDataType().toString();
                object = String.format("DataType (%s) of inputArgument #%d (%s) does not match the expected (%s)", variantArray[i2].getCompositeClass(), i2, argumentArray[i2].getName(), object);
                logger.info((String)object);
                diagnosticInfoArray[i2] = new DiagnosticInfo((String)object, null, null, null, null, null, null);
            }
            if (!bl2) {
                statusCodeArray[i2] = new StatusCode(StatusCodes.Bad_TypeMismatch);
                logger.info("Dimensions of the inputargument does not match given ValueRank and ArrayDimensions of the Method InputArgument");
            }
            n2 = 1;
        }
        if (n2 != 0) {
            throw new StatusException(StatusCodes.Bad_InvalidArgument);
        }
    }

    protected void checkOutputArguments(Variant[] variantArray, UaMethod uaMethod) throws StatusException {
        int n2;
        Argument[] argumentArray;
        try {
            argumentArray = uaMethod.getOutputArguments();
        }
        catch (MethodArgumentException methodArgumentException) {
            argumentArray = null;
        }
        int n3 = variantArray == null ? 0 : variantArray.length;
        int n4 = n2 = argumentArray == null ? 0 : argumentArray.length;
        if (logger.isDebugEnabled()) {
            logger.debug("checkOutputArguments: outputArguments={}", (Object)Arrays.toString(variantArray));
        }
        if (n3 != n2) {
            logger.warn("checkOutputArguments: methodOutputs={} != outputArguments={}", (Object)n2, (Object)n3);
            return;
        }
        for (n3 = 0; n3 < n2; ++n3) {
            Object object;
            if (this.dataTypeEquals(variantArray[n3], argumentArray[n3].getDataType())) continue;
            try {
                object = this.getNode(argumentArray[n3].getDataType());
            }
            catch (StatusException statusException) {
                object = null;
            }
            object = object != null ? object.toString() : argumentArray[n3].getDataType().toString();
            object = String.format("Method %s(ID=%s): DataType (%s) of outputArgument #%d (%s) does not match the expected (%s)", uaMethod.getBrowseName(), uaMethod.getNodeId(), variantArray[n3].getCompositeClass(), n3, argumentArray[n3].getName(), object);
            logger.warn((String)object);
        }
    }

    protected boolean fireCall(ServiceContext serviceContext, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray, NodeId nodeId, UaNode uaNode, NodeId nodeId2, UaMethod uaMethod, Variant[] variantArray2) throws StatusException {
        logger.debug(" method: {}", (Object)uaMethod);
        for (CallableListener callableListener : this.listeners) {
            if (!callableListener.onCall(serviceContext, nodeId, uaNode, nodeId2, uaMethod, variantArray, statusCodeArray, diagnosticInfoArray, variantArray2)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean requireUaNode() {
        return true;
    }
}

