/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.AnnotationException;
import com.prosysopc.ua.AnnotationUtils;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaValueNode;
import com.prosysopc.ua.server.IoManager;
import com.prosysopc.ua.server.NodeManager;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.io.IoManagerListener;
import com.prosysopc.ua.server.io.TypeIoManagerListener;
import com.prosysopc.ua.server.io.UaNodeIoListener;
import com.prosysopc.ua.server.io.UaTypeIoListener;
import com.prosysopc.ua.types.opcua.BaseInstanceType;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.Attributes;
import org.opcfoundation.ua.core.TimestampsToReturn;
import org.opcfoundation.ua.utils.NumericRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoManagerUaNode
extends IoManager {
    private static Logger logger = LoggerFactory.getLogger(IoManagerUaNode.class);
    private final TypeIoManagerListener cP = new TypeIoManagerListener();

    public IoManagerUaNode(NodeManager nodeManager) {
        super(nodeManager);
        this.setListeners(this.getNodeListener(), this.getTypeListener(), this.getDefaultListener());
    }

    public void addNodeListener(UaNode uaNode, UaNodeIoListener uaNodeIoListener) {
        this.addNodeListener(uaNode.getNodeId(), uaNodeIoListener);
    }

    public void addTypeListener(Class<? extends BaseInstanceType> clazz, UaTypeIoListener uaTypeIoListener) throws AnnotationException, ServiceResultException {
        this.addTypeListener(this.getNodeManager().getNamespaceTable().toNodeId(AnnotationUtils.readTypeDefinitionId(clazz)), uaTypeIoListener);
    }

    public void addTypeListener(NodeId nodeId, UaTypeIoListener uaTypeIoListener) {
        this.cP.addListener(nodeId, uaTypeIoListener);
    }

    public IoManagerListener getTypeListener() {
        return this.cP;
    }

    @Override
    protected void readNonValue(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        uaNode.readAttribute(unsignedInteger, dataValue, serviceContext.getSession().getDefaultLocale());
        logger.debug("readValue({}): {}", (Object)nodeId, (Object)dataValue);
    }

    @Override
    protected void readValue(ServiceContext serviceContext, Object object, NodeId nodeId, UaValueNode uaValueNode, NumericRange numericRange, TimestampsToReturn timestampsToReturn, DateTime dateTime, DataValue dataValue) throws StatusException {
        logger.debug("readValue: nodeId={} indexRange={} minTimestamp={}", new Object[]{nodeId, numericRange, dateTime});
        logger.debug("readValue: value={}", (Object)dataValue);
        uaValueNode.readAttribute(Attributes.Value, dataValue, serviceContext.getSession().getDefaultLocale());
        long l2 = DateTime.currentTime().getMilliSeconds();
        if (dataValue.getServerTimestamp() == null || dataValue.getServerTimestamp().getMilliSeconds() < dateTime.getMilliSeconds()) {
            dataValue.setServerTimestamp(new DateTime(l2 * 10000L));
        }
        IoManagerUaNode.applyIndexRangeToReadValue(dataValue, numericRange);
        logger.debug("readValue: result={}", (Object)dataValue);
    }

    @Override
    protected boolean requireUaNode() {
        return true;
    }

    @Override
    protected boolean writeNonValue(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        return uaNode.writeAttribute(unsignedInteger, dataValue);
    }

    @Override
    protected boolean writeValue(ServiceContext serviceContext, Object object, NodeId nodeId, UaValueNode uaValueNode, NumericRange numericRange, DataValue dataValue) throws StatusException {
        boolean bl;
        logger.debug("writeValue: nodeId={} value={}", (Object)nodeId, (Object)dataValue);
        dataValue = IoManagerUaNode.applyIndexRangeToWriteValue(uaValueNode.getValue(), dataValue, numericRange);
        try {
            bl = uaValueNode.writeAttribute(Attributes.Value, dataValue);
        }
        catch (StatusException statusException) {
            logger.debug("writeAttribute failed", (Throwable)statusException);
            throw statusException;
        }
        logger.debug("writeValue: returnValue={}", (Object)bl);
        return bl;
    }
}

