/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.WriteAccess;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaValueNode;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.server.MonitoredDataItem;
import com.prosysopc.ua.server.NodeManager;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.ServiceManagerBase;
import com.prosysopc.ua.server.io.IoManagerListener;
import com.prosysopc.ua.server.io.IoManagerListenerChain;
import com.prosysopc.ua.server.io.IoManagerListenerChainImpl;
import com.prosysopc.ua.server.io.NodeIoManagerListener;
import com.prosysopc.ua.server.io.UaNodeIoListener;
import com.prosysopc.ua.server.k;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedByte;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.core.AccessLevel;
import org.opcfoundation.ua.core.Attributes;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.ReadValueId;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.core.TimestampsToReturn;
import org.opcfoundation.ua.core.WriteValue;
import org.opcfoundation.ua.utils.AttributesUtil;
import org.opcfoundation.ua.utils.CryptoUtil;
import org.opcfoundation.ua.utils.MultiDimensionArrayUtils;
import org.opcfoundation.ua.utils.NumericRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoManager
extends ServiceManagerBase {
    private static final IoManagerListener je = new k();
    private static Logger logger = LoggerFactory.getLogger(IoManager.class);
    private final IoManagerListenerChain jf = new IoManagerListenerChainImpl();
    private final NodeIoManagerListener jg = new NodeIoManagerListener();
    private final NodeManager dX;

    public static void applyIndexRangeToReadValue(DataValue dataValue, NumericRange numericRange) throws StatusException {
        logger.debug("applyIndexRangeToReadValue: dataValue={}", (Object)dataValue);
        logger.debug("applyIndexRangeToReadValue: indexRange={}", (Object)numericRange);
        if (dataValue.getStatusCode().isNotBad() && !NumericRange.isNullOrEmpty((NumericRange)numericRange)) {
            Object object = dataValue.getValue().getValue();
            object = IoManager.applyIndexRangeToReadValue(object, numericRange, 0);
            if (logger.isDebugEnabled()) {
                logger.debug("applyIndexRangeToReadValue: value={}", (Object)MultiDimensionArrayUtils.toString((Object)object));
                logger.debug("applyIndexRangeToReadValue: class={}", object.getClass());
            }
            dataValue.setValue(new Variant(object));
        }
    }

    public static DataValue applyIndexRangeToWriteValue(DataValue objectArray, DataValue dataValue, NumericRange numericRange) throws StatusException {
        logger.debug("applyIndexRangeToWriteValue: currentValue={}", (Object)objectArray);
        logger.debug("applyIndexRangeToWriteValue: newValue={}", (Object)dataValue);
        logger.debug("applyIndexRangeToWriteValue: indexRange={}", (Object)numericRange);
        if (!NumericRange.isNullOrEmpty((NumericRange)numericRange)) {
            dataValue = (DataValue)dataValue.clone();
            if ((objectArray = objectArray.getValue().getValue()) == null) {
                throw new StatusException(StatusCodes.Bad_IndexRangeNoData);
            }
            if (objectArray instanceof String) {
                objectArray = (String)objectArray;
                String string = objectArray.substring(numericRange.getBegin(), numericRange.getEnd() + 1);
                dataValue.setValue(new Variant((Object)string));
            } else if (objectArray instanceof byte[]) {
                byte[] byArray = (byte[])objectArray;
                objectArray = byArray;
                byte[] byArray2 = Arrays.copyOfRange(byArray, 0, objectArray.length);
                objectArray = (byte[])dataValue.getValue().getValue();
                try {
                    int n2 = numericRange.getBegin();
                    int n3 = 0;
                    while (n2 <= numericRange.getEnd()) {
                        byArray2[n2] = (byte)objectArray[n3];
                        ++n2;
                        ++n3;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    logger.debug("Index error", (Throwable)arrayIndexOutOfBoundsException);
                    throw new StatusException(StatusCodes.Bad_IndexRangeNoData);
                }
                dataValue.setValue(new Variant((Object)byArray2));
            } else {
                objectArray = objectArray;
                Class<?> clazz = objectArray.getClass();
                objectArray = Arrays.copyOfRange(objectArray, 0, objectArray.length, clazz);
                Object[] objectArray2 = (Object[])dataValue.getValue().getValue();
                try {
                    int n4 = numericRange.getBegin();
                    int n5 = 0;
                    while (n4 <= numericRange.getEnd()) {
                        objectArray[n4] = objectArray2[n5];
                        ++n4;
                        ++n5;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    logger.debug("Index error", (Throwable)arrayIndexOutOfBoundsException);
                    throw new StatusException(StatusCodes.Bad_IndexRangeNoData);
                }
                dataValue.setValue(new Variant((Object)objectArray));
            }
            logger.debug("applyIndexRangeToWriteValue: newValue={}", (Object)dataValue);
        }
        return dataValue;
    }

    protected static Object applyIndexRangeToReadValue(Object objectArray, NumericRange numericRange, int n2) throws StatusException {
        if (logger.isDebugEnabled()) {
            logger.debug("applyIndexRangeToReadValue: dimension={} indexRange={}", (Object)n2, (Object)numericRange);
            logger.debug("applyIndexRangeToReadValue: value={}", (Object)MultiDimensionArrayUtils.toString((Object)objectArray));
        }
        if (objectArray != null && Object[].class.isAssignableFrom(objectArray.getClass())) {
            try {
                Object[] objectArray2 = objectArray;
                if (objectArray2.length < numericRange.getEnd(n2) + 1) {
                    throw new StatusException(StatusCodes.Bad_IndexRangeNoData);
                }
                objectArray2 = Arrays.copyOfRange(objectArray2, numericRange.getBegin(n2), numericRange.getEnd(n2) + 1, objectArray2.getClass());
                if (n2 + 1 < numericRange.getDimensions()) {
                    for (int i2 = 0; i2 < objectArray2.length; ++i2) {
                        objectArray2[i2] = IoManager.applyIndexRangeToReadValue(objectArray2[i2], numericRange, n2 + 1);
                    }
                }
                objectArray = objectArray2;
            }
            catch (Exception exception) {
                logger.debug("Failed to copy the requested range " + numericRange.getBegin(n2) + ":" + numericRange.getEnd(n2), (Throwable)exception);
                throw new StatusException(StatusCodes.Bad_IndexRangeNoData, (Throwable)exception);
            }
        } else if (objectArray instanceof byte[]) {
            try {
                if (((byte[])objectArray).length < numericRange.getEnd(n2) + 1) {
                    throw new StatusException(StatusCodes.Bad_IndexRangeNoData);
                }
                objectArray = Arrays.copyOfRange((byte[])objectArray, numericRange.getBegin(n2), numericRange.getEnd(n2) + 1);
            }
            catch (Exception exception) {
                logger.debug("Failed to copy the requested range " + numericRange.getBegin(n2) + ":" + numericRange.getEnd(n2) + " from byte array " + CryptoUtil.toHex((byte[])((byte[])objectArray)), (Throwable)exception);
                throw new StatusException(StatusCodes.Bad_IndexRangeNoData, (Throwable)exception);
            }
        } else if (objectArray instanceof String) {
            try {
                objectArray = ((String)objectArray).substring(numericRange.getBegin(n2), numericRange.getEnd(n2) + 1);
            }
            catch (Exception exception) {
                logger.debug("Failed to copy the requested range " + numericRange.getBegin(n2) + ":" + numericRange.getEnd(n2) + " from string " + objectArray, (Throwable)exception);
                throw new StatusException(StatusCodes.Bad_IndexRangeNoData, (Throwable)exception);
            }
        } else {
            throw new StatusException(StatusCodes.Bad_IndexRangeNoData);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("applyIndexRangeToReadValue: result={}", (Object)MultiDimensionArrayUtils.toString((Object)objectArray));
        }
        return objectArray;
    }

    protected static void checkIndexRange(Object object, NumericRange numericRange, int n2) throws StatusException {
        if (object instanceof Collection) {
            object = (Collection)object;
            IoManager.validateIndexRange(n2, object.size(), numericRange);
            return;
        }
        if (object instanceof String) {
            IoManager.validateIndexRange(n2, ((String)object).length(), numericRange);
        }
    }

    protected static void validateIndexRange(int n2, int n3, NumericRange numericRange) throws StatusException {
        int n4 = numericRange.getBegin(n2);
        n2 = numericRange.getEnd(n2);
        if (n4 >= n3 || n2 >= n3) {
            throw new StatusException(StatusCodes.Bad_IndexRangeNoData);
        }
    }

    public IoManager(NodeManager nodeManager) {
        super(nodeManager.getServer());
        this.dX = nodeManager;
        nodeManager.setIoManager(this);
        this.jf.setListeners(this.jg, je);
    }

    public void addListeners(IoManagerListener ... ioManagerListenerArray) {
        this.jf.addListeners(ioManagerListenerArray);
    }

    public void addNodeListener(NodeId nodeId, UaNodeIoListener uaNodeIoListener) {
        this.jg.addListener(nodeId, uaNodeIoListener);
    }

    public final Variant autoConvert(Variant variant, NodeId nodeId) {
        if (variant == null || variant.getValue() == null) {
            return variant;
        }
        Object object = variant.getValue();
        if (object instanceof byte[]) {
            try {
                UnsignedByte[] unsignedByteArray = this.dX.getNodeManagerTable().getNodeManagerRoot().getType(nodeId);
                if (unsignedByteArray.inheritsFrom(Identifiers.Byte)) {
                    byte[] byArray = (byte[])object;
                    object = byArray;
                    unsignedByteArray = new UnsignedByte[byArray.length];
                    for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                        unsignedByteArray[i2] = UnsignedByte.getFromBits((byte)object[i2]);
                    }
                    return new Variant((Object)unsignedByteArray);
                }
                return variant;
            }
            catch (Exception exception) {
                logger.error("Error while autoconverting Value={} to DataTypeId={}", new Object[]{variant, nodeId, exception});
                return variant;
            }
        }
        return variant;
    }

    public IoManagerListener getDefaultListener() {
        return je;
    }

    public IoManagerListener getNodeListener() {
        return this.jg;
    }

    public NodeManager getNodeManager() {
        return this.dX;
    }

    public DataValue readAttribute(NodeId nodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, DateTime dateTime) throws StatusException {
        DataValue dataValue = new DataValue();
        this.readAttribute(ServiceContext.INTERNAL_OPERATION_CONTEXT, null, nodeId, unsignedInteger, numericRange, TimestampsToReturn.Both, dateTime, dataValue);
        return dataValue;
    }

    public void removeListeners(IoManagerListener ... ioManagerListenerArray) {
        this.jf.removeListeners(ioManagerListenerArray);
    }

    public void setListeners(IoManagerListener ... ioManagerListenerArray) {
        this.jf.setListeners(ioManagerListenerArray);
    }

    public void writeAttribute(NodeId nodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, DataValue dataValue) throws StatusException {
        this.writeAttribute(ServiceContext.INTERNAL_OPERATION_CONTEXT, null, nodeId, unsignedInteger, numericRange, dataValue);
    }

    protected Object beginRead(ServiceContext serviceContext, ReadValueId[] readValueIdArray, TimestampsToReturn timestampsToReturn, DateTime dateTime, DataValue[] dataValueArray, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        return null;
    }

    protected Object beginWrite(ServiceContext serviceContext, WriteValue[] writeValueArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        return null;
    }

    protected void checkAccessLevel(ServiceContext object, Object object2, NodeId nodeId, UaVariable uaVariable, AccessLevel accessLevel) throws StatusException {
        logger.debug("checkAccessLevel: variable={}", (Object)uaVariable);
        EnumSet<AccessLevel> enumSet = this.getAccessLevel((ServiceContext)object, object2, nodeId, uaVariable);
        logger.debug("variableAccessLevel={}", enumSet);
        if (enumSet == null || !enumSet.contains(accessLevel)) {
            throw new StatusException(String.format("AccessLevel of node '%s(ID=%s) does not enable %s'", uaVariable == null ? "" : uaVariable.getClass(), nodeId, accessLevel), accessLevel.equals((Object)AccessLevel.CurrentRead) || accessLevel.equals((Object)AccessLevel.HistoryRead) ? StatusCodes.Bad_NotReadable : StatusCodes.Bad_NotWritable);
        }
        object = this.getUserAccessLevel((ServiceContext)object, object2, nodeId, uaVariable);
        logger.debug("userAccessLevel={}", object);
        if (object == null || !((AbstractCollection)object).contains(accessLevel)) {
            throw new StatusException(String.format("UserAccessLevel of node '(ID=%s) does not enable %s'", nodeId, accessLevel), StatusCodes.Bad_UserAccessDenied);
        }
    }

    protected void checkDataType(NodeId nodeId, UaValueNode uaValueNode, DataValue dataValue) throws StatusException {
        nodeId = this.getVariableDataType(nodeId, uaValueNode);
        dataValue.setValue(this.autoConvert(dataValue.getValue(), nodeId));
        if (!this.dataTypeEquals(dataValue.getValue(), nodeId)) {
            throw new StatusException(StatusCodes.Bad_TypeMismatch);
        }
    }

    protected void checkSupportsAttribute(ServiceContext serviceContext, NodeId nodeId, UaNode uaNode, UnsignedInteger unsignedInteger) throws StatusException {
        if (uaNode != null && !uaNode.supportsAttribute(unsignedInteger)) {
            throw new StatusException(String.format("Attribute '%s' not supported by node type '%s'", AttributesUtil.toString((UnsignedInteger)unsignedInteger), uaNode.getClass()), StatusCodes.Bad_AttributeIdInvalid);
        }
    }

    protected void checkWriteMask(ServiceContext object, Object object2, NodeId nodeId, UaNode uaNode, UnsignedInteger unsignedInteger) throws StatusException {
        logger.debug("checkWriteMask: node={}", (Object)uaNode);
        EnumSet<WriteAccess> enumSet = this.getWriteMask((ServiceContext)object, object2, nodeId, uaNode);
        logger.debug("checkWriteMask:nodeWriteMask={}", enumSet);
        if (enumSet == null || !WriteAccess.hasAccessToAttribute(enumSet, unsignedInteger)) {
            throw new StatusException(String.format("Attribute '%s' not writable in node '%s(ID=%s)'", AttributesUtil.toString((UnsignedInteger)unsignedInteger), uaNode.getClass(), nodeId), StatusCodes.Bad_NotWritable);
        }
        if ((object = this.getUserWriteMask((ServiceContext)object, object2, nodeId, uaNode)) == null || !WriteAccess.hasAccessToAttribute((EnumSet<WriteAccess>)object, unsignedInteger)) {
            throw new StatusException(String.format("Attribute '%s' not user writable in node '(ID=%s)'", AttributesUtil.toString((UnsignedInteger)unsignedInteger), nodeId), StatusCodes.Bad_UserAccessDenied);
        }
    }

    protected void endRead(ServiceContext serviceContext, Object object, ReadValueId[] readValueIdArray, TimestampsToReturn timestampsToReturn, DateTime dateTime, DataValue[] dataValueArray, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
    }

    protected void endWrite(ServiceContext serviceContext, Object object, WriteValue[] writeValueArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
    }

    protected EnumSet<AccessLevel> getAccessLevel(ServiceContext serviceContext, Object object, NodeId nodeId, UaVariable uaVariable) throws StatusException {
        DataValue dataValue = new DataValue();
        this.readNonValue(serviceContext, object, nodeId, uaVariable, Attributes.AccessLevel, dataValue);
        if (dataValue.isNull() || dataValue.getStatusCode().isBad()) {
            return null;
        }
        serviceContext = dataValue.getValue();
        object = serviceContext.getValue();
        if (object instanceof EnumSet) {
            return (EnumSet)object;
        }
        return AccessLevel.getSet((int)serviceContext.intValue());
    }

    protected boolean getExecutable(ServiceContext serviceContext, Object object, NodeId nodeId, UaMethod uaMethod) throws StatusException {
        DataValue dataValue = new DataValue();
        this.readNonValue(serviceContext, object, nodeId, uaMethod, Attributes.Executable, dataValue);
        if (dataValue.isNull() || dataValue.getStatusCode().isBad()) {
            return false;
        }
        serviceContext = dataValue.getValue();
        return serviceContext.booleanValue();
    }

    protected EnumSet<AccessLevel> getUserAccessLevel(ServiceContext serviceContext, Object object, NodeId nodeId, UaVariable uaVariable) {
        return this.jf.onGetUserAccessLevel(serviceContext, nodeId, uaVariable);
    }

    protected boolean getUserExecutable(ServiceContext serviceContext, Object object, NodeId nodeId, UaMethod uaMethod) {
        return this.jf.onGetUserExecutable(serviceContext, nodeId, uaMethod);
    }

    protected EnumSet<WriteAccess> getUserWriteMask(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode) {
        return this.jf.onGetUserWriteMask(serviceContext, nodeId, uaNode);
    }

    protected NodeId getVariableDataType(NodeId nodeId, UaValueNode uaValueNode) throws StatusException {
        return this.getNodeManager().getVariableDataType(nodeId, uaValueNode);
    }

    protected EnumSet<WriteAccess> getWriteMask(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode) throws StatusException {
        DataValue dataValue = new DataValue();
        this.readNonValue(serviceContext, object, nodeId, uaNode, Attributes.WriteMask, dataValue);
        if (dataValue.isNull() || dataValue.getStatusCode().isBad()) {
            return null;
        }
        serviceContext = dataValue.getValue();
        object = serviceContext.getValue();
        if (object instanceof EnumSet) {
            return (EnumSet)object;
        }
        return WriteAccess.getSet(serviceContext.intValue());
    }

    protected void initializeMonitoredDataItem(ServiceContext serviceContext, MonitoredDataItem monitoredDataItem, DataValue dataValue) throws StatusException {
        this.readAttribute(serviceContext, null, monitoredDataItem.getNodeId(), monitoredDataItem.getAttributeId(), monitoredDataItem.getIndexRange(), monitoredDataItem.getTimestampsToReturn(), DateTime.MIN_VALUE, dataValue);
    }

    protected void readAttribute(ServiceContext object, Object object2, NodeId nodeId, UnsignedInteger object3, NumericRange object4, TimestampsToReturn timestampsToReturn, DateTime dateTime, DataValue dataValue) throws StatusException {
        UaNode uaNode = this.getNode(nodeId);
        if (object3.equals((Object)Attributes.Value)) {
            this.checkIsValueNode(uaNode);
            UaValueNode uaValueNode = (UaValueNode)uaNode;
            if (this.isVariable(uaValueNode)) {
                this.checkAccessLevel((ServiceContext)object, object2, nodeId, (UaVariable)uaValueNode, AccessLevel.CurrentRead);
            }
            this.readValue((ServiceContext)object, object2, nodeId, uaValueNode, (NumericRange)object4, timestampsToReturn, dateTime, dataValue);
            object3 = uaValueNode;
            object2 = object;
            object = this;
            logger.debug("fireReadValue");
            ((IoManager)object).jf.onReadValue((ServiceContext)object2, nodeId, (UaValueNode)object3, (NumericRange)object4, timestampsToReturn, dateTime, dataValue);
            return;
        }
        dataValue.setStatusCode(StatusCode.GOOD);
        if (object3.equals((Object)Attributes.AccessLevel)) {
            this.checkIsVariable(uaNode);
            UaVariable uaVariable = (UaVariable)uaNode;
            object4 = this.getAccessLevel((ServiceContext)object, object2, nodeId, uaVariable);
            dataValue.setValue(new Variant((Object)AccessLevel.getMask((Collection)(object4 == null ? AccessLevel.NONE : object4))));
        } else if (object3.equals((Object)Attributes.UserAccessLevel)) {
            this.checkIsVariable(uaNode);
            UaVariable uaVariable = (UaVariable)uaNode;
            object4 = this.getUserAccessLevel((ServiceContext)object, object2, nodeId, uaVariable);
            object2 = this.getAccessLevel((ServiceContext)object, object2, nodeId, uaVariable);
            if (object2 != null && object4 != null) {
                object4 = EnumSet.copyOf(object4);
                object4.retainAll((Collection<?>)object2);
            }
            dataValue.setValue(new Variant((Object)AccessLevel.getMask((Collection)(object4 == null ? AccessLevel.NONE : object4))));
        } else if (object3.equals((Object)Attributes.Executable)) {
            this.checkIsMethod(uaNode);
            boolean bl = this.getExecutable((ServiceContext)object, object2, nodeId, (UaMethod)uaNode);
            dataValue.setValue(new Variant((Object)bl));
        } else if (object3.equals((Object)Attributes.UserExecutable)) {
            this.checkIsMethod(uaNode);
            boolean bl = this.getUserExecutable((ServiceContext)object, object2, nodeId, (UaMethod)uaNode);
            boolean bl2 = this.getExecutable((ServiceContext)object, object2, nodeId, (UaMethod)uaNode);
            dataValue.setValue(new Variant((Object)(bl && bl2 ? 1 : 0)));
        } else if (object3.equals((Object)Attributes.WriteMask)) {
            EnumSet<WriteAccess> enumSet = this.getWriteMask((ServiceContext)object, object2, nodeId, uaNode);
            dataValue.setValue(new Variant((Object)WriteAccess.getMask(enumSet == null ? WriteAccess.NONE : enumSet)));
        } else if (object3.equals((Object)Attributes.UserWriteMask)) {
            EnumSet<WriteAccess> enumSet = this.getUserWriteMask((ServiceContext)object, object2, nodeId, uaNode);
            object4 = this.getWriteMask((ServiceContext)object, object2, nodeId, uaNode);
            if (object4 != null && enumSet != null) {
                enumSet = EnumSet.copyOf(enumSet);
                enumSet.retainAll((Collection<?>)object4);
            }
            dataValue.setValue(new Variant((Object)WriteAccess.getMask(enumSet == null ? WriteAccess.NONE : enumSet)));
        } else {
            this.readNonValue((ServiceContext)object, object2, nodeId, uaNode, (UnsignedInteger)object3, dataValue);
        }
        dataValue.setServerTimestamp(new DateTime());
        timestampsToReturn = dataValue;
        Object object5 = object3;
        object3 = uaNode;
        object2 = object;
        object = this;
        ((IoManager)object).jf.onReadNonValue((ServiceContext)object2, nodeId, (UaNode)object3, (UnsignedInteger)object5, (DataValue)timestampsToReturn);
    }

    protected void readNonValue(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
    }

    protected void readValue(ServiceContext serviceContext, Object object, NodeId nodeId, UaValueNode uaValueNode, NumericRange numericRange, TimestampsToReturn timestampsToReturn, DateTime dateTime, DataValue dataValue) throws StatusException {
    }

    protected boolean writeAttribute(ServiceContext serviceContext, Object object, NodeId nodeId, UnsignedInteger object2, NumericRange numericRange, DataValue dataValue) throws StatusException {
        logger.debug("writeAttribute: nodeId={}; attributeId={}; indexRange={}; value={}", new Object[]{nodeId, object2, numericRange, dataValue});
        UaNode uaNode = this.getNode(nodeId);
        if (object2.equals((Object)Attributes.Value)) {
            this.checkIsValueNode(uaNode);
            object2 = (UaValueNode)uaNode;
            if (this.isVariable((UaNode)object2)) {
                this.checkAccessLevel(serviceContext, object, nodeId, (UaVariable)object2, AccessLevel.CurrentWrite);
            } else {
                this.checkWriteMask(serviceContext, object, nodeId, (UaNode)object2, Attributes.Value);
            }
            this.checkDataType(nodeId, (UaValueNode)object2, dataValue);
            DataValue dataValue2 = dataValue;
            NumericRange numericRange2 = numericRange;
            Object object3 = object2;
            NodeId nodeId2 = nodeId;
            ServiceContext serviceContext2 = serviceContext;
            IoManager ioManager = this;
            return ioManager.jf.onWriteValue(serviceContext2, nodeId2, (UaValueNode)object3, numericRange2, dataValue2) || this.writeValue(serviceContext, object, nodeId, (UaValueNode)object2, numericRange, dataValue);
        }
        logger.debug("checking that node supports attribute");
        this.checkSupportsAttribute(serviceContext, nodeId, uaNode, (UnsignedInteger)object2);
        logger.debug("node does support attribute, checking writeMask");
        this.checkWriteMask(serviceContext, object, nodeId, uaNode, (UnsignedInteger)object2);
        logger.debug("node supports writing attribute");
        DataValue dataValue3 = dataValue;
        Object object4 = object2;
        UaNode uaNode2 = uaNode;
        NodeId nodeId3 = nodeId;
        ServiceContext serviceContext3 = serviceContext;
        IoManager ioManager = this;
        return ioManager.jf.onWriteNonValue(serviceContext3, nodeId3, uaNode2, (UnsignedInteger)object4, dataValue3) || this.writeNonValue(serviceContext, object, nodeId, uaNode, (UnsignedInteger)object2, dataValue);
    }

    protected boolean writeNonValue(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        return false;
    }

    protected boolean writeValue(ServiceContext serviceContext, Object object, NodeId nodeId, UaValueNode uaValueNode, NumericRange numericRange, DataValue dataValue) throws StatusException {
        return false;
    }
}

