/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.BrowsePath;
import com.prosysopc.ua.server.ExternalReferenceDeclaration;
import com.prosysopc.ua.server.InstanceDeclaration;
import com.prosysopc.ua.server.InstanceReferenceDeclaration;
import com.prosysopc.ua.server.ModellingRule;
import com.prosysopc.ua.server.TemporaryInstanceDeclaration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InstanceDeclarationImpl
implements InstanceDeclaration,
Comparable<InstanceDeclaration> {
    private final Set<BrowsePath> bp;
    private final Set<ExternalReferenceDeclaration> bq = new HashSet<ExternalReferenceDeclaration>();
    private final Set<InstanceReferenceDeclaration> br = new HashSet<InstanceReferenceDeclaration>();
    private final Logger logger = LoggerFactory.getLogger(InstanceDeclarationImpl.class);
    private final UaNode node;

    InstanceDeclarationImpl(TemporaryInstanceDeclaration temporaryInstanceDeclaration) {
        this.node = temporaryInstanceDeclaration.getNode();
        this.bq.addAll(temporaryInstanceDeclaration.getExternalReferences());
        this.bp = temporaryInstanceDeclaration.getBrowsePaths();
    }

    public void addReference(InstanceReferenceDeclaration instanceReferenceDeclaration) {
        this.br.add(instanceReferenceDeclaration);
    }

    @Override
    public int compareTo(InstanceDeclaration instanceDeclaration) {
        UaNode uaNode = this.getNode();
        UaNode uaNode2 = instanceDeclaration.getNode();
        if (uaNode != null) {
            if (uaNode2 == null) {
                return 1;
            }
            return uaNode.getBrowseName().getName().compareTo(uaNode2.getBrowseName().getName());
        }
        return this.getNodeId().compareTo(instanceDeclaration.getNodeId());
    }

    public boolean equals(Object object) {
        if (object instanceof InstanceDeclarationImpl) {
            object = (InstanceDeclarationImpl)object;
            return this.node.getNodeId().equals((Object)((InstanceDeclarationImpl)object).node.getNodeId());
        }
        return super.equals(object);
    }

    @Override
    public Set<BrowsePath> getBrowsePaths() {
        return this.bp;
    }

    @Override
    public Set<ExternalReferenceDeclaration> getExternalReferences() {
        return Collections.unmodifiableSet(this.bq);
    }

    @Override
    public Set<InstanceReferenceDeclaration> getInstanceReferences() {
        return Collections.unmodifiableSet(this.br);
    }

    @Override
    public Set<InstanceDeclaration> getNextDeclarations() {
        HashSet<InstanceDeclaration> hashSet = new HashSet<InstanceDeclaration>();
        for (InstanceReferenceDeclaration instanceReferenceDeclaration : this.K()) {
            hashSet.add(instanceReferenceDeclaration.getInstance());
        }
        return hashSet;
    }

    @Override
    public Set<InstanceDeclaration> getNextMandatoryDeclarations() {
        return this.getNextMandatoryDeclarations(Collections.EMPTY_SET);
    }

    @Override
    public Set<InstanceDeclaration> getNextMandatoryDeclarations(Set<BrowsePath> object) {
        HashSet<InstanceDeclaration> hashSet = new HashSet<InstanceDeclaration>();
        for (InstanceReferenceDeclaration instanceReferenceDeclaration : this.a((Set<BrowsePath>)object)) {
            hashSet.add(instanceReferenceDeclaration.getInstance());
        }
        return hashSet;
    }

    @Override
    public UaNode getNode() {
        return this.node;
    }

    @Override
    public NodeId getNodeId() {
        return this.node.getNodeId();
    }

    public int hashCode() {
        return this.node.getNodeId().hashCode();
    }

    public String toString() {
        return String.format("%s [ModellingRule=%s, NodeId=%s]", this.node.getDisplayName().getText(), this.getModellingRule().getNamingRule(), this.node.getNodeId());
    }

    private Set<InstanceReferenceDeclaration> K() {
        HashSet<InstanceReferenceDeclaration> hashSet = new HashSet<InstanceReferenceDeclaration>();
        for (InstanceReferenceDeclaration instanceReferenceDeclaration : this.br) {
            this.logger.debug("getHierarchicalReferences: r={}", (Object)instanceReferenceDeclaration);
            if (instanceReferenceDeclaration.getInstance().getModellingRule() == null || !instanceReferenceDeclaration.aV()) continue;
            hashSet.add(instanceReferenceDeclaration);
        }
        return hashSet;
    }

    private Set<InstanceReferenceDeclaration> a(Set<BrowsePath> set) {
        HashSet<InstanceReferenceDeclaration> hashSet = new HashSet<InstanceReferenceDeclaration>();
        for (InstanceReferenceDeclaration instanceReferenceDeclaration : this.br) {
            if (instanceReferenceDeclaration.getInstance().getModellingRule() != ModellingRule.Mandatory) {
                if (instanceReferenceDeclaration.getInstance().getModellingRule() != ModellingRule.Optional) continue;
                Set<BrowsePath> set2 = set;
                Set<BrowsePath> set3 = instanceReferenceDeclaration.getInstance().getBrowsePaths();
                set3 = new HashSet<BrowsePath>(set3);
                set3.retainAll(set2);
                if (!(!set3.isEmpty())) continue;
            }
            if (!instanceReferenceDeclaration.aV()) continue;
            hashSet.add(instanceReferenceDeclaration);
        }
        return hashSet;
    }
}

