/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.server.HistoryContinuationPoint;
import com.prosysopc.ua.server.HistoryManagerListener;
import com.prosysopc.ua.server.HistoryResult;
import com.prosysopc.ua.server.NodeManager;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.ServiceManagerBase;
import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.server.l;
import java.util.concurrent.atomic.AtomicReference;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.core.AccessLevel;
import org.opcfoundation.ua.core.AggregateConfiguration;
import org.opcfoundation.ua.core.DeleteAtTimeDetails;
import org.opcfoundation.ua.core.DeleteEventDetails;
import org.opcfoundation.ua.core.DeleteRawModifiedDetails;
import org.opcfoundation.ua.core.EventFilter;
import org.opcfoundation.ua.core.HistoryData;
import org.opcfoundation.ua.core.HistoryEvent;
import org.opcfoundation.ua.core.HistoryEventFieldList;
import org.opcfoundation.ua.core.HistoryModifiedData;
import org.opcfoundation.ua.core.HistoryReadDetails;
import org.opcfoundation.ua.core.HistoryReadValueId;
import org.opcfoundation.ua.core.HistoryUpdateDetails;
import org.opcfoundation.ua.core.HistoryUpdateResult;
import org.opcfoundation.ua.core.PerformUpdateType;
import org.opcfoundation.ua.core.ReadAtTimeDetails;
import org.opcfoundation.ua.core.ReadEventDetails;
import org.opcfoundation.ua.core.ReadProcessedDetails;
import org.opcfoundation.ua.core.ReadRawModifiedDetails;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.core.TimestampsToReturn;
import org.opcfoundation.ua.core.UpdateDataDetails;
import org.opcfoundation.ua.core.UpdateEventDetails;
import org.opcfoundation.ua.core.UpdateStructureDataDetails;
import org.opcfoundation.ua.utils.NumericRange;

public class HistoryManager
extends ServiceManagerBase {
    private static final HistoryManagerListener eK = new l();
    private final AtomicReference<HistoryManagerListener> listener = new AtomicReference<HistoryManagerListener>(eK);

    public HistoryManager(NodeManager nodeManager) {
        super(nodeManager.getServer());
        nodeManager.setHistoryManager(this);
    }

    public HistoryManagerListener getListener() {
        return this.listener.get();
    }

    public void setListener(HistoryManagerListener historyManagerListener) {
        this.listener.set(historyManagerListener);
    }

    protected Object beginHistoryRead(ServiceContext object, HistoryReadDetails object2, TimestampsToReturn timestampsToReturn, HistoryReadValueId[] timestampsToReturn2, HistoryContinuationPoint[] historyContinuationPointArray, HistoryResult[] objectArray) throws ServiceException {
        HistoryResult[] historyResultArray = objectArray;
        objectArray = historyContinuationPointArray;
        historyContinuationPointArray = timestampsToReturn2;
        timestampsToReturn2 = timestampsToReturn;
        timestampsToReturn = object2;
        object2 = object;
        object = this;
        return ((HistoryManager)object).getListener().onBeginHistoryRead((ServiceContext)object2, (HistoryReadDetails)timestampsToReturn, timestampsToReturn2, (HistoryReadValueId[])historyContinuationPointArray, (HistoryContinuationPoint[])objectArray, historyResultArray);
    }

    protected Object beginHistoryUpdate(ServiceContext object, HistoryUpdateDetails[] object2, HistoryUpdateResult[] historyUpdateResultArray, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        DiagnosticInfo[] diagnosticInfoArray2 = diagnosticInfoArray;
        diagnosticInfoArray = historyUpdateResultArray;
        historyUpdateResultArray = object2;
        object2 = object;
        object = this;
        return ((HistoryManager)object).getListener().onBeginHistoryUpdate((ServiceContext)object2, (HistoryUpdateDetails[])historyUpdateResultArray, (HistoryUpdateResult[])diagnosticInfoArray, diagnosticInfoArray2);
    }

    protected void deleteAtTimes(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, DateTime[] dateTimeArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
    }

    protected void deleteEvents(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, byte[][] byArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
    }

    protected void deleteModified(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, DateTime dateTime, DateTime dateTime2) throws StatusException {
    }

    protected void deleteRaw(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, DateTime dateTime, DateTime dateTime2) throws StatusException {
    }

    protected void endHistoryRead(ServiceContext object, Object object2, HistoryReadDetails object3, TimestampsToReturn timestampsToReturn, HistoryReadValueId[] timestampsToReturn2, HistoryContinuationPoint[] historyContinuationPointArray, HistoryResult[] objectArray) throws ServiceException {
        HistoryResult[] historyResultArray = objectArray;
        objectArray = historyContinuationPointArray;
        historyContinuationPointArray = timestampsToReturn2;
        timestampsToReturn2 = timestampsToReturn;
        timestampsToReturn = object3;
        object3 = object2;
        object2 = object;
        object = this;
        ((HistoryManager)object).getListener().onEndHistoryRead((ServiceContext)object2, object3, (HistoryReadDetails)timestampsToReturn, timestampsToReturn2, (HistoryReadValueId[])historyContinuationPointArray, (HistoryContinuationPoint[])objectArray, historyResultArray);
    }

    protected void endHistoryUpdate(ServiceContext object, Object object2, HistoryUpdateDetails[] object3, HistoryUpdateResult[] historyUpdateResultArray, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        DiagnosticInfo[] diagnosticInfoArray2 = diagnosticInfoArray;
        diagnosticInfoArray = historyUpdateResultArray;
        historyUpdateResultArray = object3;
        object3 = object2;
        object2 = object;
        object = this;
        ((HistoryManager)object).getListener().onEndHistoryUpdate((ServiceContext)object2, object3, (HistoryUpdateDetails[])historyUpdateResultArray, (HistoryUpdateResult[])diagnosticInfoArray, diagnosticInfoArray2);
    }

    protected HistoryResult historyRead(ServiceContext serviceContext, Object object, TimestampsToReturn timestampsToReturn, NodeId nodeId, NumericRange numericRange, HistoryContinuationPoint object2, HistoryReadDetails historyReadDetails, int n2) throws StatusException {
        Object object3;
        UaNode uaNode = this.getNode(nodeId);
        if (uaNode instanceof UaVariable) {
            object3 = (UaVariable)uaNode;
            this.getNodeManagerTable().getIoManager(nodeId).checkAccessLevel(serviceContext, object, nodeId, (UaVariable)object3, AccessLevel.HistoryRead);
        }
        object3 = null;
        if (object2 != null) {
            historyReadDetails = ((HistoryContinuationPoint)object2).getDetails();
            timestampsToReturn = ((HistoryContinuationPoint)object2).getTimestampsToReturn();
            object3 = ((HistoryContinuationPoint)object2).getUserContinuationPoint();
        }
        if (historyReadDetails instanceof ReadEventDetails) {
            HistoryEvent historyEvent;
            historyReadDetails = (ReadEventDetails)historyReadDetails;
            HistoryEvent historyEvent2 = historyEvent = new HistoryEvent();
            EventFilter eventFilter = historyReadDetails.getFilter();
            UnsignedInteger unsignedInteger = historyReadDetails.getNumValuesPerNode();
            DateTime dateTime = historyReadDetails.getEndTime();
            DateTime dateTime2 = historyReadDetails.getStartTime();
            Object object4 = object3;
            UaNode uaNode2 = uaNode;
            NodeId nodeId2 = nodeId;
            Object object5 = object;
            ServiceContext serviceContext2 = serviceContext;
            object2 = this;
            if ((object2 = ((HistoryManager)object2).getListener().onReadEvents(serviceContext2, object5, nodeId2, uaNode2, object4, dateTime2, dateTime, unsignedInteger, eventFilter, historyEvent2)) == null) {
                object2 = this.readEvents(serviceContext, object, object, nodeId, uaNode, object3, historyReadDetails.getStartTime(), historyReadDetails.getEndTime(), historyReadDetails.getNumValuesPerNode(), historyReadDetails.getFilter(), historyEvent);
            }
            serviceContext = historyEvent;
        } else if (historyReadDetails instanceof ReadRawModifiedDetails) {
            if ((historyReadDetails = (ReadRawModifiedDetails)historyReadDetails).getIsReadModified().booleanValue()) {
                HistoryModifiedData historyModifiedData;
                if (historyReadDetails.getReturnBounds() != null && historyReadDetails.getReturnBounds().booleanValue()) {
                    throw new StatusException(StatusCodes.Bad_InvalidArgument);
                }
                HistoryModifiedData historyModifiedData2 = historyModifiedData = new HistoryModifiedData();
                NumericRange numericRange2 = numericRange;
                UnsignedInteger unsignedInteger = historyReadDetails.getNumValuesPerNode();
                DateTime dateTime = historyReadDetails.getEndTime();
                DateTime dateTime3 = historyReadDetails.getStartTime();
                Object object6 = object3;
                UaNode uaNode3 = uaNode;
                NodeId nodeId3 = nodeId;
                TimestampsToReturn timestampsToReturn2 = timestampsToReturn;
                Object object7 = object;
                ServiceContext serviceContext3 = serviceContext;
                object2 = this;
                if ((object2 = ((HistoryManager)object2).getListener().onReadModified(serviceContext3, object7, timestampsToReturn2, nodeId3, uaNode3, object6, dateTime3, dateTime, unsignedInteger, numericRange2, historyModifiedData2)) == null) {
                    object2 = this.readModified(serviceContext, object, timestampsToReturn, nodeId, uaNode, object3, historyReadDetails.getStartTime(), historyReadDetails.getEndTime(), historyReadDetails.getNumValuesPerNode(), numericRange, historyModifiedData);
                }
                serviceContext = historyModifiedData;
            } else {
                HistoryData historyData;
                HistoryData historyData2 = historyData = new HistoryData();
                NumericRange numericRange3 = numericRange;
                Boolean bl = historyReadDetails.getReturnBounds();
                UnsignedInteger unsignedInteger = historyReadDetails.getNumValuesPerNode();
                DateTime dateTime = historyReadDetails.getEndTime();
                DateTime dateTime4 = historyReadDetails.getStartTime();
                Object object8 = object3;
                UaNode uaNode4 = uaNode;
                NodeId nodeId4 = nodeId;
                TimestampsToReturn timestampsToReturn3 = timestampsToReturn;
                Object object9 = object;
                ServiceContext serviceContext4 = serviceContext;
                object2 = this;
                if ((object2 = ((HistoryManager)object2).getListener().onReadRaw(serviceContext4, object9, timestampsToReturn3, nodeId4, uaNode4, object8, dateTime4, dateTime, unsignedInteger, bl, numericRange3, historyData2)) == null) {
                    object2 = this.readRaw(serviceContext, object, timestampsToReturn, nodeId, uaNode, object3, historyReadDetails.getStartTime(), historyReadDetails.getEndTime(), historyReadDetails.getNumValuesPerNode(), historyReadDetails.getReturnBounds(), numericRange, historyData);
                }
                serviceContext = historyData;
            }
        } else if (historyReadDetails instanceof ReadProcessedDetails) {
            NodeId nodeId5;
            if ((historyReadDetails = (ReadProcessedDetails)historyReadDetails).getStartTime().equals((Object)historyReadDetails.getEndTime())) {
                throw new StatusException("StartTime must not equal EndTime for a ReadProcessed request.", StatusCodes.Bad_InvalidArgument);
            }
            HistoryData historyData = new HistoryData();
            try {
                nodeId5 = historyReadDetails.getAggregateType()[n2];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new StatusException(StatusCodes.Bad_AggregateListMismatch);
            }
            HistoryData historyData3 = historyData;
            NumericRange numericRange4 = numericRange;
            AggregateConfiguration aggregateConfiguration = historyReadDetails.getAggregateConfiguration();
            NodeId nodeId6 = nodeId5;
            Double d2 = historyReadDetails.getProcessingInterval();
            DateTime dateTime = historyReadDetails.getEndTime();
            DateTime dateTime5 = historyReadDetails.getStartTime();
            Object object10 = object3;
            UaNode uaNode5 = uaNode;
            NodeId nodeId7 = nodeId;
            TimestampsToReturn timestampsToReturn4 = timestampsToReturn;
            Object object11 = object;
            ServiceContext serviceContext5 = serviceContext;
            object2 = this;
            object2 = ((HistoryManager)object2).getListener().onReadProcessed(serviceContext5, object11, timestampsToReturn4, nodeId7, uaNode5, object10, dateTime5, dateTime, d2, nodeId6, aggregateConfiguration, numericRange4, historyData3);
            if (object2 == null) {
                object2 = this.readProcessed(serviceContext, object, timestampsToReturn, nodeId, uaNode, object3, historyReadDetails.getStartTime(), historyReadDetails.getEndTime(), historyReadDetails.getProcessingInterval(), nodeId5, historyReadDetails.getAggregateConfiguration(), numericRange, historyData);
            }
            serviceContext = historyData;
        } else if (historyReadDetails instanceof ReadAtTimeDetails) {
            HistoryData historyData;
            historyReadDetails = (ReadAtTimeDetails)historyReadDetails;
            HistoryData historyData4 = historyData = new HistoryData();
            NumericRange numericRange5 = numericRange;
            DateTime[] dateTimeArray = historyReadDetails.getReqTimes();
            Object object12 = object3;
            UaNode uaNode6 = uaNode;
            NodeId nodeId8 = nodeId;
            TimestampsToReturn timestampsToReturn5 = timestampsToReturn;
            Object object13 = object;
            ServiceContext serviceContext6 = serviceContext;
            object2 = this;
            if ((object2 = ((HistoryManager)object2).getListener().onReadAtTimes(serviceContext6, object13, timestampsToReturn5, nodeId8, uaNode6, object12, dateTimeArray, numericRange5, historyData4)) == null) {
                object2 = this.readAtTimes(serviceContext, object, timestampsToReturn, nodeId, uaNode, object3, historyReadDetails.getReqTimes(), numericRange, historyData);
            }
            serviceContext = historyData;
        } else {
            throw new StatusException(StatusCodes.Bad_HistoryOperationInvalid);
        }
        return new HistoryResult((Structure)serviceContext, object2);
    }

    /*
     * WARNING - void declaration
     */
    protected void historyUpdate(ServiceContext serviceContext, Object object, HistoryUpdateDetails historyUpdateDetails, HistoryUpdateResult historyUpdateResult) throws StatusException {
        void var6_14;
        UaNode uaNode = this.getNode(historyUpdateDetails.getNodeId());
        Object statusCodeArray6 = null;
        DiagnosticInfo[] diagnosticInfoArray = null;
        if (historyUpdateDetails instanceof DeleteAtTimeDetails) {
            historyUpdateDetails = (DeleteAtTimeDetails)historyUpdateDetails;
            DateTime[] dateTimeArray = historyUpdateDetails.getReqTimes();
            StatusCode[] statusCodeArray = new StatusCode[dateTimeArray.length];
            DiagnosticInfo[] diagnosticInfoArray2 = diagnosticInfoArray = new DiagnosticInfo[dateTimeArray.length];
            StatusCode[] statusCodeArray2 = statusCodeArray;
            DateTime[] dateTimeArray2 = dateTimeArray;
            UaNode uaNode2 = uaNode;
            NodeId nodeId = historyUpdateDetails.getNodeId();
            Object object2 = object;
            ServiceContext serviceContext2 = serviceContext;
            HistoryManager historyManager = this;
            historyManager.getListener().onDeleteAtTimes(serviceContext2, object2, nodeId, uaNode2, dateTimeArray2, statusCodeArray2, diagnosticInfoArray2);
            this.deleteAtTimes(serviceContext, object, historyUpdateDetails.getNodeId(), uaNode, dateTimeArray, statusCodeArray, diagnosticInfoArray);
        } else if (historyUpdateDetails instanceof DeleteEventDetails) {
            historyUpdateDetails = (DeleteEventDetails)historyUpdateDetails;
            byte[][] byArray = historyUpdateDetails.getEventIds();
            StatusCode[] statusCodeArray = new StatusCode[byArray.length];
            DiagnosticInfo[] diagnosticInfoArray3 = diagnosticInfoArray = new DiagnosticInfo[byArray.length];
            StatusCode[] statusCodeArray3 = statusCodeArray;
            byte[][] byArray2 = byArray;
            UaNode uaNode3 = uaNode;
            NodeId nodeId = historyUpdateDetails.getNodeId();
            Object object3 = object;
            ServiceContext serviceContext3 = serviceContext;
            HistoryManager historyManager = this;
            historyManager.getListener().onDeleteEvents(serviceContext3, object3, nodeId, uaNode3, byArray2, statusCodeArray3, diagnosticInfoArray3);
            this.deleteEvents(serviceContext, object, historyUpdateDetails.getNodeId(), uaNode, byArray, statusCodeArray, diagnosticInfoArray);
        } else if (historyUpdateDetails instanceof DeleteRawModifiedDetails) {
            if ((historyUpdateDetails = (DeleteRawModifiedDetails)historyUpdateDetails).getIsDeleteModified().booleanValue()) {
                DateTime dateTime = historyUpdateDetails.getEndTime();
                DateTime dateTime2 = historyUpdateDetails.getStartTime();
                UaNode uaNode4 = uaNode;
                NodeId nodeId = historyUpdateDetails.getNodeId();
                Object object4 = object;
                ServiceContext serviceContext4 = serviceContext;
                HistoryManager historyManager = this;
                historyManager.getListener().onDeleteModified(serviceContext4, object4, nodeId, uaNode4, dateTime2, dateTime);
                this.deleteModified(serviceContext, object, historyUpdateDetails.getNodeId(), uaNode, historyUpdateDetails.getStartTime(), historyUpdateDetails.getEndTime());
            } else {
                DateTime dateTime = historyUpdateDetails.getEndTime();
                DateTime dateTime3 = historyUpdateDetails.getStartTime();
                UaNode uaNode5 = uaNode;
                NodeId nodeId = historyUpdateDetails.getNodeId();
                Object object5 = object;
                ServiceContext serviceContext5 = serviceContext;
                HistoryManager historyManager = this;
                historyManager.getListener().onDeleteRaw(serviceContext5, object5, nodeId, uaNode5, dateTime3, dateTime);
                this.deleteRaw(serviceContext, object, historyUpdateDetails.getNodeId(), uaNode, historyUpdateDetails.getStartTime(), historyUpdateDetails.getEndTime());
            }
        } else if (historyUpdateDetails instanceof UpdateDataDetails) {
            historyUpdateDetails = (UpdateDataDetails)historyUpdateDetails;
            DataValue[] dataValueArray = historyUpdateDetails.getUpdateValues();
            StatusCode[] statusCodeArray = new StatusCode[dataValueArray.length];
            DiagnosticInfo[] diagnosticInfoArray4 = diagnosticInfoArray = new DiagnosticInfo[dataValueArray.length];
            StatusCode[] statusCodeArray4 = statusCodeArray;
            PerformUpdateType performUpdateType = historyUpdateDetails.getPerformInsertReplace();
            DataValue[] dataValueArray2 = dataValueArray;
            UaNode uaNode6 = uaNode;
            NodeId nodeId = historyUpdateDetails.getNodeId();
            Object object6 = object;
            ServiceContext serviceContext6 = serviceContext;
            HistoryManager historyManager = this;
            historyManager.getListener().onUpdateData(serviceContext6, object6, nodeId, uaNode6, dataValueArray2, performUpdateType, statusCodeArray4, diagnosticInfoArray4);
            this.updateData(serviceContext, object, historyUpdateDetails.getNodeId(), uaNode, dataValueArray, historyUpdateDetails.getPerformInsertReplace(), statusCodeArray, diagnosticInfoArray);
        } else if (historyUpdateDetails instanceof UpdateStructureDataDetails) {
            historyUpdateDetails = (UpdateStructureDataDetails)historyUpdateDetails;
            DataValue[] dataValueArray = historyUpdateDetails.getUpdateValues();
            StatusCode[] statusCodeArray = new StatusCode[dataValueArray.length];
            DiagnosticInfo[] diagnosticInfoArray5 = diagnosticInfoArray = new DiagnosticInfo[dataValueArray.length];
            StatusCode[] statusCodeArray5 = statusCodeArray;
            PerformUpdateType performUpdateType = historyUpdateDetails.getPerformInsertReplace();
            DataValue[] dataValueArray3 = dataValueArray;
            UaNode uaNode7 = uaNode;
            NodeId nodeId = historyUpdateDetails.getNodeId();
            Object object7 = object;
            ServiceContext serviceContext7 = serviceContext;
            HistoryManager historyManager = this;
            historyManager.getListener().onUpdateStructureData(serviceContext7, object7, nodeId, uaNode7, dataValueArray3, performUpdateType, statusCodeArray5, diagnosticInfoArray5);
            this.updateStructureData(serviceContext, object, historyUpdateDetails.getNodeId(), uaNode, dataValueArray, historyUpdateDetails.getPerformInsertReplace(), statusCodeArray, diagnosticInfoArray);
        } else if (historyUpdateDetails instanceof UpdateEventDetails) {
            historyUpdateDetails = (UpdateEventDetails)historyUpdateDetails;
            for (HistoryEventFieldList historyEventFieldList : historyUpdateDetails.getEventData()) {
                Variant[] variantArray = historyEventFieldList == null ? null : historyEventFieldList.getEventFields();
                int n2 = variantArray == null ? 0 : variantArray.length;
                StatusCode[] statusCodeArray = new StatusCode[n2];
                DiagnosticInfo[] diagnosticInfoArray6 = diagnosticInfoArray = new DiagnosticInfo[n2];
                StatusCode[] statusCodeArray7 = statusCodeArray;
                PerformUpdateType performUpdateType = historyUpdateDetails.getPerformInsertReplace();
                EventFilter eventFilter = historyUpdateDetails.getFilter();
                Variant[] variantArray2 = variantArray;
                UaNode uaNode8 = uaNode;
                NodeId nodeId = historyUpdateDetails.getNodeId();
                Object object8 = object;
                ServiceContext serviceContext8 = serviceContext;
                HistoryManager historyManager = this;
                historyManager.getListener().onUpdateEvent(serviceContext8, object8, nodeId, uaNode8, variantArray2, eventFilter, performUpdateType, statusCodeArray7, diagnosticInfoArray6);
                this.updateEvent(serviceContext, object, historyUpdateDetails.getNodeId(), uaNode, variantArray, historyUpdateDetails.getFilter(), historyUpdateDetails.getPerformInsertReplace(), statusCodeArray, diagnosticInfoArray);
            }
        } else {
            throw new StatusException(StatusCodes.Bad_HistoryOperationInvalid);
        }
        historyUpdateResult.setOperationResults((StatusCode[])var6_14);
        historyUpdateResult.setDiagnosticInfos(diagnosticInfoArray);
    }

    protected Object readAtTimes(ServiceContext serviceContext, Object object, TimestampsToReturn timestampsToReturn, NodeId nodeId, UaNode uaNode, Object object2, DateTime[] dateTimeArray, NumericRange numericRange, HistoryData historyData) throws StatusException {
        return null;
    }

    protected Object readEvents(ServiceContext serviceContext, Object object, Object object2, NodeId nodeId, UaNode uaNode, Object object3, DateTime dateTime, DateTime dateTime2, UnsignedInteger unsignedInteger, EventFilter eventFilter, HistoryEvent historyEvent) throws StatusException {
        return null;
    }

    protected Object readModified(ServiceContext serviceContext, Object object, TimestampsToReturn timestampsToReturn, NodeId nodeId, UaNode uaNode, Object object2, DateTime dateTime, DateTime dateTime2, UnsignedInteger unsignedInteger, NumericRange numericRange, HistoryModifiedData historyModifiedData) throws StatusException {
        return null;
    }

    protected Object readProcessed(ServiceContext serviceContext, Object object, TimestampsToReturn timestampsToReturn, NodeId nodeId, UaNode uaNode, Object object2, DateTime dateTime, DateTime dateTime2, Double d2, NodeId nodeId2, AggregateConfiguration aggregateConfiguration, NumericRange numericRange, HistoryData historyData) throws StatusException {
        return null;
    }

    protected Object readRaw(ServiceContext serviceContext, Object object, TimestampsToReturn timestampsToReturn, NodeId nodeId, UaNode uaNode, Object object2, DateTime dateTime, DateTime dateTime2, UnsignedInteger unsignedInteger, Boolean bl, NumericRange numericRange, HistoryData historyData) throws StatusException {
        return null;
    }

    protected void releaseHistoryContinuationPoint(ServiceContext object, NodeId nodeId, byte[] byArray) throws StatusException {
        if (((Session)(object = ((ServiceContext)object).getSession())).getHistoryContinuationPoint(byArray) == null) {
            throw new StatusException(StatusCodes.Bad_ContinuationPointInvalid);
        }
    }

    @Override
    protected boolean requireUaNode() {
        return false;
    }

    protected void updateData(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, DataValue[] dataValueArray, PerformUpdateType performUpdateType, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
    }

    protected void updateEvent(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, Variant[] variantArray, EventFilter eventFilter, PerformUpdateType performUpdateType, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
    }

    protected void updateStructureData(ServiceContext serviceContext, Object object, NodeId nodeId, UaNode uaNode, DataValue[] dataValueArray, PerformUpdateType performUpdateType, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
    }
}

