/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.ContentFilterBuilder;
import com.prosysopc.ua.EventData;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.server.NodeManagerRoot;
import com.prosysopc.ua.server.NodeManagerUaNode;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.ExtensionObject;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedByte;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedLong;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.AttributeOperand;
import org.opcfoundation.ua.core.ContentFilterElementResult;
import org.opcfoundation.ua.core.ElementOperand;
import org.opcfoundation.ua.core.FilterOperand;
import org.opcfoundation.ua.core.FilterOperator;
import org.opcfoundation.ua.core.LiteralOperand;
import org.opcfoundation.ua.core.RelativePathElement;
import org.opcfoundation.ua.core.SimpleAttributeOperand;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.encoding.DecodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterOperatorDefinition {
    static Logger logger = LoggerFactory.getLogger(FilterOperatorDefinition.class);
    private static Map<Class<? extends FilterOperand>, Constructor<? extends OperandDefinition>> dM = new ConcurrentHashMap<Class<? extends FilterOperand>, Constructor<? extends OperandDefinition>>();
    private static Map<FilterOperator, Constructor<? extends FilterOperatorDefinition>> dN = new ConcurrentHashMap<FilterOperator, Constructor<? extends FilterOperatorDefinition>>();
    private final ContentFilterElementResult dO = new ContentFilterElementResult();
    private NodeManagerRoot dP;
    protected List<OperandDefinition> operandList;

    public static FilterOperatorDefinition newOperator(FilterOperator object, ExtensionObject[] extensionObjectArray, NodeManagerRoot nodeManagerRoot, FilterOperatorDefinition[] filterOperatorDefinitionArray) {
        logger.debug("newOperator: {} operandCount: {}", object, (Object)extensionObjectArray.length);
        ContentFilterBuilder.checkOperandCount((FilterOperator)object, extensionObjectArray.length);
        object = dN.get(object);
        if (object == null) {
            return null;
        }
        try {
            object = (FilterOperatorDefinition)((Constructor)object).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        ((FilterOperatorDefinition)object).parse(extensionObjectArray, filterOperatorDefinitionArray, nodeManagerRoot);
        return object;
    }

    private static void a(Class<? extends FilterOperand> clazz, Class<? extends OperandDefinition> genericDeclaration) {
        try {
            genericDeclaration = genericDeclaration.getConstructor(FilterOperand.class);
            dM.put(clazz, (Constructor<? extends OperandDefinition>)genericDeclaration);
            return;
        }
        catch (SecurityException securityException) {
            throw new RuntimeException(securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
    }

    private static void a(FilterOperator filterOperator, Class<? extends FilterOperatorDefinition> genericDeclaration) {
        try {
            genericDeclaration = genericDeclaration.getConstructor(new Class[0]);
            dN.put(filterOperator, (Constructor<? extends FilterOperatorDefinition>)genericDeclaration);
            return;
        }
        catch (SecurityException securityException) {
            throw new RuntimeException(securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
    }

    protected static boolean setTypeOfEventData(EventData eventData, NodeManagerUaNode nodeManagerUaNode) {
        UaType uaType = eventData.getEventType();
        if (uaType == null) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("eventData.getEventTypeId()={}", (Object)eventData.getEventTypeId());
                }
                uaType = nodeManagerUaNode.getType(eventData.getEventTypeId());
                logger.debug("eventDataEventType={}", (Object)uaType);
                eventData.setEventType(uaType);
            }
            catch (StatusException statusException) {
                logger.warn("eventTypeEquals: Cannot find type node of eventData (eventTypeId=" + eventData.getEventTypeId() + ")", (Throwable)statusException);
                return false;
            }
        }
        return true;
    }

    public Object evaluate(EventData eventData, Boolean bl) {
        logger.debug("FilterOperatorDefinition.evaluate: return={}", (Object)bl);
        return null;
    }

    public DiagnosticInfo getElementDiagnosticInfo() {
        return null;
    }

    public ContentFilterElementResult getElementResult() {
        return this.dO;
    }

    public final boolean parse(ExtensionObject[] extensionObjectArray, FilterOperatorDefinition[] filterOperatorDefinitionArray, NodeManagerRoot nodeManagerRoot) {
        logger.debug("{} parse", this.getClass());
        this.operandList = new ArrayList<OperandDefinition>(extensionObjectArray.length);
        this.dO.setStatusCode(StatusCode.GOOD);
        StatusCode[] statusCodeArray = new StatusCode[extensionObjectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[extensionObjectArray.length];
        for (int i2 = 0; i2 < extensionObjectArray.length; ++i2) {
            Object object;
            try {
                Object object2 = (FilterOperand)extensionObjectArray[i2].decode(nodeManagerRoot.getNodeManagerTable().getEncoderContext());
                try {
                    object = dM.get(object2.getClass());
                    if (object == null) {
                        statusCodeArray[i2] = new StatusCode(StatusCodes.Bad_FilterOperandInvalid);
                    } else {
                        object2 = (OperandDefinition)((Constructor)object).newInstance(object2);
                        ((OperandDefinition)object2).applyOperators(filterOperatorDefinitionArray);
                        try {
                            ((OperandDefinition)object2).applyNodeManager(nodeManagerRoot);
                            this.operandList.add((OperandDefinition)object2);
                            this.validateOperand((OperandDefinition)object2, i2);
                            statusCodeArray[i2] = StatusCode.GOOD;
                        }
                        catch (StatusException statusException) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("FilterOperand {} invalid: {} diagnostics: {}", new Object[]{i2, statusException.getStatusCode(), statusException.getDiagnosticInfo()});
                            }
                            statusCodeArray[i2] = statusException.getStatusCode();
                            diagnosticInfoArray[i2] = statusException.getDiagnosticInfo();
                        }
                    }
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            catch (DecodingException decodingException) {
                logger.warn("FilterOperatorDefinition: ", (Throwable)decodingException);
                object = new ServiceException((ServiceResultException)((Object)decodingException));
                statusCodeArray[i2] = new StatusCode(StatusCodes.Bad_FilterOperandInvalid);
                diagnosticInfoArray[i2] = ((ServiceException)object).getDiagnosticInfo();
                if (this.dO.getStatusCode().isGood()) {
                    this.dO.setStatusCode(new StatusCode(StatusCodes.Bad_FilterOperatorInvalid));
                }
            }
            catch (ClassCastException classCastException) {
                logger.warn("FilterOperatorDefinition: ", (Throwable)classCastException);
                statusCodeArray[i2] = new StatusCode(StatusCodes.Bad_FilterOperandInvalid);
                diagnosticInfoArray[i2] = null;
            }
            if (!statusCodeArray[i2].isBad() || !this.dO.getStatusCode().isGood()) continue;
            this.dO.setStatusCode(new StatusCode(StatusCodes.Bad_FilterOperatorInvalid));
        }
        this.dO.setOperandStatusCodes(statusCodeArray);
        this.dO.setOperandDiagnosticInfos(diagnosticInfoArray);
        try {
            this.applyNodeManager(nodeManagerRoot);
        }
        catch (StatusException statusException) {
            this.dO.setStatusCode(new StatusCode(StatusCodes.Bad_FilterOperatorInvalid));
        }
        return this.dO.getStatusCode().isGood();
    }

    protected void applyNodeManager(NodeManagerRoot nodeManagerRoot) throws StatusException {
        this.dP = nodeManagerRoot;
    }

    protected Boolean asBoolean(Variant variant) {
        if (this.isNull(variant)) {
            return null;
        }
        try {
            return variant.booleanValue();
        }
        catch (ClassCastException classCastException) {
            logger.warn("Cannot convert variant {} to Boolean: using null", (Object)variant);
            return null;
        }
    }

    protected Boolean eventTypeEquals(UaType uaType, NodeId nodeId, EventData eventData) {
        try {
            return this.getNodeManager().isOfType(eventData.getEventTypeId(), eventData.getEventType(), nodeId, uaType);
        }
        catch (StatusException statusException) {
            logger.debug("EventTypeId not referring to a valid node", (Throwable)statusException);
            return false;
        }
    }

    protected NodeManagerRoot getNodeManager() {
        return this.dP;
    }

    protected boolean isNull(Variant variant) {
        return variant == null || variant.isEmpty();
    }

    protected void validateOperand(OperandDefinition operandDefinition, int n2) throws StatusException {
    }

    static {
        FilterOperatorDefinition.a(LiteralOperand.class, OperandDefinition.LiteralOperandDefinition.class);
        FilterOperatorDefinition.a(ElementOperand.class, OperandDefinition.ElementOperandDefinition.class);
        FilterOperatorDefinition.a(SimpleAttributeOperand.class, OperandDefinition.SimpleAttributeOperandDefinition.class);
        FilterOperatorDefinition.a(AttributeOperand.class, OperandDefinition.AttributeOperandDefinition.class);
        FilterOperatorDefinition.a(FilterOperator.OfType, n.class);
        FilterOperatorDefinition.a(FilterOperator.Equals, e.class);
        FilterOperatorDefinition.a(FilterOperator.IsNull, i.class);
        FilterOperatorDefinition.a(FilterOperator.GreaterThan, h.class);
        FilterOperatorDefinition.a(FilterOperator.GreaterThanOrEqual, j.class);
        FilterOperatorDefinition.a(FilterOperator.LessThan, g.class);
        FilterOperatorDefinition.a(FilterOperator.LessThanOrEqual, a.class);
        FilterOperatorDefinition.a(FilterOperator.Like, m.class);
        FilterOperatorDefinition.a(FilterOperator.Not, f.class);
        FilterOperatorDefinition.a(FilterOperator.Between, p.class);
        FilterOperatorDefinition.a(FilterOperator.InList, k.class);
        FilterOperatorDefinition.a(FilterOperator.And, l.class);
        FilterOperatorDefinition.a(FilterOperator.Or, d.class);
        FilterOperatorDefinition.a(FilterOperator.Cast, o.class);
        FilterOperatorDefinition.a(FilterOperator.BitwiseAnd, q.class);
        FilterOperatorDefinition.a(FilterOperator.BitwiseOr, r.class);
    }

    static class d
    extends c {
        @Override
        protected final Object a(boolean bl, boolean bl2) {
            return bl || bl2;
        }

        @Override
        protected final Boolean aB() {
            return true;
        }
    }

    static class OperandDefinition {
        protected final FilterOperand operand;

        public OperandDefinition(FilterOperand filterOperand) {
            this.operand = filterOperand;
        }

        public void applyOperators(FilterOperatorDefinition[] filterOperatorDefinitionArray) {
        }

        public FilterOperatorDefinition getOperator() {
            return null;
        }

        public Variant getValue(EventData eventData, Boolean bl) {
            return null;
        }

        protected void applyNodeManager(NodeManagerUaNode nodeManagerUaNode) throws StatusException {
        }

        public static class SimpleAttributeOperandDefinition
        extends AbstractAttributeOperandDefinition {
            private SimpleAttributeOperand hx;

            public SimpleAttributeOperandDefinition(FilterOperand filterOperand) {
                super(filterOperand);
                this.hx = (SimpleAttributeOperand)filterOperand;
            }

            public SimpleAttributeOperand getOperand() {
                return this.hx;
            }

            @Override
            protected QualifiedName[] getBrowsePath() {
                return this.hx.getBrowsePath();
            }

            @Override
            protected NodeId getTypeDefinitionId() {
                return this.hx.getTypeDefinitionId();
            }
        }

        public static class LiteralOperandDefinition
        extends OperandDefinition {
            private final Variant value;

            public LiteralOperandDefinition(FilterOperand filterOperand) {
                super(filterOperand);
                this.value = ((LiteralOperand)filterOperand).getValue();
            }

            @Override
            public Variant getValue(EventData eventData, Boolean bl) {
                return this.value;
            }
        }

        public static class ElementOperandDefinition
        extends OperandDefinition {
            private final int index;
            private FilterOperatorDefinition gs;

            public ElementOperandDefinition(FilterOperand filterOperand) {
                super(filterOperand);
                this.index = ((ElementOperand)filterOperand).getIndex().intValue();
            }

            @Override
            public void applyOperators(FilterOperatorDefinition[] filterOperatorDefinitionArray) {
                super.applyOperators(filterOperatorDefinitionArray);
                this.gs = filterOperatorDefinitionArray[this.index];
            }

            public long getIndex() {
                return this.index;
            }

            @Override
            public FilterOperatorDefinition getOperator() {
                return this.gs;
            }

            @Override
            public Variant getValue(EventData object, Boolean bl) {
                object = this.getOperator().evaluate((EventData)object, bl);
                if (object instanceof Variant) {
                    return (Variant)object;
                }
                return new Variant(object);
            }
        }

        public static class AttributeOperandDefinition
        extends AbstractAttributeOperandDefinition {
            private AttributeOperand c;

            public AttributeOperandDefinition(FilterOperand filterOperand) {
                super(filterOperand);
                this.c = (AttributeOperand)filterOperand;
            }

            public AttributeOperand getOperand() {
                return this.c;
            }

            @Override
            protected QualifiedName[] getBrowsePath() {
                RelativePathElement[] relativePathElementArray = this.c.getBrowsePath();
                ArrayList<QualifiedName> arrayList = new ArrayList<QualifiedName>();
                for (RelativePathElement relativePathElement : relativePathElementArray.getElements()) {
                    arrayList.add(relativePathElement.getTargetName());
                }
                return arrayList.toArray(new QualifiedName[arrayList.size()]);
            }

            @Override
            protected NodeId getTypeDefinitionId() {
                return this.c.getNodeId();
            }
        }

        public static abstract class AbstractAttributeOperandDefinition
        extends OperandDefinition {
            private UaType b;
            private NodeManagerUaNode nodeManager;

            public AbstractAttributeOperandDefinition(FilterOperand filterOperand) {
                super(filterOperand);
            }

            public UaType getEventType() {
                return this.b;
            }

            @Override
            public Variant getValue(EventData eventData, Boolean bl) {
                logger.debug("getValue: eventType={}", (Object)this.b);
                if (this.b != null) {
                    FilterOperatorDefinition.setTypeOfEventData(eventData, this.nodeManager);
                    logger.debug("getValue: eventData.getEventType()={}", (Object)eventData.getEventType());
                    if (!this.eventTypeEquals(this.b, this.getTypeDefinitionId(), eventData).booleanValue()) {
                        return null;
                    }
                }
                return eventData.getFieldValue(this.getBrowsePath());
            }

            public void setEventType(UaType uaType) {
                this.b = uaType;
            }

            @Override
            protected void applyNodeManager(NodeManagerUaNode nodeManagerUaNode) throws StatusException {
                logger.debug("SimpleAttributeOperandDefinition.applyNodeManager: {}", (Object)nodeManagerUaNode);
                this.nodeManager = nodeManagerUaNode;
                super.applyNodeManager(nodeManagerUaNode);
                logger.debug("getTypeDefinitionId()={}", (Object)this.getTypeDefinitionId());
                if (!NodeId.isNull((NodeId)this.getTypeDefinitionId())) {
                    this.b = nodeManagerUaNode != null ? nodeManagerUaNode.getType(this.getTypeDefinitionId()) : null;
                }
            }

            protected Boolean eventTypeEquals(UaType uaType, NodeId nodeId, EventData eventData) {
                try {
                    return this.nodeManager.isOfType(eventData.getEventTypeId(), eventData.getEventType(), nodeId, uaType);
                }
                catch (StatusException statusException) {
                    logger.debug("EventTypeId not referring to a valid node", (Throwable)statusException);
                    return false;
                }
            }

            protected abstract QualifiedName[] getBrowsePath();

            protected abstract NodeId getTypeDefinitionId();
        }
    }

    static class n
    extends FilterOperatorDefinition {
        private UaType it;
        private NodeId iu;

        @Override
        public Object evaluate(EventData object, Boolean bl) {
            logger.debug("OfType evaluate: filteredEventTypeId={}", (Object)this.iu);
            if (!NodeId.isNull((NodeId)this.iu)) {
                logger.debug("OfType evaluate: filteredEventType={}", (Object)this.it);
                if (this.it != null) {
                    n.setTypeOfEventData((EventData)object, this.getNodeManager());
                }
                object = this.eventTypeEquals(this.it, this.iu, (EventData)object);
                logger.debug("OfType evaluate: return={}", object);
                return object;
            }
            if (bl.booleanValue()) {
                return null;
            }
            return false;
        }

        @Override
        protected void applyNodeManager(NodeManagerRoot nodeManagerRoot) throws StatusException {
            logger.debug("OfTypeOperatorDefinition.applyNodeManager");
            super.applyNodeManager(nodeManagerRoot);
            OperandDefinition operandDefinition = (OperandDefinition)this.operandList.get(0);
            operandDefinition = operandDefinition.getValue(null, null);
            this.iu = operandDefinition == null ? NodeId.NULL : (NodeId)operandDefinition.asClass(NodeId.class, NodeId.NULL);
            try {
                if (NodeId.isNull((NodeId)this.iu)) {
                    throw new StatusException(StatusCodes.Bad_NodeIdInvalid);
                }
                this.it = nodeManagerRoot != null ? nodeManagerRoot.getType(this.iu) : null;
                logger.debug("OfTypeOperatorDefinition.applyNodeManager: filteredEventType={}", (Object)this.it);
                return;
            }
            catch (ClassCastException classCastException) {
                nodeManagerRoot = new StatusCode(StatusCodes.Bad_FilterOperandInvalid);
                this.getElementResult().getOperandStatusCodes()[0] = nodeManagerRoot;
                throw new StatusException("Node is not a Type", (StatusCode)nodeManagerRoot);
            }
            catch (StatusException statusException) {
                this.getElementResult().getOperandStatusCodes()[0] = new StatusCode(StatusCodes.Bad_NodeIdUnknown);
                throw statusException;
            }
        }
    }

    static class f
    extends FilterOperatorDefinition {
        @Override
        public Object evaluate(EventData object, Boolean bl) {
            OperandDefinition operandDefinition = (OperandDefinition)this.operandList.get(0);
            object = operandDefinition.getValue((EventData)object, bl);
            if ((object = this.asBoolean((Variant)object)) == null) {
                return null;
            }
            return !((Boolean)object).booleanValue();
        }
    }

    static class m
    extends s {
        private String hs = null;

        private static String f(String string) {
            string = string.replace("*", "[*]").replace(".", "[.]");
            string = string.replace("%", ".*").replace("_", ".");
            string = string.replace("\\.*", "%").replace("\\.", "_");
            return string;
        }

        private String g(String string) {
            int n2;
            int n3;
            Object object = new ArrayList<String>();
            int n4 = 0;
            while (n4 < string.length() && (n3 = string.indexOf(91, n4)) >= 0 && (n2 = string.indexOf(93, n3)) >= 0) {
                object.add(m.f(string.substring(n4, n3)));
                n4 = n2 + 1;
                object.add(string.substring(n3, n4));
            }
            object.add(m.f(string.substring(n4)));
            StringBuilder stringBuilder = new StringBuilder();
            if (!string.startsWith(".*")) {
                stringBuilder.append("^");
            }
            Object object2 = object.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                stringBuilder.append((String)object);
            }
            if (!string.endsWith(".*")) {
                stringBuilder.append("$");
            }
            object2 = stringBuilder.toString();
            return object2;
        }

        @Override
        protected final Object a(Variant object, Variant object2) {
            object = object.getValue().toString();
            object2 = this.hs != null ? this.hs : this.g(object2.getValue().toString());
            logger.debug("regexp={}", object2);
            return ((String)object).matches((String)object2);
        }

        @Override
        protected void validateOperand(OperandDefinition operandDefinition, int n2) throws StatusException {
            super.validateOperand(operandDefinition, n2);
            if (n2 == 1 && operandDefinition instanceof OperandDefinition.LiteralOperandDefinition) {
                try {
                    this.hs = this.g(operandDefinition.getValue(null, true).getValue().toString());
                    this.evaluate(null, true);
                    return;
                }
                catch (Exception exception) {
                    throw new StatusException(StatusCodes.Bad_FilterOperandInvalid, (Throwable)exception);
                }
            }
        }
    }

    static class a
    extends s {
        @Override
        protected final Object a(Variant variant, Variant variant2) {
            return variant.compareTo(variant2) <= 0;
        }
    }

    static class g
    extends s {
        @Override
        protected final Object a(Variant variant, Variant variant2) {
            return variant.compareTo(variant2) < 0;
        }
    }

    static class i
    extends FilterOperatorDefinition {
        @Override
        public Object evaluate(EventData eventData, Boolean bl) {
            OperandDefinition operandDefinition = (OperandDefinition)this.operandList.get(0);
            eventData = operandDefinition.getValue(eventData, bl);
            logger.debug("value={}", (Object)eventData);
            boolean bl2 = this.isNull((Variant)eventData);
            if (bl2 && bl.booleanValue()) {
                return null;
            }
            return bl2;
        }
    }

    static class k
    extends FilterOperatorDefinition {
        @Override
        public Object evaluate(EventData eventData, Boolean bl) {
            if (logger.isDebugEnabled()) {
                logger.debug("evaluate: operandList.count={}", (Object)this.operandList.size());
            }
            OperandDefinition operandDefinition = (OperandDefinition)this.operandList.get(0);
            Variant variant = operandDefinition.getValue(eventData, bl);
            logger.debug("evaluate: value1={}", (Object)variant);
            if (variant == null) {
                return null;
            }
            for (int i2 = 1; i2 < this.operandList.size(); ++i2) {
                OperandDefinition operandDefinition2 = (OperandDefinition)this.operandList.get(i2);
                Variant variant2 = operandDefinition2.getValue(eventData, bl);
                logger.debug("evaluate: value2={}", (Object)variant2);
                if (this.isNull(variant2)) continue;
                try {
                    if (!variant.valueEquals(variant2)) continue;
                    return true;
                }
                catch (RuntimeException runtimeException) {
                    logger.warn("Cannot compare filtered values {} vs. {}", (Object)operandDefinition, (Object)operandDefinition2);
                }
            }
            return false;
        }
    }

    static class j
    extends s {
        @Override
        protected final Object a(Variant variant, Variant variant2) {
            return variant.compareTo(variant2) >= 0;
        }
    }

    static class h
    extends s {
        @Override
        protected final Object a(Variant variant, Variant variant2) {
            return variant.compareTo(variant2) > 0;
        }
    }

    static class e
    extends s {
        @Override
        protected final Object a(Variant variant, Variant variant2) {
            return variant.valueEquals(variant2);
        }
    }

    static abstract class s
    extends FilterOperatorDefinition {
        private static final Map<Class<?>, Integer> km = new HashMap();
        static Logger logger = LoggerFactory.getLogger(s.class);

        s() {
        }

        private static int e(Class<?> clazz) throws IllegalArgumentException {
            Integer n2 = km.get(clazz);
            logger.debug("classPrecedenceIndex: clazz={}->{}", clazz, (Object)n2);
            if (n2 == null) {
                throw new IllegalArgumentException("Class not found from precedence table: " + clazz);
            }
            return n2;
        }

        private static boolean b(Class<?> clazz, Class<?> clazz2) {
            try {
                return s.e(clazz) < s.e(clazz2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        @Override
        public Object evaluate(EventData eventData, Boolean bl) {
            if (logger.isDebugEnabled()) {
                logger.debug("evaluate: operandList.count={}", (Object)this.operandList.size());
            }
            OperandDefinition operandDefinition = (OperandDefinition)this.operandList.get(0);
            OperandDefinition operandDefinition2 = (OperandDefinition)this.operandList.get(1);
            Variant variant = operandDefinition.getValue(eventData, bl);
            Variant variant2 = operandDefinition2.getValue(eventData, bl);
            logger.debug("evaluate: value1={}", (Object)variant);
            logger.debug("evaluate: value2={}", (Object)variant2);
            if (!this.isNull(variant) && !this.isNull(variant2)) {
                try {
                    variant = this.b(variant, variant2);
                    variant2 = this.b(variant2, variant);
                    logger.debug("evaluate (convertImplicit): value1={}", (Object)variant);
                    logger.debug("evaluate (convertImplicit): value2={}", (Object)variant2);
                    return this.a(variant, variant2);
                }
                catch (ServiceResultException serviceResultException) {
                    logger.warn(String.format("Cannot compare filtered values %s vs. %s: ", operandDefinition, operandDefinition2), (Throwable)serviceResultException);
                    return null;
                }
            }
            return super.evaluate(eventData, bl);
        }

        private Variant b(Variant variant, Variant variant2) throws ServiceResultException {
            if (variant.isEmpty() || variant2.isEmpty()) {
                return variant;
            }
            Class clazz = variant.getCompositeClass();
            Class<?> clazz2 = variant2.getCompositeClass();
            if (variant.isArray() && !variant2.isArray() || s.b(clazz2, clazz)) {
                if (variant2.isArray()) {
                    clazz2 = Array.newInstance(clazz2, 0).getClass();
                }
                return this.getNodeManager().getDataTypeConverter().convert(variant, clazz2);
            }
            return variant;
        }

        protected abstract Object a(Variant var1, Variant var2);

        static {
            km.put(Double.class, 1);
            km.put(Float.class, 2);
            km.put(Long.class, 3);
            km.put(UnsignedLong.class, 4);
            km.put(Integer.class, 5);
            km.put(UnsignedInteger.class, 6);
            km.put(StatusCode.class, 7);
            km.put(Short.class, 8);
            km.put(UnsignedShort.class, 9);
            km.put(Byte.class, 10);
            km.put(UnsignedByte.class, 11);
            km.put(Boolean.class, 12);
            km.put(UUID.class, 13);
            km.put(String.class, 14);
            km.put(ExpandedNodeId.class, 15);
            km.put(NodeId.class, 16);
            km.put(LocalizedText.class, 17);
            km.put(QualifiedName.class, 18);
        }
    }

    static class o
    extends FilterOperatorDefinition {
        @Override
        public Object evaluate(EventData eventData, Boolean bl) {
            if (logger.isDebugEnabled()) {
                logger.debug("Cast evaluate: operandList.count={}", (Object)this.operandList.size());
            }
            OperandDefinition operandDefinition = (OperandDefinition)this.operandList.get(0);
            OperandDefinition operandDefinition2 = (OperandDefinition)this.operandList.get(1);
            operandDefinition = operandDefinition.getValue(eventData, bl);
            Variant variant = operandDefinition2.getValue(eventData, bl);
            logger.debug("Cast evaluate: value1={}", (Object)operandDefinition);
            logger.debug("Cast evaluate: value2={}", (Object)variant);
            if (!this.isNull((Variant)operandDefinition) && !this.isNull(variant)) {
                eventData = (NodeId)variant.asClass(NodeId.class, null);
                if (eventData == null) {
                    logger.warn("Cannot find type to cast: {}", (Object)operandDefinition2);
                    return null;
                }
                try {
                    eventData = this.getNodeManager().getDataTypeConverter().convert((Variant)operandDefinition, (NodeId)eventData);
                    logger.debug("result={}", (Object)eventData);
                    return eventData;
                }
                catch (ServiceResultException serviceResultException) {
                    logger.warn(String.format("Cast of value %s to type %s failed:", operandDefinition, variant), (Throwable)serviceResultException);
                    return null;
                }
            }
            return super.evaluate(eventData, bl);
        }
    }

    static abstract class c
    extends FilterOperatorDefinition {
        c() {
        }

        @Override
        public Object evaluate(EventData object, Boolean bl) {
            if (logger.isDebugEnabled()) {
                logger.debug("evaluate: operandList.count={}", (Object)this.operandList.size());
            }
            Object object2 = (OperandDefinition)this.operandList.get(0);
            Object object3 = (OperandDefinition)this.operandList.get(1);
            object2 = ((OperandDefinition)object2).getValue((EventData)object, bl);
            object3 = ((OperandDefinition)object3).getValue((EventData)object, bl);
            logger.debug("BooleanOperatorDefinition.evaluate: value1={}", object2);
            logger.debug("BooleanOperatorDefinition.evaluate: value2={}", object3);
            object2 = this.asBoolean((Variant)object2);
            object3 = this.asBoolean((Variant)object3);
            object = object2 == null && object3 == null ? super.evaluate((EventData)object, bl) : (object2 == null ? (bl.booleanValue() ? object3 : (object3 == this.aB() ? this.aB() : super.evaluate((EventData)object, bl))) : (object3 == null ? (bl.booleanValue() ? object2 : (object2 == this.aB() ? this.aB() : super.evaluate((EventData)object, bl))) : this.a((Boolean)object2, (Boolean)object3)));
            logger.debug("BooleanOperatorDefinition.evaluate: result={}", object);
            return object;
        }

        protected abstract Object a(boolean var1, boolean var2);

        protected abstract Boolean aB();
    }

    static class r
    extends b {
        @Override
        protected final long a(long l2, long l3) {
            return l2 | l3;
        }
    }

    static abstract class b
    extends FilterOperatorDefinition {
        @Override
        public Object evaluate(EventData eventData, Boolean bl) {
            if (logger.isDebugEnabled()) {
                logger.debug("evaluate: operandList.count={}", (Object)this.operandList.size());
            }
            OperandDefinition operandDefinition = (OperandDefinition)this.operandList.get(0);
            OperandDefinition operandDefinition2 = (OperandDefinition)this.operandList.get(1);
            Variant variant = operandDefinition.getValue(eventData, bl);
            Variant variant2 = operandDefinition2.getValue(eventData, bl);
            logger.debug("evaluate: value1={}", (Object)variant);
            logger.debug("evaluate: value2={}", (Object)variant2);
            if (!this.isNull(variant) && !this.isNull(variant2)) {
                try {
                    long l2 = variant.longValue();
                    long l3 = variant2.longValue();
                    long l4 = this.a(l2, l3);
                    logger.debug("result={}", (Object)l4);
                    return l4;
                }
                catch (ClassCastException classCastException) {
                    logger.warn("Cannot compare filtered values {} vs. {}", (Object)operandDefinition, (Object)operandDefinition2);
                }
            }
            return super.evaluate(eventData, bl);
        }

        protected abstract long a(long var1, long var3);
    }

    static class q
    extends b {
        @Override
        protected final long a(long l2, long l3) {
            return l2 & l3;
        }
    }

    static class p
    extends FilterOperatorDefinition {
        @Override
        public Object evaluate(EventData eventData, Boolean bl) {
            if (logger.isDebugEnabled()) {
                logger.debug("evaluate: operandList.count={}", (Object)this.operandList.size());
            }
            OperandDefinition operandDefinition = (OperandDefinition)this.operandList.get(0);
            OperandDefinition operandDefinition2 = (OperandDefinition)this.operandList.get(1);
            OperandDefinition operandDefinition3 = (OperandDefinition)this.operandList.get(2);
            Variant variant = operandDefinition.getValue(eventData, bl);
            Variant variant2 = operandDefinition2.getValue(eventData, bl);
            operandDefinition3 = operandDefinition3.getValue(eventData, bl);
            logger.debug("evaluate: value1={}", (Object)variant);
            logger.debug("evaluate: value2={}", (Object)variant2);
            logger.debug("evaluate: value3={}", (Object)operandDefinition3);
            if (!this.isNull(variant) && !this.isNull(variant2)) {
                try {
                    return variant.compareTo(variant2) >= 0 && variant.compareTo((Variant)operandDefinition3) <= 0;
                }
                catch (RuntimeException runtimeException) {
                    logger.warn("Cannot compare filtered values {} vs. {}", (Object)operandDefinition, (Object)operandDefinition2);
                }
            }
            return super.evaluate(eventData, bl);
        }
    }

    static class l
    extends c {
        @Override
        protected final Object a(boolean bl, boolean bl2) {
            return bl && bl2;
        }

        @Override
        protected final Boolean aB() {
            return false;
        }
    }
}

