/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaNodeFactoryException;
import com.prosysopc.ua.nodes.UaReferenceType;
import com.prosysopc.ua.server.NodeManager;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.UaServer;
import com.prosysopc.ua.server.nodes.BaseNode;
import com.prosysopc.ua.server.nodes.FileFolderType;
import com.prosysopc.ua.types.opcua.FolderType;
import com.prosysopc.ua.types.opcua.server.FileTypeNode;
import java.io.File;
import java.util.EnumSet;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.core.AccessLevel;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.NodeAttributes;
import org.opcfoundation.ua.core.NodeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileNodeManager
extends NodeManagerUaNode {
    private static Logger logger = LoggerFactory.getLogger(FileNodeManager.class);
    private boolean dc = false;
    private final List<FileFolderType> dd = new CopyOnWriteArrayList<FileFolderType>();
    private long de = 1000L;
    private TimerTask df;
    private Timer dg;
    private final FolderType dh;

    public FileNodeManager(UaServer uaServer, String string, String string2) {
        super(uaServer, string);
        this.dh = string2 != null && !string2.isEmpty() ? this.createInstance(FolderType.class, string2, new NodeId(this.getNamespaceIndex(), 1)) : null;
        this.getNodeFactory().registerTypeDefinition(Identifiers.FolderType, FileFolderType.class);
    }

    public FileFolderType addFolder(File file) throws StatusException {
        logger.debug("addFolder: dir={}", (Object)file);
        FileFolderType fileFolderType = new FileFolderType((NodeManagerUaNode)this, this.nodeIdForFile(file), new QualifiedName(file.getName()), new LocalizedText(file.getName()));
        fileFolderType.setFile(file);
        this.addNode(fileFolderType);
        this.dd.add(fileFolderType);
        if (this.dh != null) {
            this.dh.addReference(fileFolderType, Identifiers.Organizes, false);
        }
        try {
            fileFolderType.refresh();
        }
        catch (Exception exception) {
            logger.error("Could not refresh folder " + file, (Throwable)exception);
        }
        this.startMonitoring();
        return fileFolderType;
    }

    public FileFolderType addFolder(String string) throws StatusException {
        return this.addFolder(new File(string));
    }

    @Override
    public UaNode addNode(UaNode uaNode) throws StatusException {
        uaNode = super.addNode(uaNode);
        if (this.dc && uaNode instanceof FileTypeNode) {
            BaseNode.setAccessLevelRecursively(uaNode, AccessLevel.READWRITE, Identifiers.HasComponent, Identifiers.HasProperty);
            ((FileTypeNode)uaNode).setWritable(Boolean.TRUE);
        }
        if (uaNode instanceof FileTypeNode) {
            EnumSet<AccessLevel> enumSet = ((FileTypeNode)uaNode).getSizeNode().getAccessLevel();
            enumSet = EnumSet.copyOf(enumSet);
            enumSet.add(AccessLevel.SemanticChange);
            ((FileTypeNode)uaNode).getSizeNode().setAccessLevel(enumSet);
        }
        return uaNode;
    }

    public QualifiedName browseNameForFile(File file) {
        return FileFolderType.browseNameForFile((NodeManager)this, file);
    }

    public QualifiedName browseNameForFile(String string) {
        return FileFolderType.browseNameForFile((NodeManager)this, string);
    }

    public long getMonitoringInterval() {
        return this.de;
    }

    public FolderType getRootFolder() {
        return this.dh;
    }

    public boolean isAllowWrite() {
        return this.dc;
    }

    public NodeId nodeIdForFile(File file) {
        return FileFolderType.nodeIdForFile(this, file);
    }

    public void refresh() {
        logger.debug("FileNodeManager.refresh");
        for (FileFolderType fileFolderType : this.dd) {
            try {
                fileFolderType.refresh();
            }
            catch (Exception exception) {
                logger.error("Could not refresh folder " + fileFolderType.getFile(), (Throwable)exception);
            }
        }
    }

    public void setAllowWrite(boolean bl) {
        this.dc = bl;
    }

    public void setMonitoringInterval(long l2) {
        this.de = l2;
        this.startMonitoring();
    }

    public void setMonitoringInterval(long l2, TimeUnit timeUnit) {
        this.setMonitoringInterval(timeUnit.toMillis(l2));
    }

    public void startMonitoring() {
        if (this.isStarted() && this.dg == null && this.de != 0L) {
            logger.debug("startMonitor");
            this.df = new TimerTask(this){
                private /* synthetic */ FileNodeManager e;
                {
                    this.e = fileNodeManager;
                }

                @Override
                public final void run() {
                    this.e.refresh();
                }
            };
            this.dg = new Timer();
            this.dg.scheduleAtFixedRate(this.df, 0L, this.de);
        }
    }

    public void stopMonitoring() {
        if (this.dg != null) {
            this.dg.cancel();
            this.dg = null;
            this.df = null;
        }
    }

    @Override
    protected void close() {
        this.stopMonitoring();
        super.close();
    }

    @Override
    protected UaNode createNodeForAddNode(NodeId nodeId, QualifiedName qualifiedName, NodeClass nodeClass, ExpandedNodeId expandedNodeId, LocalizedText localizedText) {
        try {
            return this.createNodeBuilder(this.getNamespaceTable().toNodeId(expandedNodeId)).setNodeId(nodeId).setBrowseName(qualifiedName).setDisplayName(localizedText).build();
        }
        catch (Exception exception) {
            logger.error("Could not create node with node builder", (Throwable)exception);
            return super.createNodeForAddNode(nodeId, qualifiedName, nodeClass, expandedNodeId, localizedText);
        }
    }

    @Override
    protected void fireAddNode(ServiceContext object, NodeId object2, UaNode object3, NodeId nodeId, UaNode uaNode, NodeClass nodeClass, QualifiedName qualifiedName, NodeAttributes nodeAttributes, UaReferenceType uaReferenceType, ExpandedNodeId expandedNodeId, UaNode uaNode2) throws StatusException {
        super.fireAddNode((ServiceContext)object, (NodeId)object2, (UaNode)object3, nodeId, uaNode, nodeClass, qualifiedName, nodeAttributes, uaReferenceType, expandedNodeId, uaNode2);
        if (uaNode instanceof FileTypeNode && object3 instanceof FileFolderType) {
            object = (FileTypeNode)uaNode;
            object2 = (FileFolderType)object3;
            ((FileFolderType)object2).addFile((FileTypeNode)object, true);
        }
        if (uaNode instanceof FileFolderType && object3 instanceof FileFolderType) {
            object = (FileFolderType)object3;
            object2 = (FileFolderType)uaNode;
            object3 = new File(((FileFolderType)object).getFile(), ((BaseNode)object2).getBrowseName().getName());
            ((File)object3).mkdirs();
            ((FileFolderType)object2).setFile((File)object3);
            ((FileFolderType)object).addFolder((FileFolderType)object2);
        }
    }

    @Override
    protected void start() throws StatusException, UaNodeFactoryException {
        super.start();
        this.startMonitoring();
    }
}

