/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.server.NodeManagerTable;
import com.prosysopc.ua.server.nodes.UaExternalNode;
import com.prosysopc.ua.server.nodes.UaExternalNodeImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.core.StatusCodes;
import org.slf4j.LoggerFactory;

public class ExternalNodeManager {
    private final NodeManagerTable nodeManagerTable;
    private final HashMap<Integer, HashMap<NodeId, UaExternalNode>> ka = new HashMap();

    protected ExternalNodeManager(NodeManagerTable nodeManagerTable) {
        this.nodeManagerTable = nodeManagerTable;
    }

    public UaExternalNode getNode(NodeId nodeId) throws StatusException {
        UaExternalNode uaExternalNode;
        if (NodeId.isNull((NodeId)nodeId)) {
            throw new StatusException(StatusCodes.Bad_NodeIdInvalid);
        }
        int n2 = nodeId.getNamespaceIndex();
        HashMap<Object, UaExternalNode> hashMap = this.ka.get(n2);
        if (hashMap == null) {
            hashMap = new HashMap();
            this.ka.put(n2, hashMap);
        }
        if ((uaExternalNode = hashMap.get(nodeId)) == null) {
            uaExternalNode = new UaExternalNodeImpl(this.nodeManagerTable.getNodeManagerRoot(), nodeId);
            hashMap.put(nodeId, uaExternalNode);
        }
        return uaExternalNode;
    }

    public Collection<UaExternalNode> getNodesByNamespace(int n2) {
        HashMap<NodeId, UaExternalNode> hashMap = this.ka.get(n2);
        if (hashMap == null) {
            return new ArrayList<UaExternalNode>();
        }
        return hashMap.values();
    }

    public boolean hasNode(NodeId object) throws StatusException {
        if (NodeId.isNull((NodeId)object)) {
            throw new StatusException(StatusCodes.Bad_NodeIdInvalid);
        }
        int n2 = object.getNamespaceIndex();
        HashMap<NodeId, UaExternalNode> hashMap = this.ka.get(n2);
        if (hashMap == null) {
            return false;
        }
        return (object = hashMap.get(object)) != null;
    }

    public boolean removeNode(NodeId nodeId) throws StatusException {
        if (NodeId.isNull((NodeId)nodeId)) {
            throw new StatusException(StatusCodes.Bad_NodeIdInvalid);
        }
        int n2 = nodeId.getNamespaceIndex();
        HashMap<NodeId, UaExternalNode> hashMap = this.ka.get(n2);
        if (hashMap == null) {
            return false;
        }
        UaExternalNode uaExternalNode = hashMap.get(nodeId);
        if (uaExternalNode == null) {
            return false;
        }
        hashMap.remove(nodeId);
        return true;
    }

    public boolean removeNode(UaExternalNode uaExternalNode) throws StatusException {
        return this.removeNode(uaExternalNode.getNodeId());
    }

    public boolean removeNodesByNamespace(int n2) {
        HashMap<NodeId, UaExternalNode> hashMap = this.ka.get(n2);
        if (hashMap == null) {
            return false;
        }
        hashMap.clear();
        this.ka.remove(hashMap);
        return true;
    }

    static {
        LoggerFactory.getLogger(ExternalNodeManager.class);
    }
}

