/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.server.EventManager;
import com.prosysopc.ua.server.MethodManager;
import com.prosysopc.ua.server.MonitoredEventItem;
import com.prosysopc.ua.server.NodeManager;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.types.opcua.ConditionType;
import com.prosysopc.ua.types.opcua.StateMachineType;
import com.prosysopc.ua.types.opcua.server.AcknowledgeableConditionTypeNode;
import com.prosysopc.ua.types.opcua.server.AlarmConditionTypeNode;
import com.prosysopc.ua.types.opcua.server.BaseEventTypeNode;
import com.prosysopc.ua.types.opcua.server.ConditionTypeNode;
import com.prosysopc.ua.types.opcua.server.ConditionTypeNodeBase;
import com.prosysopc.ua.types.opcua.server.ShelvedStateMachineTypeNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.StatusCodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventManagerUaNode
extends EventManager {
    private static Logger logger = LoggerFactory.getLogger(EventManagerUaNode.class);

    public EventManagerUaNode(NodeManager nodeManager) {
        super(nodeManager);
    }

    public Collection<ConditionTypeNode> getConditions() {
        try {
            return this.getConditions(Identifiers.Server);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("ObjectsFolder not available", statusException);
        }
    }

    public Collection<ConditionTypeNode> getConditions(NodeId nodeId) throws StatusException {
        return this.getConditions(this.getNodeManagerTable().getNode(nodeId));
    }

    public Collection<ConditionTypeNode> getConditions(UaNode uaNode) {
        ArrayList<ConditionTypeNode> arrayList = new ArrayList<ConditionTypeNode>();
        this.collectConditions(uaNode, arrayList);
        return arrayList;
    }

    @Override
    public boolean onCall(ServiceContext serviceContext, NodeId object, UaNode uaNode, NodeId object2, UaMethod uaMethod, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray, Variant[] variantArray2) throws StatusException {
        logger.debug("onCall: ", "object=" + uaNode == null ? object : (uaNode.getBrowseName() + "; method=" + uaMethod == null ? object2 : uaMethod.getBrowseName()));
        if (super.onCall(serviceContext, (NodeId)object, uaNode, (NodeId)object2, uaMethod, variantArray, statusCodeArray, diagnosticInfoArray, variantArray2)) {
            return true;
        }
        if (!(uaNode instanceof ConditionType) && !(uaNode instanceof StateMachineType)) {
            return false;
        }
        object = null;
        if (uaNode instanceof ConditionTypeNode) {
            object = (ConditionTypeNode)uaNode;
        }
        if (this.methodEqualsIdOrName(uaMethod, Identifiers.ConditionType_Enable, "Enable")) {
            return this.enable(serviceContext, (ConditionTypeNode)object);
        }
        if (this.methodEqualsIdOrName(uaMethod, Identifiers.ConditionType_Disable, "Disable")) {
            return this.disable(serviceContext, (ConditionTypeNode)object);
        }
        if (this.methodEqualsIdOrName(uaMethod, Identifiers.ConditionType_AddComment, "AddComment")) {
            object2 = new Class[]{byte[].class, LocalizedText.class};
            MethodManager.checkInputArguments(object2, variantArray, statusCodeArray, diagnosticInfoArray, true);
            byte[] byArray = (byte[])variantArray[0].getValue();
            LocalizedText localizedText = (LocalizedText)variantArray[1].getValue();
            return this.addComment(serviceContext, (ConditionTypeNode)object, byArray, localizedText);
        }
        if (this.methodEqualsIdOrName(uaMethod, Identifiers.AcknowledgeableConditionType_Acknowledge, "Acknowledge")) {
            object2 = new Class[]{byte[].class, LocalizedText.class};
            MethodManager.checkInputArguments(object2, variantArray, statusCodeArray, diagnosticInfoArray, true);
            byte[] byArray = (byte[])variantArray[0].getValue();
            LocalizedText localizedText = (LocalizedText)variantArray[1].getValue();
            return this.acknowledge(serviceContext, (AcknowledgeableConditionTypeNode)object, byArray, localizedText);
        }
        if (this.methodEqualsIdOrName(uaMethod, Identifiers.AcknowledgeableConditionType_Confirm, "Confirm")) {
            object2 = new Class[]{byte[].class, LocalizedText.class};
            MethodManager.checkInputArguments(object2, variantArray, statusCodeArray, diagnosticInfoArray, true);
            byte[] byArray = (byte[])variantArray[0].getValue();
            LocalizedText localizedText = (LocalizedText)variantArray[1].getValue();
            return this.confirm(serviceContext, (AcknowledgeableConditionTypeNode)object, byArray, localizedText);
        }
        if (this.methodEqualsIdOrName(uaMethod, Identifiers.ShelvedStateMachineType_Unshelve, "Unshelve")) {
            object2 = (ShelvedStateMachineTypeNode)uaNode;
            AlarmConditionTypeNode alarmConditionTypeNode = object2.getCondition();
            return this.unshelve(serviceContext, alarmConditionTypeNode, (ShelvedStateMachineTypeNode)object2);
        }
        if (this.methodEqualsIdOrName(uaMethod, Identifiers.ShelvedStateMachineType_OneShotShelve, "OneShotShelve")) {
            object2 = (ShelvedStateMachineTypeNode)uaNode;
            AlarmConditionTypeNode alarmConditionTypeNode = object2.getCondition();
            return this.oneshotshelve(serviceContext, alarmConditionTypeNode, (ShelvedStateMachineTypeNode)object2);
        }
        if (this.methodEqualsIdOrName(uaMethod, Identifiers.ShelvedStateMachineType_TimedShelve, "TimedShelve")) {
            object2 = new Class[]{Double.class};
            MethodManager.checkInputArguments(object2, variantArray, statusCodeArray, diagnosticInfoArray, false);
            double d2 = Double.parseDouble(variantArray[0].getValue().toString());
            object = (ShelvedStateMachineTypeNode)uaNode;
            uaNode = object.getCondition();
            return this.timedshelve(serviceContext, (AlarmConditionTypeNode)uaNode, (ShelvedStateMachineTypeNode)object, d2);
        }
        return false;
    }

    protected boolean acknowledge(ServiceContext serviceContext, AcknowledgeableConditionTypeNode acknowledgeableConditionTypeNode, byte[] byArray, LocalizedText localizedText) throws StatusException {
        return this.getListener().onAcknowledge(serviceContext, acknowledgeableConditionTypeNode, byArray, localizedText);
    }

    protected boolean addComment(ServiceContext serviceContext, ConditionTypeNode conditionTypeNode, byte[] byArray, LocalizedText localizedText) throws StatusException {
        return this.getListener().onAddComment(serviceContext, conditionTypeNode, byArray, localizedText);
    }

    protected void collectConditions(UaNode object, Collection<ConditionTypeNode> collection) {
        if (object != null) {
            if (object instanceof ConditionTypeNode) {
                collection.add((ConditionTypeNode)object);
            }
            Object object2 = new HashSet<UaReference>();
            object2.addAll(Arrays.asList(object.getReferences(Identifiers.HasNotifier, false)));
            object2.addAll(Arrays.asList(object.getReferences(Identifiers.HasEventSource, false)));
            object2.addAll(Arrays.asList(object.getReferences(Identifiers.HasCondition, false)));
            object = object2.iterator();
            while (object.hasNext()) {
                object2 = (UaReference)object.next();
                this.collectConditions(((UaReference)object2).getTargetNode(), collection);
            }
        }
    }

    protected boolean confirm(ServiceContext serviceContext, AcknowledgeableConditionTypeNode acknowledgeableConditionTypeNode, byte[] byArray, LocalizedText localizedText) throws StatusException {
        return this.getListener().onConfirm(serviceContext, acknowledgeableConditionTypeNode, byArray, localizedText);
    }

    protected boolean disable(ServiceContext serviceContext, ConditionTypeNode conditionTypeNode) throws StatusException {
        if (!conditionTypeNode.isEnabled()) {
            throw new StatusException(StatusCodes.Bad_ConditionAlreadyDisabled);
        }
        return this.getListener().onDisable(serviceContext, conditionTypeNode);
    }

    protected boolean enable(ServiceContext serviceContext, ConditionTypeNode conditionTypeNode) throws StatusException {
        if (conditionTypeNode.isEnabled()) {
            throw new StatusException(StatusCodes.Bad_ConditionAlreadyEnabled);
        }
        return this.getListener().onEnable(serviceContext, conditionTypeNode);
    }

    protected boolean oneshotshelve(ServiceContext serviceContext, AlarmConditionTypeNode alarmConditionTypeNode, ShelvedStateMachineTypeNode shelvedStateMachineTypeNode) throws StatusException {
        return this.getListener().onOneshotShelve(serviceContext, alarmConditionTypeNode, shelvedStateMachineTypeNode);
    }

    @Override
    protected void refreshItem(MonitoredEventItem monitoredEventItem) {
        Object object = monitoredEventItem.getNode();
        logger.debug("refreshItem: node={}", object);
        if (object instanceof ConditionTypeNode) {
            ConditionTypeNode conditionTypeNode = (ConditionTypeNode)object;
            if (conditionTypeNode.isRetain().booleanValue()) {
                monitoredEventItem.notifyEvent(conditionTypeNode.getLastEvent());
            }
            return;
        }
        Object object2 = new ArrayList<ConditionTypeNode>();
        this.collectConditions((UaNode)object, (Collection<ConditionTypeNode>)object2);
        object = ((ArrayList)object2).iterator();
        while (object.hasNext()) {
            object2 = (ConditionTypeNode)object.next();
            if (!((ConditionTypeNodeBase)object2).isRetain().booleanValue()) continue;
            monitoredEventItem.notifyEvent(((BaseEventTypeNode)object2).getLastEvent());
        }
    }

    @Override
    protected boolean requireUaNode() {
        return true;
    }

    protected boolean timedshelve(ServiceContext serviceContext, AlarmConditionTypeNode alarmConditionTypeNode, ShelvedStateMachineTypeNode shelvedStateMachineTypeNode, double d2) throws StatusException {
        return this.getListener().onTimedShelve(serviceContext, alarmConditionTypeNode, shelvedStateMachineTypeNode, d2);
    }

    protected boolean unshelve(ServiceContext serviceContext, AlarmConditionTypeNode alarmConditionTypeNode, ShelvedStateMachineTypeNode shelvedStateMachineTypeNode) throws StatusException {
        return this.getListener().onUnshelve(serviceContext, alarmConditionTypeNode, shelvedStateMachineTypeNode);
    }
}

