/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.EventData;
import com.prosysopc.ua.MonitoredItemBase;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.CallableListener;
import com.prosysopc.ua.server.EventManagerListener;
import com.prosysopc.ua.server.MethodManager;
import com.prosysopc.ua.server.MonitoredEventItem;
import com.prosysopc.ua.server.NodeManager;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.ServiceManagerBase;
import com.prosysopc.ua.server.Subscription;
import com.prosysopc.ua.server.g;
import com.prosysopc.ua.types.opcua.server.RefreshEndEventTypeNode;
import com.prosysopc.ua.types.opcua.server.RefreshStartEventTypeNode;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.core.EventFilter;
import org.opcfoundation.ua.core.EventFilterResult;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.StatusCodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventManager
extends ServiceManagerBase
implements CallableListener {
    private static AtomicLong dV = new AtomicLong(0L);
    private static final EventManagerListener dW = new g();
    protected static final Logger logger = LoggerFactory.getLogger(EventManager.class);
    protected static final EventFilterResult RESULT_OK = null;
    private final NodeManager dX;
    protected final AtomicReference<EventManagerListener> listener = new AtomicReference<EventManagerListener>(dW);

    public static byte[] createEventId(long l2) throws RuntimeException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeLong(l2);
            dataOutputStream.flush();
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] createFullEventId(byte[] byArray) {
        byte[] byArray2 = EventManager.createEventId(dV.incrementAndGet());
        if (byArray != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                byteArrayOutputStream.write(byArray2);
                byteArrayOutputStream.write(byArray);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            return byteArrayOutputStream.toByteArray();
        }
        return byArray2;
    }

    public static byte[] extractUserEventId(byte[] byArray) {
        if (byArray == null || byArray.length < 9) {
            return null;
        }
        return Arrays.copyOfRange(byArray, 8, byArray.length);
    }

    public EventManager(NodeManager nodeManager) {
        super(nodeManager.getServer());
        nodeManager.setEventManager(this);
        this.dX = nodeManager;
    }

    public EventManagerListener getListener() {
        return this.listener.get();
    }

    public NodeManager getNodeManager() {
        return this.dX;
    }

    @Override
    public boolean onCall(ServiceContext serviceContext, NodeId object, UaNode uaNode, NodeId nodeId, UaMethod uaMethod, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray, Variant[] variantArray2) throws StatusException {
        if (logger.isDebugEnabled()) {
            logger.debug("onCall: ", "object=" + uaNode == null ? object : (uaNode.getBrowseName() + "; method=" + uaMethod == null ? nodeId : uaMethod.getBrowseName()));
        }
        if (nodeId.equals((Object)Identifiers.ConditionType_ConditionRefresh) || uaMethod != null && uaMethod.getBrowseName().equals((Object)new QualifiedName("ConditionRefresh"))) {
            try {
                MethodManager.checkInputArguments(new Class[]{UnsignedInteger.class}, variantArray, statusCodeArray, diagnosticInfoArray, false);
                object = (UnsignedInteger)variantArray[0].getValue();
                logger.debug("subscriptionId: {}", object);
                object = this.getSubscriptionManager().getSubscription((UnsignedInteger)object);
                logger.debug("subscription: {}", object);
                return this.refresh(serviceContext, (Subscription)object);
            }
            catch (ClassCastException classCastException) {
                statusCodeArray[0] = new StatusCode(StatusCodes.Bad_SubscriptionIdInvalid);
            }
            catch (ServiceException serviceException) {
                statusCodeArray[0] = new StatusCode(StatusCodes.Bad_SubscriptionIdInvalid);
            }
            throw new StatusException(StatusCodes.Bad_InvalidArgument);
        }
        return false;
    }

    public void refreshSubscription(ServiceContext serviceContext, UnsignedInteger unsignedInteger) throws StatusException, ServiceException {
        this.refresh(serviceContext, this.getSubscriptionManager().getSubscription(unsignedInteger));
    }

    public void setListener(EventManagerListener eventManagerListener) {
        this.listener.set(eventManagerListener != null ? eventManagerListener : dW);
    }

    protected void afterCreateMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, MonitoredEventItem monitoredEventItem) {
        this.getListener().onAfterCreateMonitoredEventItem(serviceContext, subscription, monitoredEventItem);
    }

    protected void afterDeleteMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, MonitoredEventItem monitoredEventItem) {
        this.getListener().onAfterDeleteMonitoredEventItem(serviceContext, subscription, monitoredEventItem);
    }

    protected void afterModifyMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, MonitoredEventItem monitoredEventItem) {
        this.getListener().onAfterModifyMonitoredEventItem(serviceContext, subscription, monitoredEventItem);
    }

    protected void createMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, NodeId nodeId, EventFilter eventFilter, EventFilterResult eventFilterResult) throws StatusException {
        this.getListener().onCreateMonitoredEventItem(serviceContext, nodeId, eventFilter, eventFilterResult);
    }

    protected void deleteMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, MonitoredEventItem monitoredEventItem) {
        this.getListener().onDeleteMonitoredEventItem(serviceContext, subscription, monitoredEventItem);
    }

    protected boolean methodEqualsIdOrName(UaMethod uaMethod, NodeId nodeId, String string) {
        return uaMethod.getNodeId().equals((Object)nodeId) || uaMethod.getBrowseName().equals((Object)new QualifiedName(string));
    }

    protected void modifyMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, MonitoredEventItem monitoredEventItem, EventFilter eventFilter, EventFilterResult eventFilterResult) throws StatusException {
        this.getListener().onModifyMonitoredEventItem(serviceContext, subscription, monitoredEventItem, eventFilter, eventFilterResult);
    }

    protected boolean refresh(ServiceContext serviceContext, Subscription subscription) throws StatusException {
        logger.debug("refresh: subscription={}", (Object)subscription);
        if (subscription != null) {
            this.refreshStartEvent(subscription);
            try {
                this.refreshItems(serviceContext, subscription);
            }
            finally {
                this.refreshEndEvent(subscription);
            }
        }
        return true;
    }

    protected void refreshEndEvent(Subscription monitoredItemBaseArray) {
        Object object = this.getNodeManagerTable().getNodeManagerRoot().createEvent(RefreshEndEventTypeNode.class);
        object = new EventData((UaNode)object, EventManager.createEventId(dV.incrementAndGet()));
        for (MonitoredItemBase monitoredItemBase : monitoredItemBaseArray.getItems()) {
            if (!(monitoredItemBase instanceof MonitoredEventItem)) continue;
            monitoredItemBase = (MonitoredEventItem)monitoredItemBase;
            logger.debug("refreshEndEvent: eventItem={}", (Object)monitoredItemBase.getMonitoredItemId());
            ((MonitoredEventItem)monitoredItemBase).notifyEvent((EventData)object, false);
        }
    }

    protected void refreshItem(MonitoredEventItem monitoredEventItem) {
    }

    protected void refreshItems(ServiceContext monitoredItemBaseArray, Subscription subscription) throws StatusException {
        Subscription object2 = subscription;
        MonitoredItemBase[] monitoredItemBaseArray2 = monitoredItemBaseArray;
        monitoredItemBaseArray = this;
        monitoredItemBaseArray.getListener().onConditionRefresh((ServiceContext)monitoredItemBaseArray2, object2);
        for (MonitoredItemBase monitoredItemBase : subscription.getItems()) {
            if (!(monitoredItemBase instanceof MonitoredEventItem)) continue;
            this.refreshItem((MonitoredEventItem)monitoredItemBase);
        }
    }

    protected void refreshStartEvent(Subscription monitoredItemBaseArray) {
        Object object = this.getNodeManagerTable().getNodeManagerRoot().createEvent(RefreshStartEventTypeNode.class);
        object = new EventData((UaNode)object, EventManager.createEventId(dV.incrementAndGet()));
        for (MonitoredItemBase monitoredItemBase : monitoredItemBaseArray.getItems()) {
            if (!(monitoredItemBase instanceof MonitoredEventItem)) continue;
            monitoredItemBase = (MonitoredEventItem)monitoredItemBase;
            logger.debug("refreshStartEvent: eventItem={}", (Object)monitoredItemBase.getMonitoredItemId());
            ((MonitoredEventItem)monitoredItemBase).notifyEvent((EventData)object, false);
        }
    }
}

