/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.nodes.UaInstance;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.server.InstantiationParameters;
import com.prosysopc.ua.server.InstantiationStrategy;
import com.prosysopc.ua.server.UaInstantiationException;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.core.NodeClass;

public class DefaultInstantiationStrategy
implements InstantiationStrategy {
    @Override
    public UaNode createInstance(InstantiationParameters instantiationParameters) {
        NodeClass nodeClass = instantiationParameters.getNode().getNodeClass();
        switch (nodeClass) {
            case ObjectType: {
                nodeClass = NodeClass.Object;
                break;
            }
            case VariableType: {
                nodeClass = NodeClass.Variable;
                break;
            }
            case Method: {
                return instantiationParameters.getNode();
            }
            case Object: 
            case Variable: {
                break;
            }
            default: {
                throw new UaInstantiationException("DefaultInstantiationStrategy: the NodeClass of InstanceDeclaration is unsupported:" + nodeClass);
            }
        }
        ExpandedNodeId expandedNodeId = null;
        if (instantiationParameters.getNode() instanceof UaInstance) {
            expandedNodeId = ((UaInstance)instantiationParameters.getNode()).getTypeDefinitionId();
        }
        if (instantiationParameters.getNode() instanceof UaType) {
            expandedNodeId = instantiationParameters.getNodeManager().getNamespaceTable().toExpandedNodeId(instantiationParameters.getNode().getNodeId());
        }
        if (expandedNodeId != null) {
            return instantiationParameters.getNodeManager().getNodeFactory().createNode(nodeClass, instantiationParameters.getNodeId(), instantiationParameters.getBrowseName(), instantiationParameters.getDisplayName(), expandedNodeId);
        }
        throw new UaInstantiationException("DefaultInstantiationStrategy: instancedeclaration does not have typedefinition, is not Method or Type");
    }

    @Override
    public boolean createsCompleteHierarchy() {
        return false;
    }
}

