/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.EventData;
import com.prosysopc.ua.server.FilterOperatorDefinition;
import com.prosysopc.ua.server.NodeManagerRoot;
import java.util.Arrays;
import java.util.List;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.core.Attributes;
import org.opcfoundation.ua.core.ContentFilter;
import org.opcfoundation.ua.core.ContentFilterElement;
import org.opcfoundation.ua.core.ContentFilterElementResult;
import org.opcfoundation.ua.core.ContentFilterResult;
import org.opcfoundation.ua.core.EventFilter;
import org.opcfoundation.ua.core.EventFilterResult;
import org.opcfoundation.ua.core.SimpleAttributeOperand;
import org.opcfoundation.ua.core.StatusCodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentFilterDefinition {
    private static Logger logger = LoggerFactory.getLogger(ContentFilterDefinition.class);
    private DiagnosticInfo[] ae;
    private ContentFilterElementResult[] af;
    private FilterOperatorDefinition[] ag;

    public static void parseEventFilter(NodeManagerRoot nodeManagerRoot, EventFilter eventFilter, List<List<QualifiedName>> list, ContentFilterDefinition contentFilterDefinition, EventFilterResult eventFilterResult) {
        list.clear();
        SimpleAttributeOperand[] simpleAttributeOperandArray = eventFilter.getSelectClauses();
        if (simpleAttributeOperandArray != null) {
            for (SimpleAttributeOperand simpleAttributeOperand : simpleAttributeOperandArray) {
                if (simpleAttributeOperand == null) continue;
                Object[] objectArray = simpleAttributeOperand.getBrowsePath();
                logger.debug("BrowsePath={}", (Object)Arrays.toString(objectArray));
                if (simpleAttributeOperand.getAttributeId().equals((Object)Attributes.Value)) {
                    if (objectArray == null) continue;
                    list.add(Arrays.asList(objectArray));
                    continue;
                }
                if (!simpleAttributeOperand.getAttributeId().equals((Object)Attributes.NodeId)) continue;
                list.add(null);
                simpleAttributeOperand.getTypeDefinitionId();
            }
        }
        contentFilterDefinition.parse(eventFilter.getWhereClause(), nodeManagerRoot);
        eventFilterResult.setWhereClauseResult(new ContentFilterResult(contentFilterDefinition.getElementResults(), contentFilterDefinition.getElementDiagnosticInfos()));
    }

    public Boolean evaluate(EventData object, Boolean bl) {
        if (this.ag == null || this.ag.length == 0 || this.ag[0] == null) {
            return true;
        }
        try {
            object = (Boolean)this.ag[0].evaluate((EventData)object, bl);
        }
        catch (ClassCastException classCastException) {
            object = null;
        }
        logger.debug("evaluate: {}", object);
        return object;
    }

    public DiagnosticInfo[] getElementDiagnosticInfos() {
        return this.ae;
    }

    public ContentFilterElementResult[] getElementResults() {
        return this.af;
    }

    public void parse(ContentFilter contentFilterElementArray, NodeManagerRoot nodeManagerRoot) {
        if ((contentFilterElementArray = contentFilterElementArray == null ? null : contentFilterElementArray.getElements()) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("parse: elements.length={}", (Object)contentFilterElementArray.length);
            }
            this.ag = new FilterOperatorDefinition[contentFilterElementArray.length];
            this.af = new ContentFilterElementResult[contentFilterElementArray.length];
            this.ae = new DiagnosticInfo[contentFilterElementArray.length];
            for (int i2 = contentFilterElementArray.length - 1; i2 >= 0; --i2) {
                ContentFilterElement contentFilterElement = contentFilterElementArray[i2];
                logger.debug("parse: i={} element={}", (Object)i2, (Object)contentFilterElement);
                if (contentFilterElement == null) continue;
                this.ag[i2] = FilterOperatorDefinition.newOperator(contentFilterElement.getFilterOperator(), contentFilterElement.getFilterOperands(), nodeManagerRoot, this.ag);
                if (this.ag[i2] == null) {
                    this.af[i2] = new ContentFilterElementResult(new StatusCode(StatusCodes.Bad_FilterOperatorUnsupported), null, null);
                } else {
                    this.af[i2] = this.ag[i2].getElementResult();
                    this.ae[i2] = this.ag[i2].getElementDiagnosticInfo();
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("parse: i={} operator={}", (Object)i2, (Object)this.ag[i2]);
            }
        }
    }
}

