/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public final class BrowsePath
implements Comparable<BrowsePath> {
    private final LinkedList<QualifiedName> list = new LinkedList();

    public BrowsePath(QualifiedName ... qualifiedNameArray) {
        this.list.addAll(Arrays.asList(qualifiedNameArray));
    }

    private BrowsePath(List<QualifiedName> list) {
        this.list.addAll(list);
    }

    public final BrowsePath append(QualifiedName ... qualifiedNameArray) {
        LinkedList<QualifiedName> linkedList = new LinkedList<QualifiedName>(this.list);
        linkedList.addAll(Arrays.asList(qualifiedNameArray));
        return new BrowsePath(linkedList);
    }

    @Override
    public final int compareTo(BrowsePath object) {
        QualifiedName qualifiedName;
        Object object2;
        if (this.equals(object)) {
            return 0;
        }
        QualifiedName qualifiedName2 = this.list.iterator();
        object = ((BrowsePath)object).list.iterator();
        do {
            if (!qualifiedName2.hasNext()) {
                return -1;
            }
            object2 = (QualifiedName)qualifiedName2.next();
            if (!object.hasNext()) {
                return 1;
            }
            qualifiedName = (QualifiedName)object.next();
        } while (object2.equals((Object)qualifiedName));
        qualifiedName2 = qualifiedName;
        object = object2;
        object2 = object.getNamespaceIndex();
        ((Integer)object2).compareTo(qualifiedName2.getNamespaceIndex());
        int n2 = ((Integer)object2).compareTo(qualifiedName2.getNamespaceIndex());
        if (n2 != 0) {
            return n2;
        }
        return object.getName().compareTo(qualifiedName2.getName());
    }

    public final boolean equals(Object object) {
        if (object instanceof BrowsePath) {
            object = (BrowsePath)object;
            return this.list.equals(((BrowsePath)object).list);
        }
        return super.equals(object);
    }

    public final QualifiedName getFirst() {
        if (this.list.isEmpty()) {
            return QualifiedName.NULL;
        }
        return this.list.peekFirst();
    }

    public final QualifiedName getLast() {
        if (this.list.isEmpty()) {
            return QualifiedName.NULL;
        }
        return this.list.peekLast();
    }

    public final int getSize() {
        return this.list.size();
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public final boolean isEmpty() {
        return this.list.isEmpty();
    }

    public final BrowsePath removeFirst() {
        LinkedList<QualifiedName> linkedList = new LinkedList<QualifiedName>(this.list);
        linkedList.pollFirst();
        return new BrowsePath(linkedList);
    }

    public final BrowsePath removeLast() {
        LinkedList<QualifiedName> linkedList = new LinkedList<QualifiedName>(this.list);
        linkedList.pollLast();
        return new BrowsePath(linkedList);
    }

    public final QualifiedName[] toArray() {
        if (this.list == null) {
            return new QualifiedName[0];
        }
        return this.list.toArray(new QualifiedName[0]);
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("/");
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            QualifiedName qualifiedName = (QualifiedName)iterator.next();
            stringBuilder.append(qualifiedName.getNamespaceIndex()).append(':').append(qualifiedName.getName());
            if (!iterator.hasNext()) continue;
            stringBuilder.append('/');
        }
        return stringBuilder.toString();
    }
}

