/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.server.HistoryContinuationPoint;
import com.prosysopc.ua.server.HistoryResult;
import com.prosysopc.ua.server.NodeManager;
import com.prosysopc.ua.server.NodeManagerTable;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.ServiceHandler;
import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.server.SessionManager;
import java.util.Map;
import java.util.TreeMap;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.ServiceRequest;
import org.opcfoundation.ua.builtintypes.ServiceResponse;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.common.ServiceFaultException;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.AttributeServiceSetHandler;
import org.opcfoundation.ua.core.Attributes;
import org.opcfoundation.ua.core.HistoryReadDetails;
import org.opcfoundation.ua.core.HistoryReadRequest;
import org.opcfoundation.ua.core.HistoryReadResponse;
import org.opcfoundation.ua.core.HistoryReadResult;
import org.opcfoundation.ua.core.HistoryReadValueId;
import org.opcfoundation.ua.core.HistoryUpdateDetails;
import org.opcfoundation.ua.core.HistoryUpdateRequest;
import org.opcfoundation.ua.core.HistoryUpdateResponse;
import org.opcfoundation.ua.core.HistoryUpdateResult;
import org.opcfoundation.ua.core.ReadRequest;
import org.opcfoundation.ua.core.ReadResponse;
import org.opcfoundation.ua.core.ReadValueId;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.core.TimestampsToReturn;
import org.opcfoundation.ua.core.WriteRequest;
import org.opcfoundation.ua.core.WriteResponse;
import org.opcfoundation.ua.core.WriteValue;
import org.opcfoundation.ua.encoding.DecodingException;
import org.opcfoundation.ua.transport.endpoint.EndpointServiceRequest;
import org.opcfoundation.ua.utils.NumericRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeServiceHandler
extends ServiceHandler
implements AttributeServiceSetHandler {
    protected static Logger logger = LoggerFactory.getLogger(AttributeServiceHandler.class);

    public AttributeServiceHandler(SessionManager sessionManager, NodeManagerTable nodeManagerTable) {
        super(sessionManager, nodeManagerTable);
    }

    public int getMaxNodesPerHistoryReadData() {
        return this.getOperationLimits().getMaxNodesPerHistoryReadData().intValue();
    }

    public int getMaxNodesPerHistoryReadEvents() {
        return this.getOperationLimits().getMaxNodesPerHistoryReadEvents().intValue();
    }

    public int getMaxNodesPerHistoryUpdateData() {
        return this.getOperationLimits().getMaxNodesPerHistoryUpdateData().intValue();
    }

    public int getMaxNodesPerHistoryUpdateEvents() {
        return this.getOperationLimits().getMaxNodesPerHistoryUpdateEvents().intValue();
    }

    public int getMaxNodesPerRead() {
        return this.getOperationLimits().getMaxNodesPerRead().intValue();
    }

    public int getMaxNodesPerWrite() {
        return this.getOperationLimits().getMaxNodesPerWrite().intValue();
    }

    public final void onHistoryRead(EndpointServiceRequest<HistoryReadRequest, HistoryReadResponse> endpointServiceRequest) throws ServiceFaultException {
        HistoryReadRequest historyReadRequest = (HistoryReadRequest)endpointServiceRequest.getRequest();
        HistoryReadResponse historyReadResponse = new HistoryReadResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest((ServiceRequest)historyReadRequest, endpointServiceRequest.getChannel());
            this.historyRead(serviceContext, historyReadRequest, historyReadResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException((ServiceResponse)historyReadResponse, serviceException);
        }
        historyReadResponse.setDiagnosticInfos(this.validateResponse((ServiceRequest)historyReadRequest, (ServiceResponse)historyReadResponse, serviceContext, historyReadResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse((ServiceResponse)historyReadResponse);
    }

    public final void onHistoryUpdate(EndpointServiceRequest<HistoryUpdateRequest, HistoryUpdateResponse> endpointServiceRequest) throws ServiceFaultException {
        HistoryUpdateRequest historyUpdateRequest = (HistoryUpdateRequest)endpointServiceRequest.getRequest();
        HistoryUpdateResponse historyUpdateResponse = new HistoryUpdateResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest((ServiceRequest)historyUpdateRequest, endpointServiceRequest.getChannel());
            this.historyUpdate(serviceContext, (HistoryUpdateRequest)endpointServiceRequest.getRequest(), historyUpdateResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException((ServiceResponse)historyUpdateResponse, serviceException);
        }
        historyUpdateResponse.setDiagnosticInfos(this.validateResponse((ServiceRequest)historyUpdateRequest, (ServiceResponse)historyUpdateResponse, serviceContext, historyUpdateResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse((ServiceResponse)historyUpdateResponse);
    }

    public final void onRead(EndpointServiceRequest<ReadRequest, ReadResponse> endpointServiceRequest) throws ServiceFaultException {
        ReadRequest readRequest = (ReadRequest)endpointServiceRequest.getRequest();
        ReadResponse readResponse = new ReadResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest((ServiceRequest)readRequest, endpointServiceRequest.getChannel());
            this.read(serviceContext, readRequest, readResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException((ServiceResponse)readResponse, serviceException);
        }
        readResponse.setDiagnosticInfos(this.validateResponse((ServiceRequest)readRequest, (ServiceResponse)readResponse, serviceContext, readResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse((ServiceResponse)readResponse);
    }

    public final void onWrite(EndpointServiceRequest<WriteRequest, WriteResponse> endpointServiceRequest) throws ServiceFaultException {
        WriteRequest writeRequest = (WriteRequest)endpointServiceRequest.getRequest();
        WriteResponse writeResponse = new WriteResponse();
        ServiceContext serviceContext = null;
        try {
            serviceContext = this.validateRequest((ServiceRequest)writeRequest, endpointServiceRequest.getChannel());
            this.write(serviceContext, writeRequest, writeResponse);
        }
        catch (ServiceException serviceException) {
            this.handleServiceResultException((ServiceResponse)writeResponse, serviceException);
        }
        writeResponse.setDiagnosticInfos(this.validateResponse((ServiceRequest)writeRequest, (ServiceResponse)writeResponse, serviceContext, writeResponse.getDiagnosticInfos()));
        endpointServiceRequest.sendResponse((ServiceResponse)writeResponse);
    }

    public void setMaxNodesPerHistoryReadData(int n2) {
        this.getOperationLimits().setMaxNodesPerHistoryReadData(UnsignedInteger.valueOf((long)n2));
    }

    public void setMaxNodesPerHistoryReadEvents(int n2) {
        this.getOperationLimits().setMaxNodesPerHistoryReadEvents(UnsignedInteger.valueOf((long)n2));
    }

    public void setMaxNodesPerHistoryUpdateData(int n2) {
        this.getOperationLimits().setMaxNodesPerHistoryUpdateData(UnsignedInteger.valueOf((long)n2));
    }

    public void setMaxNodesPerHistoryUpdateEvents(int n2) {
        this.getOperationLimits().setMaxNodesPerHistoryUpdateEvents(UnsignedInteger.valueOf((long)n2));
    }

    public void setMaxNodesPerRead(int n2) {
        this.getOperationLimits().setMaxNodesPerRead(UnsignedInteger.valueOf((long)n2));
    }

    public void setMaxNodesPerWrite(int n2) {
        this.getOperationLimits().setMaxNodesPerWrite(UnsignedInteger.valueOf((long)n2));
    }

    private void a(ServiceContext serviceContext, Map<Integer, Object> map, HistoryReadDetails historyReadDetails, HistoryReadValueId[] historyReadValueIdArray, HistoryContinuationPoint[] historyContinuationPointArray, TimestampsToReturn timestampsToReturn, HistoryResult[] historyResultArray) throws ServiceException {
        for (Integer n2 : map.keySet()) {
            try {
                Object object = this.getNodeManagerTable().getNodeManager(n2);
                object = ((NodeManager)object).getHistoryManager().beginHistoryRead(serviceContext, historyReadDetails, timestampsToReturn, historyReadValueIdArray, historyContinuationPointArray, historyResultArray);
                map.put(n2, object);
            }
            catch (StatusException statusException) {}
        }
    }

    private void a(ServiceContext serviceContext, Map<Integer, Object> map, HistoryUpdateDetails[] historyUpdateDetailsArray, HistoryUpdateResult[] historyUpdateResultArray, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        for (Integer n2 : map.keySet()) {
            try {
                Object object = this.getNodeManagerTable().getNodeManager(n2);
                object = ((NodeManager)object).getHistoryManager().beginHistoryUpdate(serviceContext, historyUpdateDetailsArray, historyUpdateResultArray, diagnosticInfoArray);
                map.put(n2, object);
            }
            catch (StatusException statusException) {}
        }
    }

    private void a(ServiceContext serviceContext, Map<Integer, Object> map, ReadValueId[] readValueIdArray, TimestampsToReturn timestampsToReturn, DateTime dateTime, DataValue[] dataValueArray, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        for (Integer n2 : map.keySet()) {
            try {
                Object object = this.getNodeManagerTable().getNodeManager(n2);
                object = ((NodeManager)object).getIoManager().beginRead(serviceContext, readValueIdArray, timestampsToReturn, dateTime, dataValueArray, diagnosticInfoArray);
                map.put(n2, object);
            }
            catch (StatusException statusException) {}
        }
    }

    private void a(ServiceContext serviceContext, Map<Integer, Object> map, WriteValue[] writeValueArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        for (Integer n2 : map.keySet()) {
            try {
                Object object = this.getNodeManagerTable().getNodeManager(n2);
                object = ((NodeManager)object).getIoManager().beginWrite(serviceContext, writeValueArray, statusCodeArray, diagnosticInfoArray);
                map.put(n2, object);
            }
            catch (StatusException statusException) {}
        }
    }

    private void a(ServiceContext serviceContext, Map<Integer, Object> map, HistoryReadDetails historyReadDetails, TimestampsToReturn timestampsToReturn, HistoryReadValueId[] historyReadValueIdArray, HistoryContinuationPoint[] historyContinuationPointArray, HistoryResult[] historyResultArray) throws ServiceException {
        for (Integer n2 : map.keySet()) {
            try {
                NodeManager nodeManager = this.getNodeManagerTable().getNodeManager(n2);
                nodeManager.getHistoryManager().endHistoryRead(serviceContext, map.get(n2), historyReadDetails, timestampsToReturn, historyReadValueIdArray, historyContinuationPointArray, historyResultArray);
            }
            catch (StatusException statusException) {}
        }
    }

    private void b(ServiceContext serviceContext, Map<Integer, Object> map, HistoryUpdateDetails[] historyUpdateDetailsArray, HistoryUpdateResult[] historyUpdateResultArray, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        for (Integer n2 : map.keySet()) {
            try {
                NodeManager nodeManager = this.getNodeManagerTable().getNodeManager(n2);
                nodeManager.getHistoryManager().endHistoryUpdate(serviceContext, map.get(n2), historyUpdateDetailsArray, historyUpdateResultArray, diagnosticInfoArray);
            }
            catch (StatusException statusException) {}
        }
    }

    private void b(ServiceContext serviceContext, Map<Integer, Object> map, ReadValueId[] readValueIdArray, TimestampsToReturn timestampsToReturn, DateTime dateTime, DataValue[] dataValueArray, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        for (Integer n2 : map.keySet()) {
            try {
                NodeManager nodeManager = this.getNodeManagerTable().getNodeManager(n2);
                nodeManager.getIoManager().endRead(serviceContext, map.get(n2), readValueIdArray, timestampsToReturn, dateTime, dataValueArray, diagnosticInfoArray);
            }
            catch (StatusException statusException) {}
        }
    }

    private void b(ServiceContext serviceContext, Map<Integer, Object> map, WriteValue[] writeValueArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        for (Integer n2 : map.keySet()) {
            try {
                NodeManager nodeManager = this.getNodeManagerTable().getNodeManager(n2);
                nodeManager.getIoManager().endWrite(serviceContext, map.get(n2), writeValueArray, statusCodeArray, diagnosticInfoArray);
            }
            catch (StatusException statusException) {}
        }
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    protected void historyRead(ServiceContext serviceContext, HistoryReadRequest object, HistoryReadResponse historyReadResponse) throws ServiceException {
        Integer n2;
        Object object2;
        int n3;
        HistoryReadDetails historyReadDetails;
        TimestampsToReturn timestampsToReturn = object.getTimestampsToReturn();
        if (timestampsToReturn == TimestampsToReturn.Neither) {
            throw new ServiceException(StatusCodes.Bad_InvalidTimestampArgument);
        }
        Session session = serviceContext.getSession();
        Object[] objectArray = object.getNodesToRead();
        this.checkRequestLength(objectArray, this.getMaxNodesPerHistoryReadData());
        try {
            historyReadDetails = (HistoryReadDetails)object.getHistoryReadDetails().decode(this.getEncoderContext());
        }
        catch (DecodingException decodingException) {
            throw new ServiceException((ServiceResultException)((Object)decodingException));
        }
        object = object.getReleaseContinuationPoints();
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        HistoryContinuationPoint[] historyContinuationPointArray = new HistoryContinuationPoint[objectArray.length];
        HistoryResult[] historyResultArray = new HistoryResult[objectArray.length];
        for (n3 = 0; n3 < objectArray.length; ++n3) {
            object2 = objectArray[n3];
            try {
                if (((Boolean)object).booleanValue()) {
                    this.releaseHistoryContinuationPoint(serviceContext, object2.getNodeId(), object2.getContinuationPoint());
                    continue;
                }
                n2 = object2.getNodeId().getNamespaceIndex();
                if (!treeMap.containsKey(n2)) {
                    treeMap.put(n2, null);
                }
                if (object2.getContinuationPoint() == null) continue;
                historyContinuationPointArray[n3] = session.getHistoryContinuationPoint(object2.getContinuationPoint());
                if (historyContinuationPointArray[n3].getDetails() != null) continue;
                throw new StatusException(StatusCodes.Bad_ContinuationPointInvalid);
            }
            catch (StatusException statusException) {
                logger.debug("historyRead: Invalid continuation point for nodeToRead=" + object2 + " error:", (Throwable)statusException);
                historyResultArray[n3] = new HistoryResult(statusException.getStatusCode(), statusException.getDiagnosticInfo());
            }
        }
        if (!((Boolean)object).booleanValue()) {
            this.a(serviceContext, treeMap, historyReadDetails, (HistoryReadValueId[])objectArray, historyContinuationPointArray, timestampsToReturn, historyResultArray);
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                if (historyResultArray[n3] != null) continue;
                object2 = objectArray[n3];
                try {
                    try {
                        object2.setParsedIndexRange(NumericRange.parse((String)object2.getIndexRange()));
                    }
                    catch (ServiceResultException serviceResultException) {
                        throw new StatusException(serviceResultException);
                    }
                    n2 = treeMap.get(object2.getNodeId().getNamespaceIndex());
                    historyResultArray[n3] = this.readNodeHistory(serviceContext, n2, timestampsToReturn, object2.getNodeId(), object2.getParsedIndexRange(), historyContinuationPointArray[n3], historyReadDetails, n3);
                    continue;
                }
                catch (StatusException statusException) {
                    logger.debug("historyRead: Invalid continuation point for nodeToRead=" + object2 + " error:", (Throwable)statusException);
                    historyResultArray[n3] = new HistoryResult(statusException.getStatusCode(), statusException.getDiagnosticInfo());
                }
            }
            this.a(serviceContext, treeMap, historyReadDetails, timestampsToReturn, (HistoryReadValueId[])objectArray, historyContinuationPointArray, historyResultArray);
        }
        HistoryReadResult[] historyReadResultArray = new HistoryReadResult[objectArray.length];
        object2 = new DiagnosticInfo[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            historyReadResultArray[i2] = new HistoryReadResult();
            object2[i2] = new DiagnosticInfo();
            object = objectArray[i2];
            if (QualifiedName.isNull((QualifiedName)(object = object.getDataEncoding()))) {
                object = QualifiedName.DEFAULT_BINARY_ENCODING;
            }
            historyReadResultArray[i2].setHistoryData(AttributeServiceHandler.toExtensionObject(serviceContext, historyResultArray[i2].getData(), (QualifiedName)object, this.getEncoderContext()));
            historyReadResultArray[i2].setStatusCode(historyResultArray[i2].getStatusCode());
            object2[i2] = historyResultArray[i2].getDiagnosticInfo();
            if (historyResultArray[i2].getContinuationPoint() == null) continue;
            try {
                if (historyContinuationPointArray[i2] != null) {
                    object = historyContinuationPointArray[i2];
                    session.addHistoryContinuationPoint(new HistoryContinuationPoint(serviceContext, historyResultArray[i2].getContinuationPoint(), ((HistoryContinuationPoint)object).getDetails(), ((HistoryContinuationPoint)object).getTimestampsToReturn()));
                }
                object = session.addHistoryContinuationPoint(new HistoryContinuationPoint(serviceContext, historyResultArray[i2].getContinuationPoint(), historyReadDetails, timestampsToReturn));
                historyReadResultArray[i2].setContinuationPoint((byte[])object);
                continue;
            }
            catch (StatusException statusException) {
                historyReadResultArray[i2].setStatusCode(statusException.getStatusCode());
                object2[i2] = statusException.getDiagnosticInfo();
            }
        }
        historyReadResponse.setResults(historyReadResultArray);
        historyReadResponse.setDiagnosticInfos(object2);
    }

    protected void historyUpdate(ServiceContext serviceContext, HistoryUpdateRequest objectArray, HistoryUpdateResponse historyUpdateResponse) throws ServiceException {
        objectArray = objectArray.getHistoryUpdateDetails();
        AttributeServiceHandler attributeServiceHandler = this;
        int n2 = attributeServiceHandler.getMaxNodesPerHistoryUpdateData();
        int n3 = attributeServiceHandler.getMaxNodesPerHistoryUpdateEvents();
        this.checkRequestLength(objectArray, n2 <= 0 ? n3 : (n3 <= 0 ? n2 : Math.max(n2, n3)));
        HistoryUpdateResult[] historyUpdateResultArray = new HistoryUpdateResult[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        HistoryUpdateDetails[] historyUpdateDetailsArray = new HistoryUpdateDetails[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            try {
                historyUpdateDetailsArray[i2] = (HistoryUpdateDetails)objectArray[i2].decode(this.getEncoderContext());
                continue;
            }
            catch (DecodingException decodingException) {
                logger.debug("DecodingException: ", (Throwable)decodingException);
                historyUpdateResultArray[i2].setStatusCode(decodingException.getStatusCode());
            }
        }
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        HistoryUpdateDetails[] historyUpdateDetailsArray2 = historyUpdateDetailsArray;
        int n4 = historyUpdateDetailsArray.length;
        for (int i3 = 0; i3 < n4; ++i3) {
            Object object = historyUpdateDetailsArray2[i3];
            if (treeMap.containsKey(object = Integer.valueOf(object.getNodeId().getNamespaceIndex()))) continue;
            treeMap.put((Integer)object, null);
        }
        this.a(serviceContext, treeMap, historyUpdateDetailsArray, historyUpdateResultArray, diagnosticInfoArray);
        for (int i4 = 0; i4 < historyUpdateDetailsArray.length; ++i4) {
            historyUpdateResultArray[i4] = new HistoryUpdateResult();
            diagnosticInfoArray[i4] = new DiagnosticInfo();
            try {
                Object v = treeMap.get(historyUpdateDetailsArray[i4].getNodeId().getNamespaceIndex());
                this.updateNodeHistory(serviceContext, v, historyUpdateDetailsArray[i4], historyUpdateResultArray[i4]);
                historyUpdateResultArray[i4].setStatusCode(StatusCode.GOOD);
                continue;
            }
            catch (StatusException statusException) {
                logger.debug("StatusException: ", (Throwable)statusException);
                historyUpdateResultArray[i4].setStatusCode(statusException.getStatusCode());
                diagnosticInfoArray[i4] = statusException.getDiagnosticInfo();
            }
        }
        this.b(serviceContext, treeMap, historyUpdateDetailsArray, historyUpdateResultArray, diagnosticInfoArray);
        historyUpdateResponse.setResults(historyUpdateResultArray);
        historyUpdateResponse.setDiagnosticInfos(diagnosticInfoArray);
    }

    protected void read(ServiceContext serviceContext, ReadRequest objectArray, ReadResponse readResponse) throws ServiceException {
        Object object;
        Object object2;
        int n2;
        logger.debug("read");
        Double d2 = objectArray.getMaxAge();
        if (d2 == null || d2 == 0.0) {
            d2 = DateTime.MAX_VALUE;
        } else {
            if (d2 < 0.0) {
                throw new ServiceException(StatusCodes.Bad_MaxAgeInvalid);
            }
            d2 = d2 >= 2.147483647E9 ? DateTime.MIN_VALUE : new DateTime((long)(((double)DateTime.currentTime().getMilliSeconds() - d2) * 10000.0));
        }
        TimestampsToReturn timestampsToReturn = objectArray.getTimestampsToReturn();
        if (timestampsToReturn == null) {
            throw new ServiceException(StatusCodes.Bad_TimestampsToReturnInvalid);
        }
        objectArray = objectArray.getNodesToRead();
        this.checkRequestLength(objectArray, this.getMaxNodesPerRead());
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        Object[] objectArray2 = objectArray;
        int n3 = objectArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            object2 = objectArray2[n2];
            object = object2.getNodeId().getNamespaceIndex();
            if (treeMap.containsKey(object)) continue;
            treeMap.put((Integer)object, null);
        }
        objectArray2 = new DataValue[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        this.a(serviceContext, treeMap, (ReadValueId[])objectArray, timestampsToReturn, (DateTime)d2, (DataValue[])objectArray2, diagnosticInfoArray);
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            if (objectArray2[n2] != null || objectArray[n2] == null) continue;
            objectArray2[n2] = new DataValue(StatusCode.GOOD);
            try {
                object2 = objectArray[n2];
                this.validateEncoding((ReadValueId)object2);
                logger.debug("nodesToRead[{}]{}", (Object)n2, object2);
                object = NumericRange.parse((String)object2.getIndexRange());
                if (object2.getAttributeId() != Attributes.Value && !object.equals((Object)NumericRange.getEmpty())) {
                    throw new StatusException(StatusCodes.Bad_IndexRangeNoData);
                }
                NodeId nodeId = object2.getNodeId();
                this.readAttribute(serviceContext, treeMap.get(nodeId.getNamespaceIndex()), nodeId, object2.getAttributeId(), (NumericRange)object, timestampsToReturn, (DateTime)d2, (DataValue)objectArray2[n2]);
                logger.debug("results[{}]{}", (Object)n2, objectArray2[n2]);
                if (objectArray2[n2].getStatusCode() == null || objectArray2[n2].getStatusCode().isBad()) {
                    objectArray2[n2].setValue(null);
                }
                Object object3 = objectArray2[n2];
                object = timestampsToReturn;
                switch (1.hd[object.ordinal()]) {
                    case 1: {
                        object3.setServerTimestamp(DateTime.MIN_VALUE);
                        object3.setSourceTimestamp(DateTime.MIN_VALUE);
                        break;
                    }
                    case 2: {
                        object3.setSourceTimestamp(DateTime.MIN_VALUE);
                        if (object3.getServerTimestamp() != null) break;
                        object3.setServerTimestamp(DateTime.currentTime());
                        break;
                    }
                    case 3: {
                        object3.setServerTimestamp(DateTime.MIN_VALUE);
                        break;
                    }
                    case 4: {
                        if (object3.getServerTimestamp() != null) break;
                        object3.setServerTimestamp(DateTime.currentTime());
                    }
                }
                if (!object2.getAttributeId().equals((Object)Attributes.Value) || !logger.isDebugEnabled()) continue;
                logger.debug("TimestampsToReturn: {} AttributeId: {} Node: {}, Server timestamp: {}, Source timestamp: {}", new Object[]{timestampsToReturn, object2.getAttributeId(), nodeId.toString(), objectArray2[n2].getServerTimestamp(), objectArray2[n2].getSourceTimestamp()});
                continue;
            }
            catch (StatusException statusException) {
                logger.debug("StatusException: ", (Throwable)statusException);
                objectArray2[n2].setStatusCode(statusException.getStatusCode());
                diagnosticInfoArray[n2] = statusException.getDiagnosticInfo();
                continue;
            }
            catch (ServiceResultException serviceResultException) {
                logger.debug("ServiceResultException: ", (Throwable)serviceResultException);
                objectArray2[n2].setStatusCode(serviceResultException.getStatusCode());
                object = serviceResultException.getAdditionalTextField();
                if (object == null) continue;
                diagnosticInfoArray[n2] = new DiagnosticInfo();
                diagnosticInfoArray[n2].setAdditionalInfo((String)object);
            }
        }
        this.b(serviceContext, treeMap, (ReadValueId[])objectArray, timestampsToReturn, (DateTime)d2, (DataValue[])objectArray2, diagnosticInfoArray);
        readResponse.setResults((DataValue[])objectArray2);
        n2 = 1;
        object2 = diagnosticInfoArray;
        int n4 = diagnosticInfoArray.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            serviceContext = object2[i2];
            if (serviceContext != null) continue;
            n2 = 0;
            break;
        }
        readResponse.setDiagnosticInfos((DiagnosticInfo[])(n2 != 0 ? diagnosticInfoArray : null));
    }

    protected void readAttribute(ServiceContext serviceContext, Object object, NodeId nodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, TimestampsToReturn timestampsToReturn, DateTime dateTime, DataValue dataValue) throws StatusException {
        this.getNodeManagerTable().readAttribute(serviceContext, object, nodeId, unsignedInteger, numericRange, timestampsToReturn, dateTime, dataValue);
    }

    protected HistoryResult readNodeHistory(ServiceContext serviceContext, Object object, TimestampsToReturn timestampsToReturn, NodeId nodeId, NumericRange numericRange, HistoryContinuationPoint historyContinuationPoint, HistoryReadDetails historyReadDetails, int n2) throws StatusException {
        return this.getNodeManagerTable().historyRead(serviceContext, object, timestampsToReturn, nodeId, numericRange, historyContinuationPoint, historyReadDetails, n2);
    }

    protected void releaseHistoryContinuationPoint(ServiceContext serviceContext, NodeId nodeId, byte[] byArray) throws StatusException {
        this.getNodeManagerTable().releaseHistoryContinuationPoint(serviceContext, nodeId, byArray);
    }

    protected void updateNodeHistory(ServiceContext serviceContext, Object object, HistoryUpdateDetails historyUpdateDetails, HistoryUpdateResult historyUpdateResult) throws StatusException {
        this.getNodeManagerTable().historyUpdate(serviceContext, object, historyUpdateDetails, historyUpdateResult);
    }

    protected void write(ServiceContext serviceContext, WriteRequest objectArray, WriteResponse writeResponse) throws ServiceException {
        Object object;
        Object object2;
        int n2;
        logger.debug("write");
        objectArray = objectArray.getNodesToWrite();
        this.checkRequestLength(objectArray, this.getMaxNodesPerWrite());
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        Object[] objectArray2 = objectArray;
        int n3 = objectArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            object2 = objectArray2[n2];
            object = object2.getNodeId().getNamespaceIndex();
            if (treeMap.containsKey(object)) continue;
            treeMap.put((Integer)object, null);
        }
        objectArray2 = new StatusCode[objectArray.length];
        DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[objectArray.length];
        this.a(serviceContext, treeMap, (WriteValue[])objectArray, (StatusCode[])objectArray2, diagnosticInfoArray);
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            if (objectArray2[n2] != null) continue;
            try {
                object2 = objectArray[n2];
                object = WriteValue.validate((WriteValue)object2);
                if (object != null && object.isBad()) {
                    throw new StatusException(object.getCode());
                }
                object = object2.getNodeId();
                if (this.writeAttribute(serviceContext, treeMap.get(object.getNamespaceIndex()), (NodeId)object, object2.getAttributeId(), NumericRange.parse((String)object2.getIndexRange()), object2.getValue())) {
                    objectArray2[n2] = StatusCode.GOOD;
                    continue;
                }
                objectArray2[n2] = new StatusCode(StatusCodes.Good_CompletesAsynchronously);
                continue;
            }
            catch (StatusException statusException) {
                logger.debug("Write failed", (Throwable)statusException);
                diagnosticInfoArray[n2] = statusException.getDiagnosticInfo();
                objectArray2[n2] = statusException.getStatusCode();
                continue;
            }
            catch (ServiceResultException serviceResultException) {
                objectArray2[n2] = serviceResultException.getStatusCode();
                object = serviceResultException.getAdditionalTextField();
                if (object == null) continue;
                diagnosticInfoArray[n2] = new DiagnosticInfo();
                diagnosticInfoArray[n2].setAdditionalInfo((String)object);
            }
        }
        this.b(serviceContext, treeMap, (WriteValue[])objectArray, (StatusCode[])objectArray2, diagnosticInfoArray);
        writeResponse.setResults((StatusCode[])objectArray2);
        writeResponse.setDiagnosticInfos(diagnosticInfoArray);
    }

    protected boolean writeAttribute(ServiceContext serviceContext, Object object, NodeId nodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, DataValue dataValue) throws StatusException {
        return this.getNodeManagerTable().writeAttribute(serviceContext, object, nodeId, unsignedInteger, numericRange, dataValue);
    }

    static final class 1 {
        static final /* synthetic */ int[] hd;

        static {
            hd = new int[TimestampsToReturn.values().length];
            try {
                1.hd[TimestampsToReturn.Neither.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.hd[TimestampsToReturn.Server.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.hd[TimestampsToReturn.Source.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.hd[TimestampsToReturn.Both.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
        }
    }
}

