/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.server.BrowsePath;
import com.prosysopc.ua.server.InstantiationStrategy;
import com.prosysopc.ua.server.UaNodeBuilderConfiguration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.NodeId;

public abstract class AbstractNodeBuilderConfiguration
implements UaNodeBuilderConfiguration {
    private final Map<InternalEntry, InstantiationStrategy> map = new ConcurrentHashMap<InternalEntry, InstantiationStrategy>();
    private final List<UaNodeBuilderConfiguration> fg = new CopyOnWriteArrayList<UaNodeBuilderConfiguration>();

    @Override
    public final InstantiationStrategy getInstantiationStrategy(UaNodeBuilderConfiguration.InstantiationStrategySearchParameters instantiationStrategySearchParameters) {
        Object object;
        for (UaNodeBuilderConfiguration object22 : this.fg) {
            object = object22.getInstantiationStrategy(instantiationStrategySearchParameters);
            if (object == null) continue;
            return object;
        }
        List<InternalEntry> list = this.getInternalEntries(instantiationStrategySearchParameters);
        Iterator<InternalEntry> iterator = list.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!this.map.containsKey(object)) continue;
            return this.map.get(object);
        }
        return null;
    }

    protected AbstractNodeBuilderConfiguration addSubConfiguration(UaNodeBuilderConfiguration uaNodeBuilderConfiguration) {
        this.fg.add(uaNodeBuilderConfiguration);
        return this;
    }

    protected abstract List<InternalEntry> getInternalEntries(UaNodeBuilderConfiguration.InstantiationStrategySearchParameters var1);

    protected AbstractNodeBuilderConfiguration removeInstantiationStrategy(InternalEntry internalEntry) {
        this.map.remove(internalEntry);
        return this;
    }

    protected AbstractNodeBuilderConfiguration setInstantiationStrategy(InternalEntry internalEntry, InstantiationStrategy instantiationStrategy) {
        if (instantiationStrategy != null) {
            this.map.put(internalEntry, instantiationStrategy);
        } else {
            this.removeInstantiationStrategy(internalEntry);
        }
        return this;
    }

    protected AbstractNodeBuilderConfiguration setInstantiationStrategyIfNotPresent(InternalEntry internalEntry, InstantiationStrategy instantiationStrategy) {
        if (!this.map.containsKey(internalEntry) && instantiationStrategy != null) {
            this.map.put(internalEntry, instantiationStrategy);
        }
        return this;
    }

    protected static final class InternalNodeId
    implements InternalEntry {
        private final NodeId bR;

        protected InternalNodeId(NodeId nodeId) {
            this.bR = nodeId;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            object = (InternalNodeId)object;
            return !(this.bR == null ? ((InternalNodeId)object).bR != null : !this.bR.equals((Object)((InternalNodeId)object).bR));
        }

        public final int hashCode() {
            int n2 = 31 + (this.bR == null ? 0 : this.bR.hashCode());
            return n2;
        }
    }

    protected static final class InternalExpandedNodeId
    implements InternalEntry {
        private final String namespaceUri;
        private final Object value;

        protected InternalExpandedNodeId(ExpandedNodeId expandedNodeId) {
            if (expandedNodeId.getNamespaceUri() == null) {
                throw new IllegalArgumentException("ExpandedNodeId must have NamespaceUri");
            }
            this.namespaceUri = expandedNodeId.getNamespaceUri();
            this.value = expandedNodeId.getValue();
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            object = (InternalExpandedNodeId)object;
            if (this.namespaceUri == null ? ((InternalExpandedNodeId)object).namespaceUri != null : !this.namespaceUri.equals(((InternalExpandedNodeId)object).namespaceUri)) {
                return false;
            }
            return !(this.value == null ? ((InternalExpandedNodeId)object).value != null : !this.value.equals(((InternalExpandedNodeId)object).value));
        }

        public final int hashCode() {
            int n2 = 31 + (this.namespaceUri == null ? 0 : this.namespaceUri.hashCode());
            n2 = n2 * 31 + (this.value == null ? 0 : this.value.hashCode());
            return n2;
        }
    }

    protected static interface InternalEntry {
    }

    protected static final class InternalBrowsePath
    implements InternalEntry {
        private final BrowsePath cS;

        protected InternalBrowsePath(BrowsePath browsePath) {
            this.cS = browsePath;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            object = (InternalBrowsePath)object;
            return !(this.cS == null ? ((InternalBrowsePath)object).cS != null : !this.cS.equals(((InternalBrowsePath)object).cS));
        }

        public final int hashCode() {
            int n2 = 31 + (this.cS == null ? 0 : this.cS.hashCode());
            return n2;
        }
    }
}

