/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client.nodes;

import com.prosysopc.ua.LocalizedTextMap;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.UaAddressSpace;
import com.prosysopc.ua.WriteAccess;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.client.nodes.UaClientReference;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaReferenceType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.core.Attributes;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.NodeAttributes;
import org.opcfoundation.ua.core.NodeClass;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.utils.AttributesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UaNodeImpl
implements UaNode {
    protected static final Logger logger = LoggerFactory.getLogger(UaNodeImpl.class);
    protected static final Map<Class<? extends UaNode>, List<UnsignedInteger>> supportedAttributesMap = new HashMap<Class<? extends UaNode>, List<UnsignedInteger>>();
    private static QualifiedName NODE_VERSION_PROPERTY_NAME = new QualifiedName("NodeVersion");
    private QualifiedName cC;
    private LocalizedTextMap cD = null;
    private LocalizedTextMap cE = null;
    private NodeId nodeId;
    private Map<QualifiedName, UaProperty> cF = null;
    private EnumSet<WriteAccess> cG = WriteAccess.NONE;
    private EnumSet<WriteAccess> cH = WriteAccess.NONE;
    protected final AddressSpace addressSpace;
    protected Set<UaReference> references = new HashSet<UaReference>();

    public UaNodeImpl(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        this.nodeId = nodeId;
        this.cC = qualifiedName;
        this.setDisplayName(localizedText);
        this.addressSpace = addressSpace;
    }

    public UaNodeImpl(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText, LocalizedText localizedText2, EnumSet<WriteAccess> enumSet, EnumSet<WriteAccess> enumSet2, UaClientReference[] uaClientReferenceArray, UaProperty[] uaPropertyArray) {
        this(addressSpace, nodeId, qualifiedName, localizedText);
        this.setDescription(localizedText2);
        this.cH = enumSet;
        this.cG = enumSet2;
        this.references.addAll(Arrays.asList(uaClientReferenceArray));
        this.addProperties(uaPropertyArray);
    }

    public UaNodeImpl(AddressSpace addressSpace, NodeId nodeId, String string, Locale locale) {
        this(addressSpace, nodeId, new QualifiedName(nodeId.getNamespaceIndex(), string), new LocalizedText(string, locale));
    }

    @Override
    public UaReference addComponent(UaNode uaNode) {
        return this.addReference(uaNode, Identifiers.HasComponent, false);
    }

    public void addProperties(UaProperty[] uaPropertyArray) {
        for (UaProperty uaProperty : uaPropertyArray) {
            this.addProperty(uaProperty);
        }
    }

    @Override
    public UaReference addProperty(UaProperty uaProperty) {
        logger.debug("addProperty: property={}", (Object)uaProperty.getBrowseName());
        return this.addReference(uaProperty, Identifiers.HasProperty, false);
    }

    @Override
    public UaReference addReference(NodeId nodeId, NodeId nodeId2, boolean bl) {
        ExpandedNodeId expandedNodeId;
        NodeId nodeId3 = bl ? nodeId : this.getNodeId();
        nodeId = bl ? this.getNodeId() : nodeId;
        try {
            expandedNodeId = this.addressSpace.getNamespaceTable().toExpandedNodeId(nodeId3);
        }
        catch (Exception exception) {
            expandedNodeId = new ExpandedNodeId(nodeId3);
        }
        try {
            nodeId3 = this.addressSpace.getNamespaceTable().toExpandedNodeId(nodeId);
        }
        catch (Exception exception) {
            nodeId3 = new ExpandedNodeId(nodeId);
        }
        return this.addReference(new UaClientReference(nodeId2, expandedNodeId, (ExpandedNodeId)nodeId3, this.addressSpace));
    }

    @Override
    public UaReference addReference(UaNode uaNode, NodeId nodeId, boolean bl) {
        logger.debug("addReference: targetNode={}", (Object)uaNode);
        if (uaNode == null) {
            throw new NullPointerException("targetNode must not be null");
        }
        NodeId nodeId2 = bl ? uaNode.getNodeId() : this.getNodeId();
        uaNode = bl ? this.getNodeId() : uaNode.getNodeId();
        return this.addReference(new UaClientReference(nodeId, new ExpandedNodeId(nodeId2), new ExpandedNodeId((NodeId)uaNode), this.addressSpace));
    }

    @Override
    public UaReference deleteReference(ExpandedNodeId expandedNodeId, NodeId nodeId, boolean bl) {
        logger.debug("deleteReference targetNodeId : {}", (Object)expandedNodeId);
        ArrayList<UaReference> arrayList = new ArrayList<UaReference>();
        for (UaReference uaReference : this.references) {
            ExpandedNodeId expandedNodeId2;
            ExpandedNodeId expandedNodeId3 = bl ? this.nodeId : expandedNodeId;
            Object object = expandedNodeId2 = bl ? expandedNodeId : this.nodeId;
            if (!uaReference.getReferenceTypeId().equals((Object)nodeId) || !uaReference.getTargetId().equals((Object)expandedNodeId3) || !uaReference.getSourceId().equals((Object)expandedNodeId2)) continue;
            arrayList.add(uaReference);
        }
        this.references.removeAll(arrayList);
        if (arrayList.isEmpty()) {
            return null;
        }
        return (UaReference)arrayList.get(0);
    }

    @Override
    public UaReference deleteReference(NodeId nodeId, NodeId nodeId2, boolean bl) {
        return this.deleteReference(new ExpandedNodeId(nodeId), nodeId2, bl);
    }

    @Override
    public UaReference deleteReference(UaNode uaNode, NodeId nodeId, boolean bl) {
        return this.deleteReference(uaNode.getNodeId(), nodeId, bl);
    }

    @Override
    public UaReference deleteReference(UaReference uaReference) {
        if (this.references.remove(uaReference)) {
            this.afterDeleteReference(uaReference);
            return uaReference;
        }
        return null;
    }

    public void deleteReferences(NodeId nodeId) {
        logger.debug("deleteReferences targetNodeId : {}", (Object)nodeId);
        ArrayList<UaReference> arrayList = new ArrayList<UaReference>();
        for (UaReference uaReference : this.references) {
            if (!uaReference.getTargetId().equals((Object)nodeId) && !uaReference.getSourceId().equals((Object)nodeId)) continue;
            arrayList.add(uaReference);
        }
        this.references.removeAll(arrayList);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (UaNode)object;
        if (NodeId.isNull((NodeId)this.nodeId)) {
            return NodeId.isNull((NodeId)object.getNodeId());
        }
        return this.nodeId.equals((Object)object.getNodeId());
    }

    @Override
    public UaAddressSpace getAddressSpace() {
        return this.addressSpace;
    }

    @Override
    public QualifiedName getBrowseName() {
        return this.cC;
    }

    @Override
    public UaNode getComponent(QualifiedName qualifiedName) {
        for (UaReference uaReference : this.getReferences(Identifiers.HasComponent, false)) {
            UaNode object = uaReference.getTargetNode();
            if (object == null || !qualifiedName.equals((Object)object.getBrowseName())) continue;
            return object;
        }
        return null;
    }

    @Override
    public UaNode[] getComponents() {
        UaReference[] uaReferenceArray = this.getReferences(Identifiers.HasComponent, false);
        ArrayList<UaNode> arrayList = new ArrayList<UaNode>(uaReferenceArray.length);
        for (UaReference uaReference : uaReferenceArray) {
            arrayList.add(uaReference.getTargetNode());
        }
        return arrayList.toArray(new UaNode[0]);
    }

    @Override
    public LocalizedText getDescription() {
        return this.getDescription(null);
    }

    public LocalizedText getDescription(Locale locale) {
        if (this.cD != null) {
            return this.cD.getLocalizedText(locale);
        }
        return null;
    }

    @Override
    public LocalizedText getDisplayName() {
        return this.getDisplayName(null);
    }

    public LocalizedText getDisplayName(Locale locale) {
        if (this.cE != null) {
            return this.cE.getLocalizedText(locale);
        }
        return null;
    }

    @Override
    public UaReference[] getForwardReferences(NodeId ... nodeIdArray) {
        return this.getReferences(false, nodeIdArray);
    }

    @Override
    public UaReference[] getInverseReferences(NodeId ... nodeIdArray) {
        return this.getReferences(true, nodeIdArray);
    }

    @Override
    public UaMethod getMethod(QualifiedName qualifiedName) {
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public NodeClass getNodeClass() {
        return NodeClass.Unspecified;
    }

    @Override
    public NodeId getNodeId() {
        return this.nodeId;
    }

    @Override
    public UaProperty getNodeVersion() {
        return this.getProperty(NODE_VERSION_PROPERTY_NAME);
    }

    public String getNodeVersionString() {
        UaProperty uaProperty = this.getNodeVersion();
        uaProperty = uaProperty == null ? null : uaProperty.getValue();
        if (uaProperty == null || uaProperty.isNull()) {
            return null;
        }
        return uaProperty.getValue().toString();
    }

    @Override
    public UaProperty[] getProperties() {
        if (this.cF == null) {
            return null;
        }
        return this.cF.values().toArray(new UaProperty[0]);
    }

    @Override
    public UaProperty getProperty(QualifiedName qualifiedName) {
        if (this.cF == null) {
            return null;
        }
        logger.debug("getProperty: name={}", (Object)qualifiedName);
        return this.cF.get(qualifiedName);
    }

    public DataValue getPropertyValue(QualifiedName qualifiedName) throws StatusException {
        UaProperty uaProperty = this.getProperty(qualifiedName);
        if (uaProperty == null) {
            throw new IllegalArgumentException("Property " + qualifiedName + " does not exist.");
        }
        return uaProperty.getValue();
    }

    @Override
    public UaReference getReference(NodeId nodeId, boolean bl) {
        for (UaReference uaReference : this.references) {
            if (!NodeId.isNull((NodeId)nodeId) && !uaReference.getReferenceTypeId().equals((Object)nodeId) || uaReference.getIsInverse(this) != bl) continue;
            return uaReference;
        }
        return null;
    }

    @Override
    public UaReference[] getReferences() {
        return this.references.toArray(new UaReference[this.references.size()]);
    }

    @Override
    public UaReference[] getReferences(NodeId nodeId, boolean bl) {
        ArrayList<UaReference> arrayList = new ArrayList<UaReference>();
        for (UaReference uaReference : this.references) {
            UaReferenceType uaReferenceType;
            if (!NodeId.isNull((NodeId)nodeId) && ((uaReferenceType = uaReference.getReferenceType()) == null ? !uaReference.getReferenceTypeId().equals((Object)nodeId) : !uaReferenceType.inheritsFrom(nodeId)) || uaReference.getIsInverse(this) != bl) continue;
            arrayList.add(uaReference);
        }
        return arrayList.toArray(new UaReference[arrayList.size()]);
    }

    @Override
    public UnsignedInteger[] getSupportedAttributes() {
        List<UnsignedInteger> list = this.N();
        return list.toArray(new UnsignedInteger[list.size()]);
    }

    @Override
    public EnumSet<WriteAccess> getUserWriteMask() {
        return this.cG;
    }

    @Override
    public EnumSet<WriteAccess> getWriteMask() {
        return this.cH;
    }

    public int hashCode() {
        int n2 = 31 + (this.nodeId == null ? 0 : this.nodeId.hashCode());
        return n2;
    }

    public boolean hasProperty(QualifiedName qualifiedName) {
        return this.cF.containsKey(qualifiedName);
    }

    public boolean hasTypeDefinition() {
        return false;
    }

    @Override
    public boolean hasUserWriteAccess(UnsignedInteger unsignedInteger) {
        return WriteAccess.hasAccessToAttribute(this.cG, unsignedInteger);
    }

    @Override
    public boolean hasWriteAccess(UnsignedInteger unsignedInteger) {
        return WriteAccess.hasAccessToAttribute(this.cH, unsignedInteger);
    }

    @Override
    public DataValue readAttribute(UnsignedInteger unsignedInteger) {
        DataValue dataValue = new DataValue();
        this.readAttribute(unsignedInteger, dataValue, null);
        return dataValue;
    }

    @Override
    public final void readAttribute(UnsignedInteger object, DataValue dataValue, Locale locale) {
        block4: {
            try {
                Locale locale2 = locale;
                DataValue dataValue2 = dataValue;
                locale = object;
                object = this;
                if (locale.equals(Attributes.DisplayName)) {
                    dataValue2.setValue(new Variant((Object)((UaNodeImpl)object).getDisplayName(locale2)));
                    break block4;
                }
                if (locale.equals(Attributes.Description)) {
                    dataValue2.setValue(new Variant((Object)((UaNodeImpl)object).getDescription(locale2)));
                    break block4;
                }
                ((UaNodeImpl)object).readAttributeValue((UnsignedInteger)locale, dataValue2);
                return;
            }
            catch (StatusException statusException) {
                dataValue.setStatusCode(statusException.getStatusCode());
            }
        }
    }

    @Override
    public UaNode removeComponent(UaNode uaNode) {
        UaReference uaReference = this.deleteReference(uaNode, Identifiers.HasComponent, false);
        if (uaReference == null) {
            return null;
        }
        return uaNode;
    }

    @Override
    public UaProperty removeProperty(QualifiedName object) {
        object = this.cF.get(object);
        this.deleteReference((UaNode)object, Identifiers.HasProperty, false);
        return object;
    }

    @Override
    public void setAttribute(UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        if (dataValue == null) {
            logger.warn("dataValue=null");
            this.writeAttributeValue(unsignedInteger, null, StatusCode.BAD, null, null);
            return;
        }
        Object object = dataValue.getStatusCode().isBad() || dataValue.isNull() ? null : dataValue.getValue().getValue();
        this.writeAttributeValue(unsignedInteger, object, dataValue.getStatusCode(), dataValue.getSourceTimestamp(), dataValue.getSourcePicoseconds());
    }

    @Override
    public void setAttributes(NodeAttributes nodeAttributes) {
        this.setDescription(nodeAttributes.getDescription());
    }

    @Override
    public void setBrowseName(QualifiedName qualifiedName) {
        this.cC = qualifiedName;
    }

    @Override
    public void setDescription(LocalizedText localizedText) {
        if (localizedText == null) {
            localizedText = LocalizedText.NULL;
        }
        if (this.cD == null) {
            this.cD = new LocalizedTextMap(localizedText);
            return;
        }
        this.cD.setLocalizedText(localizedText);
    }

    @Override
    public void setDisplayName(LocalizedText localizedText) {
        if (this.cE == null) {
            this.cE = new LocalizedTextMap(localizedText);
            return;
        }
        this.cE.setLocalizedText(localizedText);
    }

    public void setPropertyValue(QualifiedName qualifiedName, Object object) throws StatusException, IllegalArgumentException {
        UaProperty uaProperty = this.getProperty(qualifiedName);
        if (uaProperty == null) {
            throw new IllegalArgumentException("Property " + qualifiedName + " does not exist.");
        }
        if (object instanceof DataValue) {
            qualifiedName = (DataValue)object;
        } else {
            qualifiedName = object instanceof Variant ? (Variant)object : new Variant(object);
            qualifiedName = new DataValue((Variant)qualifiedName);
        }
        uaProperty.setValue((DataValue)qualifiedName);
    }

    @Override
    public void setReferences(UaReference[] uaReferenceArray) {
        this.references.clear();
        this.references.addAll(Arrays.asList(uaReferenceArray));
    }

    @Override
    public void setUserWriteMask(EnumSet<WriteAccess> enumSet) {
        this.cG = enumSet;
    }

    @Override
    public void setWriteMask(EnumSet<WriteAccess> enumSet) {
        this.cH = enumSet;
    }

    @Override
    public boolean supportsAttribute(UnsignedInteger unsignedInteger) {
        return this.N().contains(unsignedInteger);
    }

    public String toString() {
        return String.format("NodeId=%s, NodeClass=%s, BrowseName=%s", this.nodeId, this.getNodeClass(), this.cC);
    }

    @Override
    public final boolean writeAttribute(UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        if (!this.supportsAttribute(unsignedInteger)) {
            throw new StatusException(String.format("Attribute '%s' not supported by node type '%s'", AttributesUtil.toString((UnsignedInteger)unsignedInteger), this.getClass()), StatusCodes.Bad_AttributeIdInvalid);
        }
        if (!this.hasWriteAccess(unsignedInteger)) {
            throw new StatusException(String.format("Attribute '%s' not writable in node '%s(ID=%s)'", AttributesUtil.toString((UnsignedInteger)unsignedInteger), this.getClass(), this.getNodeId()), StatusCodes.Bad_NotWritable);
        }
        try {
            this.setAttribute(unsignedInteger, dataValue);
        }
        catch (ClassCastException classCastException) {
            throw new StatusException("Write failed", StatusCodes.Bad_TypeMismatch);
        }
        return true;
    }

    private List<UnsignedInteger> N() {
        List<UnsignedInteger> list = supportedAttributesMap.get(this.getClass());
        if (list == null) {
            list = new ArrayList<UnsignedInteger>();
            this.initSupportedAttributes(list);
            supportedAttributesMap.put(this.getClass(), list);
        }
        return list;
    }

    protected UaReference addReference(UaReference uaReference) {
        logger.debug("addReference: {}", (Object)uaReference);
        if (this.references.contains(uaReference)) {
            return this.getReference(uaReference.getReferenceTypeId(), uaReference.getIsInverse(this));
        }
        if (!(uaReference instanceof UaClientReference)) {
            throw new IllegalArgumentException("UaNodeImpl.addReference() requires an instance of UaClientReference");
        }
        if (!this.beforeAddReference(uaReference)) {
            return null;
        }
        boolean bl = this.references.add(uaReference);
        logger.debug("result: {}", (Object)bl);
        this.afterAddReference(uaReference);
        return uaReference;
    }

    protected void afterAddReference(UaReference uaReference) {
    }

    protected void afterDeleteReference(UaReference uaReference) {
        UaNode uaNode = uaReference.getTargetNode();
        if (uaNode != null && this.cF != null && uaReference.getReferenceTypeId().equals((Object)Identifiers.HasProperty)) {
            this.cF.remove(uaNode.getBrowseName());
        }
    }

    protected void assertTypeSupport(ExpandedNodeId expandedNodeId) {
        if (expandedNodeId != null && this.getNodeClass() != NodeClass.Object && this.getNodeClass() != NodeClass.Variable) {
            throw new IllegalArgumentException("Type definitions are only available for the NodeClasses Object and Variable");
        }
    }

    protected void assertTypeSupport(NodeId nodeId) {
        if (nodeId != null && this.getNodeClass() != NodeClass.Object && this.getNodeClass() != NodeClass.Variable) {
            throw new IllegalArgumentException("Type definitions are only available for the NodeClasses Object and Variable");
        }
    }

    protected boolean beforeAddReference(UaReference object) {
        if (((UaReference)object).getReferenceTypeId().equals((Object)Identifiers.HasProperty) && !((UaReference)object).getIsInverse(this)) {
            if ((object = ((UaReference)object).getTargetNode()) instanceof UaProperty) {
                return this.doAddProperty((UaProperty)object);
            }
            logger.warn("Target of HasProperty (Source=" + this.getBrowseName() + "--Target=" + (object == null ? "null" : object.getBrowseName()) + ") reference is not UaProperty (i.e. TypeDefinition does not refer to PropertyType)");
        }
        return true;
    }

    protected boolean doAddProperty(UaProperty uaProperty) {
        logger.debug("doAddProperty: {}", (Object)uaProperty);
        if (uaProperty != null) {
            if (this.cF == null) {
                this.cF = new HashMap<QualifiedName, UaProperty>();
            }
            if (this.cF.containsKey(uaProperty.getBrowseName())) {
                return false;
            }
            this.cF.put(uaProperty.getBrowseName(), uaProperty);
            return true;
        }
        return false;
    }

    protected NodeAttributes getAttributes(NodeAttributes nodeAttributes) {
        nodeAttributes.setDescription(this.getDescription());
        nodeAttributes.setDisplayName(this.getDisplayName());
        return nodeAttributes;
    }

    protected UaReference[] getReferences(boolean bl, NodeId ... nodeIdArray) {
        ArrayList<UaReference> arrayList = new ArrayList<UaReference>();
        for (NodeId nodeId : nodeIdArray) {
            UaReference[] uaReferenceArray;
            UaReference[] uaReferenceArray2 = uaReferenceArray = this.getReferences(nodeId, bl);
            int n2 = uaReferenceArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                UaReference uaReference = uaReferenceArray2[i2];
                if (!(bl ? uaReference.getIsInverse(this) : !uaReference.getIsInverse(this))) continue;
                arrayList.add(uaReference);
            }
        }
        return arrayList.toArray(new UaReference[arrayList.size()]);
    }

    protected void initSupportedAttributes(List<UnsignedInteger> list) {
        list.addAll(Arrays.asList(Attributes.NodeId, Attributes.NodeClass, Attributes.BrowseName, Attributes.DisplayName, Attributes.Description, Attributes.WriteMask, Attributes.UserWriteMask));
    }

    protected void readAttributeValue(UnsignedInteger object, DataValue dataValue) throws StatusException {
        if (object.equals((Object)Attributes.NodeId)) {
            dataValue.setValue(new Variant((Object)this.getNodeId()));
            return;
        }
        if (object.equals((Object)Attributes.NodeClass)) {
            object = this.getNodeClass().getValue();
            dataValue.setValue(new Variant(object));
            return;
        }
        if (object.equals((Object)Attributes.BrowseName)) {
            dataValue.setValue(new Variant((Object)this.getBrowseName()));
            return;
        }
        if (object.equals((Object)Attributes.DisplayName)) {
            dataValue.setValue(new Variant((Object)this.getDisplayName()));
            return;
        }
        if (object.equals((Object)Attributes.Description)) {
            dataValue.setValue(new Variant((Object)this.getDescription()));
            return;
        }
        if (object.equals((Object)Attributes.WriteMask)) {
            dataValue.setValue(new Variant((Object)WriteAccess.getMask(this.getWriteMask())));
            return;
        }
        if (object.equals((Object)Attributes.UserWriteMask)) {
            dataValue.setValue(new Variant((Object)WriteAccess.getMask(this.getUserWriteMask())));
            return;
        }
        throw new StatusException(StatusCodes.Bad_AttributeIdInvalid);
    }

    protected void setNodeVersion(String string) throws StatusException {
        this.setPropertyValue(NODE_VERSION_PROPERTY_NAME, string);
    }

    protected void writeAttributeValue(UnsignedInteger unsignedInteger, Object object, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort) throws StatusException {
        logger.debug("writeAttributeValue attributeId={} value={}", (Object)unsignedInteger, object);
        if (unsignedInteger.equals((Object)Attributes.NodeId)) {
            this.nodeId = (NodeId)object;
            return;
        }
        if (unsignedInteger.equals((Object)Attributes.NodeClass)) {
            throw new StatusException(StatusCodes.Bad_WriteNotSupported);
        }
        if (unsignedInteger.equals((Object)Attributes.BrowseName)) {
            this.cC = (QualifiedName)object;
            return;
        }
        if (unsignedInteger.equals((Object)Attributes.DisplayName)) {
            this.setDisplayName((LocalizedText)object);
            return;
        }
        if (unsignedInteger.equals((Object)Attributes.Description)) {
            this.setDescription((LocalizedText)object);
            return;
        }
        if (unsignedInteger.equals((Object)Attributes.WriteMask)) {
            if (object == null) {
                this.cH = WriteAccess.NONE;
                return;
            }
            if (object.getClass().equals(EnumSet.class)) {
                this.cH = (EnumSet)object;
                return;
            }
            this.cH = WriteAccess.getSet((UnsignedInteger)object);
            return;
        }
        if (unsignedInteger.equals((Object)Attributes.UserWriteMask)) {
            if (object == null) {
                this.cG = WriteAccess.NONE;
                return;
            }
            if (object.getClass().equals(EnumSet.class)) {
                this.cG = (EnumSet)object;
                return;
            }
            this.cG = WriteAccess.getSet((UnsignedInteger)object);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Invalid attribute {" + this.getClass() + "}: " + AttributesUtil.toString((UnsignedInteger)unsignedInteger));
        }
        throw new StatusException(StatusCodes.Bad_AttributeIdInvalid);
    }
}

