/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client.nodes;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.WriteAccess;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.client.nodes.UaClientReference;
import com.prosysopc.ua.client.nodes.UaNodeImpl;
import com.prosysopc.ua.nodes.MethodArgumentException;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaProperty;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.ExtensionObject;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.core.Argument;
import org.opcfoundation.ua.core.Attributes;
import org.opcfoundation.ua.core.MethodAttributes;
import org.opcfoundation.ua.core.NodeAttributes;
import org.opcfoundation.ua.core.NodeClass;
import org.opcfoundation.ua.encoding.DecodingException;

public class UaMethodImpl
extends UaNodeImpl
implements UaMethod {
    private static final QualifiedName INPUT_ARGUMENTS = new QualifiedName("InputArguments");
    private static final QualifiedName OUTPUT_ARGUMENTS = new QualifiedName("OutputArguments");
    private Boolean hb = true;
    private Boolean hc = true;

    public UaMethodImpl(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    public UaMethodImpl(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText, LocalizedText localizedText2, EnumSet<WriteAccess> enumSet, EnumSet<WriteAccess> enumSet2, UaClientReference[] uaClientReferenceArray, UaProperty[] uaPropertyArray, Boolean bl, Boolean bl2) {
        super(addressSpace, nodeId, qualifiedName, localizedText, localizedText2, enumSet, enumSet2, uaClientReferenceArray, uaPropertyArray);
        this.hb = bl;
        this.hc = bl2;
    }

    public UaMethodImpl(AddressSpace addressSpace, NodeId nodeId, String string, Locale locale) {
        super(addressSpace, nodeId, string, locale);
    }

    @Override
    public NodeAttributes getAttributes() {
        return this.getAttributes(new MethodAttributes());
    }

    @Override
    public Boolean getExecutable() {
        return this.hb;
    }

    @Override
    public Argument[] getInputArguments() throws MethodArgumentException {
        return this.a(this.getProperty(INPUT_ARGUMENTS));
    }

    @Override
    public final NodeClass getNodeClass() {
        return NodeClass.Method;
    }

    @Override
    public Argument[] getOutputArguments() throws MethodArgumentException {
        return this.a(this.getProperty(OUTPUT_ARGUMENTS));
    }

    @Override
    public Boolean getUserExecutable() {
        return this.hc;
    }

    public void setAttributes(MethodAttributes methodAttributes) {
        super.setAttributes((NodeAttributes)methodAttributes);
        this.setExecutable(methodAttributes.getExecutable());
    }

    @Override
    public void setExecutable(Boolean bl) {
        this.hb = bl;
    }

    @Override
    public void setUserExecutable(Boolean bl) {
        this.hc = bl;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    private Argument[] a(UaProperty objectArray) throws MethodArgumentException {
        if (objectArray == null || objectArray.getValue().isNull()) {
            return new Argument[0];
        }
        if (!objectArray.getValue().getValue().isArray()) {
            throw new MethodArgumentException("Property is not an array: " + objectArray.getBrowseName());
        }
        if ((objectArray = (Object[])objectArray.getValue().getValue().getValue()) instanceof Argument[]) {
            return (Argument[])objectArray;
        }
        int n2 = objectArray.length;
        Argument[] argumentArray = new Argument[n2];
        if (objectArray instanceof Structure[]) {
            objectArray = (Structure[])objectArray;
            for (int i2 = 0; i2 < n2; ++i2) {
                try {
                    argumentArray[i2] = (Argument)objectArray[i2];
                    continue;
                }
                catch (ClassCastException classCastException) {
                    throw new MethodArgumentException("Cannot cast argument value #" + i2 + " " + objectArray[i2]);
                }
            }
        } else if (objectArray instanceof ExtensionObject[]) {
            objectArray = (ExtensionObject[])objectArray;
            for (int i3 = 0; i3 < n2; ++i3) {
                try {
                    argumentArray[i3] = (Argument)objectArray[i3].decode(this.addressSpace.getClient().getEncoderContext());
                    continue;
                }
                catch (DecodingException decodingException) {
                    throw new MethodArgumentException("Cannot decode argument value #" + i3);
                }
            }
        } else {
            throw new MethodArgumentException("Cannot cast arguments from " + objectArray);
        }
        return argumentArray;
    }

    protected NodeAttributes getAttributes(MethodAttributes methodAttributes) {
        super.getAttributes((NodeAttributes)methodAttributes);
        methodAttributes.setExecutable(this.getExecutable());
        methodAttributes.setUserExecutable(this.getUserExecutable());
        return methodAttributes;
    }

    @Override
    protected void initSupportedAttributes(List<UnsignedInteger> list) {
        super.initSupportedAttributes(list);
        list.add(Attributes.Executable);
        list.add(Attributes.UserExecutable);
    }

    @Override
    protected void readAttributeValue(UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        if (unsignedInteger.equals((Object)Attributes.Executable)) {
            dataValue.setValue(new Variant((Object)this.hb));
            return;
        }
        if (unsignedInteger.equals((Object)Attributes.UserExecutable)) {
            dataValue.setValue(new Variant((Object)this.hc));
            return;
        }
        super.readAttributeValue(unsignedInteger, dataValue);
    }

    @Override
    protected void writeAttributeValue(UnsignedInteger unsignedInteger, Object object, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort) throws StatusException {
        if (unsignedInteger.equals((Object)Attributes.Executable)) {
            this.hb = (Boolean)object;
            return;
        }
        if (unsignedInteger.equals((Object)Attributes.UserExecutable)) {
            this.hc = (Boolean)object;
            return;
        }
        super.writeAttributeValue(unsignedInteger, object, statusCode, dateTime, unsignedShort);
    }
}

