/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client.nodes;

import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaReferenceType;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaClientReference
extends UaReference {
    private static Logger logger = LoggerFactory.getLogger(UaClientReference.class);
    private final AddressSpace addressSpace;
    private final NodeId bu;
    private final ExpandedNodeId eE;
    private final ExpandedNodeId eF;

    public UaClientReference(NodeId nodeId, ExpandedNodeId expandedNodeId, ExpandedNodeId expandedNodeId2, AddressSpace addressSpace) {
        this.bu = nodeId;
        this.eF = expandedNodeId2;
        this.eE = expandedNodeId;
        this.addressSpace = addressSpace;
    }

    public UaClientReference(NodeId nodeId, UaNode uaNode, UaNode uaNode2, AddressSpace addressSpace) {
        this(nodeId, new ExpandedNodeId(uaNode.getNodeId()), new ExpandedNodeId(uaNode2.getNodeId()), addressSpace);
    }

    @Override
    public void delete() {
        UaNode uaNode = this.getSourceNode();
        UaNode uaNode2 = this.getTargetNode();
        if (uaNode != null) {
            uaNode.deleteReference(this);
        }
        if (uaNode2 != null) {
            uaNode2.deleteReference(this);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (UaClientReference)object;
        if (this.eF == null ? ((UaClientReference)object).eF != null : !this.addressSpace.getNamespaceTable().nodeIdEquals(this.eF, ((UaClientReference)object).eF)) {
            return false;
        }
        if (this.eE == null ? ((UaClientReference)object).eE != null : !this.addressSpace.getNamespaceTable().nodeIdEquals(this.eE, ((UaClientReference)object).eE)) {
            return false;
        }
        return !(this.bu == null ? ((UaClientReference)object).bu != null : !this.bu.equals((Object)((UaClientReference)object).bu));
    }

    @Override
    public boolean getIsInverse(NodeId nodeId) {
        logger.debug("getIsInverse: nodeId={} sourceId={} targetId={}", new Object[]{nodeId, this.eE, this.eF});
        if (this.addressSpace.getNamespaceTable().nodeIdEquals(nodeId, this.eE)) {
            return false;
        }
        if (this.addressSpace.getNamespaceTable().nodeIdEquals(nodeId, this.eF)) {
            return true;
        }
        throw new RuntimeException("getIsInverse() called from non-related node");
    }

    @Override
    public boolean getIsInverse(UaNode uaNode) {
        return this.getIsInverse(uaNode.getNodeId());
    }

    @Override
    public UaReferenceType getReferenceType() {
        UaNode uaNode = this.c(this.bu);
        if (uaNode instanceof UaReferenceType) {
            return (UaReferenceType)uaNode;
        }
        return null;
    }

    @Override
    public NodeId getReferenceTypeId() {
        return this.bu;
    }

    @Override
    public ExpandedNodeId getSourceId() {
        return this.eE;
    }

    @Override
    public UaNode getSourceNode() {
        UaNode uaNode = this.a(this.eE);
        return uaNode;
    }

    @Override
    public ExpandedNodeId getTargetId() {
        return this.eF;
    }

    @Override
    public UaNode getTargetNode() {
        UaNode uaNode = this.a(this.eF);
        return uaNode;
    }

    public int hashCode() {
        int n2 = 31 + (this.bu == null ? 0 : this.bu.hashCode());
        n2 = n2 * 31 + (this.eF == null ? 0 : this.eF.hashCode());
        n2 = n2 * 31 + (this.eE == null ? 0 : this.eE.hashCode());
        return n2;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("");
        UaReferenceType uaReferenceType = this.addressSpace.getClient().isConnected() ? this.getReferenceType() : null;
        if (uaReferenceType != null) {
            stringBuilder.append(" ReferenceType=");
            stringBuilder.append(uaReferenceType.getBrowseName());
        } else {
            stringBuilder.append(" ReferenceTypeId=");
            stringBuilder.append(this.getReferenceTypeId());
        }
        stringBuilder.append(" SourceId=");
        stringBuilder.append(this.getSourceId());
        stringBuilder.append(" TargetId=");
        stringBuilder.append(this.getTargetId());
        return stringBuilder.toString();
    }

    private UaNode a(ExpandedNodeId expandedNodeId) {
        try {
            return this.c(this.addressSpace.getNamespaceTable().toNodeId(expandedNodeId));
        }
        catch (Exception exception) {
            logger.warn("Unable to retrieve node from AddressSpace: ", (Throwable)exception);
            return null;
        }
    }

    private UaNode c(NodeId nodeId) {
        try {
            return this.addressSpace.getNode(nodeId);
        }
        catch (Exception exception) {
            logger.warn("Unable to retrieve node from AddressSpace: ", (Throwable)exception);
            return null;
        }
    }
}

