/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client.nodes;

import com.prosysopc.ua.RegisteredClasses;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.client.nodes.UaDataTypeImpl;
import com.prosysopc.ua.client.nodes.UaMethodImpl;
import com.prosysopc.ua.client.nodes.UaObjectImpl;
import com.prosysopc.ua.client.nodes.UaObjectTypeImpl;
import com.prosysopc.ua.client.nodes.UaPropertyImpl;
import com.prosysopc.ua.client.nodes.UaReferenceTypeImpl;
import com.prosysopc.ua.client.nodes.UaVariableImpl;
import com.prosysopc.ua.client.nodes.UaVariableTypeImpl;
import com.prosysopc.ua.client.nodes.UaViewImpl;
import com.prosysopc.ua.nodes.UaInstance;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaNodeFactory;
import com.prosysopc.ua.nodes.UaNodeFactoryException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.NodeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaClientNodeFactory
implements UaNodeFactory {
    private final AddressSpace addressSpace;
    private final Map<NodeClass, Constructor<? extends UaNode>> eR;
    private Map<NodeId, Constructor<? extends UaNode>> eT;
    protected final Logger logger = LoggerFactory.getLogger(UaClientNodeFactory.class);
    private RegisteredClasses eS;

    public UaClientNodeFactory(AddressSpace addressSpace) {
        this.eR = new HashMap<NodeClass, Constructor<? extends UaNode>>();
        this.eT = new HashMap<NodeId, Constructor<? extends UaNode>>();
        try {
            this.registerNodeClass(NodeClass.Object, UaObjectImpl.class);
            this.registerNodeClass(NodeClass.Variable, UaVariableImpl.class);
            this.registerNodeClass(NodeClass.Method, UaMethodImpl.class);
            this.registerNodeClass(NodeClass.ObjectType, UaObjectTypeImpl.class);
            this.registerNodeClass(NodeClass.VariableType, UaVariableTypeImpl.class);
            this.registerNodeClass(NodeClass.ReferenceType, UaReferenceTypeImpl.class);
            this.registerNodeClass(NodeClass.DataType, UaDataTypeImpl.class);
            this.registerNodeClass(NodeClass.View, UaViewImpl.class);
            this.registerTypeDefinition(Identifiers.PropertyType, UaPropertyImpl.class);
        }
        catch (UaNodeFactoryException uaNodeFactoryException) {
            UaNodeFactoryException uaNodeFactoryException2 = uaNodeFactoryException;
            uaNodeFactoryException.printStackTrace();
        }
        this.addressSpace = addressSpace;
        this.eS = addressSpace != null ? addressSpace.getClient().getRegisteredClasses() : null;
    }

    @Override
    public UaNode createNode(NodeClass nodeClass, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) throws UaNodeFactoryException {
        return this.createNode(nodeClass, nodeId, qualifiedName, localizedText, (NodeId)null);
    }

    @Override
    public UaNode createNode(NodeClass object, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText, ExpandedNodeId expandedNodeId) throws UaNodeFactoryException {
        object = this.getConstructor((NodeClass)object, expandedNodeId);
        return this.a((Constructor<? extends UaNode>)object, nodeId, qualifiedName, localizedText, expandedNodeId);
    }

    @Override
    public UaNode createNode(NodeClass object, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText, NodeId nodeId2) throws UaNodeFactoryException {
        object = this.getConstructor((NodeClass)object, nodeId2);
        return this.a((Constructor<? extends UaNode>)object, nodeId, qualifiedName, localizedText, nodeId2 == null ? null : new ExpandedNodeId(nodeId2));
    }

    @Override
    public UaNode createNode(NodeClass nodeClass, NodeId nodeId, String string, Locale locale) throws UaNodeFactoryException {
        return this.createNode(nodeClass, nodeId, new QualifiedName(string), new LocalizedText(string, locale));
    }

    @Override
    public UaNode createNode(NodeClass nodeClass, NodeId nodeId, String string, Locale locale, ExpandedNodeId expandedNodeId) throws UaNodeFactoryException {
        return this.createNode(nodeClass, nodeId, new QualifiedName(string), new LocalizedText(string, locale), expandedNodeId);
    }

    @Override
    public UaNode createNode(NodeClass nodeClass, NodeId nodeId, String string, Locale locale, NodeId nodeId2) throws UaNodeFactoryException {
        return this.createNode(nodeClass, nodeId, new QualifiedName(string), new LocalizedText(string, locale), nodeId2);
    }

    @Override
    public Class<? extends UaNode> getClassType(NodeClass nodeClass, ExpandedNodeId expandedNodeId) {
        return this.getConstructor(nodeClass, expandedNodeId).getDeclaringClass();
    }

    @Override
    public Class<? extends UaNode> getClassType(NodeClass nodeClass, NodeId nodeId) {
        return this.getConstructor(nodeClass, nodeId).getDeclaringClass();
    }

    @Override
    public void registerNodeClass(NodeClass nodeClass, Class<? extends UaNode> clazz) throws UaNodeFactoryException {
        this.eR.put(nodeClass, UaClientNodeFactory.a(clazz));
    }

    @Override
    public void registerTypeDefinition(NodeId nodeId, Class<? extends UaNode> clazz) throws UaNodeFactoryException {
        this.eT.put(nodeId, UaClientNodeFactory.a(clazz));
    }

    private UaNode a(Constructor<? extends UaNode> constructor, NodeId object, QualifiedName qualifiedName, LocalizedText localizedText, ExpandedNodeId expandedNodeId) throws UaNodeFactoryException {
        this.logger.debug("createInstance: {}", constructor);
        try {
            object = constructor.newInstance(this.addressSpace, object, qualifiedName, localizedText);
            if (object instanceof UaInstance) {
                ((UaInstance)object).setTypeDefinitionId(expandedNodeId);
            }
            return object;
        }
        catch (Exception exception) {
            throw new UaNodeFactoryException("Cannot create a new UaNode instance of class " + constructor.getName(), exception);
        }
    }

    private static Constructor<? extends UaNode> a(Class<? extends UaNode> clazz) throws UaNodeFactoryException {
        try {
            Constructor<? extends UaNode> constructor = clazz.getDeclaredConstructor(AddressSpace.class, NodeId.class, QualifiedName.class, LocalizedText.class);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new UaNodeFactoryException("Cannot create a new UaNode instance: The constructor(NodeId, QualifiedName, LocalizedText) is not found from class " + clazz.getName(), noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new UaNodeFactoryException("Cannot create a new UaNode instance: The constructor(NodeId, QualifiedName, LocalizedText) is not public or accessible in class " + clazz.getName(), securityException);
        }
    }

    protected Constructor<? extends UaNode> getConstructor(NodeClass nodeClass, ExpandedNodeId expandedNodeId) {
        NodeId nodeId = null;
        if (!ExpandedNodeId.isNull((ExpandedNodeId)expandedNodeId) && expandedNodeId.isLocal()) {
            try {
                nodeId = this.addressSpace.getNamespaceTable().toNodeId(expandedNodeId);
            }
            catch (ServiceResultException serviceResultException) {
                this.logger.warn("ServiceResultException: ", (Throwable)serviceResultException);
            }
        }
        return this.getConstructor(nodeClass, nodeId);
    }

    protected Constructor<? extends UaNode> getConstructor(NodeClass nodeClass, NodeId nodeId) {
        if (nodeId != null) {
            if (this.eT.containsKey(nodeId)) {
                return this.eT.get(nodeId);
            }
            nodeId = new ExpandedNodeId(null, this.addressSpace.getNamespaceTable().getUri(nodeId.getNamespaceIndex()), nodeId.getValue());
            if (this.eS.containsClass((ExpandedNodeId)nodeId)) {
                return UaClientNodeFactory.a(this.eS.getClass((ExpandedNodeId)nodeId));
            }
        }
        return this.eR.get(nodeClass);
    }
}

