/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client;

import com.prosysopc.ua.ApplicationIdentity;
import com.prosysopc.ua.MethodCallStatusException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.SessionActivationException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.SubscriptionBase;
import com.prosysopc.ua.UaAddress;
import com.prosysopc.ua.UaApplication;
import com.prosysopc.ua.UserIdentity;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.client.ConnectException;
import com.prosysopc.ua.client.InvalidServerEndpointException;
import com.prosysopc.ua.client.ServerConnectionException;
import com.prosysopc.ua.client.ServerStatusListener;
import com.prosysopc.ua.client.Subscription;
import com.prosysopc.ua.client.UaClientListener;
import com.prosysopc.ua.types.opcua.OperationLimitsType;
import com.prosysopc.ua.types.opcua.client.InformationModel;
import com.prosysopc.ua.types.opcua.client.OperationLimitsTypeImpl;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.opcfoundation.ua.application.Application;
import org.opcfoundation.ua.application.Client;
import org.opcfoundation.ua.application.Session;
import org.opcfoundation.ua.application.SessionChannel;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.ExtensionObject;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.ServiceRequest;
import org.opcfoundation.ua.builtintypes.ServiceResponse;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedByte;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.common.NamespaceTable;
import org.opcfoundation.ua.common.ServerTable;
import org.opcfoundation.ua.common.ServiceFaultException;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.ActivateSessionResponse;
import org.opcfoundation.ua.core.AggregateConfiguration;
import org.opcfoundation.ua.core.ApplicationDescription;
import org.opcfoundation.ua.core.Attributes;
import org.opcfoundation.ua.core.BuildInfo;
import org.opcfoundation.ua.core.CallMethodRequest;
import org.opcfoundation.ua.core.CallRequest;
import org.opcfoundation.ua.core.CallResponse;
import org.opcfoundation.ua.core.CreateSubscriptionResponse;
import org.opcfoundation.ua.core.DeleteAtTimeDetails;
import org.opcfoundation.ua.core.DeleteEventDetails;
import org.opcfoundation.ua.core.DeleteRawModifiedDetails;
import org.opcfoundation.ua.core.DeleteSubscriptionsResponse;
import org.opcfoundation.ua.core.EndpointConfiguration;
import org.opcfoundation.ua.core.EndpointDescription;
import org.opcfoundation.ua.core.EventFilter;
import org.opcfoundation.ua.core.GetEndpointsRequest;
import org.opcfoundation.ua.core.HistoryData;
import org.opcfoundation.ua.core.HistoryEvent;
import org.opcfoundation.ua.core.HistoryEventFieldList;
import org.opcfoundation.ua.core.HistoryModifiedData;
import org.opcfoundation.ua.core.HistoryReadDetails;
import org.opcfoundation.ua.core.HistoryReadResult;
import org.opcfoundation.ua.core.HistoryReadValueId;
import org.opcfoundation.ua.core.HistoryUpdateDetails;
import org.opcfoundation.ua.core.HistoryUpdateResponse;
import org.opcfoundation.ua.core.HistoryUpdateResult;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.MessageSecurityMode;
import org.opcfoundation.ua.core.ModificationInfo;
import org.opcfoundation.ua.core.ModifySubscriptionResponse;
import org.opcfoundation.ua.core.PerformUpdateType;
import org.opcfoundation.ua.core.PublishRequest;
import org.opcfoundation.ua.core.PublishResponse;
import org.opcfoundation.ua.core.ReadAtTimeDetails;
import org.opcfoundation.ua.core.ReadEventDetails;
import org.opcfoundation.ua.core.ReadProcessedDetails;
import org.opcfoundation.ua.core.ReadRawModifiedDetails;
import org.opcfoundation.ua.core.ReadRequest;
import org.opcfoundation.ua.core.ReadResponse;
import org.opcfoundation.ua.core.ReadValueId;
import org.opcfoundation.ua.core.RequestHeader;
import org.opcfoundation.ua.core.ResponseHeader;
import org.opcfoundation.ua.core.ServerState;
import org.opcfoundation.ua.core.ServerStatusDataType;
import org.opcfoundation.ua.core.SignatureData;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.core.SubscriptionAcknowledgement;
import org.opcfoundation.ua.core.TimestampsToReturn;
import org.opcfoundation.ua.core.TransferResult;
import org.opcfoundation.ua.core.TransferSubscriptionsResponse;
import org.opcfoundation.ua.core.UpdateDataDetails;
import org.opcfoundation.ua.core.UpdateEventDetails;
import org.opcfoundation.ua.core.UpdateStructureDataDetails;
import org.opcfoundation.ua.core.UserIdentityToken;
import org.opcfoundation.ua.core.UserTokenPolicy;
import org.opcfoundation.ua.core.WriteRequest;
import org.opcfoundation.ua.core.WriteResponse;
import org.opcfoundation.ua.core.WriteValue;
import org.opcfoundation.ua.encoding.DecodingException;
import org.opcfoundation.ua.encoding.EncoderContext;
import org.opcfoundation.ua.encoding.EncodingException;
import org.opcfoundation.ua.transport.AsyncResult;
import org.opcfoundation.ua.transport.ChannelService;
import org.opcfoundation.ua.transport.RequestChannel;
import org.opcfoundation.ua.transport.ResultListener;
import org.opcfoundation.ua.transport.SecureChannel;
import org.opcfoundation.ua.transport.TransportChannelSettings;
import org.opcfoundation.ua.transport.https.HttpsSettings;
import org.opcfoundation.ua.transport.impl.AsyncResultImpl;
import org.opcfoundation.ua.transport.security.Cert;
import org.opcfoundation.ua.transport.security.HttpsSecurityPolicy;
import org.opcfoundation.ua.transport.security.KeyPair;
import org.opcfoundation.ua.transport.security.SecurityMode;
import org.opcfoundation.ua.transport.security.SecurityPolicy;
import org.opcfoundation.ua.utils.EndpointUtil;
import org.opcfoundation.ua.utils.MultiDimensionArrayUtils;
import org.opcfoundation.ua.utils.NumericRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaClient
extends UaApplication {
    public static final Double MAX_CACHE_AGE = new Double(2.147483647E9);
    private static UaApplication.Protocol aq = UaApplication.Protocol.OpcTcp;
    private static Logger logger = LoggerFactory.getLogger(UaClient.class);
    private List<SubscriptionAcknowledgement> ar = new ArrayList<SubscriptionAcknowledgement>();
    private UaAddress as;
    private AddressSpace addressSpace;
    private ApplicationIdentity applicationIdentity = new ApplicationIdentity();
    private String at = null;
    private volatile boolean au = true;
    private final AtomicReference<SessionChannel> channel = new AtomicReference<Object>(null);
    private Client client;
    private UnsignedInteger av = UnsignedInteger.valueOf((long)0L);
    private EndpointDescription[] aw;
    private EndpointDescription endpoint;
    private final EndpointConfiguration endpointConfiguration = EndpointConfiguration.defaults();
    private volatile boolean ax;
    private final HttpsSettings httpsSettings = new HttpsSettings();
    private boolean ay;
    private final AtomicReference<DiagnosticInfo[]> az = new AtomicReference<Object>(null);
    private final AtomicLong aA = new AtomicLong();
    private final AtomicReference<ResponseHeader> aB = new AtomicReference<Object>(null);
    private OperationLimitsType aC;
    private UaClientListener aD = null;
    private Locale locale = Locale.getDefault();
    private UnsignedInteger aE = UnsignedInteger.ZERO;
    private boolean aF;
    private EnumSet<UaApplication.DiagnosticMask> aG = EnumSet.noneOf(UaApplication.DiagnosticMask.class);
    private double aH = 2.0;
    private UnsignedInteger aI = UnsignedInteger.MAX_VALUE;
    private a aJ;
    private volatile Thread aK;
    private SecureChannel aL;
    private SecurityMode aM = SecurityMode.BASIC128RSA15_SIGN_ENCRYPT;
    private ApplicationIdentity aN = new ApplicationIdentity();
    private final AtomicReference<ServerStatusDataType> aO = new AtomicReference<Object>(null);
    private final AtomicReference<StatusCode> aP = new AtomicReference<Object>(null);
    private final List<ServerStatusListener> aQ = new CopyOnWriteArrayList<ServerStatusListener>();
    private boolean aR;
    private final AtomicLong aS = new AtomicLong(0L);
    private EnumSet<UaApplication.DiagnosticMask> aT = EnumSet.noneOf(UaApplication.DiagnosticMask.class);
    private volatile Session session;
    private String aU;
    private Double aV = 3600000.0;
    private long aW;
    private long aX = 1000L;
    private long aY = 10000L;
    private UnsignedInteger aZ = null;
    private UserIdentity ba = new UserIdentity();
    private boolean bb = true;
    final List<Subscription> bc = new CopyOnWriteArrayList<Subscription>();

    public static UaApplication.Protocol getDefaultProtocol() {
        return aq;
    }

    public static void setDefaultProtocol(UaApplication.Protocol protocol) {
        aq = protocol;
    }

    public UaClient() {
    }

    public UaClient(String string) throws URISyntaxException {
        this();
        this.setUri(string);
    }

    public UaClient(UaAddress uaAddress) {
        this.setAddress(uaAddress);
    }

    public void addServerStatusListener(ServerStatusListener serverStatusListener) {
        if (!this.hasServerStatusListener(serverStatusListener)) {
            this.aQ.add(serverStatusListener);
        }
    }

    public Subscription addSubscription(Subscription subscription) throws ServiceException, StatusException {
        logger.debug("addSubscription ID was:{}", (Object)subscription.getSubscriptionId());
        if (subscription.getClient() != null) {
            subscription.transferTo(this);
        } else {
            subscription.setClient(this);
            if (!this.bc.contains(subscription)) {
                this.bc.add(subscription);
            }
            if (this.isConnected()) {
                this.a(subscription, false);
            }
        }
        logger.debug("addSubscription: added subscription={}", (Object)subscription);
        this.x();
        return subscription;
    }

    public CallResponse call(CallMethodRequest ... callResponse) throws ServiceException {
        try {
            callResponse = this.D().Call(this.getRequestHeader(), (CallMethodRequest[])callResponse);
            this.checkServiceResult((ServiceResponse)callResponse, callResponse.getDiagnosticInfos());
            return callResponse;
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
    }

    public Variant[] call(NodeId nodeId, NodeId nodeId2, Variant ... variantArray) throws ServiceException, MethodCallStatusException {
        nodeId = new CallMethodRequest(nodeId, nodeId2, variantArray);
        nodeId = this.call(new CallMethodRequest[]{nodeId});
        nodeId2 = nodeId.getResults()[0];
        variantArray = (nodeId = nodeId.getDiagnosticInfos()) == null || ((DiagnosticInfo[])nodeId).length == 0 ? null : nodeId[0];
        nodeId = nodeId2;
        if (nodeId.getStatusCode().isBad()) {
            throw new MethodCallStatusException(nodeId.getStatusCode(), (DiagnosticInfo)variantArray, nodeId.getInputArgumentResults(), nodeId.getInputArgumentDiagnosticInfos());
        }
        return nodeId2.getOutputArguments();
    }

    public AsyncResult<ServiceResponse> callAsync(CallMethodRequest ... callMethodRequestArray) {
        return this.D().CallAsync(new CallRequest(this.getRequestHeader(), callMethodRequestArray));
    }

    public synchronized void connect() throws ServiceException, ConnectException, SessionActivationException, InvalidServerEndpointException {
        logger.debug("connect");
        if (!this.isConnected()) {
            try {
                UaClient uaClient;
                this.u();
                if (this.endpoint == null) {
                    this.v();
                }
                this.t();
                this.n();
                this.o();
                if (this.aD != null) {
                    this.aD.onAfterCreateSessionChannel(this, this.getSession());
                }
                this.j();
                try {
                    uaClient = this;
                    Cert cert = uaClient.getSession().getServerCertificate();
                    if (cert == null && !uaClient.aM.getMessageSecurityMode().equals((Object)MessageSecurityMode.None)) {
                        throw new StatusException("Missing server certificate", StatusCodes.Bad_CertificateInvalid);
                    }
                    if (!uaClient.getEndpoint().needsCertificate() && cert != null) {
                        logger.info("Server sent a certificate, although SecurityPolicy NONE is used");
                    }
                    uaClient.aN = new ApplicationIdentity(cert, null);
                    uaClient.aN.addSoftwareCertificates(uaClient.getSession().getServerSoftwareCertificates());
                    cert = uaClient.getSession().getEndpoint().getServer();
                    uaClient.aN.setApplicationDescription((ApplicationDescription)cert);
                    if (!uaClient.aM.getMessageSecurityMode().equals((Object)MessageSecurityMode.None) && (uaClient = uaClient.validateApplicationCertificate(uaClient.aN)).isBad()) {
                        throw new StatusException("Invalid server certificate", (StatusCode)uaClient);
                    }
                }
                catch (StatusException statusException) {
                    throw new ServiceException("Invalid server certificate", statusException.getStatusCode());
                }
                this.l();
                this.startPublishing();
                this.getAddressSpace().aC();
                this.registerModel(InformationModel.MODEL);
                uaClient = this;
                try {
                    uaClient.aC = (OperationLimitsTypeImpl)uaClient.getAddressSpace().getNode(Identifiers.Server_ServerCapabilities_OperationLimits);
                }
                catch (Exception exception) {
                    logger.debug("Failed to init OperationLimits: " + exception);
                    return;
                }
            }
            catch (ServiceException serviceException) {
                this.disconnect();
                throw serviceException;
            }
            catch (RuntimeException runtimeException) {
                this.disconnect();
                throw runtimeException;
            }
        }
    }

    public void disconnect() {
        this.disconnect(60000L);
    }

    public void disconnect(long l2) {
        this.disconnect(UnsignedInteger.valueOf((long)l2));
    }

    public void disconnect(long l2, TimeUnit timeUnit) {
        this.disconnect(timeUnit.toMillis(l2));
    }

    public synchronized void disconnect(UnsignedInteger object) {
        this.stopPublishing();
        this.a((UnsignedInteger)object);
        object = this;
        object.aO.set(null);
        object.aP.set(null);
        object.aS.set(0L);
        object.aN = null;
        object.aC = null;
    }

    public EndpointDescription[] discoverEndpoints() throws InvalidServerEndpointException, ConnectException, ServiceException {
        return this.discoverEndpoints(this.getProtocol());
    }

    public EndpointDescription[] discoverEndpoints(UaApplication.Protocol ... protocolArray) throws InvalidServerEndpointException, ConnectException, ServiceException {
        Client client;
        block7: {
            client = this.client != null ? this.client : Client.createClientApplication(null);
            String string = this.getUri();
            if (logger.isDebugEnabled()) {
                logger.debug("discoverEndpoints: connectUri=" + string + " protocols=" + Arrays.toString((Object[])protocolArray));
            }
            SecurityMode securityMode = SecurityMode.NONE;
            client = client.createSecureChannel(string, "", securityMode, null);
            securityMode = new ChannelService((RequestChannel)client);
            try {
                protocolArray = this.a((ChannelService)securityMode, string, protocolArray);
                if (protocolArray != null && protocolArray.length != 0) break block7;
                protocolArray = this.a((ChannelService)securityMode, null, new UaApplication.Protocol[0]);
            }
            catch (Throwable throwable) {
                try {
                    client.close();
                    client.dispose();
                    throw throwable;
                }
                catch (ServiceResultException serviceResultException) {
                    logger.debug("Connection failed", (Throwable)serviceResultException);
                    if (serviceResultException.getStatusCode().getValue().equals((Object)StatusCodes.Bad_ServerUriInvalid)) {
                        throw new InvalidServerEndpointException("Server URI invalid", this.getUri(), null, serviceResultException);
                    }
                    throw new ConnectException("Failed to retrieve endpoints. The server is not available", this.getUri(), null, serviceResultException);
                }
            }
        }
        client.close();
        client.dispose();
        return protocolArray;
    }

    public ReadResponse doRead(Double d2, TimestampsToReturn timestampsToReturn, ReadValueId ... readValueIdArray) throws ServiceException {
        try {
            d2 = this.D().Read(this.getRequestHeader(), d2, timestampsToReturn, readValueIdArray);
            this.checkServiceResult((ServiceResponse)d2, d2.getDiagnosticInfos());
            UaClient.a(d2.getResults(), readValueIdArray);
            return d2;
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
    }

    @Override
    public AddressSpace getAddressSpace() {
        if (this.addressSpace == null) {
            this.addressSpace = new AddressSpace(this);
        }
        return this.addressSpace;
    }

    public ApplicationIdentity getApplicationIdentity() {
        return this.applicationIdentity;
    }

    public String getAuditEntryId() {
        return this.at;
    }

    @Override
    public EncoderContext getEncoderContext() {
        if (this.client == null) {
            throw new IllegalStateException("EncoderContext is not available before the client is initialized (i.e. connected)");
        }
        this.u();
        return this.client.getEncoderContext();
    }

    public EndpointDescription getEndpoint() {
        return this.endpoint;
    }

    public EndpointConfiguration getEndpointConfiguration() {
        return this.endpointConfiguration;
    }

    public String getHost() {
        if (this.as == null) {
            return "";
        }
        return this.as.getHost();
    }

    public HttpsSettings getHttpsSettings() {
        if (this.client != null) {
            return this.client.getApplicationHttpsSettings();
        }
        return this.httpsSettings;
    }

    public DiagnosticInfo[] getLastOperationDiagnostics() {
        return this.az.get();
    }

    public DateTime getLastResponseTimestamp() {
        return this.aB.get().getTimestamp();
    }

    public DiagnosticInfo getLastServiceDiagnostics() {
        return this.aB.get().getServiceDiagnostics();
    }

    public StatusCode getLastServiceResult() {
        return this.aB.get().getServiceResult();
    }

    public UaClientListener getListener() {
        return this.aD;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public UnsignedInteger getMaxResponseMessageSize() {
        return this.aE;
    }

    @Override
    public NamespaceTable getNamespaceTable() {
        if (!this.aF) {
            try {
                this.y();
            }
            catch (Exception exception) {
                logger.error("Could not get namespace table from server", (Throwable)exception);
            }
        }
        return super.getNamespaceTable();
    }

    public NamespaceTable getNamespaceTable(boolean bl) throws ServiceException, StatusException {
        if (!this.aF || bl) {
            this.y();
        }
        return this.getNamespaceTable();
    }

    public EnumSet<UaApplication.DiagnosticMask> getOperationDiagnosticMask() {
        return this.aG;
    }

    public OperationLimitsType getOperationLimits() {
        return this.aC;
    }

    public int getPort() {
        if (this.as == null) {
            return 0;
        }
        return this.as.getPort();
    }

    public UaApplication.Protocol getProtocol() {
        if (this.as == null) {
            return UaApplication.Protocol.OpcTcp;
        }
        return this.as.getProtocol();
    }

    public double getPublishRequestFactor() {
        return this.aH;
    }

    public UnsignedInteger getPublishRequestTimeout() {
        return this.aI;
    }

    public SecureChannel getSecureChannel() throws ServerConnectionException {
        return this.D().getSecureChannel();
    }

    public SecurityMode getSecurityMode() {
        return this.aM;
    }

    public ApplicationIdentity getServerIdentity() {
        return this.aN;
    }

    public String getServerName() {
        if (this.as == null) {
            return "";
        }
        return this.as.getServerName();
    }

    public ServerState getServerState() {
        ServerStatusDataType serverStatusDataType = this.r();
        StatusCode statusCode = this.q();
        if (serverStatusDataType != null) {
            return serverStatusDataType.getState();
        }
        if (statusCode == null || statusCode.equals((Object)StatusCode.BAD)) {
            return ServerState.Unknown;
        }
        return ServerState.CommunicationFault;
    }

    public ServerStatusDataType getServerStatus() throws StatusException, ServerConnectionException {
        if (!this.isConnected()) {
            throw new ServerConnectionException("Not connected to server", this.getUri(), this.aM);
        }
        StatusCode statusCode = this.q();
        if (statusCode != null && statusCode.isBad()) {
            throw new StatusException("ServerStatus not available", statusCode);
        }
        if (this.aX > 0L) {
            int n2 = 0;
            try {
                while (this.r() == null && this.isConnected() && n2++ < 10) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.r();
    }

    public StatusCode getServerStatusError() {
        return this.aP.get();
    }

    public ServerTable getServerTable() {
        if (!this.aR) {
            try {
                this.z();
            }
            catch (Exception exception) {
                logger.error("Could not get namespace table from server", (Throwable)exception);
            }
        }
        return this.getEncoderContext().getServerTable();
    }

    public ServerTable getServerTable(boolean bl) throws ServiceException, StatusException {
        if (!this.aR || bl) {
            this.z();
        }
        return this.getEncoderContext().getServerTable();
    }

    public long getServerTimeDifference() {
        return this.aS.get();
    }

    public EnumSet<UaApplication.DiagnosticMask> getServiceDiagnosticMask() {
        return this.aT;
    }

    public Session getSession() {
        SessionChannel sessionChannel = this.channel.get();
        logger.trace("getSession: sessionChannel={}", (Object)sessionChannel);
        if (sessionChannel == null) {
            return null;
        }
        return sessionChannel.getSession();
    }

    public String getSessionName() {
        return this.aU;
    }

    public double getSessionTimeout() {
        return this.aV;
    }

    public long getStatusCheckInterval() {
        return this.aX;
    }

    public long getStatusCheckTimeout() {
        return this.aY;
    }

    public Subscription getSubscription(int n2) {
        return this.bc.get(n2);
    }

    public Subscription getSubscriptionById(UnsignedInteger unsignedInteger) {
        if (unsignedInteger != null) {
            for (Subscription subscription : this.bc) {
                if (!unsignedInteger.equals((Object)subscription.getSubscriptionId())) continue;
                return subscription;
            }
        }
        return null;
    }

    public int getSubscriptionCount() {
        return this.bc.size();
    }

    public Subscription[] getSubscriptions() {
        return this.bc.toArray(new Subscription[this.bc.size()]);
    }

    public List<SecurityMode> getSupportedSecurityModes() throws InvalidServerEndpointException, ServerConnectionException, ServiceException {
        EndpointDescription[] endpointDescriptionArray = this.discoverEndpoints();
        ArrayList<SecurityMode> arrayList = new ArrayList<SecurityMode>();
        for (EndpointDescription endpointDescription : endpointDescriptionArray) {
            try {
                endpointDescription = new SecurityMode(SecurityPolicy.getSecurityPolicy((String)endpointDescription.getSecurityPolicyUri()), endpointDescription.getSecurityMode());
                if (arrayList.contains(endpointDescription)) continue;
                arrayList.add((SecurityMode)endpointDescription);
            }
            catch (ServiceResultException serviceResultException) {
                logger.info("Unknown security policy supported by the server.", (Throwable)serviceResultException);
            }
        }
        return arrayList;
    }

    public UserTokenPolicy[] getSupportedUserIdentityTokens() throws ServerConnectionException, ServiceException {
        EndpointDescription endpointDescription = this.endpoint;
        try {
            if (this.endpoint == null) {
                this.v();
            }
            UserTokenPolicy[] userTokenPolicyArray = this.endpoint.getUserIdentityTokens();
            return userTokenPolicyArray;
        }
        finally {
            this.endpoint = endpointDescription;
        }
    }

    public int getTimeout() {
        if (this.aZ == null) {
            return -1;
        }
        return this.aZ.intValue();
    }

    public String getUri() {
        if (this.as == null) {
            return "";
        }
        return this.as.getAddress();
    }

    public UserIdentity getUserIdentity() {
        return this.ba;
    }

    public boolean hasServerStatusListener(ServerStatusListener serverStatusListener) {
        if (serverStatusListener == null) {
            throw new NullPointerException("null listener not allowed");
        }
        return this.aQ.contains(serverStatusListener);
    }

    public boolean hasSubscription(UnsignedInteger unsignedInteger) {
        return this.getSubscriptionById(unsignedInteger) != null;
    }

    public HistoryUpdateResult historyDeleteAtTimes(NodeId historyUpdateResultArray, DateTime[] dateTimeArray) throws StatusException, ServerConnectionException, ServiceException {
        historyUpdateResultArray = new DeleteAtTimeDetails((NodeId)historyUpdateResultArray, dateTimeArray);
        historyUpdateResultArray = this.historyUpdate(new HistoryUpdateDetails[]{historyUpdateResultArray});
        this.checkOperationResult(historyUpdateResultArray[0].getStatusCode());
        return historyUpdateResultArray[0];
    }

    public HistoryUpdateResult historyDeleteEvents(NodeId historyUpdateResultArray, List<byte[]> list) throws StatusException, ServerConnectionException, ServiceException {
        historyUpdateResultArray = new DeleteEventDetails((NodeId)historyUpdateResultArray, (byte[][])list.toArray((T[])new byte[list.size()][]));
        historyUpdateResultArray = this.historyUpdate(new HistoryUpdateDetails[]{historyUpdateResultArray});
        this.checkOperationResult(historyUpdateResultArray[0].getStatusCode());
        return historyUpdateResultArray[0];
    }

    public HistoryUpdateResult historyDeleteModified(NodeId historyUpdateResultArray, DateTime dateTime, DateTime dateTime2) throws StatusException, ServerConnectionException, ServiceException {
        historyUpdateResultArray = new DeleteRawModifiedDetails((NodeId)historyUpdateResultArray, Boolean.valueOf(true), dateTime, dateTime2);
        historyUpdateResultArray = this.historyUpdate(new HistoryUpdateDetails[]{historyUpdateResultArray});
        this.checkOperationResult(historyUpdateResultArray[0].getStatusCode());
        return historyUpdateResultArray[0];
    }

    public HistoryUpdateResult historyDeleteRaw(NodeId historyUpdateResultArray, DateTime dateTime, DateTime dateTime2) throws StatusException, ServerConnectionException, ServiceException {
        historyUpdateResultArray = new DeleteRawModifiedDetails((NodeId)historyUpdateResultArray, Boolean.valueOf(false), dateTime, dateTime2);
        historyUpdateResultArray = this.historyUpdate(new HistoryUpdateDetails[]{historyUpdateResultArray});
        this.checkOperationResult(historyUpdateResultArray[0].getStatusCode());
        return historyUpdateResultArray[0];
    }

    public HistoryReadResult[] historyRead(HistoryReadDetails historyReadDetails, TimestampsToReturn timestampsToReturn, Boolean bl, HistoryReadValueId ... historyReadValueIdArray) throws ServerConnectionException, ServiceException {
        if (historyReadDetails == null) {
            throw new NullPointerException("details");
        }
        if (historyReadValueIdArray == null) {
            throw new NullPointerException("nodesToRead");
        }
        try {
            historyReadDetails = this.D().HistoryRead(this.getRequestHeader(), ExtensionObject.binaryEncode((Structure)historyReadDetails, (EncoderContext)this.client.getEncoderContext()), timestampsToReturn, bl, historyReadValueIdArray);
            this.checkServiceResult((ServiceResponse)historyReadDetails, historyReadDetails.getDiagnosticInfos());
            UaClient.a(historyReadDetails.getResults(), historyReadValueIdArray);
            return historyReadDetails.getResults();
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (EncodingException encodingException) {
            throw new IllegalArgumentException(encodingException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
    }

    public AsyncResult<ServiceResponse> historyReadAsync(HistoryReadDetails historyReadDetails, TimestampsToReturn timestampsToReturn, Boolean bl, HistoryReadValueId ... historyReadValueIdArray) {
        if (historyReadDetails == null) {
            throw new NullPointerException("details");
        }
        if (historyReadValueIdArray == null) {
            throw new NullPointerException("nodesToRead");
        }
        try {
            return this.D().HistoryReadAsync(this.getRequestHeader(), ExtensionObject.binaryEncode((Structure)historyReadDetails, (EncoderContext)this.client.getEncoderContext()), timestampsToReturn, bl, historyReadValueIdArray);
        }
        catch (EncodingException encodingException) {
            throw new IllegalArgumentException(encodingException);
        }
    }

    public DataValue[] historyReadAtTimes(NodeId nodeId, DateTime[] dateTimeArray, NumericRange numericRange, TimestampsToReturn timestampsToReturn) throws StatusException, ServerConnectionException, ServiceException, DecodingException {
        return this.historyReadAtTimes(nodeId, dateTimeArray, numericRange, timestampsToReturn, false);
    }

    public DataValue[] historyReadAtTimes(NodeId nodeId, DateTime[] readAtTimeDetails, NumericRange numericRange, TimestampsToReturn timestampsToReturn, Boolean bl) throws StatusException, ServerConnectionException, ServiceException, DecodingException {
        readAtTimeDetails = new ReadAtTimeDetails((DateTime[])readAtTimeDetails, bl);
        return this.a(nodeId, numericRange, timestampsToReturn, (HistoryReadDetails)readAtTimeDetails);
    }

    public HistoryEventFieldList[] historyReadEvents(NodeId nodeId, DateTime dateTime, DateTime dateTime2, UnsignedInteger unsignedInteger, EventFilter eventFilter, TimestampsToReturn timestampsToReturn) throws StatusException, ServerConnectionException, ServiceException, DecodingException {
        dateTime = new ReadEventDetails(unsignedInteger, dateTime, dateTime2, eventFilter);
        return this.b(nodeId, null, timestampsToReturn, (HistoryReadDetails)dateTime);
    }

    public HistoryModifiedData historyReadModified(NodeId nodeId, DateTime dateTime, DateTime dateTime2, UnsignedInteger unsignedInteger, NumericRange numericRange, TimestampsToReturn timestampsToReturn) throws StatusException, ServerConnectionException, ServiceException, DecodingException {
        dateTime = new ReadRawModifiedDetails(Boolean.valueOf(true), dateTime, dateTime2, unsignedInteger, Boolean.valueOf(false));
        return this.c(nodeId, numericRange, timestampsToReturn, (HistoryReadDetails)dateTime);
    }

    public DataValue[] historyReadProcessed(NodeId nodeId, DateTime dateTime, DateTime dateTime2, Double d2, NodeId nodeId2, AggregateConfiguration aggregateConfiguration, NumericRange numericRange, TimestampsToReturn timestampsToReturn) throws ServerConnectionException, ServiceException, DecodingException, StatusException {
        dateTime = new ReadProcessedDetails(dateTime, dateTime2, d2, new NodeId[]{nodeId2}, aggregateConfiguration);
        return this.a(nodeId, numericRange, timestampsToReturn, (HistoryReadDetails)dateTime);
    }

    public DataValue[] historyReadRaw(NodeId nodeId, DateTime dateTime, DateTime dateTime2, long l2, Boolean bl, NumericRange numericRange, TimestampsToReturn timestampsToReturn) throws ServerConnectionException, DecodingException, ServiceException, StatusException {
        return this.historyReadRaw(nodeId, dateTime, dateTime2, UnsignedInteger.valueOf((long)l2), bl, numericRange, timestampsToReturn);
    }

    public DataValue[] historyReadRaw(NodeId nodeId, DateTime dateTime, DateTime dateTime2, UnsignedInteger unsignedInteger, Boolean bl, NumericRange numericRange, TimestampsToReturn timestampsToReturn) throws ServerConnectionException, ServiceException, DecodingException, StatusException {
        dateTime = new ReadRawModifiedDetails(Boolean.valueOf(false), dateTime, dateTime2, unsignedInteger, bl);
        return this.a(nodeId, numericRange, timestampsToReturn, (HistoryReadDetails)dateTime);
    }

    public HistoryUpdateResult[] historyUpdate(HistoryUpdateDetails ... historyUpdateDetailsArray) throws ServerConnectionException, ServiceException {
        if (historyUpdateDetailsArray == null) {
            throw new NullPointerException("details");
        }
        try {
            HistoryUpdateResponse historyUpdateResponse = new ExtensionObject[historyUpdateDetailsArray.length];
            for (int i2 = 0; i2 < historyUpdateDetailsArray.length; ++i2) {
                historyUpdateResponse[i2] = ExtensionObject.binaryEncode((Structure)historyUpdateDetailsArray[i2], (EncoderContext)this.client.getEncoderContext());
            }
            historyUpdateResponse = this.D().HistoryUpdate(this.getRequestHeader(), (ExtensionObject[])historyUpdateResponse);
            this.checkServiceResult((ServiceResponse)historyUpdateResponse, historyUpdateResponse.getDiagnosticInfos());
            UaClient.a(historyUpdateResponse.getResults(), historyUpdateDetailsArray);
            return historyUpdateResponse.getResults();
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (EncodingException encodingException) {
            throw new IllegalArgumentException(encodingException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
    }

    public AsyncResult<ServiceResponse> historyUpdateAsync(HistoryUpdateDetails ... historyUpdateDetailsArray) throws ServerConnectionException {
        if (historyUpdateDetailsArray == null) {
            throw new NullPointerException("details");
        }
        try {
            ExtensionObject[] extensionObjectArray = new ExtensionObject[historyUpdateDetailsArray.length];
            for (int i2 = 0; i2 < historyUpdateDetailsArray.length; ++i2) {
                extensionObjectArray[i2] = ExtensionObject.binaryEncode((Structure)historyUpdateDetailsArray[i2], (EncoderContext)this.client.getEncoderContext());
            }
            return this.D().HistoryUpdateAsync(this.getRequestHeader(), extensionObjectArray);
        }
        catch (EncodingException encodingException) {
            throw new IllegalArgumentException(encodingException);
        }
    }

    public HistoryUpdateResult historyUpdateData(NodeId historyUpdateResultArray, PerformUpdateType performUpdateType, DataValue[] dataValueArray) throws StatusException, ServerConnectionException, ServiceException {
        historyUpdateResultArray = new UpdateDataDetails((NodeId)historyUpdateResultArray, performUpdateType, dataValueArray);
        historyUpdateResultArray = this.historyUpdate(new HistoryUpdateDetails[]{historyUpdateResultArray});
        this.checkOperationResult(historyUpdateResultArray[0].getStatusCode());
        return historyUpdateResultArray[0];
    }

    public HistoryUpdateResult historyUpdateEvent(NodeId historyUpdateResultArray, PerformUpdateType performUpdateType, EventFilter eventFilter, HistoryEventFieldList[] historyEventFieldListArray) throws StatusException, ServerConnectionException, ServiceException {
        historyUpdateResultArray = new UpdateEventDetails((NodeId)historyUpdateResultArray, performUpdateType, eventFilter, historyEventFieldListArray);
        historyUpdateResultArray = this.historyUpdate(new HistoryUpdateDetails[]{historyUpdateResultArray});
        this.checkOperationResult(historyUpdateResultArray[0].getStatusCode());
        return historyUpdateResultArray[0];
    }

    public HistoryUpdateResult historyUpdateStructureData(NodeId historyUpdateResultArray, PerformUpdateType performUpdateType, DataValue[] dataValueArray) throws StatusException, ServerConnectionException, ServiceException {
        historyUpdateResultArray = new UpdateStructureDataDetails((NodeId)historyUpdateResultArray, performUpdateType, dataValueArray);
        historyUpdateResultArray = this.historyUpdate(new HistoryUpdateDetails[]{historyUpdateResultArray});
        this.checkOperationResult(historyUpdateResultArray[0].getStatusCode());
        return historyUpdateResultArray[0];
    }

    public boolean isAutoReconnect() {
        return this.au;
    }

    public boolean isConnected() {
        return this.getSession() != null;
    }

    public boolean isKeepSubscriptions() {
        return this.ay;
    }

    public boolean isValidateDiscoveredEndpoints() {
        return this.bb;
    }

    public ReadResponse read(Double d2, TimestampsToReturn timestampsToReturn, ReadValueId ... readValueIdArray) throws ServiceException {
        int n2 = 0;
        if (readValueIdArray.length > 1 && this.getOperationLimits() != null) {
            try {
                n2 = this.getOperationLimits().getMaxNodesPerRead().intValue();
            }
            catch (Exception exception) {
                logger.debug("read: Failed to get operationLimits.MaxNodesPerRead: ", (Throwable)exception);
            }
        }
        if (n2 > 0 && n2 < readValueIdArray.length) {
            ResponseHeader responseHeader = null;
            DataValue[] dataValueArray = new DataValue[readValueIdArray.length];
            DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[readValueIdArray.length];
            for (int i2 = 0; i2 < readValueIdArray.length; i2 += n2) {
                int n3 = Math.min(n2, readValueIdArray.length - i2);
                responseHeader = Arrays.copyOfRange(readValueIdArray, i2, i2 + n3);
                ReadResponse readResponse = this.doRead(d2, timestampsToReturn, (ReadValueId[])responseHeader);
                responseHeader = readResponse.getResponseHeader();
                for (int i3 = 0; i3 < n3; ++i3) {
                    dataValueArray[i2 + i3] = readResponse.getResults()[i3];
                }
                DiagnosticInfo[] diagnosticInfoArray2 = readResponse.getDiagnosticInfos();
                if (diagnosticInfoArray2 == null) continue;
                for (int i4 = 0; i4 < n3; ++i4) {
                    diagnosticInfoArray[i2 + i4] = diagnosticInfoArray2[i4];
                }
            }
            return new ReadResponse(responseHeader, dataValueArray, diagnosticInfoArray);
        }
        return this.doRead(d2, timestampsToReturn, readValueIdArray);
    }

    public AsyncResult<ServiceResponse> readAsync(Double d2, TimestampsToReturn timestampsToReturn, ReadValueId ... readValueIdArray) {
        d2 = new ReadRequest(this.getRequestHeader(), new Double(d2), timestampsToReturn, readValueIdArray);
        return this.D().ReadAsync((ReadRequest)d2);
    }

    public DataValue readAttribute(NodeId nodeId, UnsignedInteger unsignedIntegerArray) throws ServiceException, StatusException {
        unsignedIntegerArray = new UnsignedInteger[]{unsignedIntegerArray};
        nodeId = this.readAttributes(nodeId, unsignedIntegerArray)[0];
        this.checkOperationResult(nodeId.getStatusCode());
        return nodeId;
    }

    public DataValue readAttribute(NodeId nodeId, UnsignedInteger unsignedIntegerArray, NumericRange numericRange, Double d2) throws ServiceException, StatusException {
        NumericRange[] numericRangeArray;
        unsignedIntegerArray = new UnsignedInteger[]{unsignedIntegerArray};
        if (numericRange == null) {
            numericRangeArray = null;
        } else {
            NumericRange[] numericRangeArray2 = new NumericRange[1];
            numericRangeArray = numericRangeArray2;
            numericRangeArray2[0] = numericRange;
        }
        numericRange = numericRangeArray;
        nodeId = this.readAttributes(nodeId, unsignedIntegerArray, (NumericRange[])numericRange, d2)[0];
        this.checkOperationResult(nodeId.getStatusCode());
        return nodeId;
    }

    public DataValue[] readAttributes(NodeId nodeId, UnsignedInteger ... unsignedIntegerArray) throws ServiceException {
        return this.readAttributes(nodeId, unsignedIntegerArray, null, MAX_CACHE_AGE);
    }

    public DataValue[] readAttributes(NodeId dataValueArray, UnsignedInteger[] unsignedIntegerArray, NumericRange[] numericRangeArray, Double d2) throws ServiceException {
        ReadValueId[] readValueIdArray = new ReadValueId[unsignedIntegerArray.length];
        for (int i2 = 0; i2 < unsignedIntegerArray.length; ++i2) {
            readValueIdArray[i2] = new ReadValueId((NodeId)dataValueArray, unsignedIntegerArray[i2], numericRangeArray == null ? null : NumericRange.toString((NumericRange)numericRangeArray[i2]), null);
        }
        ReadResponse readResponse = this.read(d2, TimestampsToReturn.Both, readValueIdArray);
        dataValueArray = readResponse.getResults();
        return dataValueArray;
    }

    public DataValue readValue(NodeId nodeId) throws ServiceException, StatusException {
        return this.readAttribute(nodeId, Attributes.Value);
    }

    public DataValue readValue(NodeId nodeId, Double d2) throws ServiceException, StatusException {
        return this.readAttribute(nodeId, Attributes.Value, null, d2);
    }

    public DataValue readValue(NodeId nodeId, NumericRange numericRange) throws ServiceException, StatusException {
        return this.readValue(nodeId, numericRange, MAX_CACHE_AGE);
    }

    public DataValue readValue(NodeId nodeId, NumericRange numericRange, Double d2) throws ServiceException, StatusException {
        return this.readAttribute(nodeId, Attributes.Value, numericRange, d2);
    }

    public DataValue[] readValues(NodeId[] nodeIdArray) throws ServiceException {
        return this.readValues(nodeIdArray, TimestampsToReturn.Both);
    }

    public DataValue[] readValues(NodeId[] nodeIdArray, NumericRange[] numericRangeArray) throws ServiceException {
        ReadValueId[] readValueIdArray = new ReadValueId[nodeIdArray.length];
        for (int i2 = 0; i2 < nodeIdArray.length; ++i2) {
            readValueIdArray[i2] = new ReadValueId(nodeIdArray[i2], Attributes.Value, numericRangeArray == null ? null : NumericRange.toString((NumericRange)numericRangeArray[i2]), null);
        }
        ReadResponse readResponse = this.read(MAX_CACHE_AGE, TimestampsToReturn.Both, readValueIdArray);
        nodeIdArray = readResponse.getResults();
        return nodeIdArray;
    }

    public DataValue[] readValues(NodeId[] nodeIdArray, NumericRange[] numericRangeArray, TimestampsToReturn timestampsToReturn) throws ServiceException {
        return this.readValues(nodeIdArray, numericRangeArray, timestampsToReturn, MAX_CACHE_AGE);
    }

    public DataValue[] readValues(NodeId[] nodeIdArray, NumericRange[] numericRangeArray, TimestampsToReturn timestampsToReturn, Double d2) throws ServiceException {
        ReadValueId[] readValueIdArray = new ReadValueId[nodeIdArray.length];
        for (int i2 = 0; i2 < nodeIdArray.length; ++i2) {
            readValueIdArray[i2] = new ReadValueId(nodeIdArray[i2], Attributes.Value, numericRangeArray == null ? null : NumericRange.toString((NumericRange)numericRangeArray[i2]), null);
        }
        ReadResponse readResponse = this.read(d2, timestampsToReturn, readValueIdArray);
        nodeIdArray = readResponse.getResults();
        return nodeIdArray;
    }

    public DataValue[] readValues(NodeId[] nodeIdArray, TimestampsToReturn timestampsToReturn) throws ServiceException {
        return this.readValues(nodeIdArray, null, timestampsToReturn);
    }

    public boolean reconnect() throws ServiceException, ConnectException, SessionActivationException {
        logger.debug("reconnect: Reconnecting to server");
        try {
            this.n();
        }
        catch (Exception exception) {
            logger.debug("Failed to create secure channel: {}", (Throwable)exception);
            if (exception.getCause() instanceof ServiceResultException) {
                throw new ServiceException((ServiceResultException)exception.getCause());
            }
            throw new ServiceException(exception.getMessage(), new StatusCode(StatusCodes.Bad_ServerNotConnected), null, (Throwable)exception);
        }
        logger.debug("reconnect: secure channel created");
        boolean bl = false;
        if (this.session == null) {
            this.m();
        } else {
            this.a(this.session.createSessionChannel(this.aL, this.client));
            logger.debug("reconnect: setting channel ok");
            try {
                this.j();
                logger.debug("reconnect: Old session re-activated");
                this.A();
                this.a(true);
                bl = true;
            }
            catch (SessionActivationException sessionActivationException) {
                this.m();
            }
        }
        logger.info("reconnect: Reconnected to server " + (bl ? "(session reactivated)" : "(new session)"));
        return bl;
    }

    public boolean removeServerStatusListener(ServerStatusListener serverStatusListener) {
        return this.aQ.remove(serverStatusListener);
    }

    public StatusCode removeSubscription(Subscription subscription) throws ServiceException {
        boolean bl;
        logger.debug("removeSubscription: {}", (Object)subscription);
        if (subscription == null) {
            return new StatusCode(StatusCodes.Good_NoData);
        }
        StatusCode statusCode = null;
        try {
            StatusCode[] statusCodeArray = this.a(new SubscriptionBase[]{subscription});
            if (statusCodeArray != null && statusCodeArray.length > 0) {
                statusCode = statusCodeArray[0];
            }
            if (subscription.getClient() == this) {
                subscription.reset();
            }
            bl = this.bc.remove(subscription);
        }
        catch (Throwable throwable) {
            if (subscription.getClient() == this) {
                subscription.reset();
            }
            boolean bl2 = this.bc.remove(subscription);
            logger.debug("removed: {}", (Object)bl2);
            if (!bl2) {
                new StatusCode(StatusCodes.Good_NoData);
            }
            throw throwable;
        }
        logger.debug("removed: {}", (Object)bl);
        if (statusCode == null) {
            statusCode = bl ? StatusCode.GOOD : new StatusCode(StatusCodes.Good_NoData);
        }
        return statusCode;
    }

    public StatusCode[] removeSubscriptions(Subscription[] subscriptionArray) throws ServiceException {
        StatusCode[] statusCodeArray = this.a(subscriptionArray);
        if (statusCodeArray == null) {
            statusCodeArray = new StatusCode[subscriptionArray.length];
        }
        this.resetSubscriptionsAfterRemove(subscriptionArray, statusCodeArray);
        return statusCodeArray;
    }

    public AsyncResult<StatusCode[]> removeSubscriptionsAsync(Subscription ... subscriptionArray) throws ServiceException {
        AsyncResultImpl asyncResultImpl = new AsyncResultImpl();
        StatusCode[] statusCodeArray = this.b(subscriptionArray);
        if (statusCodeArray == null) {
            statusCodeArray = new StatusCode[subscriptionArray.length];
            this.resetSubscriptionsAfterRemove(subscriptionArray, statusCodeArray);
            asyncResultImpl.setResult((Object)statusCodeArray);
        } else {
            statusCodeArray.setListener((ResultListener)new ResultListener<ServiceResponse>(this, subscriptionArray, asyncResultImpl){
                private /* synthetic */ Subscription[] gR;
                private /* synthetic */ AsyncResultImpl gS;
                private /* synthetic */ UaClient cM;
                {
                    this.cM = uaClient;
                    this.gR = subscriptionArray;
                    this.gS = asyncResultImpl;
                }

                public final void onError(ServiceResultException serviceResultException) {
                    this.gS.setError(serviceResultException);
                }
            });
        }
        return asyncResultImpl;
    }

    public void resetEndpoint() {
        this.endpoint = null;
    }

    public ServiceResponse serviceRequest(ServiceRequest serviceRequest) throws ServiceException {
        try {
            if (serviceRequest.getRequestHeader() == null) {
                serviceRequest.setRequestHeader(this.getRequestHeader());
            }
            serviceRequest = (ServiceResponse)this.D().serviceRequest(serviceRequest);
            this.checkServiceResult((ServiceResponse)serviceRequest, null);
            return serviceRequest;
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
    }

    public AsyncResult<ServiceResponse> serviceRequestAsync(ServiceRequest serviceRequest) throws ServiceException {
        if (serviceRequest.getRequestHeader() == null) {
            serviceRequest.setRequestHeader(this.getRequestHeader());
        }
        return this.D().serviceRequestAsync(serviceRequest);
    }

    public ServiceResponse sessionlessRequest(ServiceRequest serviceRequest) throws InvalidServerEndpointException, ServerConnectionException, ServiceException {
        if (this.isConnected()) {
            return this.serviceRequest(serviceRequest);
        }
        if (this.endpoint == null) {
            this.u();
            this.v();
            this.t();
        }
        this.n();
        try {
            serviceRequest = this.aL.serviceRequest(serviceRequest);
            return serviceRequest;
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        finally {
            this.disconnect();
        }
    }

    public void setAddress(UaAddress object) {
        this.as = object;
        object = this;
        ((UaClient)object).getAddressSpace().aD();
        ((UaClient)object).resetEndpoint();
    }

    public void setApplicationIdentity(ApplicationIdentity applicationIdentity) {
        this.applicationIdentity = applicationIdentity;
    }

    public void setAuditEntryId(String string) {
        this.at = string;
    }

    public void setAutoReconnect(boolean bl) {
        this.au = bl;
    }

    public void setEndpoint(EndpointDescription endpointDescription) throws URISyntaxException {
        this.k();
        if (endpointDescription != null) {
            this.setUri(endpointDescription.getEndpointUrl());
        }
        this.endpoint = endpointDescription;
    }

    public void setKeepSubscriptions(boolean bl) {
        this.ay = bl;
    }

    public void setListener(UaClientListener uaClientListener) {
        this.aD = uaClientListener;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setMaxResponseMessageSize(int n2) {
        this.setMaxResponseMessageSize(UnsignedInteger.valueOf((long)n2));
    }

    public void setMaxResponseMessageSize(UnsignedInteger unsignedInteger) {
        this.aE = unsignedInteger == null ? UnsignedInteger.ZERO : unsignedInteger;
    }

    public void setOperationDiagnosticMask(EnumSet<UaApplication.DiagnosticMask> enumSet) {
        this.aG = enumSet;
        this.C();
    }

    public void setPublishRequestFactor(double d2) {
        logger.debug("setPublishRequestFactor: {}", (Object)d2);
        this.aH = d2;
    }

    public void setPublishRequestTimeout(long l2) {
        this.setPublishRequestTimeout(UnsignedInteger.valueOf((long)l2));
    }

    public void setPublishRequestTimeout(long l2, TimeUnit timeUnit) {
        this.setPublishRequestTimeout(timeUnit.toMillis(l2));
    }

    public void setPublishRequestTimeout(UnsignedInteger unsignedInteger) {
        if (unsignedInteger.getValue() == 0L) {
            this.aI = UnsignedInteger.MAX_VALUE;
            return;
        }
        this.aI = unsignedInteger;
    }

    public void setSecurityMode(SecurityMode securityMode) throws ServerConnectionException {
        if (!securityMode.equals((Object)this.aM)) {
            this.k();
            this.aM = securityMode;
            this.resetEndpoint();
        }
    }

    public void setServiceDiagnosticMask(EnumSet<UaApplication.DiagnosticMask> enumSet) {
        this.aT = enumSet;
        this.C();
    }

    public void setSessionName(String string) {
        this.aU = string;
    }

    public void setSessionTimeout(double d2) {
        this.aV = d2;
    }

    public void setSessionTimeout(long l2, TimeUnit timeUnit) {
        double d2;
        switch (timeUnit) {
            case MICROSECONDS: {
                d2 = (double)l2 / 1000.0;
                break;
            }
            case NANOSECONDS: {
                d2 = (double)l2 / 1000000.0;
                break;
            }
            default: {
                d2 = timeUnit.toMillis(l2);
            }
        }
        this.setSessionTimeout(d2);
    }

    public void setStatusCheckInterval(long l2) {
        if (l2 != this.aX) {
            this.aX = l2;
            this.x();
        }
    }

    public void setStatusCheckInterval(long l2, TimeUnit timeUnit) {
        this.setStatusCheckInterval(timeUnit.toMillis(l2));
    }

    public void setStatusCheckTimeout(long l2) {
        this.aY = l2;
    }

    public void setStatusCheckTimeout(long l2, TimeUnit timeUnit) {
        this.aY = timeUnit.toMillis(l2);
    }

    public void setTimeout(long l2) {
        this.setTimeout(new UnsignedInteger(l2));
    }

    public void setTimeout(long l2, TimeUnit timeUnit) {
        this.setTimeout(timeUnit.toMillis(l2));
    }

    public void setTimeout(UnsignedInteger unsignedInteger) {
        this.aZ = unsignedInteger;
    }

    public void setUri(String object) throws URISyntaxException {
        object = new UaAddress((String)object);
        this.setAddress((UaAddress)object);
    }

    public void setUserIdentity(UserIdentity object) throws SessionActivationException {
        if (object == null) {
            object = new UserIdentity();
        }
        if (!this.ba.equals(object)) {
            this.ba = object;
            object = this;
            if (((UaClient)object).isConnected()) {
                super.j();
            }
        }
    }

    public void setValidateDiscoveredEndpoints(boolean bl) {
        this.bb = bl;
    }

    public void updateServerStatus() {
        long l2;
        Object object;
        ServerState serverState;
        StatusCode statusCode;
        block18: {
            statusCode = this.q();
            serverState = this.getServerState();
            logger.trace("updateServerStatus: oldState={} error={}", (Object)serverState, (Object)statusCode);
            statusCode = ServerState.Unknown;
            try {
                object = null;
                ReadValueId readValueId = new ReadValueId(Identifiers.Server_ServerStatus, Attributes.Value, null, null);
                RequestHeader requestHeader = this.a(UnsignedInteger.ZERO, UnsignedInteger.valueOf((long)this.aY), null);
                Object object2 = this.D().Read(requestHeader, Double.valueOf(0.0), TimestampsToReturn.Both, new ReadValueId[]{readValueId});
                this.checkServiceResult((ServiceResponse)object2, object2.getDiagnosticInfos());
                if (object2.getResults().length > 0) {
                    object = object2.getResults()[0];
                }
                if (object == null) {
                    this.a(null, StatusCode.BAD);
                    break block18;
                }
                if (object.isNull() && object.getStatusCode().isBad()) {
                    this.a(null, object.getStatusCode());
                    this.aS.set(0L);
                    break block18;
                }
                object2 = object.getValue().getValue();
                boolean bl = object2 != null && object2 instanceof ServerStatusDataType ? (readValueId = (ServerStatusDataType)object2).getBuildInfo() != null || readValueId.getCurrentTime() != null || readValueId.getSecondsTillShutdown() != null || readValueId.getShutdownReason() != null || readValueId.getStartTime() != null || readValueId.getState() != null : false;
                if (bl) {
                    this.a((ServerStatusDataType)object2, object.getStatusCode());
                } else {
                    object = this;
                    object2 = new NodeId[]{Identifiers.Server_ServerStatus_StartTime, Identifiers.Server_ServerStatus_CurrentTime, Identifiers.Server_ServerStatus_State, Identifiers.Server_ServerStatus_SecondsTillShutdown, Identifiers.Server_ServerStatus_ShutdownReason, Identifiers.Server_ServerStatus_BuildInfo};
                    object2 = ((UaClient)object).readValues((NodeId[])object2, TimestampsToReturn.Neither);
                    DateTime dateTime = null;
                    requestHeader = null;
                    ServerState serverState2 = null;
                    BuildInfo buildInfo = null;
                    UnsignedInteger unsignedInteger = null;
                    LocalizedText localizedText = null;
                    try {
                        NodeId[] nodeIdArray;
                        dateTime = (DateTime)object2[0].getValue().asClass(DateTime.class, null);
                        requestHeader = (DateTime)object2[1].getValue().asClass(DateTime.class, null);
                        serverState2 = (ServerState)object2[2].getValue().asClass(ServerState.class, null);
                        if (serverState2 == null) {
                            serverState2 = ServerState.valueOf((int)((Number)object2[2].getValue().asClass(Number.class, (Object)ServerState.Unknown.getValue())).intValue());
                        }
                        if ((unsignedInteger = (UnsignedInteger)object2[3].getValue().asClass(UnsignedInteger.class, null)) == null) {
                            nodeIdArray = (NodeId[])object2[3].getValue().asClass(Number.class, (Object)0);
                            unsignedInteger = UnsignedInteger.valueOf((long)nodeIdArray.intValue());
                        }
                        if ((localizedText = (LocalizedText)object2[4].getValue().asClass(LocalizedText.class, null)) == null) {
                            localizedText = new LocalizedText((String)object2[4].getValue().asClass(String.class, null), Locale.getDefault());
                        }
                        if ((buildInfo = (BuildInfo)object2[5].getValue().asClass(BuildInfo.class, null)) == null) {
                            object2 = object;
                            nodeIdArray = new NodeId[]{Identifiers.Server_ServerStatus_BuildInfo_ProductUri, Identifiers.Server_ServerStatus_BuildInfo_ManufacturerName, Identifiers.Server_ServerStatus_BuildInfo_ProductName, Identifiers.Server_ServerStatus_BuildInfo_SoftwareVersion, Identifiers.Server_ServerStatus_BuildInfo_BuildNumber, Identifiers.Server_ServerStatus_BuildInfo_BuildDate};
                            object2 = ((UaClient)object2).readValues(nodeIdArray, TimestampsToReturn.Neither);
                            object2 = new BuildInfo((String)object2[0].getValue().asClass(String.class, null), (String)object2[1].getValue().asClass(String.class, null), (String)object2[2].getValue().asClass(String.class, null), (String)object2[3].getValue().asClass(String.class, null), (String)object2[4].getValue().asClass(String.class, null), (DateTime)object2[5].getValue().asClass(DateTime.class, null));
                            buildInfo = object2;
                        }
                        super.a(new ServerStatusDataType(dateTime, (DateTime)requestHeader, serverState2, buildInfo, unsignedInteger, localizedText), StatusCode.GOOD);
                    }
                    catch (Exception exception) {
                        super.a(new ServerStatusDataType(dateTime, (DateTime)requestHeader, serverState2, buildInfo, unsignedInteger, localizedText), StatusCode.GOOD);
                    }
                    catch (Throwable throwable) {
                        super.a(new ServerStatusDataType(dateTime, (DateTime)requestHeader, serverState2, buildInfo, unsignedInteger, localizedText), StatusCode.GOOD);
                        throw throwable;
                    }
                }
                readValueId = this.r();
                this.aS.set(readValueId.getCurrentTime().getTimeInMillis() - System.currentTimeMillis());
                statusCode = readValueId.getState();
            }
            catch (ServiceException serviceException) {
                logger.debug("updateServerStatus", (Throwable)serviceException);
                this.a(null, serviceException.getServiceResult());
                statusCode = ServerState.CommunicationFault;
            }
            catch (ServerConnectionException serverConnectionException) {
                logger.debug("updateServerStatus", (Throwable)serverConnectionException);
                this.a(null, new StatusCode(StatusCodes.Bad_ServerNotConnected));
                statusCode = ServerState.CommunicationFault;
            }
            catch (ServiceResultException serviceResultException) {
                logger.debug("updateServerStatus", (Throwable)serviceResultException);
                this.a(null, serviceResultException.getStatusCode());
                if (serviceResultException.getStatusCode().getValue().equals((Object)StatusCodes.Bad_SessionNotActivated)) break block18;
                statusCode = ServerState.CommunicationFault;
            }
        }
        this.p();
        if (!statusCode.equals((Object)serverState)) {
            this.a(serverState, (ServerState)statusCode);
        }
        object = this.r();
        if (statusCode.equals((Object)ServerState.Shutdown) && (l2 = object == null ? 0L : object.getSecondsTillShutdown().getValue()) > 0L) {
            this.a(l2, object == null ? new LocalizedText("") : object.getShutdownReason());
            this.a((UnsignedInteger)null);
            this.aW = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(l2 + 10L);
        }
    }

    public WriteResponse write(WriteValue ... writeValueArray) throws ServiceException {
        int n2 = 0;
        if (writeValueArray.length > 1 && this.getOperationLimits() != null) {
            try {
                n2 = this.getOperationLimits().getMaxNodesPerWrite().intValue();
            }
            catch (Exception exception) {
                logger.debug("Error while parsing operation limits", (Throwable)exception);
            }
        }
        if (n2 > 0 && n2 < writeValueArray.length) {
            ResponseHeader responseHeader = null;
            StatusCode[] statusCodeArray = new StatusCode[writeValueArray.length];
            DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[writeValueArray.length];
            for (int i2 = 0; i2 < writeValueArray.length; i2 += n2) {
                int n3 = Math.min(n2, writeValueArray.length - i2);
                responseHeader = Arrays.copyOfRange(writeValueArray, i2, i2 + n3);
                WriteResponse writeResponse = this.a((WriteValue[])responseHeader);
                responseHeader = writeResponse.getResponseHeader();
                for (int i3 = 0; i3 < n3; ++i3) {
                    statusCodeArray[i2 + i3] = writeResponse.getResults()[i3];
                }
                DiagnosticInfo[] diagnosticInfoArray2 = writeResponse.getDiagnosticInfos();
                if (diagnosticInfoArray2 == null) continue;
                for (int i4 = 0; i4 < n3; ++i4) {
                    diagnosticInfoArray[i2 + i4] = diagnosticInfoArray2[i4];
                }
            }
            return new WriteResponse(responseHeader, statusCodeArray, diagnosticInfoArray);
        }
        return this.a(writeValueArray);
    }

    public AsyncResult<ServiceResponse> writeAsync(WriteValue ... writeRequest) {
        writeRequest = new WriteRequest(this.getRequestHeader(), (WriteValue[])writeRequest);
        return this.D().WriteAsync(writeRequest);
    }

    public boolean writeAttribute(NodeId writeResponse, UnsignedInteger unsignedInteger, Object object) throws ServiceException, StatusException {
        writeResponse = new WriteResponse[]{new WriteValue((NodeId)writeResponse, unsignedInteger, null, UaClient.a(object))};
        writeResponse = this.write((WriteValue[])writeResponse);
        writeResponse = writeResponse.getResults()[0];
        this.checkOperationResult((StatusCode)writeResponse);
        return writeResponse.equals((Object)StatusCode.GOOD);
    }

    public boolean writeAttribute(NodeId writeResponse, UnsignedInteger unsignedInteger, Object object, NumericRange numericRange) throws ServiceException, StatusException {
        writeResponse = new WriteResponse[]{new WriteValue((NodeId)writeResponse, unsignedInteger, NumericRange.toString((NumericRange)numericRange), UaClient.a(object))};
        writeResponse = this.write((WriteValue[])writeResponse);
        writeResponse = writeResponse.getResults()[0];
        this.checkOperationResult((StatusCode)writeResponse);
        return writeResponse.equals((Object)StatusCode.GOOD);
    }

    public boolean writeValue(NodeId nodeId, Object object) throws ServiceException, StatusException {
        return this.writeAttribute(nodeId, Attributes.Value, object);
    }

    public boolean writeValue(NodeId nodeId, Object object, NumericRange numericRange) throws ServiceException, StatusException {
        return this.writeAttribute(nodeId, Attributes.Value, object, numericRange);
    }

    public StatusCode[] writeValues(NodeId[] nodeIdArray, Object[] objectArray) throws ServiceException, StatusException {
        WriteValue[] writeValueArray = new WriteValue[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            writeValueArray[i2] = new WriteValue(nodeIdArray[i2], Attributes.Value, null, UaClient.a(objectArray[i2]));
        }
        WriteResponse writeResponse = this.write(writeValueArray);
        return writeResponse.getResults();
    }

    public StatusCode[] writeValues(NodeId[] nodeIdArray, Object[] objectArray, NumericRange[] numericRangeArray) throws ServiceException, StatusException {
        WriteValue[] writeValueArray = new WriteValue[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            writeValueArray[i2] = new WriteValue(nodeIdArray[i2], Attributes.Value, NumericRange.toString((NumericRange)numericRangeArray[i2]), UaClient.a(objectArray[i2]));
        }
        WriteResponse writeResponse = this.write(writeValueArray);
        return writeResponse.getResults();
    }

    private void j() throws SessionActivationException {
        UserIdentityToken userIdentityToken = null;
        logger.debug("activateSessionChannel: endpoint={}", (Object)this.getSession().getEndpoint().getEndpointUrl());
        SignatureData signatureData = null;
        try {
            switch (this.ba.getType()) {
                case Anonymous: {
                    userIdentityToken = EndpointUtil.createAnonymousIdentityToken((EndpointDescription)this.getSession().getEndpoint());
                    break;
                }
                case Certificate: {
                    signatureData = new SignatureData();
                    userIdentityToken = EndpointUtil.createX509IdentityToken((EndpointDescription)this.getSession().getEndpoint(), (byte[])this.getSession().getServerNonce(), (Cert)this.ba.getCertificate(), (PrivateKey)this.ba.getPrivateKey().getPrivateKey(), (SignatureData)signatureData);
                    break;
                }
                case IssuedToken: {
                    userIdentityToken = EndpointUtil.createIssuedIdentityToken((EndpointDescription)this.getSession().getEndpoint(), (byte[])this.getSession().getServerNonce(), (byte[])this.ba.getIssuedIdentityToken());
                    break;
                }
                case UserName: {
                    userIdentityToken = EndpointUtil.createUserNameIdentityToken((EndpointDescription)this.getSession().getEndpoint(), (byte[])this.getSession().getServerNonce(), (String)this.ba.getName(), (String)this.ba.getPassword());
                }
            }
        }
        catch (ServiceResultException serviceResultException) {
            logger.debug("ServiceResultException: ", (Throwable)serviceResultException);
            throw new SessionActivationException("Failed to initialize User Identity Token: " + serviceResultException.getMessage(), this.ba, serviceResultException);
        }
        try {
            Application application = this.client.getApplication();
            for (Locale locale : application.getLocales()) {
                application.removeLocale(locale);
            }
            application.addLocale(this.locale);
            ActivateSessionResponse activateSessionResponse = this.D().activate(userIdentityToken, signatureData);
            StatusCode statusCode = activateSessionResponse.getResponseHeader().getServiceResult();
            if (statusCode.isBad()) {
                throw new SessionActivationException("Failed to activate Session.", this.ba, statusCode);
            }
            return;
        }
        catch (ServiceResultException serviceResultException) {
            logger.debug("ServiceResultException: ", (Throwable)serviceResultException);
            throw new SessionActivationException("Failed to activate Session.", this.ba, serviceResultException);
        }
    }

    private void k() throws ServerConnectionException {
        if (this.isConnected()) {
            throw new ServerConnectionException("Cannot change connection or security settings when connected.", this.getUri(), this.aM);
        }
    }

    private void a(UnsignedInteger unsignedInteger) {
        SessionChannel sessionChannel = this.channel.get();
        if (sessionChannel != null && sessionChannel.getSession() != null) {
            try {
                sessionChannel.CloseSession(this.a(null, unsignedInteger, null), Boolean.valueOf(!this.ay));
            }
            catch (ServiceResultException serviceResultException) {
                logger.info("Failed to CloseSession: ", (Throwable)serviceResultException);
            }
            if (!this.ay) {
                this.a((TransferResult[])null);
            }
        }
        if (sessionChannel != null) {
            sessionChannel.closeSecureChannel();
        }
        this.a((SessionChannel)null);
    }

    private void l() throws ServiceException {
        logger.debug("connectSubscriptions");
        try {
            this.B();
        }
        catch (ServiceException serviceException) {
            logger.debug("transferSubscriptions: ", (Throwable)serviceException);
            this.a((TransferResult[])null);
        }
        this.a(true);
    }

    private void m() throws ConnectException, SessionActivationException, ServiceException {
        logger.debug("createAndActivateSessionChannel: unable to activate old session");
        try {
            this.o();
        }
        catch (Exception exception) {
            logger.debug("createAndActivateSessionChannel: re-init endpoint and retry.", (Throwable)exception);
            this.n();
            this.v();
            if (this.endpoint == null) {
                throw new ConnectException("No endpoint found", this.getUri(), this.aM);
            }
            this.o();
        }
        this.j();
        this.l();
        logger.debug("createAndActivateSessionChannel: New session created and activated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void n() throws ConnectException {
        TransportChannelSettings transportChannelSettings = new TransportChannelSettings();
        transportChannelSettings.setConfiguration(this.endpointConfiguration);
        transportChannelSettings.setDescription(this.endpoint);
        Object object = this.channel.get();
        this.a((SessionChannel)null);
        if (object != null) {
            object.closeSecureChannel();
        }
        object = this;
        synchronized (object) {
            try {
                this.aL = this.client.createSecureChannel(this.getUri(), transportChannelSettings);
            }
            catch (ServiceResultException serviceResultException) {
                this.aL = null;
                throw new ConnectException("Failed to create secure channel to server: ", this.endpoint.getEndpointUrl(), this.aM, serviceResultException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void o() throws ConnectException {
        logger.debug("createSessionChannel");
        UaClient uaClient = this;
        synchronized (uaClient) {
            this.session = null;
            try {
                EndpointDescription[] endpointDescriptionArray = this.bb ? this.aw : null;
                this.session = this.client.createSession(this.aL, this.getMaxResponseMessageSize(), Double.valueOf(this.getSessionTimeout()), this.getSessionName(), endpointDescriptionArray);
            }
            catch (ServiceResultException serviceResultException) {
                this.aL.closeAsync();
                this.aL = null;
                if (StatusCodes.Bad_UnexpectedError.equals((Object)serviceResultException.getStatusCode().getValue())) {
                    throw new InvalidServerEndpointException("Failed to create session channel to server: ", this.getUri(), this.aM, serviceResultException);
                }
                throw new ConnectException("Failed to create session channel to server: ", this.getUri(), this.aM, serviceResultException);
            }
        }
        this.a(this.session.createSessionChannel(this.aL, this.client));
    }

    private boolean a(Subscription subscription, boolean bl) throws ServiceException {
        CreateSubscriptionResponse createSubscriptionResponse;
        logger.debug("createSubscription: subscription={}, allowModification={}, isModified={}", new Object[]{subscription.getSubscriptionId(), bl, subscription.isModified()});
        if (subscription.getSubscriptionId() != null && subscription.getSubscriptionId().getValue() != 0L) {
            try {
                if (bl && subscription.isModified()) {
                    this.a((SubscriptionBase)subscription);
                }
                return false;
            }
            catch (ServiceException serviceException) {
                logger.debug("createSubscription: cannot modify: invalid subscription={} Exception={}", (Object)subscription.getSubscriptionId(), (Object)serviceException);
                subscription.setSubscriptionId(null);
            }
        }
        try {
            logger.debug("createSubscription: subscription={}", (Object)subscription);
            createSubscriptionResponse = this.D().CreateSubscription(this.getRequestHeader(), Double.valueOf(subscription.getPublishingInterval()), UnsignedInteger.valueOf((long)subscription.getLifetimeCount()), UnsignedInteger.valueOf((long)subscription.getMaxKeepAliveCount()), UnsignedInteger.valueOf((long)subscription.getMaxNotificationsPerPublish()), Boolean.valueOf(subscription.isPublishingEnabled()), UnsignedByte.valueOf((int)subscription.getPriority()));
            logger.debug("createSubscription: reponse={}", (Object)createSubscriptionResponse.getResponseHeader().getServiceResult());
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        this.checkServiceResult((ServiceResponse)createSubscriptionResponse, null);
        logger.debug("createSubscription: response.getSubscriptionId()={}", (Object)createSubscriptionResponse.getSubscriptionId());
        subscription.setSubscriptionId(createSubscriptionResponse.getSubscriptionId());
        subscription.setPublishingInterval(createSubscriptionResponse.getRevisedPublishingInterval());
        subscription.setLifetimeCount(createSubscriptionResponse.getRevisedLifetimeCount());
        subscription.setMaxKeepAliveCount(createSubscriptionResponse.getRevisedMaxKeepAliveCount());
        subscription.setClient(this);
        subscription.createItems();
        subscription.fireAfterCreate();
        return true;
    }

    private void a(boolean bl) {
        this.ax = false;
        for (Subscription subscription : this.bc) {
            try {
                this.a(subscription, bl);
            }
            catch (Exception exception) {
                logger.warn("Failed to create subscription to the server: {} Exception={}", (Object)subscription, (Object)exception);
                this.ax = true;
            }
        }
    }

    private StatusCode[] a(SubscriptionBase ... subscriptionBaseArray) throws ServiceException {
        if (this.isConnected()) {
            DeleteSubscriptionsResponse deleteSubscriptionsResponse;
            UnsignedInteger[] unsignedIntegerArray = new UnsignedInteger[subscriptionBaseArray.length];
            for (int i2 = 0; i2 < subscriptionBaseArray.length; ++i2) {
                unsignedIntegerArray[i2] = subscriptionBaseArray[i2].getSubscriptionId();
            }
            try {
                deleteSubscriptionsResponse = this.D().DeleteSubscriptions(this.getRequestHeader(), unsignedIntegerArray);
                logger.debug("deleteSubscriptions: response={}", (Object)deleteSubscriptionsResponse);
            }
            catch (ServiceFaultException serviceFaultException) {
                throw new ServiceException(serviceFaultException);
            }
            catch (ServiceResultException serviceResultException) {
                throw new ServiceException(serviceResultException);
            }
            this.checkServiceResult((ServiceResponse)deleteSubscriptionsResponse, null);
            unsignedIntegerArray = deleteSubscriptionsResponse.getResults();
            if (unsignedIntegerArray != null && unsignedIntegerArray.length != subscriptionBaseArray.length && logger.isWarnEnabled()) {
                logger.warn("Received {} DeleteSubscriptions results when expecting {}, received StatusCodes: {}", new Object[]{unsignedIntegerArray.length, subscriptionBaseArray.length, MultiDimensionArrayUtils.toString((Object)unsignedIntegerArray)});
            }
            return unsignedIntegerArray;
        }
        return null;
    }

    private AsyncResult<ServiceResponse> b(SubscriptionBase ... subscriptionBaseArray) throws ServiceException {
        if (this.isConnected()) {
            UnsignedInteger[] unsignedIntegerArray = new UnsignedInteger[subscriptionBaseArray.length];
            for (int i2 = 0; i2 < subscriptionBaseArray.length; ++i2) {
                unsignedIntegerArray[i2] = subscriptionBaseArray[i2].getSubscriptionId();
            }
            return this.D().DeleteSubscriptionsAsync(this.getRequestHeader(), unsignedIntegerArray);
        }
        return null;
    }

    private void a(TransferResult[] transferResultArray) {
        if (logger.isDebugEnabled()) {
            logger.debug("disconnectSubscriptions: " + Arrays.toString(transferResultArray));
        }
        for (int i2 = 0; i2 < this.bc.size(); ++i2) {
            if (transferResultArray != null && transferResultArray[i2] != null && !transferResultArray[i2].getStatusCode().isBad()) continue;
            this.bc.get(i2).setSubscriptionId(0);
        }
    }

    private EndpointDescription[] a(ChannelService channelService, String string, UaApplication.Protocol ... protocolArray) throws ServiceFaultException, ServiceResultException, ServiceException {
        String[] stringArray = new String[protocolArray.length];
        for (int i2 = 0; i2 < protocolArray.length; ++i2) {
            stringArray[i2] = protocolArray[i2].getTransportProfileUri();
        }
        GetEndpointsRequest getEndpointsRequest = new GetEndpointsRequest(this.getRequestHeader(), string, stringArray, stringArray);
        channelService = channelService.GetEndpoints(getEndpointsRequest);
        this.checkServiceResult((ServiceResponse)channelService, null);
        return channelService.getEndpoints();
    }

    private WriteResponse a(WriteValue ... writeValueArray) throws ServiceException {
        try {
            WriteResponse writeResponse = this.D().Write(this.getRequestHeader(), writeValueArray);
            this.checkServiceResult((ServiceResponse)writeResponse, writeResponse.getDiagnosticInfos());
            UaClient.a(writeResponse.getResults(), writeValueArray);
            return writeResponse;
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
    }

    private void a(long l2, LocalizedText localizedText) {
        for (ServerStatusListener serverStatusListener : this.aQ) {
            try {
                serverStatusListener.onShutdown(this, l2, localizedText);
            }
            catch (Exception exception) {
                logger.error("Exception in ServerStatusListener", (Throwable)exception);
            }
        }
    }

    private void a(ServerState serverState, ServerState serverState2) {
        for (ServerStatusListener serverStatusListener : this.aQ) {
            try {
                serverStatusListener.onStateChange(this, serverState, serverState2);
            }
            catch (Exception exception) {
                logger.error("Exception in ServerStatusListener", (Throwable)exception);
            }
        }
    }

    private void p() {
        for (ServerStatusListener serverStatusListener : this.aQ) {
            try {
                serverStatusListener.onStatusChange(this, this.aO.get());
            }
            catch (Exception exception) {
                logger.error("Exception in ServerStatusListener", (Throwable)exception);
            }
        }
    }

    private EndpointDescription[] getEndpoints() throws InvalidServerEndpointException, ConnectException, ServiceException {
        Object object;
        this.aw = this.discoverEndpoints();
        if (logger.isDebugEnabled()) {
            logger.debug("endpoints:" + Arrays.toString(this.aw));
        }
        if (this.aw == null || this.aw.length == 0) {
            throw new ServiceException("GetEndpointsResponse, endpoint list received from the server is empty.", new StatusCode(StatusCodes.Bad_UnexpectedError));
        }
        EndpointDescription[] endpointDescriptionArray = this.a(this.aw, this.getUri());
        if (endpointDescriptionArray.length == 0 && (((UaClient)(object = this)).getHost().isEmpty() || ((UaClient)object).getHost().toLowerCase().equals("localhost"))) {
            try {
                object = InetAddress.getLocalHost();
                endpointDescriptionArray = this.a(this.aw, this.getUri().replaceFirst("localhost", ((InetAddress)object).getHostName()));
                endpointDescriptionArray = this.a(this.aw, this.getUri().replaceFirst("localhost", ((InetAddress)object).getCanonicalHostName()));
            }
            catch (UnknownHostException unknownHostException) {
                logger.info("Cannot convert localhost to HostName: ", (Throwable)unknownHostException);
            }
        }
        if (endpointDescriptionArray.length == 0) {
            endpointDescriptionArray = this.a(this.aw, null);
        }
        if (endpointDescriptionArray.length == 0) {
            throw new InvalidServerEndpointException("Requested endpoint not supported by the server", this.getUri(), this.getProtocol().equals((Object)UaApplication.Protocol.OpcTcp) ? this.getSecurityMode() : SecurityMode.NONE);
        }
        endpointDescriptionArray = EndpointUtil.sortBySecurityLevel((EndpointDescription[])endpointDescriptionArray);
        return endpointDescriptionArray;
    }

    private RequestHeader a(UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2, String string) {
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setReturnDiagnostics(unsignedInteger);
        requestHeader.setTimeoutHint(unsignedInteger2);
        requestHeader.setAuditEntryId(string);
        requestHeader.setTimestamp(DateTime.currentTime());
        requestHeader.setRequestHandle(this.w());
        return requestHeader;
    }

    private StatusCode q() {
        return this.aP.get();
    }

    private ServerStatusDataType r() {
        return this.aO.get();
    }

    private synchronized SubscriptionAcknowledgement[] getSubscriptionAcknowledgements() {
        SubscriptionAcknowledgement[] subscriptionAcknowledgementArray = this.ar.toArray(new SubscriptionAcknowledgement[0]);
        this.ar = new ArrayList<SubscriptionAcknowledgement>();
        return subscriptionAcknowledgementArray;
    }

    private DataValue[] a(NodeId object, NumericRange numericRange, TimestampsToReturn timestampsToReturn, HistoryReadDetails historyReadDetails) throws ServiceException, StatusException, DecodingException {
        Object[] objectArray;
        HistoryReadValueId historyReadValueId = new HistoryReadValueId();
        historyReadValueId.setNodeId(object);
        if (numericRange != null) {
            historyReadValueId.setIndexRange(numericRange.toString());
        }
        object = null;
        do {
            objectArray = this.historyRead(historyReadDetails, timestampsToReturn, false, historyReadValueId);
            this.checkOperationResult(objectArray[0].getStatusCode());
            if (objectArray[0].getStatusCode().getValue().equals((Object)StatusCodes.Good_NoData) || (numericRange = objectArray[0].getHistoryData()) == null) break;
            numericRange = (HistoryData)numericRange.decode(this.client.getEncoderContext());
            byte[] byArray = objectArray[0].getContinuationPoint();
            objectArray = byArray;
            if (byArray == null && object == null) {
                return numericRange.getDataValues();
            }
            if (object == null) {
                object = new ArrayList();
            }
            object.addAll(Arrays.asList(numericRange.getDataValues()));
            historyReadValueId.setContinuationPoint((byte[])objectArray);
            if (numericRange.getDataValues().length == 0 && objectArray != null) {
                logger.info("historyReadAll: Received empty HistoryData with continuationPoint");
                break;
            }
            logger.debug("historyReadAll: got {} values", (Object)numericRange.getDataValues().length);
        } while (objectArray != null);
        if (object == null) {
            return new DataValue[0];
        }
        return object.toArray(new DataValue[object.size()]);
    }

    private HistoryEventFieldList[] b(NodeId object, NumericRange numericRange, TimestampsToReturn timestampsToReturn, HistoryReadDetails historyReadDetails) throws ServiceException, StatusException, DecodingException {
        Object[] objectArray;
        numericRange = new HistoryReadValueId();
        numericRange.setNodeId(object);
        object = null;
        do {
            ExtensionObject extensionObject;
            objectArray = this.historyRead(historyReadDetails, timestampsToReturn, false, new HistoryReadValueId[]{numericRange});
            this.checkOperationResult(objectArray[0].getStatusCode());
            if (objectArray[0].getStatusCode().getValue().equals((Object)StatusCodes.Good_NoData) || (extensionObject = objectArray[0].getHistoryData()) == null) break;
            extensionObject = (HistoryEvent)extensionObject.decode(this.client.getEncoderContext());
            byte[] byArray = objectArray[0].getContinuationPoint();
            objectArray = byArray;
            if (byArray == null && object == null) {
                return extensionObject.getEvents();
            }
            if (object == null) {
                object = new ArrayList();
            }
            object.addAll(Arrays.asList(extensionObject.getEvents()));
            numericRange.setContinuationPoint((byte[])objectArray);
        } while (objectArray != null);
        if (object == null) {
            return new HistoryEventFieldList[0];
        }
        return object.toArray(new HistoryEventFieldList[object.size()]);
    }

    private HistoryModifiedData c(NodeId object, NumericRange object2, TimestampsToReturn timestampsToReturn, HistoryReadDetails historyReadDetails) throws ServiceException, StatusException, DecodingException {
        Object[] objectArray;
        HistoryReadValueId historyReadValueId = new HistoryReadValueId();
        historyReadValueId.setNodeId(object);
        if (object2 != null) {
            historyReadValueId.setIndexRange(object2.toString());
        }
        object = null;
        object2 = null;
        do {
            ExtensionObject extensionObject;
            objectArray = this.historyRead(historyReadDetails, timestampsToReturn, false, historyReadValueId);
            this.checkOperationResult(objectArray[0].getStatusCode());
            if (objectArray[0].getStatusCode().getValue().equals((Object)StatusCodes.Good_NoData) || (extensionObject = objectArray[0].getHistoryData()) == null) break;
            extensionObject = (HistoryModifiedData)extensionObject.decode(this.client.getEncoderContext());
            byte[] byArray = objectArray[0].getContinuationPoint();
            objectArray = byArray;
            if (byArray == null && object == null) {
                return extensionObject;
            }
            if (object == null) {
                object = new ArrayList();
                object2 = new ArrayList();
            }
            object.addAll(Arrays.asList(extensionObject.getDataValues()));
            object2.addAll(Arrays.asList(extensionObject.getModificationInfos()));
            historyReadValueId.setContinuationPoint((byte[])objectArray);
        } while (objectArray != null);
        if (object == null) {
            return new HistoryModifiedData(new DataValue[0], new ModificationInfo[0]);
        }
        return new HistoryModifiedData(object.toArray(new DataValue[object.size()]), object2.toArray(new ModificationInfo[object2.size()]));
    }

    private void t() {
        Application application = this.client.getApplication();
        application.setApplicationName(this.getApplicationIdentity().getApplicationDescription().getApplicationName());
        application.setApplicationUri(this.getApplicationIdentity().getApplicationDescription().getApplicationUri());
        application.setProductUri(this.getApplicationIdentity().getApplicationDescription().getProductUri());
    }

    private void u() {
        if (this.client == null) {
            this.client = Client.createClientApplication((KeyPair)this.applicationIdentity.getKeys());
            this.client.getApplicationHttpsSettings().readFrom(this.getHttpsSettings());
            this.client.getApplicationHttpsSettings().setKeyPair(this.applicationIdentity.getHttpsCertificate(), new Cert[0]);
        }
    }

    private void v() throws InvalidServerEndpointException, ConnectException, ServiceException {
        if (this.getUri() == null) {
            throw new NullPointerException("Uri not defined.");
        }
        EndpointDescription[] endpointDescriptionArray = this.getEndpoints();
        this.endpoint = endpointDescriptionArray[endpointDescriptionArray.length - 1];
        if (!this.endpoint.getEndpointUrl().equals(this.getUri())) {
            logger.info("Using an alternate endpoint URL '{}' instead of the requested '{}'", (Object)this.endpoint.getEndpointUrl(), (Object)this.getUri());
        }
        logger.debug("initEndpoint: endpoint={}", (Object)this.endpoint);
    }

    private UnsignedInteger w() {
        long l2 = 0L;
        while (l2 == 0L) {
            long l3 = this.aA.incrementAndGet();
            l2 = l3 & 0xFFFFFFFFL;
        }
        return new UnsignedInteger(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void x() {
        if (this.isConnected() && this.aK != null) {
            UaClient uaClient = this;
            synchronized (uaClient) {
                this.notify();
                return;
            }
        }
    }

    private static DataValue a(Object object) {
        if (object instanceof DataValue) {
            object = (DataValue)object;
        } else {
            object = object instanceof Variant ? (Variant)object : new Variant(object);
            object = new DataValue((Variant)object, StatusCode.GOOD);
        }
        return object;
    }

    private synchronized void y() throws ServiceException, StatusException {
        DataValue dataValue = this.readValue(Identifiers.Server_NamespaceArray);
        this.getEncoderContext().setNamespaceTable(NamespaceTable.createFromArray((String[])((String[])dataValue.getValue().getValue())));
        this.aF = true;
    }

    private void z() throws ServiceException, StatusException {
        DataValue dataValue = this.readValue(Identifiers.Server_ServerArray);
        this.getEncoderContext().setServerTable(ServerTable.createFromArray((String[])((String[])dataValue.getValue().getValue())));
        this.aR = true;
    }

    private void A() {
        for (Subscription subscription : this.bc) {
            try {
                subscription.republishAllAvailable();
            }
            catch (ServiceException serviceException) {
                logger.info("Subscription ID={} no longer valid (), recreating", (Object)subscription.getSubscriptionId(), (Object)serviceException.getServiceResult());
                subscription.setSubscriptionId(0);
            }
        }
    }

    private EndpointDescription[] a(EndpointDescription[] endpointDescriptionArray, String string) {
        return EndpointUtil.select((EndpointDescription[])endpointDescriptionArray, (String)string, (String)this.getProtocol().toString(), (MessageSecurityMode)this.aM.getMessageSecurityMode(), (SecurityPolicy)this.aM.getSecurityPolicy(), null);
    }

    private void a(SessionChannel sessionChannel) {
        this.channel.set(sessionChannel);
    }

    private synchronized void a(ServerStatusDataType serverStatusDataType, StatusCode statusCode) {
        if (logger.isTraceEnabled()) {
            logger.trace("setServerStatusAndError: Status=" + (serverStatusDataType == null ? "null" : serverStatusDataType.getState()) + " Code=" + statusCode);
        }
        this.aO.set(serverStatusDataType);
        this.aP.set(statusCode);
    }

    private synchronized void startPublishing() {
        logger.debug("startPublishing");
        if (this.aK == null) {
            this.aJ = new a(this);
            this.aK = new Thread(this.aJ);
            this.aK.setName("PublishTask-" + this.toString());
            this.aK.start();
        }
    }

    private synchronized void stopPublishing() {
        if (this.aK != null) {
            logger.debug("stopPublishing: interrupting publishThread");
            this.notify();
            this.aJ.terminate();
            this.aJ = null;
            this.aK = null;
        }
    }

    private TransferResult[] B() throws ServiceException {
        if (logger.isDebugEnabled()) {
            logger.debug("transferSubscriptions: subscriptions.size()={}", (Object)this.bc.size());
        }
        if (this.bc.size() > 0) {
            TransferSubscriptionsResponse transferSubscriptionsResponse;
            UnsignedInteger[] unsignedIntegerArray = new UnsignedInteger[this.bc.size()];
            for (int i2 = 0; i2 < this.bc.size(); ++i2) {
                unsignedIntegerArray[i2] = this.bc.get(i2).getSubscriptionId();
            }
            try {
                transferSubscriptionsResponse = this.D().TransferSubscriptions(this.getRequestHeader(), unsignedIntegerArray, Boolean.valueOf(true));
            }
            catch (ServiceFaultException serviceFaultException) {
                throw new ServiceException(serviceFaultException);
            }
            catch (ServiceResultException serviceResultException) {
                throw new ServiceException(serviceResultException);
            }
            this.checkServiceResult((ServiceResponse)transferSubscriptionsResponse, transferSubscriptionsResponse.getDiagnosticInfos());
            unsignedIntegerArray = transferSubscriptionsResponse.getResults();
            this.a((TransferResult[])unsignedIntegerArray);
            return unsignedIntegerArray;
        }
        return new TransferResult[0];
    }

    private void C() {
        int n2 = 0;
        for (UaApplication.DiagnosticMask diagnosticMask : this.aG) {
            n2 += diagnosticMask.getValue();
        }
        n2 <<= 5;
        for (UaApplication.DiagnosticMask diagnosticMask : this.aT) {
            n2 += diagnosticMask.getValue();
        }
        this.av = UnsignedInteger.valueOf((long)n2);
    }

    protected synchronized void addSubscriptionAck(SubscriptionAcknowledgement subscriptionAcknowledgement) {
        this.ar.add(subscriptionAcknowledgement);
    }

    protected void finalize() throws Throwable {
        if (this.isConnected()) {
            System.err.println("UaClient.close() was never called. Still connected to " + this.getUri() + " at finalize(). Check that you disconnect your connection properly.");
        }
        super.finalize();
    }

    protected HttpsSecurityPolicy[] getHttpsSecurityPolicies() {
        return this.getHttpsSettings().getHttpsSecurityPolicies();
    }

    protected void resetSubscriptionsAfterRemove(Subscription[] subscriptionArray, StatusCode[] statusCodeArray) {
        for (int i2 = 0; i2 < subscriptionArray.length; ++i2) {
            if (subscriptionArray[i2].getClient() == this) {
                subscriptionArray[i2].reset();
            }
            boolean bl = this.bc.remove(subscriptionArray[i2]);
            if (statusCodeArray[i2] != null) continue;
            statusCodeArray[i2] = bl ? StatusCode.GOOD : new StatusCode(StatusCodes.Good_NoData);
        }
    }

    protected void setHttpsSecurityPolicies(HttpsSecurityPolicy[] httpsSecurityPolicyArray) {
        this.getHttpsSettings().setHttpsSecurityPolicies(httpsSecurityPolicyArray);
    }

    final void checkOperationResult(StatusCode statusCode) throws StatusException {
        if (statusCode.isBad()) {
            DiagnosticInfo[] diagnosticInfoArray = this.az.get();
            if (diagnosticInfoArray == null || diagnosticInfoArray.length == 0) {
                throw new StatusException(statusCode);
            }
            throw new StatusException(statusCode, diagnosticInfoArray[0]);
        }
    }

    static void a(Object[] objectArray, Object[] objectArray2) throws ServiceException {
        if (objectArray == null) {
            throw new ServiceException("Results == null");
        }
        if (objectArray.length != objectArray2.length) {
            throw new ServiceException("Size of results differs from requested");
        }
    }

    final void checkServiceResult(ServiceResponse serviceResponse, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        serviceResponse = serviceResponse.getResponseHeader();
        this.aB.set((ResponseHeader)serviceResponse);
        this.az.set(diagnosticInfoArray);
        if (serviceResponse.getServiceResult().isBad()) {
            throw new ServiceException(serviceResponse.getServiceResult(), serviceResponse.getServiceDiagnostics());
        }
    }

    final SessionChannel D() throws ServerConnectionException {
        logger.trace("getChannel");
        if (!this.isConnected()) {
            throw new ServerConnectionException("Server not connected", this.getUri(), this.aM);
        }
        return this.channel.get();
    }

    final RequestHeader getRequestHeader() {
        return this.a(this.av, this.aZ, this.at);
    }

    final SubscriptionBase a(SubscriptionBase subscriptionBase) throws ServiceException, ServerConnectionException {
        logger.debug("modifySubscription: isConnected={}", (Object)this.isConnected());
        if (this.isConnected()) {
            ModifySubscriptionResponse modifySubscriptionResponse;
            try {
                logger.debug("modifySubscription: subscription={}", (Object)subscriptionBase);
                modifySubscriptionResponse = this.D().ModifySubscription(this.getRequestHeader(), subscriptionBase.getSubscriptionId(), Double.valueOf(subscriptionBase.getPublishingInterval()), UnsignedInteger.valueOf((long)subscriptionBase.getLifetimeCount()), UnsignedInteger.valueOf((long)subscriptionBase.getMaxKeepAliveCount()), UnsignedInteger.valueOf((long)subscriptionBase.getMaxNotificationsPerPublish()), UnsignedByte.valueOf((int)subscriptionBase.getPriority()));
                logger.debug("modifySubscription: response={}", (Object)modifySubscriptionResponse.getResponseHeader().getServiceResult());
            }
            catch (ServiceFaultException serviceFaultException) {
                logger.debug("modifySubscription: exception={}", (Throwable)serviceFaultException);
                throw new ServiceException(serviceFaultException);
            }
            catch (ServiceResultException serviceResultException) {
                logger.debug("modifySubscription: exception={}", (Throwable)serviceResultException);
                throw new ServiceException(serviceResultException);
            }
            this.checkServiceResult((ServiceResponse)modifySubscriptionResponse, null);
            subscriptionBase.setPublishingInterval(modifySubscriptionResponse.getRevisedPublishingInterval());
            subscriptionBase.setLifetimeCount(modifySubscriptionResponse.getRevisedLifetimeCount());
            subscriptionBase.setMaxKeepAliveCount(modifySubscriptionResponse.getRevisedMaxKeepAliveCount());
        }
        return subscriptionBase;
    }

    final void b(SubscriptionBase subscriptionBase) throws ServiceException, StatusException {
        if (this.isConnected()) {
            try {
                subscriptionBase = this.D().SetPublishingMode(this.getRequestHeader(), Boolean.valueOf(subscriptionBase.isPublishingEnabled()), new UnsignedInteger[]{subscriptionBase.getSubscriptionId()});
            }
            catch (ServiceFaultException serviceFaultException) {
                throw new ServiceException(serviceFaultException);
            }
            catch (ServiceResultException serviceResultException) {
                throw new ServiceException(serviceResultException);
            }
            this.checkServiceResult((ServiceResponse)subscriptionBase, subscriptionBase.getDiagnosticInfos());
            this.checkOperationResult(subscriptionBase.getResults()[0]);
        }
    }

    static /* synthetic */ boolean a(UaClient object, PublishResponse publishResponse) throws ServiceException {
        logger.debug("handlePublishResponse: response={}", (Object)publishResponse.getNotificationMessage().getSequenceNumber());
        logger.trace("handlePublishResponse: response={}", (Object)publishResponse);
        if (((UaClient)object).isConnected()) {
            ((UaClient)object).checkServiceResult((ServiceResponse)publishResponse, publishResponse.getDiagnosticInfos());
            if (((UaClient)object).aD != null && !((UaClient)object).aD.validatePublishResponse((UaClient)object, publishResponse)) {
                return false;
            }
            if ((object = ((UaClient)object).getSubscriptionById(publishResponse.getSubscriptionId())) == null) {
                logger.info("handlePublishResponse: no subscription with ID={} SequenceNumber={}; response discarded", (Object)publishResponse.getSubscriptionId(), (Object)publishResponse.getNotificationMessage().getSequenceNumber());
                return false;
            }
            ((Subscription)object).onPublishResponse(publishResponse);
            return true;
        }
        logger.debug("handlePublishResponse: not connected; response discarded");
        return false;
    }

    private class a
    implements ResultListener<ServiceResponse>,
    Runnable {
        private long cI;
        private final Logger logger = LoggerFactory.getLogger(a.class);
        private final AtomicInteger cJ = new AtomicInteger(0);
        private volatile boolean cK = false;
        private volatile boolean cL = false;
        private /* synthetic */ UaClient cM;

        public a(UaClient uaClient) {
            this.cM = uaClient;
        }

        public void onError(ServiceResultException serviceResultException) {
            UnsignedInteger unsignedInteger = serviceResultException.getStatusCode().getValue();
            if (a.c(unsignedInteger) || unsignedInteger.equals((Object)StatusCodes.Bad_NoSubscription)) {
                this.logger.debug("onError: {}", (Object)serviceResultException.getMessage());
            } else {
                this.logger.warn("onError: ", (Throwable)serviceResultException);
            }
            this.cJ.decrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.logger.debug("run");
            while (!this.cK) {
                Object object = this;
                ((a)object).logger.trace("queuePublishRequests: #subscriptions={}", (Object)((a)object).cM.bc.size());
                if (!((a)object).cM.bc.isEmpty()) {
                    int n2 = (int)Math.ceil((double)((a)object).cM.bc.size() * ((a)object).cM.getPublishRequestFactor());
                    ((a)object).logger.trace("queuePublishRequests: n={}", (Object)n2);
                    while (((a)object).isActive() && ((a)object).cJ.get() < n2) {
                        ((a)object).logger.trace("queuePublishRequests: requestCount={}", (Object)((a)object).cJ.get());
                        if (((a)object).ag()) continue;
                    }
                }
                object = this;
                for (Subscription subscription : ((a)object).cM.bc) {
                    try {
                        subscription.handleNotificationDatas();
                    }
                    catch (Exception exception) {
                        ((a)object).logger.error("handlePublishResponses", (Throwable)exception);
                    }
                }
                a a2 = object;
                for (Subscription subscription : a2.cM.bc) {
                    subscription.checkTimeout();
                }
                object = this;
                ((a)object).logger.trace("checkServerStatus: statusCheckInterval={}", (Object)((a)object).cM.aX);
                if (((a)object).cM.aX > 0L) {
                    Subscription subscription;
                    boolean bl = ((a)object).cM.r() != null;
                    subscription = ((a)object).cM.getServerState();
                    boolean bl2 = subscription.equals(ServerState.CommunicationFault);
                    if (bl2 && (a2 = ((a)object).cM.q()) != null) {
                        UnsignedInteger unsignedInteger = a2.getValue();
                        bl2 = a.c(unsignedInteger);
                    }
                    boolean bl3 = bl2 || subscription.equals(ServerState.Shutdown) && System.currentTimeMillis() > ((a)object).cM.aW;
                    boolean bl4 = System.currentTimeMillis() - ((a)object).cI > ((a)object).cM.aX;
                    ((a)object).logger.trace("checkServerStatus: hasStatus={} commError={} isConnected={} timeToCheck={} timeToReconnect", new Object[]{bl, bl2, ((a)object).cM.isConnected(), bl4});
                    if (((a)object).cM.isAutoReconnect() && bl3) {
                        try {
                            ((a)object).cM.reconnect();
                            bl4 = true;
                        }
                        catch (Exception exception) {
                            ((a)object).logger.debug("checkServerStatus: reconnect failed: ", (Throwable)exception);
                        }
                    }
                    if (((a)object).cM.isConnected() && (!bl || bl4)) {
                        ((a)object).cM.updateServerStatus();
                        ((a)object).cI = System.currentTimeMillis();
                        if (((a)object).cM.ax) {
                            ((a)object).cM.a(false);
                        }
                    }
                }
                try {
                    this.logger.trace("sleep");
                    object = this.cM;
                    synchronized (object) {
                        this.cM.wait(100L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.logger.debug("interrupted");
                }
            }
            this.logger.debug("terminated");
        }

        public final void terminate() {
            this.cK = true;
        }

        private boolean isActive() {
            try {
                ServerStatusDataType serverStatusDataType = this.cM.getServerStatus();
                this.logger.trace("isActive: status={}", (Object)serverStatusDataType);
                if (serverStatusDataType == null && this.cM.aX == 0L) {
                    return true;
                }
                return serverStatusDataType != null && serverStatusDataType.getState().equals((Object)ServerState.Running);
            }
            catch (ServerConnectionException serverConnectionException) {
                this.logger.trace("isActive: exception=", (Throwable)serverConnectionException);
                return false;
            }
            catch (StatusException statusException) {
                this.logger.trace("isActive: exception=", (Throwable)statusException);
                return false;
            }
        }

        private boolean ag() {
            if (this.cJ.get() == 0) {
                this.cL = false;
            }
            if (!this.cL) {
                try {
                    SessionChannel sessionChannel = this.cM.D();
                    this.logger.debug("sendPublishRequest: channel={} secureChannel.isOpen={}", (Object)sessionChannel, (Object)sessionChannel.getSecureChannel().isOpen());
                    if (sessionChannel != null) {
                        RequestHeader requestHeader = this.cM.a(null, this.cM.getPublishRequestTimeout(), null);
                        requestHeader = new PublishRequest(requestHeader, this.cM.getSubscriptionAcknowledgements());
                        if (this.cM.aD != null) {
                            this.cM.aD.onBeforePublishRequest(this.cM, (PublishRequest)requestHeader);
                        }
                        sessionChannel = sessionChannel.PublishAsync((PublishRequest)requestHeader);
                        sessionChannel.setListener((ResultListener)this);
                        this.cJ.incrementAndGet();
                        this.logger.trace("request sent: publishRequest");
                        return true;
                    }
                }
                catch (ServerConnectionException serverConnectionException) {
                    this.logger.debug("ServerConnectionException: ", (Throwable)serverConnectionException);
                }
            }
            return false;
        }

        private static boolean c(UnsignedInteger unsignedInteger) {
            return unsignedInteger.equals((Object)StatusCodes.Bad_ServerNotConnected) || unsignedInteger.equals((Object)StatusCodes.Bad_Timeout) || unsignedInteger.equals((Object)StatusCodes.Bad_SessionClosed) || unsignedInteger.equals((Object)StatusCodes.Bad_SecureChannelIdInvalid) || unsignedInteger.equals((Object)StatusCodes.Bad_SecureChannelClosed) || unsignedInteger.equals((Object)StatusCodes.Bad_SessionIdInvalid) || unsignedInteger.equals((Object)StatusCodes.Bad_SessionNotActivated);
        }
    }
}

