/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client;

import com.prosysopc.ua.MonitoredItemBase;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.SubscriptionBase;
import com.prosysopc.ua.client.MonitoredDataItem;
import com.prosysopc.ua.client.MonitoredEventItem;
import com.prosysopc.ua.client.MonitoredItem;
import com.prosysopc.ua.client.ServerConnectionException;
import com.prosysopc.ua.client.SubscriptionAliveListener;
import com.prosysopc.ua.client.SubscriptionNotificationListener;
import com.prosysopc.ua.client.UaClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.ExtensionObject;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.ServiceResponse;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedByte;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.common.ServiceFaultException;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.CreateMonitoredItemsResponse;
import org.opcfoundation.ua.core.DataChangeNotification;
import org.opcfoundation.ua.core.DeleteMonitoredItemsResponse;
import org.opcfoundation.ua.core.EventFieldList;
import org.opcfoundation.ua.core.EventNotificationList;
import org.opcfoundation.ua.core.ModifyMonitoredItemsResponse;
import org.opcfoundation.ua.core.MonitoredItemCreateRequest;
import org.opcfoundation.ua.core.MonitoredItemCreateResult;
import org.opcfoundation.ua.core.MonitoredItemModifyRequest;
import org.opcfoundation.ua.core.MonitoredItemModifyResult;
import org.opcfoundation.ua.core.MonitoringFilterResult;
import org.opcfoundation.ua.core.MonitoringMode;
import org.opcfoundation.ua.core.MonitoringParameters;
import org.opcfoundation.ua.core.NotificationData;
import org.opcfoundation.ua.core.PublishResponse;
import org.opcfoundation.ua.core.ReadValueId;
import org.opcfoundation.ua.core.RepublishResponse;
import org.opcfoundation.ua.core.ResponseHeader;
import org.opcfoundation.ua.core.SetMonitoringModeResponse;
import org.opcfoundation.ua.core.StatusChangeNotification;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.core.SubscriptionAcknowledgement;
import org.opcfoundation.ua.core.TimestampsToReturn;
import org.opcfoundation.ua.core.TransferSubscriptionsResponse;
import org.opcfoundation.ua.encoding.DecodingException;
import org.opcfoundation.ua.encoding.EncoderContext;
import org.opcfoundation.ua.encoding.EncodingException;
import org.opcfoundation.ua.utils.AttributesUtil;
import org.opcfoundation.ua.utils.MultiDimensionArrayUtils;
import org.opcfoundation.ua.utils.NumericRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Subscription
extends SubscriptionBase {
    private static final ExtensionObject[] fv = new ExtensionObject[0];
    private static final long fw = UnsignedInteger.MAX_VALUE.longValue() / 2L;
    private static final Logger logger = LoggerFactory.getLogger(Subscription.class);
    private final List<SubscriptionAliveListener> fx = new CopyOnWriteArrayList<SubscriptionAliveListener>();
    private volatile UaClient fm;
    private DiagnosticInfo ds;
    private volatile Calendar fy;
    private DiagnosticInfo[] fz;
    private volatile UnsignedInteger fA = UnsignedInteger.ZERO;
    private ResponseHeader fB;
    private final AtomicReference<a> fC = new AtomicReference();
    private int fD = -1;
    private int fE = 100;
    private final List<SubscriptionNotificationListener> fF = new CopyOnWriteArrayList<SubscriptionNotificationListener>();
    private final ConcurrentSkipListMap<UnsignedInteger, ExtensionObject[]> fG = new ConcurrentSkipListMap();
    private boolean fH = true;
    private StatusCode aj = StatusCode.GOOD;
    private volatile boolean fI;
    private double fJ = 1.3;
    private TimestampsToReturn ex = TimestampsToReturn.Source;
    protected boolean modified;

    public Subscription() {
        this(true, 1000.0, 60L, 20L, 0L, 0);
    }

    public Subscription(Boolean bl, Double d2, long l2, long l3, long l4, int n2) {
        super(null, bl, d2, UnsignedInteger.valueOf((long)l2), UnsignedInteger.valueOf((long)l3), UnsignedInteger.valueOf((long)l4), UnsignedByte.valueOf((int)n2));
    }

    public Subscription(UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2, UnsignedInteger unsignedInteger3, Double d2, Boolean bl, UnsignedByte unsignedByte) {
        super(null, bl, d2, unsignedInteger2, unsignedInteger3, unsignedInteger, unsignedByte);
    }

    public void addAliveListener(SubscriptionAliveListener subscriptionAliveListener) {
        if (!this.hasAliveListener(subscriptionAliveListener)) {
            this.fx.add(subscriptionAliveListener);
        }
    }

    public MonitoredItemCreateResult addItem(MonitoredItem monitoredItem) throws ServiceException, StatusException {
        this.addItem(monitoredItem, monitoredItem.getClientHandle());
        monitoredItem.a(this);
        try {
            CreateMonitoredItemsResponse createMonitoredItemsResponse = this.createMonitoredItems(monitoredItem);
            if (createMonitoredItemsResponse != null && createMonitoredItemsResponse.getResults() != null && createMonitoredItemsResponse.getResults().length > 0) {
                if (createMonitoredItemsResponse.getResults().length > 1 && logger.isWarnEnabled()) {
                    logger.warn("Got more than one CreateMonitoredItemResponse for one added item: {}, results: {}", (Object)monitoredItem, (Object)MultiDimensionArrayUtils.toString((Object)createMonitoredItemsResponse.getResults()));
                }
                this.fm.checkOperationResult(createMonitoredItemsResponse.getResults()[0].getStatusCode());
                return createMonitoredItemsResponse.getResults()[0];
            }
        }
        catch (ServiceException serviceException) {
            ServiceException serviceException2 = serviceException;
            throw serviceException;
        }
        catch (StatusException statusException) {
            StatusException statusException2 = statusException;
            throw statusException;
        }
        return null;
    }

    public MonitoredItemCreateResult[] addItems(MonitoredItem ... monitoredItemArray) throws ServiceException {
        for (int i2 = 0; i2 < monitoredItemArray.length; ++i2) {
            this.addItem(monitoredItemArray[i2], monitoredItemArray[i2].getClientHandle());
            monitoredItemArray[i2].a(this);
        }
        CreateMonitoredItemsResponse createMonitoredItemsResponse = this.createMonitoredItems(monitoredItemArray);
        if (createMonitoredItemsResponse != null) {
            return createMonitoredItemsResponse.getResults();
        }
        return null;
    }

    public void addNotificationListener(SubscriptionNotificationListener subscriptionNotificationListener) {
        if (!this.hasNotificationListener(subscriptionNotificationListener)) {
            this.fF.add(subscriptionNotificationListener);
        }
    }

    public SubscriptionAliveListener[] getAliveListeners() {
        return this.fx.toArray(new SubscriptionAliveListener[this.fx.size()]);
    }

    public UnsignedInteger[] getAvailableSequenceNumbers() {
        List<UnsignedInteger> list = this.getAvailableSequenceNumbersList();
        return list.toArray(new UnsignedInteger[list.size()]);
    }

    public UaClient getClient() {
        return this.fm;
    }

    public DiagnosticInfo getDiagnosticInfo() {
        return this.ds;
    }

    @Override
    public MonitoredItem getItem(NodeId nodeId, UnsignedInteger unsignedInteger) {
        return (MonitoredItem)super.getItem(nodeId, unsignedInteger);
    }

    public Calendar getLastAlive() {
        return this.fy;
    }

    public DiagnosticInfo[] getLastOperationDiagnostics() {
        return this.fz;
    }

    public UnsignedInteger getLastSequenceNumber() {
        return this.fA;
    }

    public DiagnosticInfo getLastServiceDiagnostics() {
        return this.fB.getServiceDiagnostics();
    }

    public StatusCode getLastServiceResult() {
        return this.fB.getServiceResult();
    }

    public int getMaxMonitoredItemsPerCall() {
        if (this.fD < 0) {
            return this.aE();
        }
        return this.fD;
    }

    public int getNotificationBufferSize() {
        return this.fE;
    }

    public SubscriptionNotificationListener[] getNotificationListeners() {
        return this.fF.toArray(new SubscriptionNotificationListener[this.fF.size()]);
    }

    public StatusCode getStatus() {
        return this.aj;
    }

    public double getTimeoutDetectionFactor() {
        return this.fJ;
    }

    public TimestampsToReturn getTimestampsToReturn() {
        return this.ex;
    }

    public boolean hasAliveListener(SubscriptionAliveListener subscriptionAliveListener) {
        if (subscriptionAliveListener == null) {
            throw new NullPointerException("null listener not allowed");
        }
        return this.fx.contains(subscriptionAliveListener);
    }

    public boolean hasNotificationListener(SubscriptionNotificationListener subscriptionNotificationListener) {
        if (subscriptionNotificationListener == null) {
            throw new NullPointerException("null listener not allowed");
        }
        return this.fF.contains(subscriptionNotificationListener);
    }

    public boolean isConnected() {
        UnsignedInteger unsignedInteger = this.getSubscriptionId();
        return unsignedInteger != null && !unsignedInteger.equals((Object)UnsignedInteger.ZERO);
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isRetransmissionEnabled() {
        return this.fH;
    }

    public boolean isTimeout() {
        return this.fI;
    }

    public String itemsToString() {
        return this.items.toString();
    }

    public DataValue[] readAll(Double d2, TimestampsToReturn timestampsToReturn) throws ServiceException {
        MonitoredItemBase[] monitoredItemBaseArray = this.getItems();
        ReadValueId[] readValueIdArray = new ReadValueId[monitoredItemBaseArray.length];
        for (int i2 = 0; i2 < monitoredItemBaseArray.length; ++i2) {
            if (!(monitoredItemBaseArray[i2] instanceof MonitoredDataItem)) continue;
            MonitoredDataItem monitoredDataItem = (MonitoredDataItem)monitoredItemBaseArray[i2];
            readValueIdArray[i2] = new ReadValueId(monitoredDataItem.getNodeId(), monitoredDataItem.getAttributeId(), NumericRange.toString((NumericRange)monitoredDataItem.getIndexRange()), monitoredDataItem.getDataEncoding());
        }
        return this.fm.read(d2, timestampsToReturn, readValueIdArray).getResults();
    }

    public void removeAliveListener(SubscriptionAliveListener subscriptionAliveListener) {
        this.fx.remove(subscriptionAliveListener);
    }

    @Override
    public MonitoredItemBase removeItem(MonitoredItemBase monitoredItemBase) throws ServiceException, StatusException {
        logger.debug("removeItem: {}", (Object)monitoredItemBase);
        return this.removeItem(monitoredItemBase.getClientHandle());
    }

    @Override
    public MonitoredItemBase removeItem(UnsignedInteger object) throws ServiceException, StatusException {
        object = super.removeItem((UnsignedInteger)object);
        try {
            DeleteMonitoredItemsResponse deleteMonitoredItemsResponse = object == null ? null : this.deleteMonitoredItems(new MonitoredItemBase[]{object});
            if (deleteMonitoredItemsResponse != null && deleteMonitoredItemsResponse.getResults()[0].isBad()) {
                throw new StatusException(deleteMonitoredItemsResponse.getResults()[0]);
            }
        }
        finally {
            if (object != null) {
                ((MonitoredItem)object).setMonitoredItemId(UnsignedInteger.ZERO);
            }
        }
        return object;
    }

    public StatusCode[] removeItems() throws ServiceException {
        return this.removeItems(null);
    }

    public StatusCode[] removeItems(MonitoredItemBase ... deleteMonitoredItemsResponse) throws ServiceException {
        StatusCode[] statusCodeArray = null;
        if (deleteMonitoredItemsResponse == null) {
            deleteMonitoredItemsResponse = this.getItems();
        }
        for (MonitoredItemBase monitoredItemBase : deleteMonitoredItemsResponse) {
            try {
                if (monitoredItemBase == null) continue;
                super.removeItem(monitoredItemBase.getClientHandle());
            }
            catch (StatusException statusException) {}
        }
        try {
            DeleteMonitoredItemsResponse deleteMonitoredItemsResponse2 = this.deleteMonitoredItems((MonitoredItemBase[])deleteMonitoredItemsResponse);
            if (deleteMonitoredItemsResponse2 != null) {
                statusCodeArray = deleteMonitoredItemsResponse2.getResults();
            }
        }
        finally {
            for (MonitoredItemBase monitoredItemBase : deleteMonitoredItemsResponse) {
                if (monitoredItemBase == null) continue;
                ((MonitoredItem)monitoredItemBase).setMonitoredItemId(UnsignedInteger.ZERO);
            }
        }
        return statusCodeArray;
    }

    public void removeNotificationListener(SubscriptionNotificationListener subscriptionNotificationListener) {
        this.fF.remove(subscriptionNotificationListener);
    }

    public void republishAllAvailable() throws ServiceException {
        StatusCode statusCode = StatusCode.GOOD;
        UnsignedInteger unsignedInteger = this.fA;
        while (statusCode.isGood()) {
            unsignedInteger = this.fA;
            long l2 = unsignedInteger.longValue() + 1L;
            if (l2 > 0xFFFFFFFFL) {
                l2 = 1L;
            }
            statusCode = this.a(l2, false);
        }
        if (statusCode.getValue().equals((Object)StatusCodes.Bad_MessageNotAvailable)) {
            this.fA = unsignedInteger;
            return;
        }
        throw new ServiceException(statusCode);
    }

    public void setMaxMonitoredItemsPerCall(int n2) {
        this.fD = n2;
    }

    public void setMonitoringMode(MonitoringMode monitoringMode) throws ServiceException {
        this.beginUpdate();
        try {
            for (MonitoredItemBase monitoredItemBase : this.items.values()) {
                monitoredItemBase.setMonitoringMode(monitoringMode);
            }
            return;
        }
        finally {
            this.endUpdate();
        }
    }

    public void setNotificationBufferSize(int n2) {
        this.fE = n2;
    }

    @Override
    public void setPublishingInterval(long l2, TimeUnit timeUnit) throws ServiceException {
        super.setPublishingInterval(l2, timeUnit);
    }

    public void setRetransmissionEnabled(boolean bl) {
        this.fH = bl;
    }

    public void setTimeoutDetectionFactor(double d2) {
        if (d2 <= 1.0) {
            throw new IllegalArgumentException("timeoutDetectionFactor must be greater than 1");
        }
        this.fJ = d2;
    }

    public void setTimestampsToReturn(TimestampsToReturn timestampsToReturn) {
        this.ex = timestampsToReturn;
    }

    public void transferTo(UaClient uaClient) throws ServiceException, StatusException {
        UnsignedInteger unsignedInteger = this.getSubscriptionId();
        this.transferTo(uaClient, unsignedInteger);
    }

    public void transferTo(UaClient uaClient, UnsignedInteger object) throws ServiceException, StatusException {
        if (this.fm != uaClient) {
            if (this.isConnected()) {
                if (uaClient.isConnected()) {
                    object = new TransferSubscriptionsResponse[]{object};
                    try {
                        object = uaClient.D().TransferSubscriptions(uaClient.getRequestHeader(), (UnsignedInteger[])object, Boolean.valueOf(true));
                    }
                    catch (ServiceFaultException serviceFaultException) {
                        throw new ServiceException(serviceFaultException);
                    }
                    catch (ServiceResultException serviceResultException) {
                        throw new ServiceException(serviceResultException);
                    }
                    this.checkServiceResult((ServiceResponse)object, object.getDiagnosticInfos());
                    this.checkOperationResult(object.getResults()[0].getStatusCode());
                    UnsignedInteger[] unsignedIntegerArray = object.getResults()[0].getAvailableSequenceNumbers();
                    object = this;
                    if (unsignedIntegerArray != null) {
                        UnsignedInteger unsignedInteger = Collections.max(Arrays.asList(unsignedIntegerArray));
                        logger.debug("setAvailableSequenceNumbers: availableSequenceNumbers={} latest={}", (Object)unsignedIntegerArray, (Object)unsignedInteger);
                        object.fC.set(new a(unsignedIntegerArray, unsignedInteger.longValue()));
                    }
                }
                if (this.fm != null) {
                    this.fm.bc.remove(this);
                }
                uaClient.bc.add(this);
            }
            this.setClient(uaClient);
        }
    }

    public void updateItems() throws ServiceException {
        ArrayList<MonitoredItem> arrayList = new ArrayList<MonitoredItem>();
        for (MonitoredItemBase monitoredItemBase : this.items.values()) {
            MonitoredItem monitoredItemBase2 = (MonitoredItem)monitoredItemBase;
            if (!monitoredItemBase2.isModified()) continue;
            arrayList.add(monitoredItemBase2);
        }
        this.modifyMonitoredItems(arrayList);
        for (MonitoredItem monitoredItem : arrayList) {
            monitoredItem.clearModified();
        }
    }

    public void updateMonitoringModes() throws ServiceException {
        for (MonitoringMode monitoringMode : MonitoringMode.values()) {
            ArrayList<MonitoredItem> arrayList = new ArrayList<MonitoredItem>();
            for (MonitoredItemBase monitoredItemBase : this.items.values()) {
                MonitoredItem monitoredItem = (MonitoredItem)monitoredItemBase;
                if (!monitoredItem.isMonitoringModeModified() || !monitoredItem.getMonitoringMode().equals((Object)monitoringMode)) continue;
                arrayList.add(monitoredItem);
            }
            this.setMonitoringMode(monitoringMode, arrayList);
            for (MonitoredItem monitoredItem : arrayList) {
                monitoredItem.clearModified();
            }
        }
    }

    private void acknowledge(UnsignedInteger unsignedInteger) {
        logger.debug("acknowledge: requestedSeqNumber={}", (Object)unsignedInteger);
        UaClient uaClient = this.getClient();
        if (uaClient != null) {
            uaClient.addSubscriptionAck(new SubscriptionAcknowledgement(this.getSubscriptionId(), unsignedInteger));
        }
        logger.debug("acknowledge: availableSequenceNumbers={}", this.getAvailableSequenceNumbersList());
    }

    private StatusCode a(long l2, boolean bl) {
        StatusCode statusCode;
        ExtensionObject[] extensionObjectArray;
        this.fA = this.fA.add(1);
        if (bl && !this.getAvailableSequenceNumbersList().contains(this.fA)) {
            logger.info("Missing NotificationMessage (SequenceNumber={})  no longer available from server.  Target SequenceNumber={}", (Object)this.fA, (Object)l2);
            this.fireMissingData(this.fA, l2, 0L, null);
            return StatusCode.GOOD;
        }
        UnsignedInteger unsignedInteger = this.fA;
        logger.info("Requesting missing NotificationMessage (SequenceNumber={}) from the server using Republish: Target SequenceNumber={}", (Object)unsignedInteger, (Object)l2);
        RepublishResponse republishResponse = null;
        try {
            extensionObjectArray = this.fm.D();
            if (extensionObjectArray == null) {
                return new StatusCode(StatusCodes.Bad_NotConnected);
            }
            republishResponse = extensionObjectArray.Republish(this.fm.getRequestHeader(), this.getSubscriptionId(), this.fA);
            statusCode = republishResponse.getResponseHeader().getServiceResult();
        }
        catch (ServiceResultException extensionObjectArray2) {
            extensionObjectArray = extensionObjectArray2;
            statusCode = extensionObjectArray2.getStatusCode();
        }
        if (statusCode.isBad()) {
            logger.debug("Republish failed: Error={}", (Object)statusCode);
        } else if (logger.isDebugEnabled()) {
            logger.debug("Republish: serviceResult={}", (Object)statusCode);
        }
        if (statusCode.getValue().equals((Object)StatusCodes.Bad_MessageNotAvailable)) {
            logger.info("Message not available");
            long l3 = (l2 + this.fA.longValue()) / 2L;
            if (bl) {
                this.a(l2, l3, statusCode);
            }
            return statusCode;
        }
        if (republishResponse == null) {
            logger.info("Failed to get a response to Republish (SequenceNumber={}): Error={}", (Object)unsignedInteger, (Object)statusCode);
            if (bl) {
                this.a(l2, this.fA.longValue() + 1L, statusCode);
            }
            return statusCode;
        }
        if (!unsignedInteger.equals((Object)republishResponse.getNotificationMessage().getSequenceNumber())) {
            logger.info("Received SequenceNumber ({}) for Republish is different than the one requested ({})", (Object)republishResponse.getNotificationMessage().getSequenceNumber(), (Object)unsignedInteger);
        }
        if ((extensionObjectArray = republishResponse.getNotificationMessage().getNotificationData()) != null && extensionObjectArray.length > 0) {
            if (this.fm.getListener() == null || this.fm.getListener().validateRepublishResponse(this.fm, republishResponse)) {
                this.a(extensionObjectArray);
            } else {
                logger.info("NotificationData returned for Republish (SequenceNumber={}) is not valid, ignoring", (Object)unsignedInteger);
            }
        } else if (republishResponse.getResponseHeader().getServiceResult().isGood()) {
            logger.warn("NotificationData returned for Republish (SequenceNumber={}) is empty", (Object)unsignedInteger);
        }
        this.acknowledge(unsignedInteger);
        return StatusCode.GOOD;
    }

    private MonitoringFilterResult a(MonitoredItem monitoredItem, ExtensionObject extensionObject) {
        MonitoringFilterResult monitoringFilterResult = null;
        if (extensionObject != null) {
            try {
                monitoringFilterResult = (MonitoringFilterResult)extensionObject.decode(this.fm.getEncoderContext());
            }
            catch (DecodingException decodingException) {
                logger.info("Cannot decode FilterResult of item " + monitoredItem.getNodeId(), (Throwable)decodingException);
            }
        }
        return monitoringFilterResult;
    }

    private CreateMonitoredItemsResponse a(MonitoredItemBase ... monitoredItemBaseArray) throws ServiceException {
        CreateMonitoredItemsResponse createMonitoredItemsResponse;
        Object object;
        MonitoredItemCreateResult[] monitoredItemCreateResultArray;
        MonitoredItemCreateResult monitoredItemCreateResult = new MonitoredItemCreateRequest[monitoredItemBaseArray.length];
        for (int i2 = 0; i2 < monitoredItemBaseArray.length; ++i2) {
            monitoredItemCreateResultArray = monitoredItemBaseArray[i2];
            ReadValueId readValueId = new ReadValueId(monitoredItemCreateResultArray.getNodeId(), monitoredItemCreateResultArray.getAttributeId(), NumericRange.toString((NumericRange)monitoredItemCreateResultArray.getIndexRange()), monitoredItemCreateResultArray.getDataEncoding());
            object = this.getMonitoringParameters((MonitoredItemBase)monitoredItemCreateResultArray);
            monitoredItemCreateResult[i2] = new MonitoredItemCreateRequest(readValueId, monitoredItemCreateResultArray.getMonitoringMode(), (MonitoringParameters)object);
        }
        try {
            createMonitoredItemsResponse = this.fm.D().CreateMonitoredItems(this.fm.getRequestHeader(), this.getSubscriptionId(), this.getTimestampsToReturn(), (MonitoredItemCreateRequest[])monitoredItemCreateResult);
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        this.checkServiceResult((ServiceResponse)createMonitoredItemsResponse, createMonitoredItemsResponse.getDiagnosticInfos());
        monitoredItemCreateResultArray = createMonitoredItemsResponse.getResults();
        if (monitoredItemCreateResultArray == null || monitoredItemCreateResultArray.length == 0) {
            throw new ServiceException("The server returned empty Results for the call", StatusCodes.Bad_UnexpectedError);
        }
        if (monitoredItemCreateResultArray.length < monitoredItemBaseArray.length) {
            logger.warn("Received fewer MonitoredItemCreateResults than expected, got {} while expecting {}", (Object)monitoredItemCreateResultArray.length, (Object)monitoredItemBaseArray.length);
        }
        if (monitoredItemCreateResultArray.length > monitoredItemBaseArray.length) {
            logger.warn("Received more MonitoredItemCreateResults than expected, got {} while expecting {}", (Object)monitoredItemCreateResultArray.length, (Object)monitoredItemBaseArray.length);
        }
        for (int i3 = 0; i3 < monitoredItemBaseArray.length; ++i3) {
            object = (MonitoredItem)monitoredItemBaseArray[i3];
            if (i3 < monitoredItemCreateResultArray.length) {
                monitoredItemCreateResult = monitoredItemCreateResultArray[i3];
                UnsignedInteger unsignedInteger = monitoredItemCreateResult.getMonitoredItemId();
                logger.debug("createMonitoredItems: i={} monitoredItemId={}", (Object)i3, (Object)unsignedInteger);
                ((MonitoredItem)object).setMonitoredItemId(unsignedInteger);
                unsignedInteger = this.a((MonitoredItem)object, monitoredItemCreateResult.getFilterResult());
                ((MonitoredItem)object).setErrorCode(monitoredItemCreateResult.getStatusCode());
                ((MonitoredItem)object).setFilterResult((MonitoringFilterResult)unsignedInteger);
                ((MonitoredItem)object).setRevisedQueueSize(monitoredItemCreateResult.getRevisedQueueSize());
                if (!(object instanceof MonitoredDataItem)) continue;
                object = (MonitoredDataItem)object;
                ((MonitoredDataItem)object).setRevisedSamplingInterval(monitoredItemCreateResult.getRevisedSamplingInterval());
                continue;
            }
            ((MonitoredItem)object).setErrorCode(new StatusCode(StatusCodes.Bad_UnexpectedError));
        }
        return createMonitoredItemsResponse;
    }

    private DeleteMonitoredItemsResponse b(MonitoredItemBase ... monitoredItemBaseArray) throws ServiceException {
        DeleteMonitoredItemsResponse deleteMonitoredItemsResponse;
        UnsignedInteger[] unsignedIntegerArray = new UnsignedInteger[monitoredItemBaseArray.length];
        for (int i2 = 0; i2 < monitoredItemBaseArray.length; ++i2) {
            unsignedIntegerArray[i2] = monitoredItemBaseArray[i2].getMonitoredItemId();
        }
        try {
            logger.debug("DeleteMonitoredItems");
            deleteMonitoredItemsResponse = this.fm.D().DeleteMonitoredItems(this.fm.getRequestHeader(), this.getSubscriptionId(), unsignedIntegerArray);
            logger.debug("DeleteMonitoredItems: response={}", (Object)deleteMonitoredItemsResponse);
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        this.checkServiceResult((ServiceResponse)deleteMonitoredItemsResponse, deleteMonitoredItemsResponse.getDiagnosticInfos());
        return deleteMonitoredItemsResponse;
    }

    private boolean a(long l2, long l3, StatusCode statusCode) {
        logger.debug("doMissingData: newSequenceNumber={}", (Object)l3);
        long l4 = this.fireMissingData(this.fA, l2, l3, statusCode);
        if (l4 > 0L && l4 != l3 && l4 < l2) {
            l3 = l4;
            logger.debug("doMissingData: (modified) newSequenceNumber={}", (Object)l3);
        }
        if (l3 >= l2) {
            logger.debug("doMissingData: break; newSequenceNumber >= sequenceNumber");
            return false;
        }
        this.fA = UnsignedInteger.valueOf((long)l3);
        return true;
    }

    private ModifyMonitoredItemsResponse a(List<MonitoredItem> list) throws ServiceException {
        ModifyMonitoredItemsResponse modifyMonitoredItemsResponse;
        Object object = new MonitoredItemModifyRequest[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            MonitoredItemBase monitoredItemBase = list.get(i2);
            object[i2] = new MonitoredItemModifyRequest(monitoredItemBase.getMonitoredItemId(), this.getMonitoringParameters(monitoredItemBase));
        }
        try {
            modifyMonitoredItemsResponse = this.fm.D().ModifyMonitoredItems(this.fm.getRequestHeader(), this.getSubscriptionId(), this.getTimestampsToReturn(), (MonitoredItemModifyRequest[])object);
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        this.checkServiceResult((ServiceResponse)modifyMonitoredItemsResponse, modifyMonitoredItemsResponse.getDiagnosticInfos());
        for (int i3 = 0; i3 < list.size(); ++i3) {
            object = list.get(i3);
            MonitoredItemModifyResult monitoredItemModifyResult = modifyMonitoredItemsResponse.getResults()[i3];
            UnsignedInteger unsignedInteger = ((MonitoredItemBase)object).getMonitoredItemId();
            logger.debug("monitoredItemId={}", (Object)unsignedInteger);
            ((MonitoredItem)object).setFilterResult(this.a((MonitoredItem)object, monitoredItemModifyResult.getFilterResult()));
            ((MonitoredItemBase)object).setQueueSize(monitoredItemModifyResult.getRevisedQueueSize());
            if (!(object instanceof MonitoredDataItem)) continue;
            object = (MonitoredDataItem)object;
            ((MonitoredDataItem)object).setSamplingInterval(monitoredItemModifyResult.getRevisedSamplingInterval());
        }
        return modifyMonitoredItemsResponse;
    }

    private void a(long l2) throws ServerConnectionException, ServiceException {
        if (this.isRetransmissionEnabled() && this.isConnected()) {
            StatusCode statusCode;
            while (this.fA != null && this.fA.longValue() < l2 && !(statusCode = this.a(l2, true)).isBad()) {
            }
        } else if (this.fA != null && this.fA.longValue() < l2) {
            this.a(l2, 0L, null);
        }
    }

    private SetMonitoringModeResponse a(MonitoringMode monitoringMode, List<MonitoredItem> list) throws ServiceException {
        SetMonitoringModeResponse setMonitoringModeResponse;
        Object object = new UnsignedInteger[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            MonitoredItemBase monitoredItemBase = list.get(i2);
            object[i2] = monitoredItemBase.getMonitoredItemId();
        }
        try {
            setMonitoringModeResponse = this.fm.D().SetMonitoringMode(this.fm.getRequestHeader(), this.getSubscriptionId(), monitoringMode, object);
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        this.checkServiceResult((ServiceResponse)setMonitoringModeResponse, setMonitoringModeResponse.getDiagnosticInfos());
        for (int i3 = 0; i3 < list.size(); ++i3) {
            object = list.get(i3);
            object.setMonitoringMode(monitoringMode);
        }
        return setMonitoringModeResponse;
    }

    private int aE() {
        int n2 = 0;
        Object object = this;
        object = ((Subscription)object).fm.getOperationLimits();
        if (object != null) {
            try {
                n2 = object.getMaxMonitoredItemsPerCall().intValue();
            }
            catch (Exception exception) {
                logger.debug("operationLimits", (Throwable)exception);
            }
        }
        logger.debug("getMaxMonitoredItemsPerCall={}", (Object)n2);
        return n2;
    }

    private void a(ExtensionObject[] extensionObjectArray) {
        UaClient uaClient = this.fm;
        if (uaClient == null) {
            logger.debug("handleNotificationData: client is null, therefore skipping handling");
            return;
        }
        if ((uaClient = uaClient.getEncoderContext()) == null) {
            logger.debug("handleNotificationData: encoder context is null, skipping handling");
            return;
        }
        logger.debug("handleNotificationData: notificationDatas.length={}", (Object)extensionObjectArray.length);
        ExtensionObject[] extensionObjectArray2 = extensionObjectArray;
        int n2 = extensionObjectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            MonitoredItem monitoredItem;
            EventFieldList eventFieldList;
            int n3;
            EventFieldList[] eventFieldListArray;
            NotificationData notificationData;
            EventFieldList[] eventFieldListArray2 = extensionObjectArray2[i2];
            if (eventFieldListArray2 == null) {
                logger.debug("handleNotificationData: o=null");
                continue;
            }
            try {
                notificationData = (NotificationData)eventFieldListArray2.decode((EncoderContext)uaClient);
                logger.debug("handleNotificationData: notificationData={}", (Object)notificationData);
            }
            catch (DecodingException decodingException) {
                logger.info("handleNotificationData: Failed to decode notification {}", (Object)eventFieldListArray2, (Object)decodingException);
                this.fireError(eventFieldListArray2, (Exception)((Object)decodingException));
                continue;
            }
            catch (RuntimeException runtimeException) {
                logger.error("handleNotificationData: Got RuntimeException while decoding NotificationData {}", (Object)eventFieldListArray2, (Object)runtimeException);
                throw runtimeException;
            }
            if (notificationData instanceof DataChangeNotification) {
                DataChangeNotification dataChangeNotification = (DataChangeNotification)notificationData;
                eventFieldListArray2 = dataChangeNotification.getMonitoredItems();
                if (eventFieldListArray2 == null) {
                    logger.debug("handleNotificationData: dataChangeNotification.getMonitoredItems()=null");
                } else {
                    logger.debug("handleNotificationData: dataChangeNotification.length={}", (Object)eventFieldListArray2.length);
                    eventFieldListArray = eventFieldListArray2;
                    int n4 = eventFieldListArray2.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        eventFieldList = eventFieldListArray[n3];
                        if (eventFieldList == null) {
                            logger.debug("handleNotificationData: MonitoredItemNotification=null");
                            continue;
                        }
                        logger.debug("handleNotificationData: MonitoredItemNotification ClientHandle={} Value={}", (Object)eventFieldList.getClientHandle(), (Object)eventFieldList.getValue());
                        try {
                            monitoredItem = (MonitoredDataItem)this.getItem(eventFieldList.getClientHandle());
                            logger.debug("item={}; firing data changes", (Object)monitoredItem);
                            this.fireDataChange((MonitoredDataItem)monitoredItem, eventFieldList.getValue());
                            logger.debug("Setting value {} to {}", (Object)eventFieldList.getValue(), (Object)monitoredItem);
                            ((MonitoredDataItem)monitoredItem).setValue(eventFieldList.getValue());
                            continue;
                        }
                        catch (StatusException statusException) {
                            logger.debug("handleNotificationData: ", (Throwable)statusException);
                            if (!this.isConnected()) break;
                            if (statusException.getStatusCode().getValue().equals((Object)StatusCodes.Bad_MonitoredItemIdInvalid)) {
                                logger.info("handleNotificationData: unknown clientHandle={} subscriptionId={}", (Object)eventFieldList.getClientHandle(), (Object)this.getSubscriptionId());
                            }
                            this.fireError(eventFieldList, statusException);
                            continue;
                        }
                        catch (ClassCastException classCastException) {
                            logger.debug("handleNotificationData: ", (Throwable)classCastException);
                            this.fireError(eventFieldList, classCastException);
                            continue;
                        }
                        catch (Exception exception) {
                            logger.error("handleNotificationData: Unexpected error (most likely MonitoredDataItem.setValue did throw RuntimeException which it should not)", (Throwable)exception);
                            this.fireError(eventFieldList, exception);
                        }
                    }
                    logger.debug("handleNotificationData: handled all MonitoredItemNotifications length={}", (Object)eventFieldListArray2.length);
                }
            } else if (notificationData instanceof StatusChangeNotification) {
                StatusChangeNotification statusChangeNotification = (StatusChangeNotification)notificationData;
                eventFieldListArray2 = this.aj;
                this.aj = statusChangeNotification.getStatus();
                this.ds = statusChangeNotification.getDiagnosticInfo();
                logger.debug("handleNotificationData: statusChange status={} diagnosticInfo={}", (Object)this.aj, (Object)this.ds);
                try {
                    this.fireStatusChange((StatusCode)eventFieldListArray2, this.aj, this.ds);
                }
                catch (ClassCastException classCastException) {
                    logger.debug("handleNotificationData: ", (Throwable)classCastException);
                    this.fireError(statusChangeNotification, classCastException);
                }
            } else if (notificationData instanceof EventNotificationList) {
                EventNotificationList eventNotificationList = (EventNotificationList)notificationData;
                eventFieldListArray2 = eventNotificationList.getEvents();
                if (eventFieldListArray2 != null) {
                    logger.debug("handleNotificationData: events.length={}", (Object)eventFieldListArray2.length);
                    eventFieldListArray = eventFieldListArray2;
                    int n5 = eventFieldListArray2.length;
                    for (n3 = 0; n3 < n5; ++n3) {
                        eventFieldList = eventFieldListArray[n3];
                        if (eventFieldList == null) continue;
                        try {
                            monitoredItem = (MonitoredEventItem)this.getItem(eventFieldList.getClientHandle());
                            Variant[] variantArray = eventFieldList.getEventFields();
                            if (monitoredItem == null) {
                                logger.debug("item=null");
                                continue;
                            }
                            if (logger.isDebugEnabled()) {
                                logger.debug("handleNotificationData: EventFieldList clientHandle={} itemId={} nodeId={} eventFields={}", new Object[]{eventFieldList.getClientHandle(), monitoredItem.getMonitoredItemId(), monitoredItem.getNodeId(), Arrays.toString(eventFieldList.getEventFields())});
                            }
                            this.fireEvent((MonitoredEventItem)monitoredItem, variantArray);
                            ((MonitoredEventItem)monitoredItem).doEvent(variantArray);
                            continue;
                        }
                        catch (StatusException statusException) {
                            logger.debug("handleNotificationData: ", (Throwable)statusException);
                            if (statusException.getStatusCode().getValue().equals((Object)StatusCodes.Bad_MonitoredItemIdInvalid)) {
                                logger.info("handleNotificationData: unknown clientHandle={}", (Object)eventFieldList.getClientHandle());
                            }
                            this.fireError(eventFieldList, statusException);
                            continue;
                        }
                        catch (ClassCastException classCastException) {
                            logger.debug("handleNotificationData: ", (Throwable)classCastException);
                            this.fireError(eventFieldList, classCastException);
                        }
                    }
                } else {
                    logger.debug("handleNotificationData: eventNotificationList.getEvents() was null");
                }
            } else {
                logger.debug("handleNotificationData: unknown notificationData type, or it is null");
            }
            this.fireNotification(notificationData);
        }
        logger.debug("handleNotificationData: handled all notificationDatas.length={}", (Object)extensionObjectArray.length);
    }

    @Override
    protected void applyUpdates() throws ServiceException {
        super.applyUpdates();
        if (this.updateCount == 0) {
            this.updateSubscription();
            this.updateItems();
            this.updateMonitoringModes();
        }
    }

    protected void checkOperationResult(StatusCode statusCode) throws StatusException {
        if (statusCode.isBad()) {
            if (this.fz == null) {
                throw new StatusException(statusCode);
            }
            throw new StatusException(statusCode, this.fz[0]);
        }
    }

    protected void checkServiceResult(ServiceResponse serviceResponse, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        this.fB = serviceResponse.getResponseHeader();
        this.fz = diagnosticInfoArray;
        if (this.getLastServiceResult().isBad()) {
            throw new ServiceException(this.getLastServiceResult());
        }
    }

    protected void checkTimeout() {
        Calendar calendar = this.getLastAlive();
        if (calendar != null) {
            long l2;
            long l3 = Calendar.getInstance().getTimeInMillis() - calendar.getTimeInMillis();
            boolean bl = (double)l2 > this.getPublishingInterval() * (double)this.getMaxKeepAliveCount() * this.fJ;
            if (bl && logger.isDebugEnabled()) {
                logger.debug("checkTimeout: msAfterLastAlive={}", (Object)l3);
            }
            this.setTimeout(bl);
        }
    }

    protected void createItems() throws ServiceException {
        this.createMonitoredItems(this.items.values().toArray(new MonitoredItemBase[this.items.size()]));
    }

    protected CreateMonitoredItemsResponse createMonitoredItems(MonitoredItemBase ... monitoredItemBaseArray) throws ServiceException {
        if (this.serverConnected() && monitoredItemBaseArray.length > 0) {
            int n2;
            if (logger.isDebugEnabled()) {
                logger.debug("createMonitoredItems: " + (monitoredItemBaseArray.length < 100 ? Arrays.toString(monitoredItemBaseArray) : monitoredItemBaseArray.length + " items"));
            }
            if ((n2 = this.getMaxMonitoredItemsPerCall()) > 0 && n2 < monitoredItemBaseArray.length) {
                ResponseHeader responseHeader = null;
                MonitoredItemCreateResult[] monitoredItemCreateResultArray = new MonitoredItemCreateResult[monitoredItemBaseArray.length];
                DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[monitoredItemBaseArray.length];
                for (int i2 = 0; i2 < monitoredItemBaseArray.length; i2 += n2) {
                    int n3 = Math.min(n2, monitoredItemBaseArray.length - i2);
                    responseHeader = Arrays.copyOfRange(monitoredItemBaseArray, i2, i2 + n3);
                    CreateMonitoredItemsResponse createMonitoredItemsResponse = this.a((MonitoredItemBase[])responseHeader);
                    responseHeader = createMonitoredItemsResponse.getResponseHeader();
                    for (int i3 = 0; i3 < n3; ++i3) {
                        monitoredItemCreateResultArray[i2 + i3] = createMonitoredItemsResponse.getResults()[i3];
                    }
                    DiagnosticInfo[] diagnosticInfoArray2 = createMonitoredItemsResponse.getDiagnosticInfos();
                    if (diagnosticInfoArray2 == null || diagnosticInfoArray2.length <= 0) continue;
                    for (int i4 = 0; i4 < n3; ++i4) {
                        diagnosticInfoArray[i2 + i4] = diagnosticInfoArray2[i4];
                    }
                }
                return new CreateMonitoredItemsResponse(responseHeader, monitoredItemCreateResultArray, diagnosticInfoArray);
            }
            return this.a(monitoredItemBaseArray);
        }
        return null;
    }

    protected DeleteMonitoredItemsResponse deleteMonitoredItems(MonitoredItemBase ... monitoredItemBaseArray) throws ServiceException {
        if (this.isConnected() && monitoredItemBaseArray.length > 0) {
            int n2 = this.getMaxMonitoredItemsPerCall();
            if (n2 > 0 && n2 < monitoredItemBaseArray.length) {
                ResponseHeader responseHeader = null;
                StatusCode[] statusCodeArray = new StatusCode[monitoredItemBaseArray.length];
                DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[monitoredItemBaseArray.length];
                for (int i2 = 0; i2 < monitoredItemBaseArray.length; i2 += n2) {
                    int n3 = Math.min(n2, monitoredItemBaseArray.length - i2);
                    responseHeader = Arrays.copyOfRange(monitoredItemBaseArray, i2, i2 + n3);
                    DeleteMonitoredItemsResponse deleteMonitoredItemsResponse = this.b((MonitoredItemBase[])responseHeader);
                    responseHeader = deleteMonitoredItemsResponse.getResponseHeader();
                    for (int i3 = 0; i3 < n3; ++i3) {
                        statusCodeArray[i2 + i3] = deleteMonitoredItemsResponse.getResults()[i3];
                    }
                    DiagnosticInfo[] diagnosticInfoArray2 = deleteMonitoredItemsResponse.getDiagnosticInfos();
                    if (diagnosticInfoArray2 == null || diagnosticInfoArray2.length <= 0) continue;
                    for (int i4 = 0; i4 < n3; ++i4) {
                        diagnosticInfoArray[i2 + i4] = diagnosticInfoArray2[i4];
                    }
                }
                return new DeleteMonitoredItemsResponse(responseHeader, statusCodeArray, diagnosticInfoArray);
            }
            return this.b(monitoredItemBaseArray);
        }
        return null;
    }

    @Override
    protected void enabledChanged() throws ServiceException, StatusException {
        if (this.fm != null) {
            this.fm.b((SubscriptionBase)this);
        }
    }

    protected void finalize() throws Throwable {
        this.items.clear();
        super.finalize();
    }

    protected void fireAfterCreate() {
        for (SubscriptionAliveListener subscriptionAliveListener : this.fx) {
            if (subscriptionAliveListener == null) continue;
            try {
                subscriptionAliveListener.onAfterCreate(this);
            }
            catch (Exception exception) {
                logger.error("Exception while calling onAlive with listener=" + subscriptionAliveListener, (Throwable)exception);
            }
        }
    }

    protected void fireAlive() {
        for (SubscriptionAliveListener subscriptionAliveListener : this.fx) {
            if (subscriptionAliveListener == null) continue;
            try {
                subscriptionAliveListener.onAlive(this);
            }
            catch (Exception exception) {
                logger.error("Exception while calling onAlive with listener=" + subscriptionAliveListener, (Throwable)exception);
            }
        }
    }

    protected void fireBufferOverflow(UnsignedInteger unsignedInteger, ExtensionObject[] extensionObjectArray) {
        for (SubscriptionNotificationListener subscriptionNotificationListener : this.fF) {
            if (subscriptionNotificationListener == null) continue;
            try {
                subscriptionNotificationListener.onBufferOverflow(this, unsignedInteger, extensionObjectArray);
            }
            catch (Exception exception) {
                logger.error("Exception while calling onBufferOverflow with listener=" + subscriptionNotificationListener, (Throwable)exception);
            }
        }
    }

    protected void fireDataChange(MonitoredDataItem monitoredDataItem, DataValue dataValue) {
        for (SubscriptionNotificationListener subscriptionNotificationListener : this.fF) {
            if (subscriptionNotificationListener == null) continue;
            try {
                subscriptionNotificationListener.onDataChange(this, monitoredDataItem, dataValue);
            }
            catch (Exception exception) {
                logger.error("Exception while calling onDataChange with listener=" + subscriptionNotificationListener, (Throwable)exception);
            }
        }
    }

    protected void fireError(Object object, Exception exception) {
        for (SubscriptionNotificationListener subscriptionNotificationListener : this.fF) {
            if (subscriptionNotificationListener == null) continue;
            try {
                subscriptionNotificationListener.onError(this, object, exception);
            }
            catch (Exception exception2) {
                logger.error("Exception while calling onError with listener=" + subscriptionNotificationListener, (Throwable)exception2);
            }
        }
    }

    protected void fireEvent(MonitoredEventItem monitoredEventItem, Variant[] variantArray) {
        for (SubscriptionNotificationListener subscriptionNotificationListener : this.fF) {
            if (subscriptionNotificationListener == null) continue;
            try {
                subscriptionNotificationListener.onEvent(this, monitoredEventItem, variantArray);
            }
            catch (Exception exception) {
                logger.error("Exception while calling onEvent with listener=" + subscriptionNotificationListener, (Throwable)exception);
            }
        }
    }

    protected long fireMissingData(UnsignedInteger unsignedInteger, long l2, long l3, StatusCode statusCode) {
        for (SubscriptionNotificationListener subscriptionNotificationListener : this.fF) {
            try {
                l3 = subscriptionNotificationListener.onMissingData(unsignedInteger, l2, l3, statusCode);
            }
            catch (Exception exception) {
                logger.error("Exception while calling onMissingData with listener=" + subscriptionNotificationListener, (Throwable)exception);
            }
        }
        return l3;
    }

    protected void fireNotification(NotificationData notificationData) {
        logger.debug("fireNotification");
        for (SubscriptionNotificationListener subscriptionNotificationListener : this.fF) {
            if (subscriptionNotificationListener == null) continue;
            try {
                subscriptionNotificationListener.onNotificationData(this, notificationData);
            }
            catch (Exception exception) {
                logger.error("Exception while calling onNotificationData with listener=" + subscriptionNotificationListener, (Throwable)exception);
            }
        }
    }

    protected void fireStatusChange(StatusCode statusCode, StatusCode statusCode2, DiagnosticInfo diagnosticInfo) {
        for (SubscriptionNotificationListener subscriptionNotificationListener : this.fF) {
            if (subscriptionNotificationListener == null) continue;
            try {
                subscriptionNotificationListener.onStatusChange(this, statusCode, statusCode2, diagnosticInfo);
            }
            catch (Exception exception) {
                logger.error("Exception while calling onStatusChange with listener=" + subscriptionNotificationListener, (Throwable)exception);
            }
        }
    }

    protected void fireTimeout() {
        for (SubscriptionAliveListener subscriptionAliveListener : this.fx) {
            if (subscriptionAliveListener == null) continue;
            try {
                subscriptionAliveListener.onTimeout(this);
            }
            catch (Exception exception) {
                logger.error("Exception while calling onTimeout with listener=" + subscriptionAliveListener, (Throwable)exception);
            }
        }
    }

    protected List<UnsignedInteger> getAvailableSequenceNumbersList() {
        a a2 = this.fC.get();
        if (a2 != null) {
            return a2.hP;
        }
        return Collections.emptyList();
    }

    protected MonitoringParameters getMonitoringParameters(MonitoredItemBase monitoredItemBase) {
        ExtensionObject extensionObject;
        try {
            extensionObject = monitoredItemBase.getFilter() == null ? null : ExtensionObject.binaryEncode((Structure)monitoredItemBase.getFilter(), (EncoderContext)this.fm.getEncoderContext());
        }
        catch (EncodingException encodingException) {
            throw new IllegalArgumentException(String.format("Cannot encode filter of item {%s.%s}", monitoredItemBase.getNodeId(), AttributesUtil.toString((UnsignedInteger)monitoredItemBase.getAttributeId())), encodingException);
        }
        extensionObject = new MonitoringParameters(monitoredItemBase.getClientHandle(), Double.valueOf(monitoredItemBase.getSamplingInterval()), extensionObject, UnsignedInteger.valueOf((long)monitoredItemBase.getQueueSize()), Boolean.valueOf(monitoredItemBase.isDiscardOldest()));
        return extensionObject;
    }

    protected void handleNotificationDatas() throws ServerConnectionException, ServiceException {
        Object object;
        Object object2;
        logger.debug("handleNotificationDatas: isConnected={}", (Object)this.isConnected());
        while ((object2 = this.fG.pollFirstEntry()) != null) {
            logger.debug("handleNotificationDatas: entry={}", object2);
            object = object2.getKey();
            object2 = (ExtensionObject[])object2.getValue();
            long l2 = this.fA == null ? 0L : this.fA.longValue();
            boolean bl = l2 - object.longValue() > fw;
            if (bl) {
                logger.debug("handleNotificationDatas: need Republish: isOverflow");
                this.a(UnsignedInteger.MAX_VALUE.longValue());
                if (l2 > fw) {
                    this.fA = UnsignedInteger.ZERO;
                    l2 = 0L;
                }
            }
            if (l2 == 0L || object.longValue() > l2 && object.longValue() - l2 < fw) {
                logger.debug("handleNotificationDatas: need Republish? lastSeqNumber={} VS. sequenceNumber={}", (Object)l2, (Object)object.longValue());
                this.a(object.longValue() - 1L);
                if (this.isAliveNotification((ExtensionObject[])object2)) {
                    logger.debug("handleNotificationDatas: this is Alive Notification");
                    this.fireAlive();
                } else {
                    logger.debug("handleNotificationDatas: calling handleNotificationData");
                    this.a((ExtensionObject[])object2);
                    logger.debug("handleNotificationDatas: calling handleNotificationData ended, setting new lastSequenceNumber {}", object);
                    this.fA = object;
                }
                object2 = this;
                object = object2.fy;
                Date date = object == null ? null : ((Calendar)object).getTime();
                logger.debug("handleNotificationDatas: leaving, lastSequenceNumber={} lastAlive={}", (Object)this.fA, (Object)date);
                continue;
            }
            if (l2 <= 0L) continue;
            logger.warn("Server sent a previously acknowledged sequence number {} for Subscription {}", object, (Object)this.getSubscriptionId());
        }
        object = this.fA;
        object2 = this;
        for (UnsignedInteger unsignedInteger : object2.getAvailableSequenceNumbersList()) {
            if (unsignedInteger.getValue() <= object.getValue() || unsignedInteger.getValue() - object.getValue() >= fw || object2.fG.containsKey(unsignedInteger)) continue;
            logger.info("Invalid sequence number {} in availableSequenceNumbers list received from server. Current SequenceNumber={}", (Object)unsignedInteger, object);
        }
    }

    protected boolean hasPublishResponses() {
        return !this.fG.isEmpty();
    }

    protected boolean isAliveNotification(ExtensionObject[] extensionObjectArray) {
        return extensionObjectArray.length == 0;
    }

    protected void itemChanged(MonitoredItem monitoredItem) throws ServiceException {
        if (!this.isConnected()) {
            monitoredItem.clearModified();
            return;
        }
        if (this.updateCount == 0) {
            this.updateItems();
        }
    }

    protected ModifyMonitoredItemsResponse modifyMonitoredItems(List<MonitoredItem> list) throws ServiceException {
        if (this.serverConnected() && list.size() > 0) {
            int n2;
            if (logger.isDebugEnabled()) {
                logger.debug("modifyMonitoredItems: getSubscriptionId()={}; items={}", (Object)this.getSubscriptionId(), (Object)Arrays.toString(list.toArray()));
            }
            if ((n2 = this.getMaxMonitoredItemsPerCall()) > 0 && n2 < list.size()) {
                ResponseHeader responseHeader = null;
                MonitoredItemModifyResult[] monitoredItemModifyResultArray = new MonitoredItemModifyResult[list.size()];
                DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[list.size()];
                for (int i2 = 0; i2 < list.size(); i2 += n2) {
                    int n3 = Math.min(n2, list.size() - i2);
                    responseHeader = list.subList(i2, i2 + n3);
                    ModifyMonitoredItemsResponse modifyMonitoredItemsResponse = this.a((List<MonitoredItem>)responseHeader);
                    responseHeader = modifyMonitoredItemsResponse.getResponseHeader();
                    for (int i3 = 0; i3 < n3; ++i3) {
                        monitoredItemModifyResultArray[i2 + i3] = modifyMonitoredItemsResponse.getResults()[i3];
                    }
                    DiagnosticInfo[] diagnosticInfoArray2 = modifyMonitoredItemsResponse.getDiagnosticInfos();
                    if (diagnosticInfoArray2 == null || diagnosticInfoArray2.length <= 0) continue;
                    for (int i4 = 0; i4 < n3; ++i4) {
                        diagnosticInfoArray[i2 + i4] = diagnosticInfoArray2[i4];
                    }
                }
                return new ModifyMonitoredItemsResponse(responseHeader, monitoredItemModifyResultArray, diagnosticInfoArray);
            }
            return this.a(list);
        }
        return null;
    }

    protected void monitoringModeChanged(MonitoredItem monitoredItem) throws ServiceException {
        if (this.updateCount == 0) {
            this.updateMonitoringModes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPublishResponse(PublishResponse object) {
        if (this.fm == null) {
            logger.debug("onPublishResponse: client is null, therefore skipping processing because this subscription has been removed from the client");
            return;
        }
        if (object.getNotificationMessage() != null) {
            Object object2;
            if (logger.isDebugEnabled()) {
                logger.debug("onPublishResponse: entering, SubscriptionID={} SequenceNumber={}", (Object)object.getSubscriptionId(), (Object)object.getNotificationMessage().getSequenceNumber());
            }
            if ((object2 = object.getNotificationMessage().getSequenceNumber()) != null) {
                long l2;
                this.fy = Calendar.getInstance();
                Object object3 = object.getNotificationMessage().getNotificationData();
                if (object3 == null || ((ExtensionObject[])object3).length == 0) {
                    object3 = fv;
                } else {
                    this.acknowledge((UnsignedInteger)object2);
                }
                this.fG.put((UnsignedInteger)object2, (ExtensionObject[])object3);
                Object[] objectArray = object.getAvailableSequenceNumbers();
                object3 = object2;
                object = this;
                logger.debug("addAvailableSequenceNumbers: lastSequenceNumber={} seqNumbers={}", (Object)((Subscription)object).fA, (Object)Arrays.toString(objectArray));
                long l3 = object3.getValue();
                do {
                    long l4;
                    if ((object3 = ((Subscription)object).fC.get()) == null || l3 > (l4 = ((a)object3).hQ) || l4 > fw && l3 < 100L) continue;
                    logger.debug("setAvailableSequenceNumbers not updated, sequenceNumber={} latestAvailableSequenceNumber={}", (Object)l3, (Object)l4);
                    break;
                } while (!((Subscription)object).fC.compareAndSet((a)object3, new a((UnsignedInteger[])objectArray, l3)));
                logger.debug("addAvailableSequenceNumbers: availableSequenceNumbers={}", ((Subscription)object).getAvailableSequenceNumbersList());
                logger.debug("onPublishResponse: responseQueue.size()={}", (Object)this.fG.size());
                object = this.getLastSequenceNumber();
                long l5 = object == null ? 0L : object.getValue();
                long l6 = l2 = l5 == UnsignedInteger.MAX_VALUE.longValue() ? 1L : l5 + 1L;
                if (l5 == 0L || object2.getValue() == l2) {
                    object = this.fm;
                    if (object == null) {
                        return;
                    }
                    object2 = object;
                    synchronized (object2) {
                        object.notify();
                    }
                }
                while (this.fG.size() > this.fE) {
                    object = this.fG.pollFirstEntry();
                    if (object == null) continue;
                    this.fireBufferOverflow((UnsignedInteger)object.getKey(), (ExtensionObject[])object.getValue());
                }
                return;
            }
            logger.debug("onPublishResponse: sequenceNumber=null");
        }
    }

    @Override
    protected void paramChanged() throws ServiceException {
        if (this.isConnected()) {
            if (this.updateCount == 0) {
                this.applyUpdates();
                return;
            }
            this.modified = true;
        }
    }

    protected void reset() {
        this.fm = null;
        this.setSubscriptionId(null);
        this.fy = null;
    }

    protected boolean serverConnected() {
        return this.fm != null && this.fm.isConnected();
    }

    protected void setClient(UaClient uaClient) {
        if (this.fm != uaClient) {
            this.fm = uaClient;
        }
    }

    protected SetMonitoringModeResponse setMonitoringMode(MonitoringMode monitoringMode, List<MonitoredItem> list) throws ServiceException {
        if (this.serverConnected() && list.size() > 0) {
            int n2;
            if (logger.isDebugEnabled()) {
                logger.debug("modifyMonitoredItems: getSubscriptionId()={}; items={}", (Object)this.getSubscriptionId(), (Object)list.toString());
            }
            if ((n2 = this.getMaxMonitoredItemsPerCall()) > 0 && n2 < list.size()) {
                ResponseHeader responseHeader = null;
                StatusCode[] statusCodeArray = new StatusCode[list.size()];
                DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[list.size()];
                for (int i2 = 0; i2 < list.size(); i2 += n2) {
                    int n3 = Math.min(n2, list.size() - i2);
                    responseHeader = list.subList(i2, i2 + n3);
                    SetMonitoringModeResponse setMonitoringModeResponse = this.a(monitoringMode, (List<MonitoredItem>)responseHeader);
                    responseHeader = setMonitoringModeResponse.getResponseHeader();
                    for (int i3 = 0; i3 < n3; ++i3) {
                        statusCodeArray[i2 + i3] = setMonitoringModeResponse.getResults()[i3];
                    }
                    DiagnosticInfo[] diagnosticInfoArray2 = setMonitoringModeResponse.getDiagnosticInfos();
                    if (diagnosticInfoArray2 == null || diagnosticInfoArray2.length <= 0) continue;
                    for (int i4 = 0; i4 < n3; ++i4) {
                        diagnosticInfoArray[i2 + i4] = diagnosticInfoArray2[i4];
                    }
                }
                return new SetMonitoringModeResponse(responseHeader, statusCodeArray, diagnosticInfoArray);
            }
            return this.a(monitoringMode, list);
        }
        return null;
    }

    protected void setSubscriptionId(int n2) {
        this.setSubscriptionId(UnsignedInteger.valueOf((long)n2));
    }

    @Override
    protected void setSubscriptionId(UnsignedInteger unsignedInteger) {
        super.setSubscriptionId(unsignedInteger);
        if (unsignedInteger == null || unsignedInteger.getValue() == 0L) {
            this.fA = UnsignedInteger.ZERO;
        }
    }

    protected void setTimeout(boolean bl) {
        if (bl != this.fI) {
            this.fI = bl;
            if (this.fI) {
                this.fireTimeout();
            }
        }
    }

    protected void updateSubscription() throws ServiceException {
        if (this.serverConnected()) {
            this.fm.a((SubscriptionBase)this);
        }
        this.modified = false;
    }

    private static final class a {
        private final List<UnsignedInteger> hP;
        private final long hQ;

        public a(UnsignedInteger[] unsignedIntegerArray, long l2) {
            this.hP = Arrays.asList(unsignedIntegerArray);
            this.hQ = l2;
        }
    }
}

