/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client;

import com.prosysopc.ua.UaApplication;
import com.prosysopc.ua.client.ServerListBase;
import com.prosysopc.ua.client.ServerListException;
import java.util.Arrays;
import org.opcfoundation.ua.application.Client;
import org.opcfoundation.ua.common.ServiceFaultException;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.ApplicationDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerList
extends ServerListBase {
    private static Logger logger = LoggerFactory.getLogger(ServerList.class);

    public ServerList() {
    }

    public ServerList(String string) throws ServerListException {
        super(string);
    }

    public void discover(UaApplication.Protocol protocol, String string) throws ServerListException {
        this.discover(UaApplication.formatUri(protocol, string, 4840, null));
    }

    @Override
    public void discover(String string) throws ServerListException {
        ApplicationDescription[] applicationDescriptionArray = Client.createClientApplication(null);
        try {
            applicationDescriptionArray = applicationDescriptionArray.discoverApplications(string);
        }
        catch (ServiceFaultException serviceFaultException) {
            logger.debug("ServiceFaultException: ", (Throwable)serviceFaultException);
            throw new ServerListException("Cannot discover applications from " + string.toString(), serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            logger.debug("ServiceFaultException: ", (Throwable)serviceResultException);
            throw new ServerListException("Cannot discover applications from " + string.toString(), serviceResultException);
        }
        if (applicationDescriptionArray == null) {
            throw new ServerListException("Cannot discover applications from " + string.toString());
        }
        this.servers.addAll(Arrays.asList(applicationDescriptionArray));
    }
}

