/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client;

import com.prosysopc.ua.NodeMap;
import com.prosysopc.ua.nodes.UaDataType;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaNodeFactory;
import com.prosysopc.ua.nodes.UaNodeFactoryException;
import com.prosysopc.ua.nodes.UaType;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.UnsignedByte;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedLong;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.builtintypes.XmlElement;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.NodeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeCache
extends NodeMap {
    private static Logger logger = LoggerFactory.getLogger(NodeCache.class);
    private int dv;
    private long dw;
    private final Map<NodeId, NodeCacheWrapper> dx = new ConcurrentHashMap<NodeId, NodeCacheWrapper>(32, 1.0f, 2);
    private final Queue<NodeCacheWrapper> dy = new LinkedList<NodeCacheWrapper>();

    public NodeCache(UaNodeFactory uaNodeFactory, int n2, long l2) {
        super(uaNodeFactory);
        this.dv = n2;
        this.dw = l2;
    }

    @Override
    public UaNode addNode(UaNode uaNode) {
        if (uaNode instanceof UaType) {
            return this.addPermanently(uaNode);
        }
        return this.addNode(uaNode, DateTime.currentTime());
    }

    public UaNode addPermanently(UaNode uaNode) {
        return this.addNode(uaNode, DateTime.MAX_VALUE);
    }

    @Override
    public void clear() {
        for (NodeId nodeId : this.dx.keySet()) {
            this.remove(nodeId);
        }
    }

    public int getMaxQueueLength() {
        return this.dv;
    }

    @Override
    public UaNode getNode(NodeId nodeId) {
        if (this.dw == 0L) {
            return null;
        }
        NodeCacheWrapper nodeCacheWrapper = this.dx.get(nodeId);
        if (nodeCacheWrapper == null) {
            return null;
        }
        Object object = new GregorianCalendar();
        ((Calendar)object).setTimeInMillis(System.currentTimeMillis() - this.dw);
        if (nodeCacheWrapper.isValid(new DateTime((Calendar)object))) {
            object = nodeCacheWrapper.getNode();
            if (object == null) {
                this.dx.remove(nodeId);
                this.dy.remove(nodeCacheWrapper);
            }
            return object;
        }
        return null;
    }

    public long getNodeMaxAgeInMillis() {
        return this.dw;
    }

    @Override
    public boolean hasNode(NodeId nodeId) {
        return this.dx.containsKey(nodeId);
    }

    public void initDataTypes() throws UaNodeFactoryException {
        UaDataType uaDataType = (UaDataType)this.addType(NodeClass.DataType, Identifiers.BaseDataType, "BaseDataType", (Class<?>)null);
        UaDataType uaDataType2 = this.addType(uaDataType, Identifiers.Number, "Number", null);
        UaDataType uaDataType3 = this.addType(uaDataType2, Identifiers.Integer, "Integer", Integer.class);
        this.addType(uaDataType3, Identifiers.SByte, "SByte", Byte.class);
        this.addType(uaDataType3, Identifiers.Int16, "Int16", Short.class);
        this.addType(uaDataType3, Identifiers.Int32, "Int32", Integer.class);
        this.addType(uaDataType3, Identifiers.Int64, "Int64", Long.class);
        uaDataType3 = this.addType(uaDataType2, Identifiers.UInteger, "UInteger", UnsignedInteger.class);
        this.addType(uaDataType3, Identifiers.Byte, "Byte", UnsignedByte.class);
        this.addType(uaDataType3, Identifiers.UInt16, "UInt16", UnsignedShort.class);
        this.addType(uaDataType3, Identifiers.UInt32, "UInt32", UnsignedInteger.class);
        this.addType(uaDataType3, Identifiers.UInt64, "UInt64", UnsignedLong.class);
        this.addType(uaDataType2, Identifiers.Float, "Float", Float.class);
        uaDataType2 = this.addType(uaDataType2, Identifiers.Double, "Double", Double.class);
        this.addType(uaDataType2, Identifiers.Duration, "Duration", Double.class);
        this.addType(uaDataType, Identifiers.Boolean, "Boolean", Boolean.class);
        this.addType(uaDataType, Identifiers.ByteString, "ByteString", byte[].class);
        this.addType(uaDataType, Identifiers.Enumeration, "Enumeration", Integer.class);
        this.addType(uaDataType, Identifiers.QualifiedName, "QualifiedName", QualifiedName.class);
        uaDataType2 = this.addType(uaDataType, Identifiers.String, "String", String.class);
        this.addType(uaDataType2, Identifiers.LocaleId, "LocaleId", Locale.class);
        this.addType(uaDataType, Identifiers.Guid, "GUID", UUID.class);
        uaDataType2 = this.addType(uaDataType, Identifiers.DateTime, "DateTime", DateTime.class);
        this.addType(uaDataType2, Identifiers.UtcTime, "UtcTime", DateTime.class);
        this.addType(uaDataType, Identifiers.DataValue, "DataValue", DataValue.class);
        this.addType(uaDataType, Identifiers.DiagnosticInfo, "DiagnosticInfo", DiagnosticInfo.class);
        this.addType(uaDataType, Identifiers.LocalizedText, "LocalizedText", LocalizedText.class);
        this.addType(uaDataType, Identifiers.ExpandedNodeId, "ExpandedNodeId", ExpandedNodeId.class);
        this.addType(uaDataType, Identifiers.NodeId, "NodeId", NodeId.class);
        this.addType(uaDataType, Identifiers.XmlElement, "XmlElement", XmlElement.class);
    }

    @Override
    public UaNode remove(NodeId object) {
        object = this.dx.remove(object);
        this.dy.remove(object);
        if (object == null) {
            return null;
        }
        return ((NodeCacheWrapper)object).getNode();
    }

    @Override
    public UaNode remove(UaNode uaNode) {
        return this.remove(uaNode.getNodeId());
    }

    public void setMaxQueueLength(int n2) {
        this.dv = n2;
        this.ai();
    }

    public void setNodeMaxAgeInMillis(long l2) {
        this.dw = l2;
    }

    public int size() {
        return this.dx.size();
    }

    private void ai() {
        NodeCacheWrapper nodeCacheWrapper;
        logger.debug("trimQueue");
        while (!(this.dy.size() <= this.dv || (nodeCacheWrapper = this.dy.peek()) != null && nodeCacheWrapper.isValid(new DateTime(System.currentTimeMillis() - this.dw)) && nodeCacheWrapper.getNode() == null)) {
            if (nodeCacheWrapper != null && nodeCacheWrapper.getNodeId() != null) {
                this.dx.remove(nodeCacheWrapper.getNodeId());
            }
            this.dy.poll();
        }
    }

    protected UaNode addNode(UaNode object, DateTime dateTime) {
        logger.debug("addNode: node={} Id={}", (Object)object.getBrowseName(), (Object)object.getNodeId());
        NodeCacheWrapper nodeCacheWrapper = new NodeCacheWrapper(this, (UaNode)object, dateTime);
        object = this.dx.put(object.getNodeId(), nodeCacheWrapper);
        if (!this.isPermanentTimestamp(dateTime)) {
            this.dy.add(nodeCacheWrapper);
            this.dy.remove(object);
            this.ai();
        }
        if (object == null) {
            return null;
        }
        return ((NodeCacheWrapper)object).getNode();
    }

    protected UaNode createNode(NodeClass object, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText, ExpandedNodeId expandedNodeId) throws UaNodeFactoryException {
        object = this.nodeFactory.createNode((NodeClass)object, nodeId, qualifiedName, localizedText, expandedNodeId);
        this.addNode((UaNode)object);
        return object;
    }

    protected boolean isPermanentTimestamp(DateTime dateTime) {
        return dateTime.compareTo(DateTime.MAX_VALUE) >= 0;
    }

    public class NodeCacheWrapper {
        private final NodeId nodeId;
        private final Object jG;
        private final DateTime ak;

        public NodeCacheWrapper(NodeCache nodeCache, UaNode uaNode, DateTime dateTime) {
            this.jG = nodeCache.isPermanentTimestamp(dateTime) ? uaNode : new SoftReference<UaNode>(uaNode);
            this.ak = dateTime;
            this.nodeId = uaNode.getNodeId();
        }

        public UaNode getNode() {
            if (this.jG instanceof UaNode) {
                return (UaNode)this.jG;
            }
            return (UaNode)((Reference)this.jG).get();
        }

        public NodeId getNodeId() {
            return this.nodeId;
        }

        public DateTime getTimestamp() {
            return this.ak;
        }

        public boolean isValid(DateTime dateTime) {
            return this.ak.compareTo(dateTime) >= 0;
        }
    }
}

