/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.client.MonitoredEventItemListener;
import com.prosysopc.ua.client.MonitoredItem;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.core.Attributes;
import org.opcfoundation.ua.core.EventFilter;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.MonitoringFilter;
import org.opcfoundation.ua.core.MonitoringMode;
import org.opcfoundation.ua.core.SimpleAttributeOperand;

public class MonitoredEventItem
extends MonitoredItem {
    private static QualifiedName[] kk = new QualifiedName[0];
    private volatile MonitoredEventItemListener kl = null;

    public static QualifiedName[] createBrowsePath(QualifiedName qualifiedName) {
        return MonitoredEventItem.createBrowsePath(qualifiedName, "/", ":");
    }

    public static QualifiedName[] createBrowsePath(QualifiedName qualifiedName, String stringArray, String string) {
        if (!qualifiedName.getName().contains((CharSequence)stringArray)) {
            return new QualifiedName[]{qualifiedName};
        }
        stringArray = qualifiedName.getName().split((String)stringArray);
        QualifiedName[] qualifiedNameArray = new QualifiedName[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String[] stringArray2;
            int n2 = qualifiedName.getNamespaceIndex();
            String string2 = stringArray[i2];
            if (string != null && !string.isEmpty() && (stringArray2 = string2.split(string)).length > 1) {
                n2 = Integer.parseInt(stringArray2[0]);
                string2 = stringArray2[1];
            }
            qualifiedNameArray[i2] = new QualifiedName(n2, string2);
        }
        return qualifiedNameArray;
    }

    public static QualifiedName[] getDefaultEventFields() {
        return kk;
    }

    public static void setDefaultEventFields(QualifiedName[] qualifiedNameArray) {
        if (qualifiedNameArray == null) {
            qualifiedNameArray = new QualifiedName[]{};
        }
        kk = qualifiedNameArray;
    }

    private static EventFilter bi() {
        NodeId nodeId = Identifiers.BaseEventType;
        UnsignedInteger unsignedInteger = Attributes.Value;
        SimpleAttributeOperand[] simpleAttributeOperandArray = new SimpleAttributeOperand[kk.length + 1];
        for (int i2 = 0; i2 < kk.length; ++i2) {
            QualifiedName[] qualifiedNameArray = MonitoredEventItem.createBrowsePath(kk[i2]);
            simpleAttributeOperandArray[i2] = new SimpleAttributeOperand(nodeId, qualifiedNameArray, unsignedInteger, null);
        }
        simpleAttributeOperandArray[MonitoredEventItem.kk.length] = new SimpleAttributeOperand(nodeId, null, Attributes.NodeId, null);
        return new EventFilter(simpleAttributeOperandArray, null);
    }

    public MonitoredEventItem(ExpandedNodeId expandedNodeId) {
        this(expandedNodeId, MonitoredEventItem.bi());
    }

    public MonitoredEventItem(ExpandedNodeId expandedNodeId, EventFilter eventFilter) {
        super(expandedNodeId, Attributes.EventNotifier, MonitoringMode.Reporting);
        try {
            this.setEventFilter(eventFilter);
            return;
        }
        catch (ServiceException serviceException) {
            throw new RuntimeException(serviceException);
        }
    }

    public MonitoredEventItem(NodeId nodeId) {
        this(nodeId, MonitoredEventItem.bi());
    }

    public MonitoredEventItem(NodeId nodeId, EventFilter eventFilter) {
        super(nodeId, Attributes.EventNotifier, MonitoringMode.Reporting);
        try {
            this.setEventFilter(eventFilter);
            return;
        }
        catch (ServiceException serviceException) {
            throw new RuntimeException(serviceException);
        }
    }

    @Deprecated
    public void addEventListener(MonitoredEventItemListener monitoredEventItemListener) {
        if (this.kl != null && monitoredEventItemListener != null && this.kl != monitoredEventItemListener) {
            throw new RuntimeException("The MonitoredEventItem no longer supports multicast events. Use of addEventListener is deprecated");
        }
        this.setEventListener(monitoredEventItemListener);
    }

    public EventFilter getEventFilter() {
        return (EventFilter)this.getFilter();
    }

    public MonitoredEventItemListener getEventListener() {
        return this.kl;
    }

    @Deprecated
    public MonitoredEventItemListener[] getEventListeners() {
        if (this.kl == null) {
            return new MonitoredEventItemListener[0];
        }
        return new MonitoredEventItemListener[]{this.kl};
    }

    @Deprecated
    public boolean hasEventListener(MonitoredEventItemListener monitoredEventItemListener) {
        return this.kl == monitoredEventItemListener;
    }

    @Deprecated
    public boolean removeEventListener(MonitoredEventItemListener monitoredEventItemListener) {
        if (this.kl == monitoredEventItemListener) {
            this.setEventListener(null);
            return true;
        }
        return false;
    }

    public void setEventFilter(EventFilter eventFilter) throws ServiceException {
        if (eventFilter == null) {
            eventFilter = MonitoredEventItem.bi();
        }
        this.setFilter((MonitoringFilter)eventFilter);
    }

    public void setEventListener(MonitoredEventItemListener monitoredEventItemListener) {
        this.kl = monitoredEventItemListener;
    }

    protected void doEvent(Variant[] object) {
        Variant[] variantArray = object;
        object = this;
        if (object.kl != null) {
            try {
                object.kl.onEvent((MonitoredEventItem)object, variantArray);
                return;
            }
            catch (Exception exception) {
                logger.error("Exception while calling onEvent with listener={}", (Object)object.kl, (Object)exception);
            }
        }
    }

    @Override
    protected long getDefaultQueueSize() {
        return UnsignedInteger.MAX_VALUE.getValue();
    }
}

