/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.MonitoredDataItemListener;
import com.prosysopc.ua.client.MonitoredItem;
import java.util.concurrent.TimeUnit;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.Attributes;
import org.opcfoundation.ua.core.DataChangeFilter;
import org.opcfoundation.ua.core.MonitoringFilter;
import org.opcfoundation.ua.core.MonitoringMode;
import org.opcfoundation.ua.utils.NumericRange;

public class MonitoredDataItem
extends MonitoredItem {
    private NumericRange bP = null;
    private double bQ = -1.0;
    private DataValue be;
    protected volatile MonitoredDataItemListener dataChangeListener = null;

    public MonitoredDataItem(ExpandedNodeId expandedNodeId) {
        this(expandedNodeId, Attributes.Value);
    }

    public MonitoredDataItem(ExpandedNodeId expandedNodeId, UnsignedInteger unsignedInteger) {
        this(expandedNodeId, unsignedInteger, MonitoringMode.Reporting);
    }

    public MonitoredDataItem(ExpandedNodeId expandedNodeId, UnsignedInteger unsignedInteger, MonitoringMode monitoringMode) {
        this(expandedNodeId, unsignedInteger, monitoringMode, -1.0);
    }

    public MonitoredDataItem(ExpandedNodeId expandedNodeId, UnsignedInteger unsignedInteger, MonitoringMode monitoringMode, double d2) {
        super(expandedNodeId, unsignedInteger, monitoringMode);
        this.bQ = d2;
    }

    public MonitoredDataItem(NodeId nodeId) {
        this(nodeId, Attributes.Value);
    }

    public MonitoredDataItem(NodeId nodeId, UnsignedInteger unsignedInteger) {
        this(nodeId, unsignedInteger, MonitoringMode.Reporting);
    }

    public MonitoredDataItem(NodeId nodeId, UnsignedInteger unsignedInteger, MonitoringMode monitoringMode) {
        this(nodeId, unsignedInteger, monitoringMode, -1.0);
    }

    public MonitoredDataItem(NodeId nodeId, UnsignedInteger unsignedInteger, MonitoringMode monitoringMode, double d2) {
        super(nodeId, unsignedInteger, monitoringMode);
        this.bQ = d2;
    }

    @Deprecated
    public void addChangeListener(MonitoredDataItemListener monitoredDataItemListener) {
        if (this.dataChangeListener != null && monitoredDataItemListener != null && this.dataChangeListener != monitoredDataItemListener) {
            throw new RuntimeException("The MonitoredDataItem no longer supports multicast events. Use of addChangeListener is deprecated");
        }
        this.setDataChangeListener(monitoredDataItemListener);
    }

    public DataChangeFilter getDataChangeFilter() {
        return (DataChangeFilter)this.getFilter();
    }

    public MonitoredDataItemListener getDataChangeListener() {
        return this.dataChangeListener;
    }

    @Deprecated
    public MonitoredDataItemListener[] getDataChangeListeners() {
        if (this.dataChangeListener == null) {
            return new MonitoredDataItemListener[0];
        }
        return new MonitoredDataItemListener[]{this.dataChangeListener};
    }

    @Override
    public NumericRange getIndexRange() {
        return this.bP;
    }

    @Override
    public double getSamplingInterval() {
        return this.bQ;
    }

    public DataValue getValue() {
        return this.be;
    }

    @Deprecated
    public boolean hasChangeListener(MonitoredDataItemListener monitoredDataItemListener) {
        if (monitoredDataItemListener == null) {
            throw new NullPointerException("null listener not allowed");
        }
        return this.dataChangeListener == monitoredDataItemListener;
    }

    @Deprecated
    public boolean removeChangeListener(MonitoredDataItemListener monitoredDataItemListener) {
        if (this.dataChangeListener == monitoredDataItemListener) {
            this.setDataChangeListener(null);
            return true;
        }
        return false;
    }

    public void setDataChangeFilter(DataChangeFilter dataChangeFilter) throws ServiceException, StatusException {
        this.setFilter((MonitoringFilter)dataChangeFilter);
    }

    public void setDataChangeListener(MonitoredDataItemListener monitoredDataItemListener) {
        this.dataChangeListener = monitoredDataItemListener;
    }

    public void setIndexRange(NumericRange numericRange) throws ServiceException {
        if (this.bP != numericRange) {
            this.bP = numericRange;
            this.itemChanged();
        }
    }

    public void setSamplingInterval(double d2) throws ServiceException {
        if (this.bQ != d2) {
            this.bQ = d2;
            this.itemChanged();
        }
    }

    public void setSamplingInterval(long l2, TimeUnit timeUnit) throws ServiceException {
        double d2;
        switch (timeUnit) {
            case MICROSECONDS: {
                d2 = l2 / 1000L;
                break;
            }
            case NANOSECONDS: {
                d2 = l2 / 1000000L;
                break;
            }
            default: {
                d2 = timeUnit.toMillis(l2);
            }
        }
        this.setSamplingInterval(d2);
    }

    protected void fireDataChange(DataValue dataValue, DataValue dataValue2) {
        if (this.dataChangeListener != null) {
            try {
                this.dataChangeListener.onDataChange(this, dataValue, dataValue2);
                return;
            }
            catch (Exception exception) {
                logger.error("Exception while calling onDataChange with listener=" + this.dataChangeListener, (Throwable)exception);
            }
        }
    }

    @Override
    protected long getDefaultQueueSize() {
        return 1L;
    }

    protected void setRevisedSamplingInterval(Double d2) {
        this.bQ = d2;
    }

    protected void setValue(DataValue dataValue) {
        if (dataValue != this.be) {
            DataValue dataValue2 = this.be;
            this.be = dataValue;
            this.fireDataChange(dataValue2, dataValue);
        }
    }
}

