/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client;

import com.prosysopc.ua.ModelException;
import com.prosysopc.ua.ModelParserBase;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.client.AddressSpaceException;
import com.prosysopc.ua.nodes.UaNode;
import java.util.List;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.common.NamespaceTable;
import org.opcfoundation.ua.common.ServerTable;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.AddNodesItem;
import org.opcfoundation.ua.core.AddReferencesItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelParser
extends ModelParserBase {
    private static final Logger logger = LoggerFactory.getLogger(ModelParser.class);
    private final AddressSpace addressSpace;

    public ModelParser(AddressSpace addressSpace) {
        super(addressSpace.getClient());
        this.addressSpace = addressSpace;
    }

    @Override
    protected void addNodes(List<AddNodesItem> list, String addNodesResultArray) throws ModelException, ServiceException {
        logger.debug("addNodes: {}", (Object)addNodesResultArray);
        if (!list.isEmpty()) {
            addNodesResultArray = this.addressSpace.addNodes(list.toArray(new AddNodesItem[list.size()]));
            for (int i2 = 0; i2 < list.size(); ++i2) {
                AddNodesItem addNodesItem = list.get(i2);
                if (addNodesResultArray[i2].getStatusCode().isBad()) {
                    this.getErrorList().add("Failed to add node " + addNodesItem.toString() + " Error: " + addNodesResultArray[i2].getStatusCode());
                    continue;
                }
                NodeId nodeId = addNodesResultArray[i2].getAddedNodeId();
                try {
                    if (nodeId.equals((Object)this.getNamespaceTable().toNodeId(addNodesItem.getRequestedNewNodeId()))) continue;
                    logger.warn("addNode: {} requested NodeId={} actual NodeId={}", new Object[]{addNodesItem.getBrowseName(), addNodesItem.getRequestedNewNodeId(), nodeId});
                    continue;
                }
                catch (ServiceResultException serviceResultException) {
                    logger.warn("addNode: {} requested NodeId={} actual NodeId={}", new Object[]{addNodesItem.getBrowseName(), addNodesItem.getRequestedNewNodeId(), nodeId});
                }
            }
        }
    }

    @Override
    protected void addReferences(List<AddReferencesItem> list) throws ModelException {
        try {
            StatusCode[] statusCodeArray = this.addressSpace.addReferences(list.toArray(new AddReferencesItem[list.size()]));
            for (int i2 = 0; i2 < list.size(); ++i2) {
                AddReferencesItem addReferencesItem = list.get(i2);
                if (!statusCodeArray[i2].isBad() || this.isIgnoredReference(addReferencesItem)) continue;
                this.getErrorList().add("Failed to add reference " + addReferencesItem.toString() + " Error: " + statusCodeArray[i2]);
            }
            return;
        }
        catch (ServiceException serviceException) {
            throw new ModelException(serviceException);
        }
    }

    @Override
    protected NamespaceTable getNamespaceTable() {
        return this.addressSpace.getNamespaceTable();
    }

    @Override
    protected UaNode getNode(NodeId nodeId) {
        try {
            return this.addressSpace.getNode(nodeId);
        }
        catch (ServiceException serviceException) {
            throw new RuntimeException(serviceException);
        }
        catch (AddressSpaceException addressSpaceException) {
            throw new RuntimeException(addressSpaceException);
        }
    }

    @Override
    protected ServerTable getServerTable() {
        return this.addressSpace.getServerTable();
    }
}

