/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpaceException;
import com.prosysopc.ua.client.ServerListBase;
import com.prosysopc.ua.client.ServerListException;
import com.prosysopc.ua.client.UaClient;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaReference;
import java.net.URISyntaxException;
import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.ApplicationDescription;
import org.opcfoundation.ua.core.ApplicationType;
import org.opcfoundation.ua.core.BrowsePath;
import org.opcfoundation.ua.core.BrowsePathResult;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.RelativePath;
import org.opcfoundation.ua.core.RelativePathElement;
import org.opcfoundation.ua.core.TimestampsToReturn;
import org.opcfoundation.ua.transport.security.SecurityMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalServerList
extends ServerListBase {
    private static final ExpandedNodeId jF = new ExpandedNodeId(null, "http://opcfoundation.org/UA/GDS/", (Object)586);
    private static Logger logger = LoggerFactory.getLogger(GlobalServerList.class);
    private UaClient fm;

    public GlobalServerList() {
    }

    public GlobalServerList(String string) throws ServerListException {
        super(string);
    }

    @Override
    public void discover(String string) throws ServerListException {
        if (this.fm == null) {
            this.fm = new UaClient();
        }
        try {
            this.fm.setUri(string);
            this.fm.setSecurityMode(SecurityMode.NONE);
            this.fm.getEndpointConfiguration().setOperationTimeout(Integer.valueOf(10000));
            this.fm.connect();
            Object object = this.fm.readValue(Identifiers.Server_ServerStatus_BuildInfo_ProductUri);
            int n2 = this.fm.getNamespaceTable().getIndex("http://opcfoundation.org/UA/GDS/");
            Object object2 = object.getValue().getValue();
            if (object.isNull() || !object2.equals("http://opcfoundation.org/UA/GDS/v1.0")) {
                throw new ServerListException(String.format("The server is not a GDS server ProductUri=%s, expected=%s", object2, "http://opcfoundation.org/UA/GDS/v1.0"));
            }
            object = this.fm.getAddressSpace().getNode(jF);
            logger.debug("discover: applications={}", object);
            for (UaReference uaReference : object.getReferences(Identifiers.Organizes, false)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("discover: hostReference=" + uaReference);
                }
                for (UaReference uaReference2 : uaReference.getTargetNode().getReferences(Identifiers.Organizes, false)) {
                    try {
                        logger.debug("discover: appReference={}", (Object)uaReference2);
                        int n3 = n2;
                        Object[] objectArray = uaReference2.getTargetNode();
                        GlobalServerList globalServerList = this;
                        ApplicationDescription applicationDescription = new ApplicationDescription();
                        applicationDescription.setApplicationName(objectArray.getDisplayName());
                        BrowsePath browsePath = globalServerList.createBrowsePath((UaNode)objectArray, n3, "ApplicationType");
                        BrowsePath browsePath2 = globalServerList.createBrowsePath((UaNode)objectArray, n3, "ApplicationUri");
                        BrowsePath browsePath3 = globalServerList.createBrowsePath((UaNode)objectArray, n3, "MachineName");
                        objectArray = globalServerList.createBrowsePath((UaNode)objectArray, n3, "DiscoveryUrls");
                        logger.debug("getApplicationDescription: appTypeName={} appUriName={}, machineNameName={}, discoveryUrisName={}s", new Object[]{browsePath, browsePath2, browsePath3, objectArray});
                        objectArray = globalServerList.fm.getAddressSpace().translateBrowsePathsToNodeIds(new BrowsePath[]{browsePath, browsePath2, browsePath3, objectArray});
                        if (logger.isDebugEnabled()) {
                            logger.debug("getApplicationDescription: results={}", (Object)Arrays.toString(objectArray));
                        }
                        objectArray = globalServerList.fm.readValues(globalServerList.a((BrowsePathResult[])objectArray), TimestampsToReturn.Neither);
                        if (logger.isDebugEnabled()) {
                            logger.debug("getApplicationDescription: values={}", (Object)Arrays.toString(objectArray));
                        }
                        applicationDescription.setApplicationType(ApplicationType.valueOf((String)globalServerList.getStringValue((DataValue[])objectArray, 0)));
                        applicationDescription.setApplicationUri(globalServerList.getStringValue((DataValue[])objectArray, 1));
                        globalServerList = objectArray[3].getStatusCode().isGood() ? (String[])objectArray[3].getValue().getValue() : null;
                        applicationDescription.setDiscoveryUrls((String[])globalServerList);
                        globalServerList = applicationDescription;
                        if (!globalServerList.getApplicationType().equals((Object)ApplicationType.Server)) continue;
                        this.servers.add(globalServerList);
                    }
                    catch (Exception exception) {
                        logger.warn("Failed to read ApplicationDescription for node {}", (Object)uaReference2.getTargetNode());
                    }
                }
            }
            return;
        }
        catch (ServiceException serviceException) {
            logger.debug("ServiceException: ", (Throwable)serviceException);
            throw new ServerListException("Cannot discover applications from " + string.toString(), serviceException);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ServerListException("Cannot discover applications from " + string.toString());
        }
        catch (StatusException statusException) {
            throw new ServerListException("Cannot discover applications from " + string.toString());
        }
        catch (AddressSpaceException addressSpaceException) {
            throw new ServerListException("Cannot discover applications from " + string.toString() + " - Cannot find 'Applications' Node");
        }
        finally {
            this.fm.disconnect(5000L);
        }
    }

    private NodeId[] a(BrowsePathResult[] browsePathResultArray) throws ServiceResultException, ServiceException, StatusException {
        NodeId[] nodeIdArray = new NodeId[browsePathResultArray.length];
        for (int i2 = 0; i2 < browsePathResultArray.length; ++i2) {
            nodeIdArray[i2] = this.getNodeId(browsePathResultArray, i2);
        }
        return nodeIdArray;
    }

    protected BrowsePath createBrowsePath(UaNode uaNode, int n2, String string) {
        return new BrowsePath(uaNode.getNodeId(), new RelativePath(new RelativePathElement[]{new RelativePathElement(Identifiers.HasProperty, Boolean.valueOf(false), Boolean.valueOf(false), new QualifiedName(n2, string))}));
    }

    protected NodeId getNodeId(BrowsePathResult[] browsePathResultArray, int n2) throws ServiceResultException, ServiceException, StatusException {
        return this.fm.getNamespaceTable().toNodeId(browsePathResultArray[n2].getTargets()[0].getTargetId());
    }

    protected String getStringValue(DataValue[] dataValueArray, int n2) {
        if (dataValueArray[n2].getStatusCode().isGood()) {
            return (String)dataValueArray[n2].getValue().getValue();
        }
        return "";
    }
}

