/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client;

import com.prosysopc.ua.FileTypeOpenMode;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpaceException;
import com.prosysopc.ua.client.FileSyncClientListener;
import com.prosysopc.ua.client.MonitoredEventItem;
import com.prosysopc.ua.client.MonitoredEventItemListener;
import com.prosysopc.ua.client.Subscription;
import com.prosysopc.ua.client.UaClient;
import com.prosysopc.ua.client.nodes.UaVariableImpl;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaObject;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.types.opcua.FileType;
import com.prosysopc.ua.types.opcua.client.FileTypeImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.ExtensionObject;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.common.NamespaceTable;
import org.opcfoundation.ua.core.AddNodesItem;
import org.opcfoundation.ua.core.Attributes;
import org.opcfoundation.ua.core.EventFilter;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.NodeClass;
import org.opcfoundation.ua.core.ObjectAttributes;
import org.opcfoundation.ua.core.SimpleAttributeOperand;
import org.opcfoundation.ua.encoding.EncoderContext;
import org.opcfoundation.ua.encoding.EncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSyncClient {
    private static Logger logger = LoggerFactory.getLogger(FileSyncClient.class);
    private int go = 0;
    private final Map<File, SyncedFolder> gp = new ConcurrentSkipListMap<File, SyncedFolder>();
    private boolean gq = true;
    private final List<FileSyncClientListener> listeners = new CopyOnWriteArrayList<FileSyncClientListener>();
    private long gr = 0L;
    private TimerTask df;
    private Timer dg;
    private Subscription l;
    private UaClient fm;

    public FileSyncClient(UaClient uaClient) {
        this.fm = uaClient;
    }

    public FileTypeImpl addFile(File object, UaNode uaNode) throws ServiceException, StatusException, EncodingException, AddressSpaceException {
        logger.debug("addFile: {} folder={}", (Object)((File)object).getPath(), (Object)uaNode.getBrowseName());
        ObjectAttributes objectAttributes = new ObjectAttributes();
        NamespaceTable namespaceTable = this.fm.getNamespaceTable();
        ExpandedNodeId expandedNodeId = new ExpandedNodeId(null, uaNode.getNodeId().getNamespaceIndex(), (Object)((File)object).getPath());
        ExpandedNodeId expandedNodeId2 = namespaceTable.toExpandedNodeId(uaNode.getNodeId());
        namespaceTable = namespaceTable.toExpandedNodeId(Identifiers.FileType);
        object = new AddNodesItem(expandedNodeId2, Identifiers.HasComponent, expandedNodeId, FileSyncClient.a(uaNode, (File)object), NodeClass.Object, ExtensionObject.binaryEncode((Structure)objectAttributes, (EncoderContext)this.fm.getEncoderContext()), (ExpandedNodeId)namespaceTable);
        object = this.fm.getAddressSpace().addNode((AddNodesItem)object);
        object = FileSyncClient.a(this.fm.getAddressSpace().getNode((NodeId)object));
        return object;
    }

    public void addListener(FileSyncClientListener fileSyncClientListener) {
        this.listeners.add(fileSyncClientListener);
    }

    public SyncedFolder addSyncedFolder(NodeId object, File file, SyncFolderDirection syncFolderDirection) {
        object = new SyncedFolder(this, (NodeId)object, file, syncFolderDirection, true, true);
        return this.addSyncedFolder((SyncedFolder)object);
    }

    public SyncedFolder addSyncedFolder(NodeId nodeId, String string, SyncFolderDirection syncFolderDirection) {
        return this.addSyncedFolder(nodeId, new File(string), syncFolderDirection);
    }

    public SyncedFolder addSyncedFolder(SyncedFolder syncedFolder) {
        this.gp.put(syncedFolder.cu, syncedFolder);
        this.aO();
        return syncedFolder;
    }

    public void close() {
        this.stopMonitor();
    }

    public int getBlockSize() {
        return this.go;
    }

    public FileSyncClientListener[] getListeners() {
        return this.listeners.toArray(new FileSyncClientListener[0]);
    }

    public long getMonitorInterval() {
        return this.gr;
    }

    public boolean isKeepRemovedFiles() {
        return this.gq;
    }

    public void readFile(File file, FileTypeImpl fileTypeImpl) throws ServiceException, StatusException, IOException {
        this.readFile(file, fileTypeImpl, false);
    }

    public void readFile(File file, FileTypeImpl fileTypeImpl, boolean bl) throws ServiceException, StatusException, IOException {
        logger.debug("readFile: {} local={}", (Object)fileTypeImpl.getBrowseName(), (Object)file);
        long l2 = fileTypeImpl.getSize().longValue();
        DateTime dateTime = fileTypeImpl.getTimestamp();
        UnsignedInteger unsignedInteger = fileTypeImpl.open(FileTypeOpenMode.Read);
        FileOutputStream fileOutputStream = new FileOutputStream(file, bl);
        try {
            int n2 = this.getActualBlockSize();
            for (long i2 = 0L; i2 < l2; i2 += (long)n2) {
                fileOutputStream.write(fileTypeImpl.read(unsignedInteger, n2));
            }
        }
        finally {
            fileOutputStream.close();
            fileTypeImpl.close(unsignedInteger);
        }
        file.setLastModified(dateTime.getTimeInMillis());
    }

    public void removeListener(FileSyncClientListener fileSyncClientListener) {
        this.listeners.remove(fileSyncClientListener);
    }

    public void setBlockSize(int n2) {
        this.go = n2;
    }

    public void setKeepRemovedFiles(boolean bl) {
        this.gq = bl;
    }

    public void setMonitorInterval(long l2) {
        if (l2 != this.gr) {
            this.stopMonitor();
            this.gr = l2;
            this.aO();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void sync() {
        logger.debug("FileSyncClient.sync()");
        Iterator<SyncedFolder> iterator = this.gp.values().iterator();
        block7: while (true) {
            if (!iterator.hasNext()) {
                this.fireChange();
                return;
            }
            SyncedFolder syncedFolder = iterator.next();
            try {
                logger.debug("sync: {} remoteId={}", (Object)syncedFolder.getLocalFolder(), (Object)syncedFolder.getRemoteFolderId());
                this.fm.getAddressSpace().getCache().remove(syncedFolder.getRemoteFolderId());
                UaNode uaNode = this.fm.getAddressSpace().getNode(syncedFolder.getRemoteFolderId());
                if (uaNode == null) {
                    this.gp.remove(syncedFolder.cu);
                    if (this.isKeepRemovedFiles() || syncedFolder.cs) continue;
                    logger.info("sync: remove local folder (no longer in server) - {}", (Object)syncedFolder.cu);
                    this.c(syncedFolder.cu);
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("sync: getComponents()=" + Arrays.toString(uaNode.getComponents()));
                }
                switch (syncedFolder.getDirection()) {
                    case ReadOnly: {
                        this.b(syncedFolder, uaNode);
                        if (this.isKeepRemovedFiles()) break;
                        logger.debug("sync: remove local files");
                        if (!syncedFolder.getLocalFolder().exists()) break;
                        File[] fileArray = syncedFolder.getLocalFolder().listFiles();
                        int n2 = fileArray.length;
                        int n3 = 0;
                        while (true) {
                            if (n3 >= n2) continue block7;
                            File file = fileArray[n3];
                            if (!file.isDirectory()) {
                                logger.debug("sync: file={}", (Object)file.getName());
                                if (uaNode.getComponent(new QualifiedName(syncedFolder.getRemoteFolderId().getNamespaceIndex(), file.getName())) == null) {
                                    logger.info("sync: remove local file (no longer in server) - {}", (Object)file);
                                    file.delete();
                                }
                            }
                            ++n3;
                        }
                    }
                    case ReadWrite: {
                        this.b(syncedFolder, uaNode);
                        this.a(syncedFolder, uaNode);
                        continue block7;
                    }
                    case WriteOnly: {
                        this.a(syncedFolder, uaNode);
                    }
                }
            }
            catch (Exception exception) {
                logger.warn("Failed to synchronize folder " + syncedFolder.cv + " from server " + this.fm.getUri(), (Throwable)exception);
                continue;
            }
            break;
        }
    }

    public void writeFile(File file, FileTypeImpl fileTypeImpl) throws ServiceException, StatusException, IOException {
        this.writeFile(file, fileTypeImpl, false);
    }

    public void writeFile(File object, FileTypeImpl fileTypeImpl, boolean bl) throws ServiceException, StatusException, IOException {
        logger.debug("writeFile: {} local={} append={}", new Object[]{fileTypeImpl.getBrowseName(), object, bl});
        long l2 = ((File)object).length();
        EnumSet<FileTypeOpenMode> enumSet = EnumSet.of(FileTypeOpenMode.Write);
        if (bl) {
            enumSet.add(FileTypeOpenMode.Append);
        } else {
            enumSet.add(FileTypeOpenMode.EraseExisting);
        }
        UnsignedInteger unsignedInteger = fileTypeImpl.open(enumSet);
        object = new FileInputStream((File)object);
        try {
            int n2 = this.getActualBlockSize();
            byte[] byArray = new byte[n2];
            for (long i2 = 0L; i2 < l2; i2 += (long)n2) {
                if ((long)n2 > l2 - i2) {
                    byArray = new byte[(int)(l2 - i2)];
                }
                ((FileInputStream)object).read(byArray);
                fileTypeImpl.write(unsignedInteger, byArray);
            }
            return;
        }
        finally {
            ((FileInputStream)object).close();
            fileTypeImpl.close(unsignedInteger);
        }
    }

    private static QualifiedName a(UaNode uaNode, File file) {
        return new QualifiedName(uaNode.getBrowseName().getNamespaceIndex(), file.getName());
    }

    private void c(File file) {
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                this.c(file2);
            }
        }
        file.delete();
    }

    private void a(SyncedFolder fileArray, UaNode uaNode) {
        fileArray = fileArray.getLocalFolder().listFiles();
        int n2 = fileArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            File file;
            File file2 = file = fileArray[i2];
            UaNode uaNode2 = uaNode;
            FileSyncClient object = this;
            FileTypeImpl fileTypeImpl = FileSyncClient.a(uaNode2.getComponent(FileSyncClient.a(uaNode2, file2)));
            try {
                long exception;
                if (fileTypeImpl == null) {
                    fileTypeImpl = object.addFile(file2, uaNode2);
                }
                try {
                    exception = fileTypeImpl.getSize().longValue();
                }
                catch (Exception exception2) {
                    exception = 0L;
                }
                if (file2.length() == exception) continue;
                object.writeFile(file2, fileTypeImpl);
                continue;
            }
            catch (Exception exception) {
                logger.info("Failed to synchronize local file to remote. File=" + file2.getPath() + " Exception=" + exception, (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void b(SyncedFolder syncedFolder, UaNode object) throws StatusException, ServiceException, IOException {
        void var6_14;
        UaReference[] uaReferenceArray;
        Object object2;
        Object object3;
        if (logger.isDebugEnabled()) {
            logger.debug("refreshRemoteFiles: folder.getComponents()=" + Arrays.toString(object.getComponents()));
        }
        for (UaNode uaNode : object.getComponents()) {
            object3 = FileSyncClient.a(uaNode);
            if (object3 == null) continue;
            try {
                SyncFolderDirection syncFolderDirection = syncedFolder.ct;
                FileTypeImpl fileTypeImpl = object3;
                object2 = syncedFolder.cu;
                FileSyncClient fileSyncClient = this;
                String string = fileTypeImpl.getBrowseName().getName();
                object2 = new File((File)object2, string);
                if (SyncFolderDirection.WriteOnly.equals((Object)syncFolderDirection)) continue;
                if (!((File)object2).exists()) {
                    logger.info("refreshRemoteFile: new file, fileType={} localFile={}", (Object)fileTypeImpl.getBrowseName(), (Object)((File)object2).getPath());
                    fileSyncClient.readFile((File)object2, fileTypeImpl, false);
                    continue;
                }
                syncFolderDirection = ((UaVariableImpl)((Object)fileTypeImpl.getSizeNode())).readValue();
                if (syncFolderDirection.getSourceTimestamp().getTimeInMillis() > ((File)object2).lastModified()) {
                    logger.info("refreshRemoteFile: updating file, fileType={} localFile={}", (Object)fileTypeImpl.getBrowseName(), (Object)((File)object2).getPath());
                    fileSyncClient.readFile((File)object2, fileTypeImpl, false);
                    continue;
                }
                if (syncFolderDirection.getSourceTimestamp().getTimeInMillis() != ((File)object2).lastModified() || !syncFolderDirection.getValue().equals((Object)((File)object2).length())) continue;
                logger.info("refreshRemoteFile: updating file, fileType={} localFile={}", (Object)fileTypeImpl.getBrowseName(), (Object)((File)object2).getPath());
                fileSyncClient.readFile((File)object2, fileTypeImpl, false);
            }
            catch (Exception exception) {
                logger.warn("Cannot refresh remote file. SyncFolder=" + syncedFolder + " with file=" + object3 + " this might happen if server deleted folders that have folders", (Throwable)exception);
            }
        }
        UaReference[] uaReferenceArray2 = uaReferenceArray = object.getForwardReferences(Identifiers.Organizes);
        int n2 = uaReferenceArray.length;
        boolean bl = false;
        while (var6_14 < n2) {
            object3 = uaReferenceArray2[var6_14];
            try {
                object2 = (UaObject)((UaReference)object3).getTargetNode();
                if (logger.isDebugEnabled()) {
                    logger.debug("refreshRemoteFiles: target=" + object2.getBrowseName() + " type=" + (object2.getTypeDefinition() == null ? object2.getTypeDefinitionId() : object2.getTypeDefinition().getBrowseName()));
                }
                if (object2.getTypeDefinitionId().equals((Object)Identifiers.FolderType)) {
                    object = new File(syncedFolder.cu, object2.getBrowseName().getName());
                    ((File)object).mkdirs();
                    if (!this.gp.containsKey(object)) {
                        SyncedFolder syncedFolder2 = new SyncedFolder(this, object2.getNodeId(), (File)object, syncedFolder.ct, syncedFolder.active);
                        this.addSyncedFolder(syncedFolder2);
                    }
                    this.b(this.gp.get(object), (UaNode)object2);
                }
            }
            catch (Exception exception) {
                logger.warn("Could not get subfolder to sync", (Throwable)exception);
            }
            ++var6_14;
        }
    }

    private synchronized void aO() {
        if (this.gr != 0L) {
            FileSyncClient fileSyncClient = this;
            if (fileSyncClient.dg == null) {
                fileSyncClient.df = new TimerTask(fileSyncClient){
                    private /* synthetic */ FileSyncClient ff;
                    {
                        this.ff = fileSyncClient;
                    }

                    @Override
                    public final void run() {
                        this.ff.sync();
                    }
                };
                fileSyncClient.dg = new Timer();
                fileSyncClient.dg.scheduleAtFixedRate(fileSyncClient.df, 0L, fileSyncClient.gr);
            }
            return;
        }
        FileSyncClient fileSyncClient = this;
        if (fileSyncClient.l == null) {
            fileSyncClient.l = new Subscription();
            try {
                fileSyncClient.fm.addSubscription(fileSyncClient.l);
                MonitoredEventItem monitoredEventItem = new MonitoredEventItem(Identifiers.Server);
                EventFilter eventFilter = new EventFilter[]{new QualifiedName("EventType")};
                eventFilter = fileSyncClient.createEventFilter((QualifiedName[])eventFilter);
                monitoredEventItem.setEventFilter(eventFilter);
                fileSyncClient.l.addItem(monitoredEventItem);
                monitoredEventItem.setEventListener(new MonitoredEventItemListener(fileSyncClient){
                    private /* synthetic */ FileSyncClient ff;
                    {
                        this.ff = fileSyncClient;
                    }

                    @Override
                    public final void onEvent(MonitoredEventItem monitoredEventItem, Variant[] variantArray) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("onEvent: " + Arrays.toString(variantArray));
                        }
                        if (Identifiers.GeneralModelChangeEventType.equals(variantArray[0].asClass(NodeId.class, (Object)NodeId.NULL))) {
                            try {
                                this.ff.sync();
                                return;
                            }
                            catch (Exception exception) {
                                logger.debug("Failed to sync after model change event", (Throwable)exception);
                            }
                        }
                    }
                });
                return;
            }
            catch (ServiceException serviceException) {
                logger.warn("Failed to create subscription", (Throwable)serviceException);
                return;
            }
            catch (StatusException statusException) {
                logger.warn("Failed to create subscription", (Throwable)statusException);
            }
        }
    }

    private synchronized void stopMonitor() {
        if (this.dg != null) {
            this.dg.cancel();
            this.dg = null;
            this.df = null;
        }
        if (this.l != null) {
            try {
                this.fm.removeSubscription(this.l);
                return;
            }
            catch (ServiceException serviceException) {
                return;
            }
            finally {
                this.l = null;
            }
        }
    }

    private static FileTypeImpl a(UaNode uaNode) {
        FileTypeImpl fileTypeImpl = null;
        if (uaNode instanceof FileTypeImpl) {
            fileTypeImpl = (FileTypeImpl)uaNode;
        } else if (uaNode instanceof FileType) {
            fileTypeImpl = (FileTypeImpl)uaNode;
        }
        return fileTypeImpl;
    }

    protected EventFilter createEventFilter(QualifiedName[] qualifiedNameArray) {
        NodeId nodeId = Identifiers.BaseEventType;
        UnsignedInteger unsignedInteger = Attributes.Value;
        SimpleAttributeOperand[] simpleAttributeOperandArray = new SimpleAttributeOperand[qualifiedNameArray.length + 1];
        for (int i2 = 0; i2 < qualifiedNameArray.length; ++i2) {
            QualifiedName[] qualifiedNameArray2 = new QualifiedName[]{qualifiedNameArray[i2]};
            simpleAttributeOperandArray[i2] = new SimpleAttributeOperand(nodeId, qualifiedNameArray2, unsignedInteger, null);
        }
        simpleAttributeOperandArray[qualifiedNameArray.length] = new SimpleAttributeOperand(nodeId, null, Attributes.NodeId, null);
        EventFilter eventFilter = new EventFilter();
        eventFilter.setSelectClauses(simpleAttributeOperandArray);
        return eventFilter;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    protected void fireChange() {
        for (FileSyncClientListener fileSyncClientListener : this.listeners) {
            try {
                fileSyncClientListener.onSync();
            }
            catch (Exception exception) {
                logger.warn("Error in listener.onSync()", (Throwable)exception);
            }
        }
    }

    protected int getActualBlockSize() {
        if (this.go > 0) {
            return this.go;
        }
        return this.fm.getEndpointConfiguration().getMaxByteStringLength() / 2;
    }

    public static enum SyncFolderDirection {
        ReadOnly,
        ReadWrite,
        WriteOnly;

    }

    public class SyncedFolder {
        boolean active;
        boolean cs;
        SyncFolderDirection ct;
        File cu;
        NodeId cv;

        public SyncedFolder(FileSyncClient fileSyncClient, NodeId nodeId, File file, SyncFolderDirection syncFolderDirection, boolean bl) {
            this(fileSyncClient, nodeId, file, syncFolderDirection, bl, false);
        }

        public SyncedFolder(FileSyncClient fileSyncClient, NodeId nodeId, File file, SyncFolderDirection syncFolderDirection, boolean bl, boolean bl2) {
            this.cv = nodeId;
            this.cu = file;
            this.ct = syncFolderDirection;
            this.active = bl;
            this.cs = bl2;
        }

        public SyncFolderDirection getDirection() {
            return this.ct;
        }

        public File getLocalFolder() {
            return this.cu;
        }

        public NodeId getRemoteFolderId() {
            return this.cv;
        }

        public boolean isActive() {
            return this.active;
        }

        public boolean isBaseFolder() {
            return this.cs;
        }

        public void setActive(boolean bl) {
            this.active = bl;
        }

        public void setBaseFolder(boolean bl) {
            this.cs = bl;
        }

        public void setDirection(SyncFolderDirection syncFolderDirection) {
            this.ct = syncFolderDirection;
        }

        public void setLocalFolder(File file) {
            this.cu = file;
        }

        public void setRemoteFolderId(NodeId nodeId) {
            this.cv = nodeId;
        }

        public String toString() {
            return "SyncedFolder [localFolder=" + this.cu + ", remoteFolderId=" + this.cv + "]";
        }
    }
}

