/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client;

import com.prosysopc.ua.DataTypeConverter;
import com.prosysopc.ua.ModelException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.UaAddressSpace;
import com.prosysopc.ua.client.AddressSpaceException;
import com.prosysopc.ua.client.ModelParser;
import com.prosysopc.ua.client.NodeCache;
import com.prosysopc.ua.client.ServerConnectionException;
import com.prosysopc.ua.client.UaClient;
import com.prosysopc.ua.client.nodes.UaClientNodeFactory;
import com.prosysopc.ua.nodes.UaInstance;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaNodeFactory;
import com.prosysopc.ua.nodes.UaNodeFactoryException;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaType;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.ExtensionObject;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.ServiceResponse;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.common.NamespaceTable;
import org.opcfoundation.ua.common.ServerTable;
import org.opcfoundation.ua.common.ServiceFaultException;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.AddNodesItem;
import org.opcfoundation.ua.core.AddNodesResult;
import org.opcfoundation.ua.core.AddReferencesItem;
import org.opcfoundation.ua.core.Attributes;
import org.opcfoundation.ua.core.BrowseDescription;
import org.opcfoundation.ua.core.BrowseDirection;
import org.opcfoundation.ua.core.BrowseNextResponse;
import org.opcfoundation.ua.core.BrowsePath;
import org.opcfoundation.ua.core.BrowsePathResult;
import org.opcfoundation.ua.core.BrowsePathTarget;
import org.opcfoundation.ua.core.BrowseRequest;
import org.opcfoundation.ua.core.BrowseResult;
import org.opcfoundation.ua.core.BrowseResultMask;
import org.opcfoundation.ua.core.ContentFilter;
import org.opcfoundation.ua.core.DeleteNodesItem;
import org.opcfoundation.ua.core.DeleteReferencesItem;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.NodeAttributes;
import org.opcfoundation.ua.core.NodeClass;
import org.opcfoundation.ua.core.NodeTypeDescription;
import org.opcfoundation.ua.core.QueryDataSet;
import org.opcfoundation.ua.core.QueryFirstRequest;
import org.opcfoundation.ua.core.QueryFirstResponse;
import org.opcfoundation.ua.core.QueryNextRequest;
import org.opcfoundation.ua.core.QueryNextResponse;
import org.opcfoundation.ua.core.ReferenceDescription;
import org.opcfoundation.ua.core.RelativePath;
import org.opcfoundation.ua.core.RelativePathElement;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.core.TimestampsToReturn;
import org.opcfoundation.ua.core.TranslateBrowsePathsToNodeIdsResponse;
import org.opcfoundation.ua.core.ViewDescription;
import org.opcfoundation.ua.encoding.EncoderContext;
import org.opcfoundation.ua.encoding.EncodingException;
import org.opcfoundation.ua.transport.AsyncResult;
import org.opcfoundation.ua.utils.AttributesUtil;
import org.opcfoundation.ua.utils.MultiDimensionArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class AddressSpace
implements UaAddressSpace {
    private static Logger logger = LoggerFactory.getLogger(AddressSpace.class);
    private BrowseDirection fk = BrowseDirection.Forward;
    private NodeCache fl;
    private final UaClient fm;
    private DataTypeConverter fn;
    private Boolean fo = true;
    private UnsignedInteger fp = UnsignedInteger.valueOf((long)1000L);
    private UnsignedInteger fq = UnsignedInteger.valueOf((long)1000L);
    private EnumSet<NodeClass> fr = EnumSet.allOf(NodeClass.class);
    private final UaNodeFactory nodeFactory;
    private NodeId bu = Identifiers.HierarchicalReferences;
    private List<NodeId> fs = null;
    private EnumSet<BrowseResultMask> ft = EnumSet.allOf(BrowseResultMask.class);
    private ViewDescription fu = null;

    public AddressSpace(UaClient uaClient) {
        this.fm = uaClient;
        this.nodeFactory = new UaClientNodeFactory(this);
    }

    public NodeId addNode(AddNodesItem addNodesItem) throws ServiceException, StatusException {
        addNodesItem = this.addNodes(addNodesItem)[0];
        this.checkOperationResult(addNodesItem.getStatusCode());
        return addNodesItem.getAddedNodeId();
    }

    public NodeId addNode(NodeId nodeId, NodeId nodeId2, NodeId nodeId3, QualifiedName qualifiedName, NodeClass nodeClass, NodeAttributes nodeAttributes, NodeId nodeId4) throws ServiceException, EncodingException, StatusException {
        nodeId = new AddNodesItem(this.getNamespaceTable().toExpandedNodeId(nodeId), nodeId2, this.getNamespaceTable().toExpandedNodeId(nodeId3), qualifiedName, nodeClass, ExtensionObject.binaryEncode((Structure)nodeAttributes, (EncoderContext)this.getEncoderContext()), this.getNamespaceTable().toExpandedNodeId(nodeId4));
        return this.addNode((AddNodesItem)nodeId);
    }

    @Override
    public void addNode(UaNode uaNode) {
        this.fl.addNode(uaNode);
    }

    public AddNodesResult[] addNodes(AddNodesItem ... addNodesResponse) throws ServiceException {
        try {
            AddressSpace addressSpace = this;
            AddressSpace addressSpace2 = addressSpace;
            addressSpace2 = this;
            addNodesResponse = addressSpace.fm.D().AddNodes(addressSpace2.fm.getRequestHeader(), (AddNodesItem[])addNodesResponse);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        this.checkServiceResult((ServiceResponse)addNodesResponse, null);
        return addNodesResponse.getResults();
    }

    public void addReference(AddReferencesItem addReferencesItem) throws ServiceException, StatusException {
        addReferencesItem = this.addReferences(addReferencesItem)[0];
        this.checkOperationResult((StatusCode)addReferencesItem);
    }

    public StatusCode[] addReferences(AddReferencesItem ... addReferencesResponse) throws ServiceException {
        try {
            AddressSpace addressSpace = this;
            AddressSpace addressSpace2 = addressSpace;
            addressSpace2 = this;
            addReferencesResponse = addressSpace.fm.D().AddReferences(addressSpace2.fm.getRequestHeader(), (AddReferencesItem[])addReferencesResponse);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        this.checkServiceResult((ServiceResponse)addReferencesResponse, null);
        return addReferencesResponse.getResults();
    }

    public List<ReferenceDescription> browse(ExpandedNodeId expandedNodeId) throws ServiceException, StatusException {
        expandedNodeId = this.toNodeId(expandedNodeId);
        return this.browse((NodeId)expandedNodeId);
    }

    public List<ReferenceDescription> browse(ExpandedNodeId expandedNodeId, BrowseDirection browseDirection, NodeId nodeId, boolean bl, NodeClass ... nodeClassArray) throws ServiceException, StatusException {
        expandedNodeId = this.toNodeId(expandedNodeId);
        return this.browse((NodeId)expandedNodeId, browseDirection, nodeId, bl, nodeClassArray);
    }

    public List<ReferenceDescription> browse(NodeId nodeId) throws ServiceException, StatusException {
        return this.browse(nodeId, this.defaultBrowseDescription(nodeId));
    }

    public List<ReferenceDescription> browse(NodeId nodeId, BrowseDirection browseDirection, NodeId nodeId2, boolean bl, NodeClass ... nodeClassArray) throws ServiceException, StatusException {
        return this.browse(nodeId, new BrowseDescription(nodeId, browseDirection, nodeId2, Boolean.valueOf(bl), NodeClass.getMask((NodeClass[])nodeClassArray), BrowseResultMask.getMask(this.ft)));
    }

    public BrowseResult[] browse(ViewDescription viewDescription, int n2, BrowseDescription ... browseDescriptionArray) throws ServiceException {
        try {
            AddressSpace addressSpace = this;
            AddressSpace addressSpace2 = addressSpace;
            addressSpace2 = this;
            viewDescription = addressSpace.fm.D().Browse(addressSpace2.fm.getRequestHeader(), viewDescription, UnsignedInteger.valueOf((long)n2), browseDescriptionArray);
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        this.checkServiceResult((ServiceResponse)viewDescription, viewDescription.getDiagnosticInfos());
        return viewDescription.getResults();
    }

    public AsyncResult<ServiceResponse> browseAsync(ExpandedNodeId expandedNodeId) throws ServiceException {
        try {
            expandedNodeId = this.toNodeId(expandedNodeId);
        }
        catch (StatusException statusException) {
            throw new ServiceException(statusException.getStatusCode());
        }
        return this.browseAsync((NodeId)expandedNodeId);
    }

    public AsyncResult<ServiceResponse> browseAsync(NodeId nodeId) throws ServiceException {
        return this.browseAsync(null, 0, this.defaultBrowseDescription(nodeId));
    }

    public AsyncResult<ServiceResponse> browseAsync(ViewDescription viewDescription, int n2, BrowseDescription ... browseDescriptionArray) throws ServiceException {
        AddressSpace addressSpace = this;
        viewDescription = new BrowseRequest(addressSpace.fm.getRequestHeader(), viewDescription, UnsignedInteger.valueOf((long)n2), browseDescriptionArray);
        addressSpace = this;
        return addressSpace.fm.D().BrowseAsync((BrowseRequest)viewDescription);
    }

    public List<ReferenceDescription> browseMethods(ExpandedNodeId expandedNodeId) throws ServiceException, StatusException {
        return this.browseMethods(this.toNodeId(expandedNodeId));
    }

    public List<ReferenceDescription> browseMethods(NodeId object) throws ServiceException, StatusException {
        object = this.browse((NodeId)object, BrowseDirection.Forward, Identifiers.HierarchicalReferences, true, new NodeClass[]{NodeClass.Method});
        return object;
    }

    public BrowseResult[] browseNext(boolean bl, byte[] ... byArray) throws ServiceException {
        BrowseNextResponse browseNextResponse;
        try {
            AddressSpace addressSpace = this;
            AddressSpace addressSpace2 = addressSpace;
            addressSpace2 = this;
            browseNextResponse = addressSpace.fm.D().BrowseNext(addressSpace2.fm.getRequestHeader(), Boolean.valueOf(bl), byArray);
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        this.checkServiceResult((ServiceResponse)browseNextResponse, browseNextResponse.getDiagnosticInfos());
        return browseNextResponse.getResults();
    }

    public List<ReferenceDescription> browseUp(ExpandedNodeId expandedNodeId) throws ServerConnectionException, ServiceException, ServiceResultException, StatusException {
        return this.browseUp(this.getNamespaceTable().toNodeId(expandedNodeId));
    }

    public List<ReferenceDescription> browseUp(NodeId browseResultArray) throws ServerConnectionException, ServiceException {
        browseResultArray = this.browse(null, this.getMaxReferencesPerNode().intValue(), new BrowseDescription((NodeId)browseResultArray, BrowseDirection.Inverse, Identifiers.HierarchicalReferences, Boolean.valueOf(true), NodeClass.getMask((Collection)NodeClass.ALL), BrowseResultMask.getMask((Collection)BrowseResultMask.ALL)));
        if ((browseResultArray = browseResultArray[0].getReferences()) == null) {
            return new ArrayList<ReferenceDescription>();
        }
        return Arrays.asList(browseResultArray);
    }

    public BrowseDescription defaultBrowseDescription(NodeId object) {
        NodeId nodeId = object;
        AddressSpace addressSpace = this;
        object = addressSpace;
        object = this;
        return new BrowseDescription(nodeId, this.fk, this.bu, this.fo, NodeClass.getMask(addressSpace.fr), BrowseResultMask.getMask(object.ft));
    }

    public void deleteNode(DeleteNodesItem deleteNodesItem) throws ServiceException, StatusException {
        deleteNodesItem = this.deleteNodes(deleteNodesItem)[0];
        this.checkOperationResult((StatusCode)deleteNodesItem);
    }

    public StatusCode[] deleteNodes(DeleteNodesItem ... deleteNodesResponse) throws ServiceException {
        try {
            AddressSpace addressSpace = this;
            AddressSpace addressSpace2 = addressSpace;
            addressSpace2 = this;
            deleteNodesResponse = addressSpace.fm.D().DeleteNodes(addressSpace2.fm.getRequestHeader(), (DeleteNodesItem[])deleteNodesResponse);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        this.checkServiceResult((ServiceResponse)deleteNodesResponse, null);
        return deleteNodesResponse.getResults();
    }

    public void deleteReference(DeleteReferencesItem deleteReferencesItem) throws ServiceException, StatusException {
        deleteReferencesItem = this.deleteReferences(deleteReferencesItem)[0];
        this.checkOperationResult((StatusCode)deleteReferencesItem);
    }

    public StatusCode[] deleteReferences(DeleteReferencesItem ... deleteReferencesResponse) throws ServiceException {
        try {
            AddressSpace addressSpace = this;
            AddressSpace addressSpace2 = addressSpace;
            addressSpace2 = this;
            deleteReferencesResponse = addressSpace.fm.D().DeleteReferences(addressSpace2.fm.getRequestHeader(), (DeleteReferencesItem[])deleteReferencesResponse);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        this.checkServiceResult((ServiceResponse)deleteReferencesResponse, null);
        return deleteReferencesResponse.getResults();
    }

    @Override
    public UaNode findNode(NodeId nodeId) {
        return this.fl.getNode(nodeId);
    }

    public BrowseDirection getBrowseDirection() {
        return this.fk;
    }

    public NodeCache getCache() {
        return this.fl;
    }

    public UaClient getClient() {
        return this.fm;
    }

    @Override
    public DataTypeConverter getDataTypeConverter() {
        return this.fn;
    }

    @Override
    public EncoderContext getEncoderContext() {
        return this.fm.getEncoderContext();
    }

    public UnsignedInteger getMaxDataSetsPerQuery() {
        return this.fp;
    }

    public UnsignedInteger getMaxReferencesPerNode() {
        return this.fq;
    }

    public UaMethod getMethod(ExpandedNodeId expandedNodeId) throws ServiceException, AddressSpaceException, StatusException, ServiceResultException {
        return this.getMethod(this.getNamespaceTable().toNodeId(expandedNodeId));
    }

    public UaMethod getMethod(NodeId nodeId) throws ServiceException, AddressSpaceException, StatusException {
        return (UaMethod)this.getNode(nodeId);
    }

    public UaMethod getMethodByName(NodeId object, QualifiedName qualifiedName) throws ServiceException, AddressSpaceException, StatusException, ServiceResultException {
        for (ReferenceDescription referenceDescription : this.browseMethods((NodeId)object)) {
            if (!qualifiedName.equals((Object)referenceDescription.getBrowseName())) continue;
            return this.getMethod(referenceDescription.getNodeId());
        }
        return null;
    }

    public List<UaMethod> getMethods(NodeId object) throws ServiceException, StatusException, AddressSpaceException {
        object = this.browseMethods((NodeId)object);
        ArrayList<UaMethod> arrayList = new ArrayList<UaMethod>();
        object = object.iterator();
        while (object.hasNext()) {
            ReferenceDescription referenceDescription = (ReferenceDescription)object.next();
            arrayList.add((UaMethod)this.getNode(referenceDescription.getNodeId()));
        }
        return arrayList;
    }

    @Override
    public NamespaceTable getNamespaceTable() {
        return this.fm.getNamespaceTable();
    }

    public UaNode getNode(ExpandedNodeId expandedNodeId) throws ServiceException, AddressSpaceException {
        if (ExpandedNodeId.isNull((ExpandedNodeId)expandedNodeId)) {
            return null;
        }
        try {
            return this.getNode(this.getNamespaceTable().toNodeId(expandedNodeId));
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
    }

    public <T extends UaNode> T getNode(ExpandedNodeId expandedNodeId, Class<T> clazz) throws ServiceException, AddressSpaceException {
        try {
            UaNode uaNode = this.getNode(expandedNodeId);
            return (T)uaNode;
        }
        catch (ClassCastException classCastException) {
            throw new AddressSpaceException("NodeId " + expandedNodeId + " is not " + clazz, classCastException);
        }
    }

    public synchronized UaNode getNode(NodeId nodeId) throws ServiceException, AddressSpaceException {
        if (NodeId.isNull((NodeId)nodeId)) {
            return null;
        }
        if (this.fl == null) {
            throw new ServerConnectionException("Cannot use AddressSpace to retrieve nodes before the client is connected", "", null);
        }
        Object object = this.fl.getNode(nodeId);
        logger.debug("getNode: nodeId={} node={}", (Object)nodeId, object);
        if (object == null) {
            object = this.fm.readAttributes(nodeId, Attributes.NodeClass, Attributes.BrowseName, Attributes.DisplayName);
            logger.debug("classValues: {}", (Object)Arrays.toString((Object[])object));
            Object object2 = object[0].getStatusCode().isGood() ? NodeClass.valueOf((Integer)((Integer)object[0].getValue().getValue())) : null;
            logger.debug("NodeClass: {}", object2);
            if (object2 != null) {
                NodeId nodeId2 = EnumSet.of(NodeClass.ObjectType, NodeClass.ReferenceType, NodeClass.VariableType, NodeClass.DataType);
                nodeId2 = nodeId2.contains(object2) ? null : this.getTypeDefinition(nodeId);
                Object object3 = object[1].getStatusCode().isGood() ? (Object)object[1].getValue().getValue() : null;
                object = object[2].getStatusCode().isGood() ? (LocalizedText)object[2].getValue().getValue() : null;
                try {
                    object = this.fl.createNode((NodeClass)object2, nodeId, (QualifiedName)object3, (LocalizedText)object, (ExpandedNodeId)nodeId2);
                }
                catch (UaNodeFactoryException uaNodeFactoryException) {
                    logger.debug("UaNodeFactoryException: ", (Throwable)uaNodeFactoryException);
                    throw new AddressSpaceException("Cannot create node of type " + object2, uaNodeFactoryException);
                }
                NodeId nodeId3 = nodeId2;
                object3 = object;
                nodeId2 = nodeId;
                object2 = this;
                if (!ExpandedNodeId.isNull((ExpandedNodeId)nodeId3) && nodeId3.isLocal()) {
                    try {
                        logger.debug("getNode() typeDefinition: {}", (Object)nodeId3);
                        NodeId nodeId4 = ((AddressSpace)object2).getNamespaceTable().toNodeId((ExpandedNodeId)nodeId3);
                        if (!nodeId4.equals((Object)nodeId2) && object3 instanceof UaInstance) {
                            ((UaInstance)object3).setTypeDefinition(((AddressSpace)object2).getType(nodeId4));
                        }
                    }
                    catch (Exception exception) {
                        logger.warn(String.format("Cannot set the type corresponding to the typeDefinition (%s) of node %s (%s)", nodeId3, object3.getBrowseName(), nodeId2), (Throwable)exception);
                    }
                }
                logger.debug("typeDefinition not local:{}", (Object)nodeId3);
                this.readNode((UaNode)object);
                logger.debug("getNode: node={}", object);
                if (!nodeId.equals((Object)Identifiers.PropertyType)) {
                    this.readReferences((UaNode)object, Identifiers.References, BrowseDirection.Both, true);
                    this.readProperties((UaNode)object);
                }
            } else {
                throw new AddressSpaceException("Cannot determine NodeClass for NodeId: " + nodeId + " because the value is not good: " + MultiDimensionArrayUtils.toString((Object)object[0]));
            }
        }
        return object;
    }

    public <T extends UaNode> T getNode(NodeId nodeId, Class<T> clazz) throws ServiceException, AddressSpaceException {
        return this.getNode(this.getNamespaceTable().toExpandedNodeId(nodeId), clazz);
    }

    public EnumSet<NodeClass> getNodeClassSet() {
        return this.fr;
    }

    public NodeId getReferenceTypeId() {
        return this.bu;
    }

    public EnumSet<BrowseResultMask> getResultMaskSet() {
        return this.ft;
    }

    public ServerTable getServerTable() {
        return this.fm.getServerTable();
    }

    public UaType getType(NodeId object) throws ServiceException, AddressSpaceException {
        if ((object = this.getNode((NodeId)object)) instanceof UaType) {
            return (UaType)object;
        }
        throw new AddressSpaceException("The given NodeId is not for a type (getNode does not return UaType)");
    }

    public ExpandedNodeId getTypeDefinition(NodeId object) throws ServerConnectionException {
        try {
            object = this.browse((NodeId)object, BrowseDirection.Forward, Identifiers.HasTypeDefinition, true, new NodeClass[0]);
            if (object.size() > 0) {
                return ((ReferenceDescription)object.get(0)).getNodeId();
            }
        }
        catch (ServiceException serviceException) {
            logger.debug("ServiceException: ", (Throwable)serviceException);
        }
        catch (StatusException statusException) {
            logger.debug("StatusException: ", (Throwable)statusException);
        }
        return ExpandedNodeId.NULL;
    }

    public ViewDescription getView() {
        return this.fu;
    }

    public Boolean isIncludeSubTypes() {
        return this.fo;
    }

    @Override
    public void loadModel(InputStream inputStream) throws SAXException, IOException, ModelException, ServiceException {
        this.loadModel(inputStream, null, false);
    }

    public void loadModel(InputStream inputStream, Collection<ExpandedNodeId> collection, boolean bl) throws IOException, SAXException, ModelException, ServiceException {
        ModelParser modelParser = new ModelParser(this);
        modelParser.setIgnoredNodes(collection);
        modelParser.setFailOnFirstError(bl);
        modelParser.parseFile(inputStream);
        modelParser.createModel(false);
    }

    @Override
    public void loadModel(URI uRI) throws SAXException, IOException, ModelException, ServiceException {
        this.loadModel(uRI, null, false);
    }

    public void loadModel(URI uRI, Collection<ExpandedNodeId> collection, boolean bl) throws SAXException, IOException, ModelException, ServiceException {
        ModelParser modelParser = new ModelParser(this);
        modelParser.setIgnoredNodes(collection);
        modelParser.setFailOnFirstError(bl);
        modelParser.parseFile(uRI);
        modelParser.createModel(false);
    }

    public QueryDataSet[] query(NodeTypeDescription[] nodeTypeDescriptionArray, ContentFilter contentFilter) throws ServiceFaultException, ServerConnectionException, ServiceResultException {
        return this.query(nodeTypeDescriptionArray, contentFilter, this.getMaxDataSetsPerQuery(), this.getMaxReferencesPerNode());
    }

    public QueryDataSet[] query(NodeTypeDescription[] nodeTypeDescriptionArray, ContentFilter contentFilter, UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2) throws ServiceFaultException, ServerConnectionException, ServiceResultException {
        return this.query(this.fu, nodeTypeDescriptionArray, contentFilter, unsignedInteger, unsignedInteger2);
    }

    public QueryFirstResponse queryFirst(NodeTypeDescription[] nodeTypeDescriptionArray, ContentFilter contentFilter) throws ServiceFaultException, ServerConnectionException, ServiceResultException {
        AddressSpace addressSpace = this;
        AddressSpace addressSpace2 = addressSpace;
        addressSpace2 = this;
        return addressSpace.fm.D().QueryFirst(addressSpace2.fm.getRequestHeader(), this.fu, nodeTypeDescriptionArray, contentFilter, this.getMaxDataSetsPerQuery(), this.getMaxReferencesPerNode());
    }

    public QueryFirstResponse queryFirst(QueryFirstRequest queryFirstRequest) throws ServiceFaultException, ServerConnectionException, ServiceResultException {
        AddressSpace addressSpace = this;
        return addressSpace.fm.D().QueryFirst(queryFirstRequest);
    }

    public QueryNextResponse queryNext(boolean bl, byte[] byArray) throws ServiceFaultException, ServerConnectionException, ServiceResultException {
        AddressSpace addressSpace = this;
        AddressSpace addressSpace2 = addressSpace;
        addressSpace2 = this;
        return addressSpace.fm.D().QueryNext(addressSpace2.fm.getRequestHeader(), Boolean.valueOf(bl), byArray);
    }

    public synchronized StatusCode[] readAttributes(UaNode uaNode, UnsignedInteger ... unsignedIntegerArray) throws ServiceException {
        if (logger.isDebugEnabled()) {
            logger.debug("readAttributes(" + uaNode + ", " + Arrays.toString(unsignedIntegerArray) + ")");
        }
        DataValue[] dataValueArray = this.fm.readAttributes(uaNode.getNodeId(), unsignedIntegerArray);
        StatusCode[] statusCodeArray = new StatusCode[unsignedIntegerArray.length];
        for (int i2 = 0; i2 < dataValueArray.length; ++i2) {
            if (dataValueArray[i2] == null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("readAttributes: attribute=" + AttributesUtil.toString((UnsignedInteger)unsignedIntegerArray[i2]) + " value=" + dataValueArray[i2]);
            }
            if (unsignedIntegerArray[i2].equals((Object)Attributes.NodeClass)) continue;
            try {
                uaNode.setAttribute(unsignedIntegerArray[i2], dataValueArray[i2]);
                statusCodeArray[i2] = StatusCode.GOOD;
                continue;
            }
            catch (StatusException statusException) {
                logger.debug("StatusException: ", (Throwable)statusException);
                statusCodeArray[i2] = statusException.getStatusCode();
            }
        }
        return statusCodeArray;
    }

    public synchronized void readComponents(UaNode uaNode) throws ServiceException {
        this.readReferences(uaNode, Identifiers.HasComponent, BrowseDirection.Forward, false);
    }

    public synchronized void readNode(UaNode uaNode) throws ServiceException {
        logger.debug("readNode: node={}", (Object)uaNode);
        Object[] objectArray = uaNode.getSupportedAttributes();
        if (logger.isDebugEnabled()) {
            logger.debug("readNode: attributes=" + Arrays.toString(objectArray));
        }
        this.readAttributes(uaNode, (UnsignedInteger[])objectArray);
    }

    public synchronized void readProperties(UaNode object) throws ServiceException {
        UaProperty[] uaPropertyArray = object.getProperties();
        if (logger.isDebugEnabled()) {
            logger.debug("readProperties: node=" + object.getBrowseName() + (uaPropertyArray == null ? " properties=null " : " properties.length " + uaPropertyArray.length));
        }
        if (uaPropertyArray != null && uaPropertyArray.length > 0) {
            int n2;
            object = new NodeId[uaPropertyArray.length];
            int n3 = 0;
            UaProperty[] uaPropertyArray2 = uaPropertyArray;
            int n4 = uaPropertyArray.length;
            for (n2 = 0; n2 < n4; ++n2) {
                UaProperty uaProperty = uaPropertyArray2[n2];
                object[n3++] = uaProperty.getNodeId();
            }
            uaPropertyArray2 = this.fm.readValues((NodeId[])object, TimestampsToReturn.Both);
            n3 = 0;
            UaProperty[] uaPropertyArray3 = uaPropertyArray;
            n2 = uaPropertyArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                object = uaPropertyArray3[i2];
                try {
                    logger.trace("readProperties: property={} value={}", (Object)object.getBrowseName(), (Object)uaPropertyArray2[n3]);
                    object.setValue((DataValue)uaPropertyArray2[n3++]);
                    continue;
                }
                catch (Exception exception) {
                    logger.warn("Failed to set value of property " + object, (Throwable)exception);
                }
            }
        }
    }

    public synchronized void readReferences(UaNode uaNode, NodeId object, BrowseDirection object2, boolean bl) throws ServiceException {
        logger.debug("readReferences: node={}", (Object)uaNode.getBrowseName());
        try {
            Object object3;
            object = this.browse(uaNode.getNodeId(), (BrowseDirection)object2, (NodeId)object, bl, new NodeClass[0]);
            if (logger.isDebugEnabled()) {
                logger.debug("readReferences: references.size()={}", (Object)object.size());
                object2 = object.iterator();
                while (object2.hasNext()) {
                    ReferenceDescription referenceDescription = (ReferenceDescription)object2.next();
                    logger.debug("readReferences: (node={}) r={}", (Object)uaNode.getBrowseName(), (Object)referenceDescription.getBrowseName());
                }
            }
            object2 = new ArrayList<UaReference>();
            ((ArrayList)object2).addAll(Arrays.asList(uaNode.getReferences()));
            if (logger.isDebugEnabled()) {
                logger.debug("readReferences: (node=" + uaNode.getBrowseName() + ") oldReferences.size()=" + ((ArrayList)object2).size());
                logger.debug("readReferences: (node=" + uaNode.getBrowseName() + ") oldReferences=" + object2);
            }
            ArrayList<ReferenceDescription> arrayList = new ArrayList<ReferenceDescription>();
            object = object.iterator();
            while (object.hasNext()) {
                object3 = (ReferenceDescription)object.next();
                try {
                    logger.debug("readReferences: (node={}) refDescription={}", (Object)uaNode.getBrowseName(), object3);
                    NodeId nodeId = this.getNamespaceTable().toNodeId(object3.getNodeId());
                    object3 = uaNode.addReference(nodeId, object3.getReferenceTypeId(), object3.getIsForward() == false);
                    arrayList.add((ReferenceDescription)object3);
                    ((ArrayList)object2).remove(object3);
                }
                catch (ServiceResultException serviceResultException) {
                    logger.warn("readReferences", (Throwable)serviceResultException);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("readReferences: (node=" + uaNode.getBrowseName() + ") newReferences.size()=" + arrayList.size());
                logger.debug("readReferences: (node=" + uaNode.getBrowseName() + ") newReferences=" + arrayList);
                logger.debug("readReferences: (node=" + uaNode.getBrowseName() + ") remaining oldReferences.size()=" + ((ArrayList)object2).size());
                logger.debug("readReferences: (node=" + uaNode.getBrowseName() + ") remaining oldReferences=" + object2);
            }
            object = ((ArrayList)object2).iterator();
            while (object.hasNext()) {
                object3 = (UaReference)object.next();
                uaNode.deleteReference((UaReference)object3);
            }
            return;
        }
        catch (StatusException statusException) {
            object = statusException;
            if (statusException.getStatusCode().getValue().equals((Object)StatusCodes.Bad_NodeIdUnknown)) {
                logger.warn("readReferences, unknown node: " + uaNode.getNodeId(), (Throwable)object);
                return;
            }
            logger.error("readReferences", (Throwable)object);
            return;
        }
    }

    public NodeId[] registerNodes(NodeId ... nodeIdArray) throws ServiceException {
        NodeId[] nodeIdArray2;
        AddressSpace addressSpace;
        try {
            AddressSpace addressSpace2 = this;
            addressSpace = addressSpace2;
            addressSpace = this;
            nodeIdArray2 = addressSpace2.fm.D().RegisterNodes(addressSpace.fm.getRequestHeader(), nodeIdArray);
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        this.checkServiceResult((ServiceResponse)nodeIdArray2, null);
        nodeIdArray2 = nodeIdArray2.getRegisteredNodeIds();
        Object[] objectArray = nodeIdArray;
        nodeIdArray = nodeIdArray2;
        addressSpace = this;
        UaClient.a(nodeIdArray, objectArray);
        if (this.fs == null) {
            this.fs = new ArrayList<NodeId>();
        }
        nodeIdArray = nodeIdArray2;
        int n2 = nodeIdArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            NodeId nodeId = nodeIdArray[i2];
            if (this.fs.contains(nodeId)) continue;
            this.fs.add(nodeId);
        }
        return nodeIdArray2;
    }

    public void setBrowseDirection(BrowseDirection browseDirection) {
        this.fk = browseDirection;
    }

    public void setIncludeSubTypes(Boolean bl) {
        this.fo = bl;
    }

    public void setMaxDataSetsPerQuery(int n2) {
        this.fp = UnsignedInteger.valueOf((long)n2);
    }

    public void setMaxReferencesPerNode(int n2) {
        this.fq = UnsignedInteger.valueOf((long)n2);
    }

    public void setNodeClassSet(EnumSet<NodeClass> enumSet) {
        this.fr = enumSet;
    }

    public void setReferenceTypeId(NodeId nodeId) {
        this.bu = nodeId;
    }

    public void setResultMaskSet(EnumSet<BrowseResultMask> enumSet) {
        this.ft = enumSet;
    }

    public void setView(ViewDescription viewDescription) {
        this.fu = viewDescription;
    }

    public BrowsePathResult[] translateBrowsePathsToNodeIds(BrowsePath ... browsePathArray) throws ServiceException {
        TranslateBrowsePathsToNodeIdsResponse translateBrowsePathsToNodeIdsResponse;
        AddressSpace addressSpace;
        try {
            AddressSpace addressSpace2 = this;
            addressSpace = addressSpace2;
            addressSpace = this;
            translateBrowsePathsToNodeIdsResponse = addressSpace2.fm.D().TranslateBrowsePathsToNodeIds(addressSpace.fm.getRequestHeader(), browsePathArray);
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        this.checkServiceResult((ServiceResponse)translateBrowsePathsToNodeIdsResponse, translateBrowsePathsToNodeIdsResponse.getDiagnosticInfos());
        Object[] objectArray = browsePathArray;
        browsePathArray = translateBrowsePathsToNodeIdsResponse.getResults();
        addressSpace = this;
        UaClient.a(browsePathArray, objectArray);
        return translateBrowsePathsToNodeIdsResponse.getResults();
    }

    public BrowsePathResult[] translateBrowsePathsToNodeIds(NodeId nodeId, RelativePath ... relativePathArray) throws ServiceException {
        BrowsePath[] browsePathArray = new BrowsePath[relativePathArray.length];
        for (int i2 = 0; i2 < relativePathArray.length; ++i2) {
            browsePathArray[i2] = new BrowsePath(nodeId, relativePathArray[i2]);
        }
        return this.translateBrowsePathsToNodeIds(browsePathArray);
    }

    public BrowsePathTarget[] translateBrowsePathToNodeId(NodeId nodeId, RelativePathElement ... relativePath) throws ServiceException, StatusException {
        relativePath = new RelativePath((RelativePathElement[])relativePath);
        nodeId = new BrowsePath(nodeId, relativePath);
        nodeId = this.translateBrowsePathsToNodeIds(new BrowsePath[]{nodeId})[0];
        this.checkOperationResult(nodeId.getStatusCode());
        return nodeId.getTargets();
    }

    public NodeId[] unregisterAllNodes() throws ServiceException {
        NodeId[] nodeIdArray = new NodeId[]{};
        if (this.fs != null) {
            nodeIdArray = this.fs.toArray(nodeIdArray);
            this.unregisterNodes(nodeIdArray);
        }
        return nodeIdArray;
    }

    public void unregisterNodes(NodeId ... nodeIdArray) throws ServiceException {
        NodeId[] nodeIdArray2;
        try {
            nodeIdArray2 = this;
            nodeIdArray2 = this;
            nodeIdArray2 = this.fm.D().UnregisterNodes(this.fm.getRequestHeader(), nodeIdArray);
            this.checkServiceResult((ServiceResponse)nodeIdArray2, null);
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        nodeIdArray2 = nodeIdArray;
        int n2 = nodeIdArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            NodeId nodeId = nodeIdArray2[i2];
            this.fs.remove(nodeId);
        }
    }

    private NodeId toNodeId(ExpandedNodeId expandedNodeId) throws StatusException {
        try {
            expandedNodeId = this.getNamespaceTable().toNodeId(expandedNodeId);
        }
        catch (ServiceResultException serviceResultException) {
            throw new StatusException(serviceResultException);
        }
        return expandedNodeId;
    }

    protected List<ReferenceDescription> browse(NodeId object, BrowseDescription browseDescription) throws ServerConnectionException, ServiceException, StatusException {
        if (object == null) {
            throw new NullPointerException("nodeId");
        }
        object = new ArrayList();
        browseDescription = this.browse(null, this.getMaxReferencesPerNode().intValue(), browseDescription)[0];
        while (true) {
            Object[] objectArray;
            this.checkOperationResult(browseDescription.getStatusCode());
            if (browseDescription.getReferences() != null) {
                ReferenceDescription[] referenceDescriptionArray = browseDescription.getReferences();
                objectArray = referenceDescriptionArray;
                int n2 = referenceDescriptionArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    byte by = objectArray[i2];
                    object.add(by);
                }
            }
            objectArray = browseDescription.getContinuationPoint();
            logger.debug("browse: c={}", (Object)Arrays.toString(objectArray));
            if (objectArray == null || objectArray.length == 0) break;
            browseDescription = this.browseNext(false, new byte[][]{objectArray})[0];
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    protected QueryDataSet[] query(ViewDescription viewDescription, NodeTypeDescription[] object, ContentFilter objectArray, UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2) throws ServiceFaultException, ServerConnectionException, ServiceResultException {
        void var5_16;
        void var4_11;
        AddressSpace addressSpace2 = this;
        addressSpace2 = this;
        viewDescription = addressSpace.fm.D().QueryFirst(addressSpace2.fm.getRequestHeader(), viewDescription, (NodeTypeDescription[])object, (ContentFilter)objectArray, (UnsignedInteger)var4_11, (UnsignedInteger)var5_16);
        object = new ArrayList();
        for (QueryDataSet queryDataSet : viewDescription.getQueryDataSets()) {
            object.add(queryDataSet);
        }
        byte[] byArray = viewDescription.getContinuationPoint();
        if (byArray != null) {
            QueryNextResponse queryNextResponse;
            byte[] byArray2;
            do {
                void var3_9;
                void var3_7;
                AddressSpace addressSpace3 = this;
                QueryNextRequest queryNextRequest = new QueryNextRequest(addressSpace3.fm.getRequestHeader(), Boolean.FALSE, (byte[])var3_7);
                AddressSpace addressSpace4 = this;
                queryNextResponse = addressSpace4.fm.D().QueryNext(queryNextRequest);
                QueryDataSet[] queryDataSetArray = queryNextResponse.getQueryDataSets();
                int n2 = queryDataSetArray.length;
                boolean bl = false;
                while (var3_9 < n2) {
                    QueryDataSet queryDataSet = queryDataSetArray[var3_9];
                    object.add(queryDataSet);
                    ++var3_9;
                }
            } while ((byArray2 = queryNextResponse.getRevisedContinuationPoint()) != null && byArray2.length != 0);
        }
        return object.toArray(new QueryDataSet[0]);
    }

    private void checkOperationResult(StatusCode statusCode) throws StatusException {
        this.fm.checkOperationResult(statusCode);
    }

    private void checkServiceResult(ServiceResponse serviceResponse, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        this.fm.checkServiceResult(serviceResponse, diagnosticInfoArray);
    }

    final void aC() {
        if (this.fl == null) {
            this.fl = new NodeCache(this.nodeFactory, 5000, 1000L);
            try {
                this.fl.initDataTypes();
            }
            catch (UaNodeFactoryException uaNodeFactoryException) {
                throw new RuntimeException("Failed to initialize the DataTypes", uaNodeFactoryException);
            }
            this.fn = new DataTypeConverter(this);
        }
    }

    final void aD() {
        this.fl = null;
    }
}

