/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.ApplicationIdentity;
import com.prosysopc.ua.SecureIdentity;
import com.prosysopc.ua.SecureIdentityException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.core.UserIdentityToken;
import org.opcfoundation.ua.core.UserTokenPolicy;
import org.opcfoundation.ua.core.UserTokenType;
import org.opcfoundation.ua.encoding.binary.BinaryEncoder;
import org.opcfoundation.ua.transport.security.Cert;
import org.opcfoundation.ua.transport.security.KeyPair;
import org.opcfoundation.ua.transport.security.PrivKey;
import org.opcfoundation.ua.transport.security.SecurityAlgorithm;
import org.opcfoundation.ua.transport.security.SecurityPolicy;
import org.opcfoundation.ua.utils.CryptoUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserIdentity
extends SecureIdentity {
    private static Logger logger = LoggerFactory.getLogger(UserIdentity.class);
    private static Map<String, UserTokenPolicy> hS = new HashMap<String, UserTokenPolicy>();
    private String password;
    protected byte[] encryptedPassword;
    protected byte[] issuedIdentityToken;
    protected String name;
    protected UserTokenType type;

    public static UserTokenPolicy getUserTokenPolicy(String string) {
        return hS.get(string);
    }

    public UserIdentity() {
        this.type = UserTokenType.Anonymous;
        this.name = null;
        this.password = null;
        this.issuedIdentityToken = null;
    }

    public UserIdentity(byte[] byArray) {
        this.name = null;
        this.password = null;
        this.issuedIdentityToken = byArray;
        this.type = UserTokenType.IssuedToken;
    }

    public UserIdentity(Cert cert, PrivKey privKey) {
        super(cert, privKey);
        this.name = null;
        this.password = null;
        this.issuedIdentityToken = null;
        this.type = UserTokenType.Certificate;
    }

    public UserIdentity(File file, File file2, String string) throws IOException, SecureIdentityException {
        super(file, file2, string);
        this.name = null;
        this.password = null;
        this.issuedIdentityToken = null;
        this.type = UserTokenType.Certificate;
    }

    public UserIdentity(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (string2 == null) {
            throw new NullPointerException("password");
        }
        this.name = string;
        this.password = string2;
        this.issuedIdentityToken = null;
        this.type = UserTokenType.UserName;
    }

    public UserIdentity(URL uRL, URL uRL2, String string) throws IOException, SecureIdentityException {
        super(uRL, uRL2, string);
        this.name = null;
        this.password = null;
        this.issuedIdentityToken = null;
        this.type = UserTokenType.Certificate;
    }

    @Override
    public boolean equals(Object object) {
        return this.equals(object, true);
    }

    public boolean equals(Object object, boolean bl) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (bl && this.getClass() != object.getClass()) {
            return false;
        }
        UserIdentity userIdentity = (UserIdentity)object;
        if (this.type == null) {
            return userIdentity.type == null;
        }
        if (!this.type.equals((Object)userIdentity.type)) {
            return false;
        }
        switch (this.type) {
            case Certificate: {
                if (super.equals(object)) break;
                return false;
            }
            case UserName: {
                if (this.name == null ? userIdentity.name != null : !this.name.equals(userIdentity.name)) {
                    return false;
                }
                if (!(this.password == null ? userIdentity.password != null : !this.password.equals(userIdentity.password))) break;
                return false;
            }
        }
        return true;
    }

    public byte[] getEncryptedPassword() {
        return this.encryptedPassword;
    }

    public byte[] getIssuedIdentityToken() {
        return this.issuedIdentityToken;
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public UserTokenType getType() {
        return this.type;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int hashCode() {
        int n2 = this.type.hashCode();
        switch (this.type) {
            case Certificate: {
                int n3 = n2 * 31;
                int n4 = super.hashCode();
                return n3 + n4;
            }
            case UserName: {
                n2 = n2 * 31 + (this.name == null ? 0 : this.name.hashCode());
                int n3 = n2 * 31;
                int n4 = this.password == null ? 0 : this.password.hashCode();
                return n3 + n4;
            }
        }
        return n2;
    }

    public String toString() {
        String string = String.format("Type=%s", this.type.toString());
        String string2 = null;
        switch (this.type) {
            case Certificate: {
                string2 = this.certificate.toString();
                break;
            }
            case UserName: {
                string2 = String.format("%s", this.name);
            }
        }
        if (string2 == null) {
            return string;
        }
        return string + " - " + string2;
    }

    protected void decryptPassword(UserIdentityToken object, ApplicationIdentity applicationIdentity, byte[] byArray, String objectArray) throws SecureIdentityException {
        byte[] byArray2;
        SecurityAlgorithm securityAlgorithm;
        UserTokenPolicy userTokenPolicy;
        if (logger.isDebugEnabled()) {
            logger.debug("decryptPassword: token={}", object);
            logger.debug("decryptPassword: encryptedPassword={}", (Object)CryptoUtil.toHex((byte[])this.encryptedPassword));
        }
        if ((userTokenPolicy = UserIdentity.getUserTokenPolicy(object.getPolicyId())) == null) {
            throw new SecureIdentityException("Unknown security policy defined: policyId=" + object.getPolicyId());
        }
        object = null;
        if (objectArray != null && !objectArray.isEmpty()) {
            securityAlgorithm = SecurityAlgorithm.valueOfUri((String)objectArray);
            if (securityAlgorithm == null) {
                throw new SecureIdentityException("Unknown encryption algorithm defined: algorithmUri=" + (String)objectArray);
            }
        } else {
            try {
                SecurityPolicy serviceResultException = SecurityPolicy.getSecurityPolicy((String)userTokenPolicy.getSecurityPolicyUri());
                securityAlgorithm = serviceResultException.getAsymmetricEncryptionAlgorithm();
            }
            catch (ServiceResultException serviceResultException) {
                throw new SecureIdentityException("Unknown security policy defined: policyUri=" + userTokenPolicy.getSecurityPolicyUri(), serviceResultException);
            }
        }
        for (KeyPair keyPair : applicationIdentity.getCertificates()) {
            try {
                object = applicationIdentity.decrypt(securityAlgorithm, this.encryptedPassword, keyPair.getPrivateKey());
                logger.debug("Successfully decrypted with key size {}", (Object)keyPair.getPrivateKey().getPrivateKey().getModulus().bitLength());
                break;
            }
            catch (Exception exception) {
                logger.debug("Failed to decrypt with key size {}", (Object)keyPair.getPrivateKey().getPrivateKey().getModulus().bitLength(), (Object)exception);
            }
        }
        if (object == null) {
            throw new SecureIdentityException("Failed to decrypt user password");
        }
        try {
            byArray2 = Arrays.copyOfRange((byte[])object, ((Object)object).length - byArray.length, ((Object)object).length);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SecureIdentityException("Password string does not include server nonce", arrayIndexOutOfBoundsException);
        }
        if (!Arrays.equals(byArray2, byArray)) {
            throw new SecureIdentityException("Invalid server nonce.", StatusCodes.Bad_IdentityTokenRejected);
        }
        this.password = new String(Arrays.copyOf((byte[])object, ((UserIdentityToken)object).length - byArray.length), BinaryEncoder.UTF8);
    }

    static {
        for (Field field : UserTokenPolicy.class.getDeclaredFields()) {
            if (!field.getType().equals(UserTokenPolicy.class)) continue;
            try {
                field = (UserTokenPolicy)field.get(null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            hS.put(field.getPolicyId(), (UserTokenPolicy)field);
        }
    }
}

