/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.AnnotationException;
import com.prosysopc.ua.ApplicationIdentity;
import com.prosysopc.ua.CodegenModel;
import com.prosysopc.ua.RegisteredClasses;
import com.prosysopc.ua.RegisteredClassesImpl;
import com.prosysopc.ua.UaAddressSpace;
import com.prosysopc.ua.UaCertificateValidator;
import com.prosysopc.ua.nodes.UaInstance;
import java.util.Collection;
import java.util.Map;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.common.NamespaceTable;
import org.opcfoundation.ua.encoding.EncoderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UaApplication {
    private static Logger logger = LoggerFactory.getLogger(UaApplication.class);
    private UaCertificateValidator hm;
    private final RegisteredClasses eS = new RegisteredClassesImpl();

    public static String formatUri(Protocol protocol, String string, int n2, String string2) {
        if (string2 == null) {
            string2 = "";
        } else if (!string2.isEmpty() && string2.charAt(0) != '/') {
            string2 = "/" + string2;
        }
        return String.format("%s://%s:%d%s", new Object[]{protocol, string, n2, string2});
    }

    public static String getSdkVersion() {
        return "2.2.2-638";
    }

    @Deprecated
    public static String getVersion() {
        return "v" + UaApplication.getSdkVersion();
    }

    public abstract UaAddressSpace getAddressSpace();

    public UaCertificateValidator getCertificateValidator() {
        return this.hm;
    }

    public abstract EncoderContext getEncoderContext();

    public NamespaceTable getNamespaceTable() {
        return this.getEncoderContext().getNamespaceTable();
    }

    public RegisteredClasses getRegisteredClasses() {
        return this.eS;
    }

    public void registerClass(Class<? extends UaInstance> clazz) throws AnnotationException {
        this.eS.registerClass(clazz);
    }

    public void registerClass(Class<? extends UaInstance> clazz, ExpandedNodeId expandedNodeId) {
        this.eS.registerClass(clazz, expandedNodeId);
    }

    public void registerClass(Class<? extends UaInstance> clazz, NodeId nodeId) {
        this.registerClass(clazz, this.getNamespaceTable().toExpandedNodeId(nodeId));
    }

    public void registerClasses(Collection<Class<? extends UaInstance>> collection) {
        this.eS.registerClasses(collection);
    }

    public void registerModel(CodegenModel codegenModel) {
        codegenModel.register(this);
    }

    public void setCertificateValidator(UaCertificateValidator uaCertificateValidator) {
        this.hm = uaCertificateValidator;
    }

    protected StatusCode validateApplicationCertificate(ApplicationIdentity applicationIdentity) {
        if (this.hm != null) {
            return this.hm.validateCertificate(applicationIdentity);
        }
        return StatusCode.GOOD;
    }

    static {
        logger.info("Prosys OPC UA Java SDK v{}", (Object)"2.2.2-638");
        logger.info("(c) Prosys PMS Ltd. <http://www.prosysopc.com>");
        if (logger.isDebugEnabled()) {
            for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                logger.debug("{}={}", entry.getKey(), entry.getValue());
            }
        }
    }

    public static enum Protocol {
        Http,
        Https,
        OpcTcp;


        public static Protocol parseProtocol(String string) {
            String string2 = string.toLowerCase();
            if (string2.equals("http")) {
                return Http;
            }
            if (string2.equals("opc.tcp")) {
                return OpcTcp;
            }
            if (string2.equals("https")) {
                return Https;
            }
            return Protocol.valueOf(string);
        }

        public final String getTransportProfileUri() {
            if (this.equals((Object)Http)) {
                return "http://opcfoundation.org/UA-Profile/Transport/https-uabinary";
            }
            if (this.equals((Object)Https)) {
                return "http://opcfoundation.org/UA-Profile/Transport/https-uabinary";
            }
            return "http://opcfoundation.org/UA-Profile/Transport/uatcp-uasc-uabinary";
        }

        public final String toString() {
            if (this.equals((Object)Http)) {
                return "http";
            }
            if (this.equals((Object)Https)) {
                return "https";
            }
            return "opc.tcp";
        }
    }

    public static enum DiagnosticMask {
        AdditionalInfo(4),
        InnerDiagnostics(16),
        InnerStatusCode(8),
        LocalizedText(2),
        SymbolicId(1);

        private int value;

        private DiagnosticMask(int n3) {
            this.value = n3;
        }

        public final int getValue() {
            return this.value;
        }
    }
}

