/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.UaApplication;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaAddress {
    private static UaApplication.Protocol aq = UaApplication.Protocol.OpcTcp;
    private static final String jh = String.format("^(%s)(\\.(%1$s))*$", "\\p{Alnum}(?>[\\p{Alnum}-_]{0,62})?");
    private static final Logger logger = LoggerFactory.getLogger(UaAddress.class);
    private final String address;
    private final String host;
    private final int port;
    private final UaApplication.Protocol ji;
    private final String serverName;

    public static UaApplication.Protocol getDefaultProtocol() {
        return aq;
    }

    public static void setDefaultProtocol(UaApplication.Protocol protocol) {
        aq = protocol;
    }

    public static void validate(String string) throws URISyntaxException {
        new UaAddress(string);
    }

    public UaAddress(UaApplication.Protocol protocol, String string, int n2) throws URISyntaxException {
        this(protocol, string, n2, "");
    }

    public UaAddress(UaApplication.Protocol protocol, String string, int n2, String string2) throws URISyntaxException {
        this(UaApplication.formatUri(protocol, string, n2, string2));
    }

    public UaAddress(String string) throws URISyntaxException {
        if (string == null) {
            throw new URISyntaxException("(null)", "UaAddress requires a valid URI");
        }
        string = string.trim();
        try {
            int n2;
            String string2;
            int n3 = -1;
            int n4 = string.indexOf("://");
            if (n4 >= 0) {
                this.ji = UaApplication.Protocol.parseProtocol(string.substring(0, n4));
                if (this.ji == UaApplication.Protocol.Http) {
                    logger.warn("The current Java stack does not support the HTTP (SOAP) protocol!");
                    throw new IllegalArgumentException("'http'-protocol is not supported");
                }
                string2 = string.substring(n4 + 3);
            } else {
                this.ji = aq;
                string2 = string;
            }
            String[] stringArray = string2.split("/");
            String string3 = stringArray[0];
            String string4 = "";
            if (string3.startsWith("[")) {
                n2 = string3.indexOf("]");
                if (n2 < 0) {
                    throw new IllegalArgumentException("Invalid hostname :");
                }
                string2 = string3.substring(0, n2 + 1);
                if (string3.length() > n2 + 1 && string3.charAt(n2 + 1) == ':') {
                    string4 = string3.substring(n2 + 2);
                }
            } else {
                String[] stringArray2 = string3.split(":");
                if (stringArray2.length > 2) {
                    throw new IllegalArgumentException("Invalid hostname: " + string3);
                }
                string2 = stringArray2[0];
                if (stringArray2.length > 1) {
                    string4 = stringArray2[1];
                }
                if (!string2.matches("^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$") && !string2.matches(jh)) {
                    throw new IllegalArgumentException("Invalid hostname: " + string2);
                }
            }
            if (!string4.isEmpty()) {
                try {
                    n3 = Integer.parseInt(string4);
                    if (n3 <= 0 || n3 > 65535) {
                        throw new IllegalArgumentException("Invalid port - not in valid range (1-65535): " + string4);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Invalid port: " + string4);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new IllegalArgumentException("Invalid port: " + string4);
                }
            }
            if (stringArray.length > 1) {
                string3 = stringArray[1];
                for (n2 = 2; n2 < stringArray.length; ++n2) {
                    string3 = string3 + "/" + stringArray[n2];
                }
            } else {
                string3 = "";
            }
            if (n3 <= 0) {
                n3 = this.ji == UaApplication.Protocol.OpcTcp ? 4840 : 4843;
            }
            this.host = string2;
            this.port = n3;
            this.serverName = string3;
            this.address = UaApplication.formatUri(this.ji, this.host, this.port, this.serverName);
            return;
        }
        catch (Exception exception) {
            logger.debug("Could not parse uri: {}", (Object)string, (Object)exception);
            throw new URISyntaxException(string, "Could not parse URI:" + exception.getMessage());
        }
    }

    public UaAddress(URI uRI) throws Exception {
        this(uRI.toString());
    }

    public UaAddress(URL uRL) throws Exception {
        this(uRL.toString());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (UaAddress)object;
        return !(this.address == null ? ((UaAddress)object).address != null : !this.address.equals(((UaAddress)object).address));
    }

    public boolean equalsAddress(String string) {
        return this.address.equals(string);
    }

    public String getAddress() {
        return this.address;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public UaApplication.Protocol getProtocol() {
        return this.ji;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int hashCode() {
        int n2 = 31 + (this.address == null ? 0 : this.address.hashCode());
        return n2;
    }

    public String toString() {
        return this.address;
    }
}

