/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.common.ServiceFaultException;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.ServiceFault;
import org.opcfoundation.ua.core.StatusCodes;

public class StatusException
extends Exception {
    private final DiagnosticInfo ds;
    private final StatusCode statusCode;

    public static DiagnosticInfo toDiagnosticInfo(ServiceFault serviceFault) {
        if (serviceFault == null) {
            return null;
        }
        return serviceFault.getResponseHeader().getServiceDiagnostics();
    }

    public StatusException(ServiceFaultException serviceFaultException) {
        this(serviceFaultException.getMessage(), serviceFaultException);
    }

    public StatusException(ServiceResultException serviceResultException) {
        this(serviceResultException.getMessage(), serviceResultException);
    }

    public StatusException(StatusCode statusCode) {
        super(statusCode.toString());
        this.statusCode = statusCode;
        this.ds = null;
    }

    public StatusException(StatusCode statusCode, DiagnosticInfo diagnosticInfo) {
        this(statusCode.toString(), statusCode, diagnosticInfo, null);
    }

    public StatusException(StatusCode statusCode, Throwable throwable) {
        super(statusCode.toString(), throwable);
        this.statusCode = statusCode;
        this.ds = StatusException.toDiagnosticInfo(ServiceFault.toServiceFault((Throwable)throwable));
    }

    public StatusException(String string) {
        this(string, StatusCodes.Bad_UnexpectedError);
    }

    public StatusException(String string, ServiceFaultException serviceFaultException) {
        this(string, serviceFaultException.getStatusCode(), StatusException.toDiagnosticInfo(serviceFaultException.getServiceFault()), (Throwable)serviceFaultException);
    }

    public StatusException(String string, ServiceResultException serviceResultException) {
        this(string, serviceResultException.getStatusCode(), null, (Throwable)serviceResultException);
    }

    public StatusException(String string, StatusCode statusCode) {
        super(string);
        this.statusCode = statusCode;
        this.ds = new DiagnosticInfo(string, null, null, null, null, null, null);
    }

    public StatusException(String string, StatusCode statusCode, DiagnosticInfo diagnosticInfo, Throwable throwable) {
        super(string, throwable);
        this.statusCode = statusCode;
        this.ds = diagnosticInfo;
    }

    public StatusException(String string, UnsignedInteger unsignedInteger) {
        this(string, new StatusCode(unsignedInteger));
    }

    public StatusException(String string, UnsignedInteger unsignedInteger, DiagnosticInfo diagnosticInfo, Throwable throwable) {
        this(string, new StatusCode(unsignedInteger), diagnosticInfo, throwable);
    }

    public StatusException(UnsignedInteger unsignedInteger) {
        this(new StatusCode(unsignedInteger));
    }

    public StatusException(UnsignedInteger unsignedInteger, DiagnosticInfo diagnosticInfo) {
        this(unsignedInteger.toString(), unsignedInteger, diagnosticInfo, null);
    }

    public StatusException(UnsignedInteger unsignedInteger, Throwable throwable) {
        this(new StatusCode(unsignedInteger), throwable);
    }

    public DiagnosticInfo getDiagnosticInfo() {
        return this.ds;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String toString() {
        String string = this.ds == null ? "" : this.ds.toString();
        if (string.length() > 0) {
            string = " Diagnostics=" + string;
        }
        return String.format("%s StatusCode=%s%s", super.toString(), this.statusCode, string);
    }
}

