/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.SecureIdentityException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.transport.security.Cert;
import org.opcfoundation.ua.transport.security.KeyPair;
import org.opcfoundation.ua.transport.security.PrivKey;
import org.opcfoundation.ua.transport.security.SecurityAlgorithm;
import org.opcfoundation.ua.transport.security.SecurityPolicy;
import org.opcfoundation.ua.utils.CryptoUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureIdentity {
    private static Logger logger = LoggerFactory.getLogger(SecureIdentity.class);
    protected Cert certificate;
    protected final PrivKey privateKey;

    private static byte[] a(byte[] byArray, byte[] byArray2, RSAPrivateKey rSAPrivateKey, SecurityAlgorithm securityAlgorithm) throws SecureIdentityException {
        Cipher cipher;
        if (logger.isDebugEnabled()) {
            logger.debug("rsa_Decrypt: {}", (Object)CryptoUtil.toHex((byte[])byArray));
        }
        if (securityAlgorithm == null) {
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            return byArray2;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("rsa_Decrypt: algorithm={} transformation={}", (Object)securityAlgorithm, (Object)securityAlgorithm.getTransformation());
        }
        try {
            cipher = CryptoUtil.getAsymmetricCipher((SecurityAlgorithm)securityAlgorithm);
        }
        catch (ServiceResultException serviceResultException) {
            logger.info("rsa_Decrypt: Failed to get asymmetric cipher for algorithm {}", (Object)securityAlgorithm);
            throw new SecureIdentityException("Error in asymmetric decrypt: failed to get asymmtric cipher for algorithm" + securityAlgorithm, serviceResultException);
        }
        int n2 = rSAPrivateKey.getModulus().bitLength() / 8;
        logger.debug("rsa_Decrypt: {}", (Object)n2);
        if (byArray.length % n2 != 0) {
            logger.info("rsa_Decrypt: Wrong blockSize!!!");
            throw new SecureIdentityException("Error in asymmetric decrypt: Input data is not an even number of encryption blocks.");
        }
        try {
            cipher.init(2, rSAPrivateKey);
            cipher.getOutputSize(byArray.length);
            cipher.getBlockSize();
            int n3 = 0;
            int n4 = 0 + byArray.length;
            int n5 = 0;
            for (int i2 = 0; i2 < n4; i2 += n2) {
                int n6 = cipher.doFinal(byArray, n5, n2, byArray2, n3);
                n5 += n2;
                n3 += n6;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("rsa_Decrypt: output={}", (Object)CryptoUtil.toHex((byte[])byArray2));
            }
            return byArray2;
        }
        catch (GeneralSecurityException generalSecurityException) {
            logger.info("rsa_Decrypt: Error in asymmetric decrypt: ", (Throwable)generalSecurityException);
            throw new SecureIdentityException("Error in asymmetric decrypt", generalSecurityException);
        }
    }

    public SecureIdentity(Cert cert, PrivKey privKey) {
        this.certificate = cert;
        this.privateKey = privKey;
    }

    public SecureIdentity(File file, File file2, String string) throws IOException, SecureIdentityException {
        try {
            this.certificate = Cert.load((File)file);
        }
        catch (CertificateException certificateException) {
            throw new SecureIdentityException("Cannot load certificate from " + file, certificateException);
        }
        this.privateKey = SecureIdentity.a(file2, string);
    }

    public SecureIdentity(File object, String string, String string2, String object2, String string3) throws IOException, SecureIdentityException {
        FileInputStream fileInputStream = new FileInputStream((File)object);
        try {
            try {
                object = KeyStore.getInstance(string3);
                ((KeyStore)object).load(fileInputStream, ((String)object2).toCharArray());
                if (!((KeyStore)object).containsAlias(string)) {
                    string = null;
                }
                if (string == null) {
                    object2 = ((KeyStore)object).aliases();
                    while (object2.hasMoreElements()) {
                        string = (String)object2.nextElement();
                    }
                    if (string == null) {
                        throw new KeyStoreException("Empty Key Store.");
                    }
                }
                this.certificate = new Cert((X509Certificate)((KeyStore)object).getCertificate(string));
                this.privateKey = string2 != null ? new PrivKey((RSAPrivateKey)((KeyStore)object).getKey(string, string2.toCharArray())) : new PrivKey((RSAPrivateKey)((KeyStore)object).getKey(string, null));
            }
            catch (KeyStoreException keyStoreException) {
                throw new SecureIdentityException("Cannot load key from PKCS12 KeyStore: " + keyStoreException.getMessage(), keyStoreException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SecureIdentityException("Cannot load key from PKCS12 KeyStore: " + noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
            }
            catch (CertificateException certificateException) {
                throw new SecureIdentityException("Cannot load key from PKCS12 KeyStore: " + certificateException.getMessage(), certificateException);
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                throw new SecureIdentityException("Cannot load key from PKCS12 KeyStore: " + unrecoverableKeyException.getMessage(), unrecoverableKeyException);
            }
            return;
        }
        finally {
            fileInputStream.close();
        }
    }

    public SecureIdentity(URL uRL, URL uRL2, String string) throws IOException, SecureIdentityException {
        try {
            this.certificate = Cert.load((URL)uRL);
        }
        catch (CertificateException certificateException) {
            throw new SecureIdentityException("Cannot load certificate from " + uRL, certificateException);
        }
        try {
            this.privateKey = PrivKey.loadFromKeyStore((URL)uRL2, (String)string);
            return;
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            throw new SecureIdentityException("Cannot load private key from " + uRL2, unrecoverableKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecureIdentityException("Cannot load private key from " + uRL2, noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            throw new SecureIdentityException("Cannot load private key from " + uRL2, certificateException);
        }
        catch (KeyStoreException keyStoreException) {
            throw new SecureIdentityException("Cannot load private key from " + uRL2, keyStoreException);
        }
    }

    protected SecureIdentity() {
        this.certificate = null;
        this.privateKey = null;
    }

    public byte[] decrypt(SecurityPolicy securityPolicy, byte[] byArray) throws SecureIdentityException {
        return this.decrypt(securityPolicy.getAsymmetricEncryptionAlgorithm(), byArray, this.privateKey);
    }

    public byte[] encrypt(SecurityPolicy object, byte[] byArray) throws SecureIdentityException {
        int n2;
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        object = object.getAsymmetricEncryptionAlgorithm();
        logger.debug("encrypt: algorithm={}", object);
        try {
            n2 = CryptoUtil.getPlainTextBlockSize((SecurityAlgorithm)object, (Key)this.certificate.getCertificate().getPublicKey());
        }
        catch (ServiceResultException serviceResultException) {
            throw new SecureIdentityException("Error in asymmetric encrypt: failed to get plain text block size", serviceResultException);
        }
        int n3 = (byArray.length + 4) / n2 + 1;
        int n4 = byArray.length / n2 + 1;
        n4 *= n2;
        byte[] byArray2 = new byte[n3 *= n2];
        Object object2 = byArray2;
        byArray2[0] = (byte)(0xFF & byArray.length);
        object2[1] = (byte)((0xFF00 & byArray.length) >> 8);
        object2[2] = (byte)((0xFF0000 & byArray.length) >> 16);
        object2[3] = (0xFF000000 & byArray.length) >> 24;
        System.arraycopy(byArray, 0, object2, 4, byArray.length);
        byArray = new byte[n4];
        byte[] byArray3 = object2;
        int n5 = 0;
        byte[] byArray4 = byArray;
        n4 = n2;
        object2 = object;
        Serializable serializable = this.certificate.getCertificate();
        object = byArray3;
        if (object2 == null) {
            System.arraycopy(object, 0, byArray4, 0, ((SecurityPolicy)object).length);
        } else {
            serializable = (RSAPublicKey)serializable.getPublicKey();
            try {
                if (((SecurityPolicy)object).length % n4 != 0) {
                    System.out.println("Wrong block size in asym encryption");
                    throw new SecureIdentityException("Error in asymmetric encrypt: Input data is not an even number of encryption blocks.");
                }
                object2 = Cipher.getInstance(object2.getTransformation());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                logger.debug("NoSuchAlgorithmException: ", (Throwable)noSuchAlgorithmException);
                throw new SecureIdentityException("Error in asymmetric encrypt: no such algorithm ", noSuchAlgorithmException);
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                logger.debug("NoSuchPaddingException: ", (Throwable)noSuchPaddingException);
                throw new SecureIdentityException("Error in asymmetric encrypt: failed to get asymmetric cipher", noSuchPaddingException);
            }
            try {
                ((Cipher)object2).init(1, (Key)serializable);
                int n6 = 0 + ((SecurityPolicy)object).length;
                int n7 = 0;
                for (int i2 = 0; i2 < n6; i2 += n4) {
                    int n8 = ((Cipher)object2).doFinal((byte[])object, n7, n4, byArray4, n5);
                    n7 += n4;
                    n5 += n8;
                }
            }
            catch (InvalidKeyException invalidKeyException) {
                logger.debug("InvalidKeyException: ", (Throwable)invalidKeyException);
                throw new SecureIdentityException("Error in asymmetric encrypt", invalidKeyException);
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                logger.debug("IllegalBlockSizeException: ", (Throwable)illegalBlockSizeException);
                throw new SecureIdentityException("Error in asymmetric encrypt", illegalBlockSizeException);
            }
            catch (BadPaddingException badPaddingException) {
                logger.debug("BadPaddingException: ", (Throwable)badPaddingException);
                throw new SecureIdentityException("Error in asymmetric encrypt", badPaddingException);
            }
            catch (ShortBufferException shortBufferException) {
                logger.debug("ShortBufferException: ", (Throwable)shortBufferException);
                throw new SecureIdentityException("Error in asymmetric encrypt", shortBufferException);
            }
        }
        return byArray;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof SecureIdentity)) {
            return false;
        }
        object = (SecureIdentity)object;
        return !(this.certificate == null ? ((SecureIdentity)object).certificate != null : !this.certificate.equals((Object)((SecureIdentity)object).certificate));
    }

    public Cert getCertificate() {
        return this.certificate;
    }

    public KeyPair getKeys() {
        if (this.certificate == null) {
            return null;
        }
        return new KeyPair(this.certificate, this.privateKey);
    }

    public PrivKey getPrivateKey() {
        return this.privateKey;
    }

    public int hashCode() {
        int n2 = 31 + (this.certificate == null ? 0 : this.certificate.hashCode());
        return n2;
    }

    private static PrivKey a(File file, String string) throws IOException, SecureIdentityException {
        try {
            try {
                return PrivKey.loadFromKeyStore((File)file, (String)string);
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
                if (iOException.getCause() instanceof UnrecoverableKeyException) {
                    throw new SecureIdentityException("Wrong password for key store " + file, iOException2);
                }
                try {
                    return PrivKey.load((File)file, (String)string);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new SecureIdentityException("Cannot load private key from " + file, generalSecurityException);
                }
            }
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            throw new SecureIdentityException("Cannot load private key from key store " + file, unrecoverableKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecureIdentityException("Cannot load private key from key store " + file, noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            throw new SecureIdentityException("Cannot load private key from key store " + file, certificateException);
        }
        catch (KeyStoreException keyStoreException) {
            throw new SecureIdentityException("Cannot load private key from key store " + file, keyStoreException);
        }
    }

    protected byte[] decrypt(SecurityAlgorithm securityAlgorithm, byte[] byArray, PrivKey object) throws SecureIdentityException {
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        int n2 = (object = object.getPrivateKey()) == null || object.getModulus().bitLength() <= 2048 ? 256 : 512;
        byte[] byArray2 = new byte[n2];
        SecureIdentity.a(byArray, byArray2, (RSAPrivateKey)object, securityAlgorithm);
        int n3 = 0 + byArray2[0];
        n3 += byArray2[1] << 8;
        n3 += byArray2[2] << 16;
        n3 += byArray2[3] << 24;
        if (logger.isDebugEnabled()) {
            logger.debug("decrypt: length={}", (Object)n3);
        }
        byArray = new byte[n3];
        System.arraycopy(byArray2, 4, byArray, 0, n3);
        return byArray;
    }
}

