/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.AnnotationException;
import com.prosysopc.ua.AnnotationUtils;
import com.prosysopc.ua.RegisteredClasses;
import com.prosysopc.ua.nodes.UaInstance;
import java.util.Collection;
import java.util.HashMap;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisteredClassesImpl
implements RegisteredClasses {
    private final HashMap<ExpandedNodeId, Class<? extends UaInstance>> dK = new HashMap();
    private final Logger logger = LoggerFactory.getLogger(RegisteredClassesImpl.class);

    @Override
    public boolean containsClass(ExpandedNodeId expandedNodeId) {
        return this.dK.containsKey(expandedNodeId);
    }

    @Override
    public Class<? extends UaInstance> getClass(ExpandedNodeId expandedNodeId) {
        return this.dK.get(expandedNodeId);
    }

    @Override
    public void registerClass(Class<? extends UaInstance> clazz) throws AnnotationException {
        this.registerClass(clazz, AnnotationUtils.readTypeDefinitionId(clazz));
    }

    @Override
    public void registerClass(Class<? extends UaInstance> clazz, ExpandedNodeId object) {
        if ((object = this.dK.put((ExpandedNodeId)object, clazz)) != null && object != clazz) {
            this.logger.warn("Class re-registered: {}", clazz);
        }
    }

    @Override
    public void registerClasses(Collection<Class<? extends UaInstance>> object) {
        object = object.iterator();
        while (object.hasNext()) {
            Class clazz = (Class)object.next();
            if (!UaInstance.class.isAssignableFrom(clazz)) continue;
            try {
                this.registerClass(clazz);
            }
            catch (AnnotationException annotationException) {
                this.logger.info("Cannot register class without TypeDefinitionId annotation");
            }
        }
    }
}

