/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.ApplicationIdentity;
import com.prosysopc.ua.CertificateValidationListener;
import com.prosysopc.ua.PkiFileBasedCertificateListener;
import com.prosysopc.ua.UaCertificateValidator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.core.ApplicationDescription;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.transport.security.Cert;
import org.opcfoundation.ua.utils.CertificateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PkiFileBasedCertificateValidator
implements UaCertificateValidator {
    private static final Logger logger = LoggerFactory.getLogger(PkiFileBasedCertificateValidator.class);
    private final File hE;
    private X509CRL hF;
    private final List<PkiFileBasedCertificateListener> listeners;
    private final File hG;
    private final File hH;
    private boolean hI = true;
    private final File hJ;
    private final CopyOnWriteArraySet<PublicKey> hK = new CopyOnWriteArraySet();
    private volatile CertificateValidationListener hL;
    private a hM = new b(this);
    private a hN = new b(this);
    private a hO = new b(this);

    public PkiFileBasedCertificateValidator() {
        this("PKI/CA", "certs", "rejected", "crl");
    }

    public PkiFileBasedCertificateValidator(String string) {
        this(string, "certs", "rejected", "crl");
    }

    public PkiFileBasedCertificateValidator(String string, String string2, String string3, String string4) {
        this.listeners = new ArrayList<PkiFileBasedCertificateListener>();
        this.hE = new File(string);
        this.hJ = new File(string, string2);
        this.hG = new File(string, string3);
        this.hH = new File(string, string4);
        this.init();
    }

    public void addListener(PkiFileBasedCertificateListener pkiFileBasedCertificateListener) {
        if (pkiFileBasedCertificateListener != null && !this.listeners.contains(pkiFileBasedCertificateListener)) {
            this.listeners.add(pkiFileBasedCertificateListener);
        }
    }

    public void addRejectedCertificate(Cert object) throws IOException {
        if (!this.a(this.hN, (Cert)object)) {
            this.a(this.hM, this.hG, (Cert)object);
        }
        this.b(this.hO, this.hJ, (Cert)object);
        logger.info("Certificate '{}' added to rejected certificates.", (Object)PkiFileBasedCertificateValidator.a((Cert)object));
        Cert cert = object;
        object = this;
        for (PkiFileBasedCertificateListener pkiFileBasedCertificateListener : ((PkiFileBasedCertificateValidator)object).listeners) {
            pkiFileBasedCertificateListener.onRejectedCertificateAdded(cert);
        }
    }

    public void addRevokedCertificate(Cert object) throws IOException {
        this.a(this.hN, this.hH, (Cert)object);
        this.b(this.hO, this.hJ, (Cert)object);
        this.b(this.hM, this.hG, (Cert)object);
        logger.info("Certificate '{}' added to revoked certificates.", (Object)PkiFileBasedCertificateValidator.a((Cert)object));
        Cert cert = object;
        object = this;
        for (PkiFileBasedCertificateListener pkiFileBasedCertificateListener : ((PkiFileBasedCertificateValidator)object).listeners) {
            pkiFileBasedCertificateListener.onRevokedCertificateAdded(cert);
        }
    }

    public void addTrustedCertificate(Cert object) throws IOException {
        logger.debug("addTrustedCertificate");
        this.a(this.hO, this.hJ, (Cert)object);
        this.b(this.hM, this.hG, (Cert)object);
        logger.info("Certificate '{}' added to trusted certificates.", (Object)PkiFileBasedCertificateValidator.a((Cert)object));
        Cert cert = object;
        object = this;
        for (PkiFileBasedCertificateListener pkiFileBasedCertificateListener : ((PkiFileBasedCertificateValidator)object).listeners) {
            pkiFileBasedCertificateListener.onTrustedCertificateAdded(cert);
        }
    }

    public void clear(boolean bl) {
        if (bl) {
            for (File file : this.hJ.listFiles()) {
                file.delete();
            }
            for (File file : this.hG.listFiles()) {
                file.delete();
            }
            for (File file : this.hH.listFiles()) {
                file.delete();
            }
        }
        this.hO.clear();
        this.hM.clear();
        this.hN.clear();
    }

    public File getBaseDir() {
        return this.hE;
    }

    public X509CRL getCrl() {
        return this.hF;
    }

    public File getFileForCert(Cert cert) {
        if (cert == null) {
            return null;
        }
        if (this.hO.containsKey(PkiFileBasedCertificateValidator.a(cert))) {
            return this.a(this.hJ, cert);
        }
        if (this.hM.containsKey(PkiFileBasedCertificateValidator.a(cert))) {
            return this.a(this.hG, cert);
        }
        if (this.hN.containsKey(PkiFileBasedCertificateValidator.a(cert))) {
            return this.a(this.hH, cert);
        }
        return null;
    }

    public Cert[] getRejectedCertificates() {
        return this.hM.values().toArray(new Cert[0]);
    }

    public File getRejectedDir() {
        return this.hG;
    }

    public File getRevocationDir() {
        return this.hH;
    }

    public Cert[] getRevokedCertificates() {
        return this.hN.values().toArray(new Cert[0]);
    }

    public Cert[] getTrustedCertificates() {
        return this.hO.values().toArray(new Cert[0]);
    }

    public File getTrustedDir() {
        return this.hJ;
    }

    public CertificateValidationListener getValidationListener() {
        return this.hL;
    }

    public boolean isStoreAcceptOnceCertificates() {
        return this.hI;
    }

    public void refresh() {
        this.init();
    }

    public void removeListener(PkiFileBasedCertificateListener pkiFileBasedCertificateListener) {
        if (pkiFileBasedCertificateListener != null) {
            this.listeners.remove(pkiFileBasedCertificateListener);
        }
    }

    public void setCrl(X509CRL x509CRL) {
        this.hF = x509CRL;
    }

    public void setStoreAcceptOnceCertificates(boolean bl) {
        this.hI = bl;
    }

    public void setValidationListener(CertificateValidationListener certificateValidationListener) {
        this.hL = certificateValidationListener;
    }

    @Override
    public StatusCode validateCertificate(ApplicationDescription object, Cert cert) {
        String[] stringArray;
        this.init();
        logger.debug("validateCertificate: applicationDescription={}", object);
        logger.debug("cert={}", (Object)cert);
        boolean bl = this.hF != null && this.hF.isRevoked(cert.getCertificate()) || this.a(this.hN, cert);
        logger.debug("isRevoked={}", (Object)bl);
        if (bl) {
            return new StatusCode(StatusCodes.Bad_CertificateRevoked);
        }
        StatusCode statusCode = StatusCode.GOOD;
        EnumSet<CertificateCheck> enumSet = EnumSet.noneOf(CertificateCheck.class);
        logger.debug("trustedCertificates={}", this.hO.keySet());
        if (!this.a(this.hM, cert) && this.a(this.hO, cert)) {
            logger.debug("trusted=yes");
            enumSet.add(CertificateCheck.Trusted);
        }
        logger.debug("trusted={}", (Object)enumSet.contains((Object)CertificateCheck.Trusted));
        X509Certificate x509Certificate = cert.getCertificate();
        try {
            x509Certificate.checkValidity();
            logger.debug("valid=yes");
            enumSet.add(CertificateCheck.Validity);
        }
        catch (CertificateExpiredException certificateExpiredException) {
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {}
        logger.debug("valid={}", (Object)enumSet.contains((Object)CertificateCheck.Validity));
        try {
            x509Certificate.verify(x509Certificate.getPublicKey());
            logger.debug("signature=yes");
            logger.debug("self-signed=yes");
            enumSet.add(CertificateCheck.Signature);
            enumSet.add(CertificateCheck.SelfSigned);
        }
        catch (GeneralSecurityException generalSecurityException) {
            for (PublicKey object22 : this.hK) {
                try {
                    x509Certificate.verify(object22);
                    if (this.hN.containsKey(object22)) {
                        return new StatusCode(StatusCodes.Bad_CertificateIssuerRevoked);
                    }
                    if (this.hO.containsKey(object22)) {
                        stringArray = (String[])this.hO.get(object22);
                        try {
                            stringArray.getCertificate().checkValidity();
                        }
                        catch (GeneralSecurityException generalSecurityException2) {
                            return new StatusCode(StatusCodes.Bad_CertificateIssuerTimeInvalid);
                        }
                    }
                    logger.debug("signature=yes");
                    enumSet.add(CertificateCheck.Signature);
                    enumSet.add(CertificateCheck.Trusted);
                }
                catch (GeneralSecurityException generalSecurityException3) {}
            }
        }
        logger.debug("signature={}", (Object)enumSet.contains((Object)CertificateCheck.Signature));
        logger.debug("self-signed={}", (Object)enumSet.contains((Object)CertificateCheck.SelfSigned));
        Object object2 = object == null ? null : object.getApplicationUri();
        boolean bl2 = object2 == null;
        if (!bl2) {
            try {
                String string = CertificateUtils.getApplicationUriOfCertificate((X509Certificate)x509Certificate);
                if (string.equals(object2)) {
                    bl2 = true;
                }
            }
            catch (CertificateParsingException certificateParsingException) {
                CertificateParsingException certificateParsingException2 = certificateParsingException;
                if (certificateParsingException.getCause().getMessage().contains("invalid URI name:")) {
                    stringArray = certificateParsingException2.getCause().getMessage().split("invalid URI name:");
                    if (stringArray.length == 2 && stringArray[1].equals(object2)) {
                        logger.warn("The provided certificate contains an invalid ApplicationURI: {}", (Object)stringArray[1]);
                        enumSet.add(CertificateCheck.Uri);
                    } else {
                        logger.warn("The provided certificate does not define the ApplicationURI", (Throwable)certificateParsingException2);
                    }
                }
                logger.warn("The provided certificate has an invalid SubjectAlternativeNames field", (Throwable)certificateParsingException2);
            }
        }
        if (bl2) {
            enumSet.add(CertificateCheck.Uri);
            enumSet.add(CertificateCheck.UriValid);
        }
        logger.debug("uri={}", (Object)enumSet.contains((Object)CertificateCheck.Uri));
        logger.debug("uriValid={}", (Object)enumSet.contains((Object)CertificateCheck.UriValid));
        EnumSet<CertificateCheck> enumSet2 = enumSet;
        object2 = object;
        x509Certificate = cert;
        object = this;
        object = ((PkiFileBasedCertificateValidator)object).hL;
        ValidationResult validationResult = object != null ? object.onValidate((Cert)x509Certificate, (ApplicationDescription)object2, enumSet2) : (enumSet2.containsAll(CertificateCheck.COMPULSORY) ? ValidationResult.AcceptPermanently : ValidationResult.Reject);
        logger.debug("action={}", (Object)validationResult);
        try {
            switch (validationResult) {
                case AcceptPermanently: {
                    statusCode = StatusCode.GOOD;
                    this.addTrustedCertificate(cert);
                    break;
                }
                case AcceptOnce: {
                    statusCode = StatusCode.GOOD;
                    if (this.hI && !enumSet.contains((Object)CertificateCheck.Trusted)) {
                        this.addRejectedCertificate(cert);
                    }
                    break;
                }
                case Reject: {
                    if (!enumSet.contains((Object)CertificateCheck.Trusted)) {
                        statusCode = new StatusCode(StatusCodes.Bad_SecurityChecksFailed);
                    } else if (!enumSet.contains((Object)CertificateCheck.Signature)) {
                        statusCode = new StatusCode(StatusCodes.Bad_SecurityChecksFailed);
                    } else if (!enumSet.contains((Object)CertificateCheck.Validity)) {
                        statusCode = new StatusCode(StatusCodes.Bad_CertificateTimeInvalid);
                    } else if (!enumSet.contains((Object)CertificateCheck.Uri)) {
                        statusCode = new StatusCode(StatusCodes.Bad_CertificateUriInvalid);
                    }
                    if (!enumSet.contains((Object)CertificateCheck.Trusted)) {
                        this.addRejectedCertificate(cert);
                    } else {
                        break;
                    }
                }
            }
        }
        catch (IOException iOException) {}
        return statusCode;
    }

    @Override
    public StatusCode validateCertificate(ApplicationIdentity applicationIdentity) {
        return this.validateCertificate(applicationIdentity.getApplicationDescription(), applicationIdentity.getCertificate());
    }

    public StatusCode validateCertificate(Cert cert) {
        logger.debug("validateCertificate: Cert={}", (Object)cert);
        if (cert == null) {
            return StatusCode.GOOD;
        }
        return this.validateCertificate(null, cert);
    }

    private static String a(Cert object) {
        byte[] byArray = object.getEncodedThumbprint();
        if (byArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(2 * byArray.length);
        byte[] byArray2 = byArray;
        int n2 = byArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by = byArray2[i2];
            stringBuilder.append("0123456789ABCDEF".charAt((by & 0xF0) >> 4)).append("0123456789ABCDEF".charAt(by & 0xF));
        }
        return stringBuilder.toString();
    }

    private File a(File file, Cert cert) {
        return new File(file, PkiFileBasedCertificateValidator.a(cert) + ".der");
    }

    private synchronized void init() {
        this.a(this.hO, this.hJ, this.hM);
        for (Cert cert : this.hO.values()) {
            this.hK.add(cert.getCertificate().getPublicKey());
        }
        this.a(this.hM, this.hG, this.hO);
        this.a(this.hN, this.hH, this.hO);
    }

    private void a(a a2, File file, a a3) {
        if (!file.exists()) {
            file.mkdirs();
        }
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                Object certificateException;
                if (file.equals(this.hH) && file2.getName().endsWith(".crl")) {
                    certificateException = file2;
                    PkiFileBasedCertificateValidator pkiFileBasedCertificateValidator = this;
                    try {
                        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                        FileInputStream fileInputStream = new FileInputStream((File)certificateException);
                        pkiFileBasedCertificateValidator.hF = (X509CRL)certificateFactory.generateCRL(fileInputStream);
                        logger.info("CRL initialized from " + certificateException + ": " + (pkiFileBasedCertificateValidator.hF.getRevokedCertificates() == null ? "no revoked certificates" : pkiFileBasedCertificateValidator.hF.getRevokedCertificates().size() + " certificates revoked"));
                    }
                    catch (Exception exception) {
                        logger.warn("Could not read CRL file {: {}", certificateException, (Object)exception.getMessage());
                    }
                    continue;
                }
                try {
                    certificateException = Cert.load((File)file2);
                    this.a(a2, file, (Cert)certificateException);
                    logger.debug("Certificate from '{}' added to accepted certificates", (Object)file2);
                    if (a3 == null) continue;
                    a3.remove(PkiFileBasedCertificateValidator.a(certificateException));
                }
                catch (IOException iOException) {
                    logger.info("File '{}' is not a certificate: {}", (Object)file2, (Object)iOException.getMessage());
                }
                catch (CertificateException certificateException2) {
                    logger.info("File '{}' is not a valid certificate: {}", (Object)file2, (Object)certificateException2.getMessage());
                }
            }
        }
    }

    private void a(a a2, File file, Cert cert) throws IOException {
        logger.debug("listAdd: cert={}; dir={}", (Object)PkiFileBasedCertificateValidator.a(cert), (Object)file);
        if (!a2.containsKey(cert)) {
            try {
                File file2 = this.a(file, cert);
                if (!file2.exists()) {
                    cert.save(file2);
                }
            }
            catch (IOException iOException) {
                logger.warn("Cannot write to directory " + file, (Throwable)iOException);
                throw iOException;
            }
            a2.put(PkiFileBasedCertificateValidator.a(cert), cert);
        }
        logger.debug("certificates.size()={}", (Object)a2.size());
    }

    private boolean a(a a2, Cert cert) {
        a2 = (Cert)a2.get(PkiFileBasedCertificateValidator.a(cert));
        return cert.equals((Object)a2);
    }

    private void b(a a2, File file, Cert cert) {
        logger.debug("removeCertificate: cert={} dir={}", (Object)PkiFileBasedCertificateValidator.a(cert), (Object)file);
        logger.debug("certificates.size()={}", (Object)a2.size());
        file = this.a(file, cert);
        file.delete();
        file = (Cert)a2.remove(PkiFileBasedCertificateValidator.a(cert));
        if (logger.isDebugEnabled()) {
            logger.debug("c=" + (file == null ? "null" : (Object)file.getEncodedThumbprint()));
            logger.debug("certificates.size()={}", (Object)a2.size());
        }
    }

    private final class b
    extends ConcurrentHashMap<String, Cert>
    implements a {
        private b(PkiFileBasedCertificateValidator pkiFileBasedCertificateValidator, byte by) {
        }

        /* synthetic */ b(PkiFileBasedCertificateValidator pkiFileBasedCertificateValidator) {
            this(pkiFileBasedCertificateValidator, 0);
        }
    }

    private static interface a
    extends Map<String, Cert> {
    }

    public static enum ValidationResult {
        AcceptOnce,
        AcceptPermanently,
        Reject;

    }

    public static enum CertificateCheck {
        SelfSigned,
        Signature,
        Trusted,
        Uri,
        UriValid,
        Validity;

        public static EnumSet<CertificateCheck> COMPULSORY;

        static {
            COMPULSORY = EnumSet.of(Trusted, Validity, Signature, Uri);
        }
    }
}

