/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.ServiceException;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.MonitoringFilter;
import org.opcfoundation.ua.core.MonitoringFilterResult;
import org.opcfoundation.ua.core.MonitoringMode;
import org.opcfoundation.ua.utils.AttributesUtil;
import org.opcfoundation.ua.utils.NumericRange;

public abstract class MonitoredItemBase {
    protected static int maxQueueSize = 1000000;
    private MonitoringFilter cx = null;
    private MonitoringFilterResult cy;
    protected final UnsignedInteger attributeId;
    protected UnsignedInteger clientHandle;
    protected final QualifiedName dataEncoding;
    protected boolean discardOldest = false;
    protected UnsignedInteger monitoredItemId;
    protected volatile MonitoringMode monitoringMode = MonitoringMode.Disabled;
    protected final NodeId nodeId;
    protected long queueSize;

    public MonitoredItemBase(UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2, NodeId nodeId, UnsignedInteger unsignedInteger3, MonitoringMode monitoringMode) {
        this.clientHandle = unsignedInteger;
        this.monitoredItemId = unsignedInteger2;
        this.nodeId = nodeId;
        this.attributeId = unsignedInteger3;
        this.dataEncoding = null;
        this.monitoringMode = monitoringMode;
        this.queueSize = this.getDefaultQueueSize();
    }

    public void close() {
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (MonitoredItemBase)object;
        if (this.monitoredItemId == null ? ((MonitoredItemBase)object).monitoredItemId != null : !this.monitoredItemId.equals((Object)((MonitoredItemBase)object).monitoredItemId)) {
            return false;
        }
        if (this.nodeId == null ? ((MonitoredItemBase)object).nodeId != null : !this.nodeId.equals((Object)((MonitoredItemBase)object).nodeId)) {
            return false;
        }
        if (this.attributeId == null ? ((MonitoredItemBase)object).attributeId != null : !this.attributeId.equals((Object)((MonitoredItemBase)object).attributeId)) {
            return false;
        }
        return !(this.clientHandle == null ? ((MonitoredItemBase)object).clientHandle != null : !this.clientHandle.equals((Object)((MonitoredItemBase)object).clientHandle));
    }

    public UnsignedInteger getAttributeId() {
        return this.attributeId;
    }

    public UnsignedInteger getClientHandle() {
        return this.clientHandle;
    }

    public QualifiedName getDataEncoding() {
        return this.dataEncoding;
    }

    public MonitoringFilter getFilter() {
        return this.cx;
    }

    public MonitoringFilterResult getFilterResult() {
        return this.cy;
    }

    public NumericRange getIndexRange() {
        return null;
    }

    public UnsignedInteger getMonitoredItemId() {
        return this.monitoredItemId;
    }

    public MonitoringMode getMonitoringMode() {
        return this.monitoringMode;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public long getQueueSize() {
        return this.queueSize;
    }

    public double getSamplingInterval() {
        return -1.0;
    }

    public int hashCode() {
        int n2 = 31 + (this.attributeId == null ? 0 : this.attributeId.hashCode());
        n2 = n2 * 31 + (this.nodeId == null ? 0 : this.nodeId.hashCode());
        n2 = n2 * 31 + (this.clientHandle == null ? 0 : this.clientHandle.hashCode());
        n2 = n2 * 31 + (this.monitoredItemId == null ? 0 : this.monitoredItemId.hashCode());
        return n2;
    }

    public boolean isDiscardOldest() {
        return this.discardOldest;
    }

    public void setDiscardOldest(boolean bl) {
        this.discardOldest = bl;
    }

    public void setMonitoringMode(MonitoringMode monitoringMode) throws ServiceException {
        if (monitoringMode == null) {
            throw new NullPointerException("monitoringMode");
        }
        if (this.monitoringMode != monitoringMode) {
            this.monitoringMode = monitoringMode;
            this.monitoringModeChanged();
            this.updateQueue();
        }
    }

    public void setQueueSize(long l2) throws ServiceException {
        this.setQueueSize(UnsignedInteger.valueOf((long)l2));
    }

    public void setQueueSize(UnsignedInteger unsignedInteger) throws ServiceException {
        long l2 = unsignedInteger.getValue();
        if (l2 == 0L) {
            l2 = this.getDefaultQueueSize();
        } else if (l2 > (long)maxQueueSize) {
            l2 = maxQueueSize;
        }
        if (l2 != this.queueSize) {
            this.queueSize = l2;
            this.updateQueue();
        }
    }

    public String toString() {
        return String.format("ClientHandle=%s, MonitoredItemId=%s, NodeId=%s, AttributeId=%s", this.clientHandle, this.monitoredItemId, this.nodeId, AttributesUtil.toString((UnsignedInteger)this.attributeId));
    }

    protected abstract long getDefaultQueueSize();

    protected void monitoringModeChanged() throws ServiceException {
    }

    protected void setFilter(MonitoringFilter monitoringFilter) throws ServiceException {
        if (monitoringFilter == null && this.cx == null) {
            return;
        }
        if (monitoringFilter != null && monitoringFilter.equals((Object)this.cx)) {
            return;
        }
        this.cx = monitoringFilter;
        this.updateFilter();
    }

    protected void setFilterResult(MonitoringFilterResult monitoringFilterResult) {
        this.cy = monitoringFilterResult;
    }

    protected void setMonitoredItemId(UnsignedInteger unsignedInteger) {
        this.monitoredItemId = unsignedInteger;
    }

    protected void updateFilter() throws ServiceException {
    }

    protected void updateQueue() throws ServiceException {
    }
}

