/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.ModelException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.UaApplication;
import com.prosysopc.ua.nodes.UaDataType;
import com.prosysopc.ua.nodes.UaNode;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.ExpandedNodeId;
import org.opcfoundation.ua.builtintypes.ExtensionObject;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.UnsignedByte;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedLong;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.builtintypes.XmlElement;
import org.opcfoundation.ua.common.NamespaceTable;
import org.opcfoundation.ua.common.ServerTable;
import org.opcfoundation.ua.core.AddNodesItem;
import org.opcfoundation.ua.core.AddReferencesItem;
import org.opcfoundation.ua.core.DataTypeAttributes;
import org.opcfoundation.ua.core.IdType;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.core.MethodAttributes;
import org.opcfoundation.ua.core.NodeAttributes;
import org.opcfoundation.ua.core.NodeClass;
import org.opcfoundation.ua.core.ObjectAttributes;
import org.opcfoundation.ua.core.ObjectTypeAttributes;
import org.opcfoundation.ua.core.ReferenceTypeAttributes;
import org.opcfoundation.ua.core.StatusCodes;
import org.opcfoundation.ua.core.VariableAttributes;
import org.opcfoundation.ua.core.VariableTypeAttributes;
import org.opcfoundation.ua.core.ViewAttributes;
import org.opcfoundation.ua.encoding.EncoderContext;
import org.opcfoundation.ua.encoding.EncodingException;
import org.opcfoundation.ua.encoding.xml.XmlDecoder;
import org.opcfoundation.ua.utils.XMLFactoryCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class ModelParserBase {
    public static final String UTF8_BOM = "\ufeff";
    private static final boolean dZ = System.getProperty("java.runtime.name").toLowerCase().contains("android");
    private static final Logger logger = LoggerFactory.getLogger(ModelParserBase.class);
    private String alias;
    private final HashMap<String, NodeId> ea = new HashMap();
    private final UaApplication eb;
    private boolean ec;
    private final Set<ExpandedNodeId> ed = new TreeSet<ExpandedNodeId>();
    private String ee;
    private final Map<String, Class<?>> ef;
    private String eg;
    private final NamespaceTable eh;
    private Locator locator;
    private final a ei = new a(this);
    private AddNodesItem ej;
    private NodeAttributes ek;
    private AddReferencesItem el;
    private final List<AddReferencesItem> em = new ArrayList<AddReferencesItem>();
    private final List<AddNodesItem> nodes = new ArrayList<AddNodesItem>();
    private final Map<ExpandedNodeId, AddReferencesItem> en = new HashMap<ExpandedNodeId, AddReferencesItem>();
    private String eo;
    private boolean ep;
    private XMLReader eq;
    private boolean er;
    private boolean es;
    private int et = 0;
    private final List<AddReferencesItem> eu = new ArrayList<AddReferencesItem>();
    private final UnsignedInteger serverIndex = UnsignedInteger.ZERO;
    private TransformerHandler ev;
    private DOMResult ew;
    private List<String> bj = new ArrayList<String>();

    public ModelParserBase(UaApplication uaApplication) {
        this.ef = new HashMap();
        this.eb = uaApplication;
        this.eh = new NamespaceTable();
    }

    public void createModel(boolean bl) throws ModelException, ServiceException {
        logger.debug("Starting model creation..");
        this.setFailOnFirstError(bl);
        Object object = new ArrayList<AddNodesItem>();
        ArrayList<AddNodesItem> arrayList = new ArrayList<AddNodesItem>();
        ArrayList<AddNodesItem> arrayList2 = new ArrayList<AddNodesItem>();
        ArrayList<AddNodesItem> arrayList3 = new ArrayList<AddNodesItem>();
        ArrayList<AddNodesItem> arrayList4 = new ArrayList<AddNodesItem>();
        ArrayList<AddNodesItem> arrayList5 = new ArrayList<AddNodesItem>();
        for (AddNodesItem addNodesItem : this.nodes) {
            if (this.ed.contains(addNodesItem.getRequestedNewNodeId())) {
                logger.debug("ignored: {} NodeId={}", (Object)addNodesItem.getBrowseName(), (Object)addNodesItem.getRequestedNewNodeId());
                continue;
            }
            switch (addNodesItem.getNodeClass()) {
                case ReferenceType: {
                    object.add(addNodesItem);
                    break;
                }
                case DataType: {
                    arrayList.add(addNodesItem);
                    break;
                }
                case Method: {
                    arrayList5.add(addNodesItem);
                    break;
                }
                case Object: {
                    arrayList2.add(addNodesItem);
                    break;
                }
                case ObjectType: {
                    arrayList4.add(addNodesItem);
                    break;
                }
                case Unspecified: {
                    arrayList3.add(addNodesItem);
                    break;
                }
                case Variable: {
                    arrayList2.add(addNodesItem);
                    break;
                }
                case VariableType: {
                    arrayList4.add(addNodesItem);
                    break;
                }
                case View: {
                    arrayList3.add(addNodesItem);
                }
            }
        }
        this.addNodes((List<AddNodesItem>)object, "ReferenceTypes");
        this.addNodes(arrayList, "DataTypes");
        object = this;
        logger.debug("linkTypeNodesAndJavaClasses");
        super.a(Identifiers.SByte, Byte.class);
        super.a(Identifiers.Int16, Short.class);
        super.a(Identifiers.Int32, Integer.class);
        super.a(Identifiers.Int64, Long.class);
        super.a(Identifiers.Byte, UnsignedByte.class);
        super.a(Identifiers.UInt16, UnsignedShort.class);
        super.a(Identifiers.UInt32, UnsignedInteger.class);
        super.a(Identifiers.UInt64, UnsignedLong.class);
        super.a(Identifiers.Float, Float.class);
        super.a(Identifiers.Double, Double.class);
        super.a(Identifiers.Duration, Double.class);
        super.a(Identifiers.Boolean, Boolean.class);
        super.a(Identifiers.ByteString, byte[].class);
        super.a(Identifiers.Enumeration, Integer.class);
        super.a(Identifiers.QualifiedName, QualifiedName.class);
        super.a(Identifiers.String, String.class);
        super.a(Identifiers.LocaleId, Locale.class);
        super.a(Identifiers.Guid, UUID.class);
        super.a(Identifiers.DateTime, DateTime.class);
        super.a(Identifiers.UtcTime, DateTime.class);
        super.a(Identifiers.DataValue, DataValue.class);
        super.a(Identifiers.DiagnosticInfo, DiagnosticInfo.class);
        super.a(Identifiers.LocalizedText, LocalizedText.class);
        super.a(Identifiers.ExpandedNodeId, ExpandedNodeId.class);
        super.a(Identifiers.NodeId, NodeId.class);
        super.a(Identifiers.XmlElement, XmlElement.class);
        this.addNodes(arrayList4, "InstanceTypeNodes");
        this.addNodes(arrayList2, "InstanceNodes");
        this.addNodes(arrayList3, "OtherNodes");
        this.addNodes(arrayList5, "MethodNodes");
        this.addReferences(this.eu);
        logger.debug("createModel: done. Errors={}", (Object)this.bj.size());
        if (!this.bj.isEmpty()) {
            throw new ModelException(this.bj);
        }
    }

    public EncoderContext getEncoderContext() {
        return this.eb.getEncoderContext();
    }

    public List<String> getErrorList() {
        return this.bj;
    }

    public Collection<ExpandedNodeId> getIgnoredNodes() {
        return this.ed;
    }

    public List<AddNodesItem> getNodes() {
        return this.nodes;
    }

    public List<AddReferencesItem> getReferences() {
        return this.eu;
    }

    public boolean isFailOnFirstError() {
        return this.ec;
    }

    public boolean isReadingExtensions() {
        return this.er;
    }

    public void parseFile(InputStream inputStream) throws IOException, SAXException, ModelException {
        Charset charset = Charset.forName("UTF8");
        this.parseFile(inputStream, charset);
    }

    public void parseFile(InputStream object, Charset object2) throws IOException, SAXException, ModelException {
        logger.debug("parseFile: charset={}" + object2);
        this.ee = "stream";
        this.eq = XMLReaderFactory.createXMLReader();
        this.eq.setContentHandler(this.ei);
        this.eq.setErrorHandler(this.ei);
        if (!((InputStream)object).markSupported()) {
            object = new BufferedInputStream((InputStream)object);
        }
        ((InputStream)object).mark(10);
        object2 = new InputStreamReader((InputStream)object, (Charset)object2);
        logger.debug("encoding={}", (Object)((InputStreamReader)object2).getEncoding());
        char[] cArray = new char[2];
        ((InputStreamReader)object2).read(cArray, 0, ((InputStreamReader)object2).getEncoding().equals("UTF8") ? 1 : 2);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("cbuf=%04x %04x bom=%04x", cArray[0], (int)cArray[1], (int)UTF8_BOM.charAt(0)));
        }
        if (cArray[0] != UTF8_BOM.charAt(0)) {
            ((InputStream)object).reset();
            object2 = new InputStreamReader((InputStream)object);
        }
        object = this;
        ((ModelParserBase)object).a("SByte", Byte.class);
        super.a("Int16", Short.class);
        super.a("Int32", Integer.class);
        super.a("Int64", Long.class);
        super.a("Byte", UnsignedByte.class);
        super.a("UInt16", UnsignedShort.class);
        super.a("UInt32", UnsignedInteger.class);
        super.a("UInt64", UnsignedLong.class);
        super.a("Float", Float.class);
        super.a("Double", Double.class);
        super.a("Duration", Double.class);
        super.a("Boolean", Boolean.class);
        super.a("ByteString", byte[].class);
        super.a("QualifiedName", QualifiedName.class);
        super.a("String", String.class);
        super.a("LocaleId", Locale.class);
        super.a("Guid", UUID.class);
        super.a("DateTime", DateTime.class);
        super.a("UtcTime", DateTime.class);
        super.a("DataValue", DataValue.class);
        super.a("DiagnosticInfo", DiagnosticInfo.class);
        super.a("LocalizedText", LocalizedText.class);
        super.a("ExpandedNodeId", ExpandedNodeId.class);
        super.a("NodeId", NodeId.class);
        super.a("XmlElement", XmlElement.class);
        super.a("ExtensionObject", ExtensionObject.class);
        this.eq.parse(new InputSource((Reader)object2));
        if (!this.bj.isEmpty()) {
            throw new ModelException(this.bj);
        }
        this.ao();
    }

    public void parseFile(URI object) throws SAXException, IOException, ModelException {
        if (logger.isDebugEnabled()) {
            logger.debug("parseFile:" + object);
        }
        this.ee = ((URI)object).toString();
        object = ((URI)object).toURL().openStream();
        this.parseFile((InputStream)object);
    }

    public void setFailOnFirstError(boolean bl) {
        this.ec = bl;
    }

    public void setIgnoredNodes(Collection<ExpandedNodeId> collection) {
        if (collection != null) {
            this.ed.addAll(collection);
        }
    }

    private void ao() {
        for (AddNodesItem addNodesItem : this.nodes) {
            if (!ExpandedNodeId.isNull((ExpandedNodeId)addNodesItem.getParentNodeId()) || !this.en.containsKey(addNodesItem.getRequestedNewNodeId())) continue;
            AddReferencesItem addReferencesItem = this.en.get(addNodesItem.getRequestedNewNodeId());
            addNodesItem.setParentNodeId(this.getNamespaceTable().toExpandedNodeId(addReferencesItem.getSourceNodeId()));
            addNodesItem.setReferenceTypeId(addReferencesItem.getReferenceTypeId());
            logger.debug("backtracking parent for:{} NodeId={} Parent={} ReferenceType={}", new Object[]{addNodesItem.getBrowseName(), addNodesItem.getRequestedNewNodeId().getValue(), addNodesItem.getParentNodeId().getValue(), addNodesItem.getReferenceTypeId().getValue()});
        }
    }

    private void a(boolean bl, List<String> list, Exception exception, String string) throws ModelException {
        logger.warn("createModel: " + string + " ", (Throwable)exception);
        if (bl) {
            if (this.locator != null) {
                throw new ModelException(string, exception, this.locator.getLineNumber());
            }
            throw new ModelException(string, exception);
        }
        if (this.locator != null) {
            list.add(string + exception + " (near line " + this.locator.getLineNumber() + ")");
            return;
        }
        list.add(string + exception);
    }

    private AddNodesItem a(Attributes attributes) {
        AddNodesItem addNodesItem = new AddNodesItem();
        ExpandedNodeId expandedNodeId = this.a(attributes, "NodeId");
        if (expandedNodeId == null) {
            throw new NullPointerException("createNode: NodeId should not be null");
        }
        addNodesItem.setRequestedNewNodeId(expandedNodeId);
        addNodesItem.setBrowseName(this.b(attributes, "BrowseName"));
        logger.debug("Creating node: {}", (Object)addNodesItem.getBrowseName().getName());
        return addNodesItem;
    }

    private void ap() {
        AddReferencesItem addReferencesItem;
        ArrayList<AddReferencesItem> arrayList = new ArrayList<AddReferencesItem>();
        if (this.em.size() == 0) {
            logger.debug("Zero references..");
        }
        for (Object object : this.em) {
            if (object.getReferenceTypeId().equals((Object)Identifiers.HasTypeDefinition) && object.getIsForward().booleanValue()) {
                this.ej.setTypeDefinition(object.getTargetNodeId());
            }
            if (object.getIsForward().booleanValue() || !ModelParserBase.b(object.getReferenceTypeId())) {
                this.eu.add((AddReferencesItem)object);
            } else {
                logger.debug("parentReferences.add {}", (Object)ModelParserBase.a(object));
                arrayList.add((AddReferencesItem)object);
            }
            if (!object.getIsForward().booleanValue() || !ModelParserBase.b(object.getReferenceTypeId())) continue;
            logger.debug("mapToParentMap {}", (Object)ModelParserBase.a(object));
            addReferencesItem = object;
            object = this;
            if (object.en.containsKey(addReferencesItem.getTargetNodeId())) {
                logger.debug("ParentMap Should only have one AddReferenceItem per node");
                continue;
            }
            logger.debug("adding to parentmap; source:{} to target:{} typeofref:{}", new Object[]{addReferencesItem.getSourceNodeId(), addReferencesItem.getTargetNodeId(), addReferencesItem.getReferenceTypeId()});
            object.en.put(addReferencesItem.getTargetNodeId(), addReferencesItem);
        }
        if (arrayList.size() == 1) {
            Object object;
            addReferencesItem = (AddReferencesItem)arrayList.get(0);
            object = this;
            logger.debug("setParent: node={} ref={}", (Object)object.ej.getBrowseName(), (Object)ModelParserBase.a(addReferencesItem));
            if (!ExpandedNodeId.isNull((ExpandedNodeId)object.ej.getParentNodeId())) {
                logger.warn("setParent: already defined!");
            }
            object.ej.setParentNodeId(addReferencesItem.getTargetNodeId());
            object.ej.setReferenceTypeId(addReferencesItem.getReferenceTypeId());
        } else if (arrayList.size() == 0) {
            logger.debug("Zero parent references");
        } else {
            logger.debug("More than one parent reference");
        }
        this.em.clear();
    }

    private static UnsignedInteger[] a(Attributes unsignedIntegerArray, String string, String string2) {
        for (int i2 = 0; i2 < unsignedIntegerArray.getLength(); ++i2) {
            if (!unsignedIntegerArray.getLocalName(i2).equalsIgnoreCase(string)) continue;
            string2 = unsignedIntegerArray.getValue(i2);
            break;
        }
        if ("".equals(string2) || string2 == null) {
            return null;
        }
        if (string2.indexOf(",") < 0) {
            try {
                return new UnsignedInteger[]{UnsignedInteger.parseUnsignedInteger((String)string2)};
            }
            catch (Exception exception) {
                return null;
            }
        }
        String[] stringArray = string2.split(",");
        try {
            unsignedIntegerArray = new UnsignedInteger[stringArray.length];
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                unsignedIntegerArray[i3] = UnsignedInteger.parseUnsignedInteger((String)stringArray[i3]);
            }
            return unsignedIntegerArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Boolean a(Attributes attributes, String string, boolean bl) {
        Boolean bl2 = bl;
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            bl2 = Boolean.parseBoolean(attributes.getValue(i2));
            break;
        }
        return bl2;
    }

    private static Double a(Attributes attributes, String string, double d2) {
        double d3 = 0.0;
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            d3 = Double.parseDouble(attributes.getValue(i2));
            break;
        }
        return d3;
    }

    private ExpandedNodeId a(Attributes attributes, String string) {
        ExpandedNodeId expandedNodeId = null;
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            attributes = NodeId.parseNodeId((String)attributes.getValue(i2));
            expandedNodeId = this.toGlobalExpandedNodeId((NodeId)attributes);
            break;
        }
        return expandedNodeId;
    }

    private static Integer a(Attributes attributes, String string, int n2) {
        n2 = -2;
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            n2 = Integer.parseInt(attributes.getValue(i2));
            break;
        }
        return n2;
    }

    private void a(Attributes attributes, NodeAttributes nodeAttributes) {
        nodeAttributes.setUserWriteMask(ModelParserBase.a(attributes, "UserWriteMask", UnsignedInteger.valueOf((long)0L)));
        nodeAttributes.setWriteMask(ModelParserBase.a(attributes, "WriteMask", UnsignedInteger.valueOf((long)0L)));
    }

    private NodeId a(Attributes object, String string, NodeId nodeId) {
        for (int i2 = 0; i2 < object.getLength(); ++i2) {
            if (!object.getLocalName(i2).equalsIgnoreCase(string)) continue;
            string = object.getValue(i2);
            object = this;
            nodeId = ((ModelParserBase)object).a(string, true);
            break;
        }
        return nodeId;
    }

    private NodeId a(String string, boolean bl) {
        if (bl && this.ea.containsKey(string)) {
            return this.ea.get(string);
        }
        return NodeId.parseNodeId((String)string);
    }

    private QualifiedName b(Attributes object, String string) {
        QualifiedName qualifiedName = null;
        for (int i2 = 0; i2 < object.getLength(); ++i2) {
            if (!object.getLocalName(i2).equalsIgnoreCase(string)) continue;
            string = QualifiedName.parseQualifiedName((String)object.getValue(i2));
            object = this;
            qualifiedName = new QualifiedName(super.a(string.getNamespaceIndex()), string.getName());
            break;
        }
        return qualifiedName;
    }

    private static String b(Attributes attributes, String string, String string2) {
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            string2 = attributes.getValue(i2);
            break;
        }
        return string2;
    }

    private static UnsignedByte a(Attributes attributes, String string, UnsignedByte unsignedByte) {
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            unsignedByte = UnsignedByte.parseUnsignedByte((String)attributes.getValue(i2));
            break;
        }
        return unsignedByte;
    }

    private static UnsignedInteger a(Attributes attributes, String string, UnsignedInteger unsignedInteger) {
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            unsignedInteger = UnsignedInteger.parseUnsignedInteger((String)attributes.getValue(i2));
            break;
        }
        return unsignedInteger;
    }

    private void a(String string, Class<?> clazz) {
        this.ef.put(string.toLowerCase(), clazz);
    }

    private static boolean b(NodeId nodeId) {
        return nodeId.equals((Object)Identifiers.HasComponent) || nodeId.equals((Object)Identifiers.HasOrderedComponent) || nodeId.equals((Object)Identifiers.HasProperty) || nodeId.equals((Object)Identifiers.Organizes) || nodeId.equals((Object)Identifiers.HasSubtype) || nodeId.equals((Object)Identifiers.HasEncoding);
    }

    private boolean aq() {
        return this.et > 0;
    }

    private void a(NodeId nodeId, Class<?> clazz) {
        try {
            ((UaDataType)this.getNode(nodeId)).setJavaClass(clazz);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException(statusException);
        }
    }

    private int a(int n2) {
        String string = this.eh.getUri(n2);
        return this.getNamespaceTable().getIndex(string);
    }

    private void ar() {
        this.ep = true;
        this.eo = "";
    }

    private void b(Attributes attributes) {
        this.alias = ModelParserBase.b(attributes, "Alias", "");
    }

    private void c(Attributes attributes) {
        this.eg = ModelParserBase.b(attributes, "Locale", "");
    }

    private static String a(AddReferencesItem addReferencesItem) {
        return String.format("finalizeReference: %s->%s (isForward=%s)", addReferencesItem.getSourceNodeId(), addReferencesItem.getTargetNodeId(), addReferencesItem.getIsForward());
    }

    private void a(String string, String string2, String string3, Attributes attributes) {
        logger.debug("valueStartElement: {}", (Object)string2);
        try {
            this.ev.startElement(string, string2, string3, attributes);
            return;
        }
        catch (SAXException sAXException) {
            logger.error("Error in valueStartElement", (Throwable)sAXException);
            return;
        }
    }

    protected void addNamespaceUri(String string) {
        this.eh.add(string);
        this.getNamespaceTable().add(string);
    }

    protected void addNodes(List<AddNodesItem> object, String object2) throws ModelException, ServiceException {
        logger.debug("addNodes: {}", object2);
        object = object.iterator();
        while (object.hasNext()) {
            object2 = (AddNodesItem)object.next();
            String string = object2;
            object2 = this;
            try {
                NodeId nodeId = ((ModelParserBase)object2).doAddNode((AddNodesItem)string);
                if (!nodeId.getValue().equals(string.getRequestedNewNodeId().getValue())) {
                    logger.warn("addNode: {} requested NodeId={} actual NodeId={}", new Object[]{string.getBrowseName(), string.getRequestedNewNodeId(), nodeId});
                    continue;
                }
                logger.debug("addNode:{} requested NodeId={}", (Object)string.getBrowseName(), (Object)string.getRequestedNewNodeId());
            }
            catch (Exception exception) {
                super.a(((ModelParserBase)object2).ec, ((ModelParserBase)object2).bj, exception, "Failed to create node: " + string.getBrowseName() + " with id:" + string.getRequestedNewNodeId());
            }
        }
    }

    protected void addReferences(List<AddReferencesItem> object) throws ModelException {
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (AddReferencesItem)object.next();
            AddReferencesItem addReferencesItem = object2;
            object2 = this;
            try {
                ((ModelParserBase)object2).doAddReference(addReferencesItem);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("createModel: Adding refitem: " + addReferencesItem.getSourceNodeId().toString() + " --> " + addReferencesItem.getTargetNodeId().toString() + " forward:" + addReferencesItem.getIsForward() + " type: " + addReferencesItem.getReferenceTypeId());
            }
            catch (Exception exception) {
                if (((ModelParserBase)object2).isIgnoredReference(addReferencesItem)) continue;
                super.a(((ModelParserBase)object2).ec, ((ModelParserBase)object2).bj, exception, "Failed to create reference: " + addReferencesItem.getSourceNodeId() + "--->" + addReferencesItem.getTargetNodeId() + " forward:" + addReferencesItem.getIsForward() + " type: " + addReferencesItem.getReferenceTypeId());
            }
        }
    }

    protected void afterCreate(AddNodesItem addNodesItem) {
    }

    protected void characters(char[] object, int n2, int n3) {
        block9: {
            try {
                block8: {
                    if (this.aq()) {
                        int n4 = n3;
                        int n5 = n2;
                        char[] cArray = object;
                        object = this;
                        try {
                            String string = new String(cArray, n5, n4);
                            string = string.trim();
                            if (!string.isEmpty()) {
                                logger.debug("valueCharacters: {}", (Object)string);
                                ((ModelParserBase)object).ev.characters(cArray, n5, n4);
                            }
                            break block8;
                        }
                        catch (SAXException sAXException) {
                            logger.error("Error in valueCharacters, start=" + n5 + " ,length=" + n4 + " ch len=" + cArray.length, (Throwable)sAXException);
                            break block8;
                        }
                        catch (Exception exception) {
                            String string = new String(cArray, n5, n4);
                            object = string;
                            object = string.trim();
                            logger.error("Error in valueCharacters, start=" + n5 + " ,length=" + n4 + " ch len=" + cArray.length + " chars:" + (String)(((String)object).isEmpty() ? "isEmpty()=true" : object), (Throwable)exception);
                            break block9;
                        }
                    }
                    if (this.ep) {
                        this.eo = this.eo + new String((char[])object, n2, n3);
                    }
                }
                return;
            }
            catch (Exception exception) {
                logger.error("Error in ModelParser2.characters, start=" + n2 + ", length=" + n3, (Throwable)exception);
            }
        }
    }

    protected NodeId doAddNode(AddNodesItem addNodesItem) throws StatusException, ServiceException {
        throw new StatusException(StatusCodes.Bad_NotImplemented);
    }

    protected void doAddReference(AddReferencesItem addReferencesItem) throws StatusException, ServiceException {
        throw new StatusException(StatusCodes.Bad_NotImplemented);
    }

    /*
     * Unable to fully structure code
     */
    protected void endElement(String var1_1, String var2_5, String var3_6) throws SAXException {
        ModelParserBase.logger.debug("endElement: {}", (Object)var2_5);
        try {
            if (this.aq()) {
                var5_9 = var3_6;
                var4_10 = var2_5;
                var3_6 = var1_1;
                var1_1 = this;
                ModelParserBase.logger.debug("valueEndElement: localName={}", var4_10);
                try {
                    var1_1.ev.endElement((String)var3_6, (String)var4_10, var5_9);
                }
                catch (SAXException var3_7) {
                    ModelParserBase.logger.error("Error in valueEndElement: localName=" + (String)var4_10, (Throwable)var3_7);
                }
                catch (EmptyStackException var3_8) {
                    ModelParserBase.logger.error("Error in valueEndElement: localName=" + (String)var4_10, (Throwable)var3_8);
                }
                if (var2_5.equals("Value")) {
                    ModelParserBase.logger.debug("endElement: readingValue={}", (Object)this.et);
                    if (--this.et <= 0) {
                        var1_1 = this;
                        var1_1.ev.endDocument();
                        if (!ModelParserBase.dZ) {
                            ModelParserBase.logger.debug("finalizing value:{}", (Object)var1_1.ew.getNode());
                            var3_6 = new StringWriter();
                            var4_10 = XMLFactoryCache.getTransformerFactory().newTransformer();
                            var4_10.setOutputProperty("omit-xml-declaration", "yes");
                            var4_10.transform(new DOMSource(var1_1.ew.getNode()), new StreamResult((Writer)var3_6));
                            var5_9 = var3_6.toString();
                            ModelParserBase.logger.debug("Parsed XML of value:\n{}", (Object)var5_9);
                            var3_6 = new XmlElement(var5_9);
                            var3_6 = new XmlDecoder((XmlElement)var3_6, var1_1.getEncoderContext());
                            try {
                                var3_6.setNamespaceTable(var1_1.eh);
                                var5_9 = var3_6.getVariant("");
                                var4_10 = var1_1;
                                if (var4_10.ek == null) ** GOTO lbl47
                                ModelParserBase.logger.debug("addValue: {}", (Object)var5_9);
                                if (var4_10.ek instanceof VariableAttributes) {
                                    ((VariableAttributes)var4_10.ek).setValue((Variant)var5_9);
                                }
                                if (!(var4_10.ek instanceof VariableTypeAttributes)) ** GOTO lbl47
                                ((VariableTypeAttributes)var4_10.ek).setValue((Variant)var5_9);
                            }
                            finally {
                                var3_6.close();
                            }
                        } else {
                            ModelParserBase.logger.debug("finalizing value: skipping because we are on android");
                        }
lbl47:
                        // 4 sources

                        var1_1.ev = null;
                    }
                }
                return;
            }
            if (this.isReadingNamespaces() && var2_5.equals("Uri")) {
                var1_1 = this;
                var3_6 = var1_1.eo.trim();
                var1_1.addNamespaceUri((String)var3_6);
                return;
            }
            var1_1 = b.valueOf(var2_5);
            switch (1.dA[var1_1.ordinal()]) {
                case 1: {
                    this.es = false;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    var1_1 = this;
                    if (var1_1.ek == null) break;
                    var3_6 = null;
                    try {
                        var3_6 = ExtensionObject.binaryEncode((Structure)var1_1.ek, (EncoderContext)var1_1.getEncoderContext());
                    }
                    catch (EncodingException var4_11) {
                        ModelParserBase.logger.error("Encoding error in finalizing node:", (Throwable)var4_11);
                    }
                    var1_1.ej.setNodeAttributes((ExtensionObject)var3_6);
                    var1_1.nodes.add(var1_1.ej);
                    var1_1.ej = null;
                    var1_1.ek = null;
                    break;
                }
                case 10: {
                    var1_1 = this;
                    var1_1.ea.put(var1_1.alias, super.a(var1_1.eo, false));
                    break;
                }
                case 11: {
                    var1_1 = this;
                    if (var1_1.ep && var1_1.ek != null) {
                        var1_1.ek.setDescription(new LocalizedText(var1_1.eo, var1_1.eg));
                    }
                    var1_1.ep = false;
                    break;
                }
                case 12: {
                    var1_1 = this;
                    if (var1_1.ep && var1_1.ek != null) {
                        var1_1.ek.setDisplayName(new LocalizedText(var1_1.eo, var1_1.eg));
                    }
                    var1_1.ep = false;
                    break;
                }
                case 13: {
                    var1_1 = this;
                    if (var1_1.ep && var1_1.ek != null) {
                        ((ReferenceTypeAttributes)var1_1.ek).setInverseName(new LocalizedText(var1_1.eo, var1_1.eg));
                    }
                    var1_1.ep = false;
                    break;
                }
                case 14: {
                    ModelParserBase.logger.error("endElement reached Value with readingValue false, localName={}", (Object)var2_5);
                    break;
                }
                case 15: {
                    var1_1 = this;
                    if (var1_1.el != null) {
                        if (var1_1.ep) {
                            var1_1.el.setTargetNodeId(var1_1.toGlobalExpandedNodeId(NodeId.parseNodeId((String)var1_1.eo)));
                        }
                        var1_1.ep = false;
                        if (ModelParserBase.logger.isDebugEnabled()) {
                            ModelParserBase.logger.debug("referenceToString(nodeReference): {}", (Object)ModelParserBase.a(var1_1.el));
                        }
                        var1_1.em.add(var1_1.el);
                        var1_1.el = null;
                    }
                    break;
                }
                case 16: {
                    this.ap();
                    break;
                }
                case 17: {
                    var1_1 = this;
                    this.er = false;
                    ModelParserBase.logger.debug("Read extensions");
                }
                default: {
                    return;
                }
            }
        }
        catch (IllegalArgumentException v0) {
            if (!this.isReadingExtensions()) {
                ModelParserBase.logger.info("Unknown element in XML: " + var2_5);
            }
            return;
        }
        catch (Exception var1_3) {
            try {
                this.a(this.ec, this.bj, var1_3, "Error in ModelParser2.endElement: localName=" + var2_5);
                return;
            }
            catch (ModelException var1_4) {
                throw new SAXException("Error in ModelParser2.endElement: localName=" + var2_5, var1_4);
            }
        }
    }

    protected abstract NamespaceTable getNamespaceTable();

    protected abstract UaNode getNode(NodeId var1) throws StatusException;

    protected abstract ServerTable getServerTable();

    protected boolean isIgnoredReference(AddReferencesItem addReferencesItem) {
        return this.ed.contains(this.getNamespaceTable().toExpandedNodeId(addReferencesItem.getSourceNodeId())) || this.ed.contains(addReferencesItem.getTargetNodeId());
    }

    protected boolean isReadingNamespaces() {
        return this.es;
    }

    protected void startElement(String object, String string, String object2, Attributes attributes) throws SAXException {
        logger.debug("startElement: {} readingValue={}", (Object)string, (Object)this.et);
        try {
            if (this.aq()) {
                if (string.equals("Value")) {
                    ++this.et;
                }
                this.a((String)object, string, (String)object2, attributes);
                return;
            }
            if (this.isReadingNamespaces()) {
                if (string.equals("Uri")) {
                    this.ar();
                }
                return;
            }
            if (this.isReadingExtensions()) {
                return;
            }
            Object object3 = b.valueOf(string);
            switch (1.dA[((Enum)object3).ordinal()]) {
                case 1: {
                    this.es = true;
                    break;
                }
                case 2: {
                    object = attributes;
                    object3 = this;
                    this.ej = super.a((Attributes)object);
                    object2 = object;
                    object = object3;
                    attributes = new DataTypeAttributes();
                    super.a((Attributes)object2, (NodeAttributes)attributes);
                    attributes.setIsAbstract(ModelParserBase.a((Attributes)object2, "IsAbstract", false));
                    ((ModelParserBase)object3).ek = attributes;
                    ((ModelParserBase)object3).ej.setNodeClass(NodeClass.DataType);
                    break;
                }
                case 3: {
                    object = attributes;
                    object3 = this;
                    this.ej = super.a((Attributes)object);
                    object2 = object;
                    object = object3;
                    attributes = new MethodAttributes();
                    super.a((Attributes)object2, (NodeAttributes)attributes);
                    attributes.setExecutable(ModelParserBase.a((Attributes)object2, "Executable", true));
                    attributes.setExecutable(ModelParserBase.a((Attributes)object2, "UserExecutable", true));
                    ((ModelParserBase)object3).ek = attributes;
                    ((ModelParserBase)object3).ej.setNodeClass(NodeClass.Method);
                    break;
                }
                case 4: {
                    object = attributes;
                    object3 = this;
                    this.ej = super.a((Attributes)object);
                    object2 = object;
                    object = object3;
                    attributes = new ObjectAttributes();
                    super.a((Attributes)object2, (NodeAttributes)attributes);
                    attributes.setEventNotifier(ModelParserBase.a((Attributes)object2, "EventNotifier", UnsignedByte.valueOf((int)0)));
                    ((ModelParserBase)object3).ek = attributes;
                    ((ModelParserBase)object3).ej.setNodeClass(NodeClass.Object);
                    break;
                }
                case 5: {
                    object = attributes;
                    object3 = this;
                    this.ej = super.a((Attributes)object);
                    object2 = object;
                    object = object3;
                    attributes = new ObjectTypeAttributes();
                    super.a((Attributes)object2, (NodeAttributes)attributes);
                    attributes.setIsAbstract(ModelParserBase.a((Attributes)object2, "IsAbstract", false));
                    ((ModelParserBase)object3).ek = attributes;
                    ((ModelParserBase)object3).ej.setNodeClass(NodeClass.ObjectType);
                    break;
                }
                case 6: {
                    object = attributes;
                    object3 = this;
                    this.ej = super.a((Attributes)object);
                    object2 = object;
                    object = object3;
                    attributes = new ReferenceTypeAttributes();
                    super.a((Attributes)object2, (NodeAttributes)attributes);
                    attributes.setIsAbstract(ModelParserBase.a((Attributes)object2, "IsAbstract", false));
                    attributes.setSymmetric(ModelParserBase.a((Attributes)object2, "Symmetric", false));
                    ((ModelParserBase)object3).ek = attributes;
                    ((ModelParserBase)object3).ej.setNodeClass(NodeClass.ReferenceType);
                    break;
                }
                case 7: {
                    object = attributes;
                    object3 = this;
                    this.ej = super.a((Attributes)object);
                    object2 = object;
                    object = object3;
                    attributes = new VariableAttributes();
                    super.a((Attributes)object2, (NodeAttributes)attributes);
                    attributes.setAccessLevel(ModelParserBase.a((Attributes)object2, "AccessLevel", UnsignedByte.valueOf((int)1)));
                    attributes.setArrayDimensions(ModelParserBase.a((Attributes)object2, "ArrayDimensions", ""));
                    attributes.setDataType(((ModelParserBase)object).toGlobalNodeId(super.a((Attributes)object2, "DataType", Identifiers.BaseDataType)));
                    attributes.setHistorizing(ModelParserBase.a((Attributes)object2, "Historizing", false));
                    attributes.setMinimumSamplingInterval(ModelParserBase.a((Attributes)object2, "MinimumSamplingInterval", 0.0));
                    attributes.setUserAccessLevel(ModelParserBase.a((Attributes)object2, "UserAccessLevel", UnsignedByte.valueOf((int)1)));
                    attributes.setValueRank(ModelParserBase.a((Attributes)object2, "ValueRank", -2));
                    ((ModelParserBase)object3).ek = attributes;
                    ((ModelParserBase)object3).ej.setNodeClass(NodeClass.Variable);
                    break;
                }
                case 8: {
                    object = attributes;
                    object3 = this;
                    this.ej = super.a((Attributes)object);
                    object2 = object;
                    object = object3;
                    attributes = new VariableTypeAttributes();
                    super.a((Attributes)object2, (NodeAttributes)attributes);
                    attributes.setIsAbstract(ModelParserBase.a((Attributes)object2, "IsAbstract", false));
                    attributes.setValueRank(ModelParserBase.a((Attributes)object2, "ValueRank", -2));
                    attributes.setArrayDimensions(ModelParserBase.a((Attributes)object2, "ArrayDimensions", ""));
                    attributes.setDataType(((ModelParserBase)object).toGlobalNodeId(super.a((Attributes)object2, "DataType", Identifiers.BaseDataType)));
                    ((ModelParserBase)object3).ek = attributes;
                    ((ModelParserBase)object3).ej.setNodeClass(NodeClass.VariableType);
                    break;
                }
                case 9: {
                    object = attributes;
                    object3 = this;
                    this.ej = super.a((Attributes)object);
                    object2 = object;
                    object = object3;
                    attributes = new ViewAttributes();
                    super.a((Attributes)object2, (NodeAttributes)attributes);
                    attributes.setContainsNoLoops(ModelParserBase.a((Attributes)object2, "ContainsNoLoops", false));
                    ((ModelParserBase)object3).ek = attributes;
                    ((ModelParserBase)object3).ej.setNodeClass(NodeClass.View);
                    break;
                }
                case 10: {
                    this.b(attributes);
                    this.ar();
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    this.c(attributes);
                    this.ar();
                    break;
                }
                case 14: {
                    ++this.et;
                    object3 = this;
                    this.ew = new DOMResult();
                    ((ModelParserBase)object3).ev = XMLFactoryCache.getSAXTransformerFactory().newTransformerHandler();
                    ((ModelParserBase)object3).ev.setResult(((ModelParserBase)object3).ew);
                    ((ModelParserBase)object3).ev.startDocument();
                    logger.debug("Created valueHandler");
                    this.a((String)object, string, (String)object2, attributes);
                    logger.debug("Start - readingValue={}, element={}", (Object)this.et, (Object)string);
                    break;
                }
                case 16: {
                    break;
                }
                case 15: {
                    object = attributes;
                    object3 = this;
                    if (((ModelParserBase)object3).ej != null) {
                        ((ModelParserBase)object3).el = new AddReferencesItem();
                        ((ModelParserBase)object3).el.setIsForward(ModelParserBase.a((Attributes)object, "IsForward", true));
                        ((ModelParserBase)object3).el.setReferenceTypeId(((ModelParserBase)object3).toGlobalNodeId(super.a((Attributes)object, "ReferenceType", Identifiers.References)));
                        object = ((ModelParserBase)object3).toGlobalNodeId(((ModelParserBase)object3).ej.getRequestedNewNodeId());
                        ((ModelParserBase)object3).el.setSourceNodeId((NodeId)object);
                    }
                    this.ar();
                    break;
                }
                case 18: 
                case 19: {
                    break;
                }
                case 17: {
                    object3 = this;
                    this.er = true;
                    logger.debug("Reading extensions");
                    break;
                }
                default: {
                    logger.debug("Ignoring element {} in {}", (Object)string, (Object)this.ee);
                    return;
                }
            }
        }
        catch (Exception exception) {
            try {
                this.a(this.ec, this.bj, exception, "Error in ModelParser2.startElement: localName=" + string);
                return;
            }
            catch (ModelException modelException) {
                throw new SAXException("Error in ModelParser2.startElement: localName=" + string, modelException);
            }
        }
    }

    protected ExpandedNodeId toGlobalExpandedNodeId(NodeId nodeId) {
        NodeId nodeId2 = nodeId;
        ModelParserBase modelParserBase = this;
        String string = modelParserBase.eh.getUri(nodeId2.getNamespaceIndex());
        if (string == null) {
            throw new IllegalArgumentException("Invalid NamespaceIndex for nodeId=" + nodeId2 + " localNamespaceTable=" + modelParserBase.eh);
        }
        return new ExpandedNodeId(this.serverIndex, string, nodeId.getValue());
    }

    protected NodeId toGlobalNodeId(ExpandedNodeId expandedNodeId) {
        return NodeId.get((IdType)expandedNodeId.getIdType(), (int)this.getNamespaceTable().getIndex(expandedNodeId.getNamespaceUri()), (Object)expandedNodeId.getValue());
    }

    protected NodeId toGlobalNodeId(NodeId nodeId) {
        return NodeId.get((IdType)nodeId.getIdType(), (int)this.a(nodeId.getNamespaceIndex()), (Object)nodeId.getValue());
    }

    private final class a
    extends DefaultHandler {
        private /* synthetic */ ModelParserBase dJ;

        private a(ModelParserBase modelParserBase, byte by) {
            this.dJ = modelParserBase;
        }

        @Override
        public final void characters(char[] cArray, int n2, int n3) throws SAXException {
            this.dJ.characters(cArray, n2, n3);
        }

        @Override
        public final void endElement(String string, String string2, String string3) throws SAXException {
            this.dJ.endElement(string, string2, string3);
        }

        @Override
        public final void setDocumentLocator(Locator locator) {
            v0.locator = locator;
        }

        @Override
        public final void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.dJ.startElement(string, string2, string3, attributes);
        }

        /* synthetic */ a(ModelParserBase modelParserBase) {
            this(modelParserBase, 0);
        }
    }

    private static enum b {
        iB,
        iC,
        iD,
        iE,
        iF,
        iG,
        iH,
        iI,
        iJ,
        iK,
        iL,
        iM,
        iN,
        iO,
        iP,
        iQ,
        iR,
        iS,
        iT,
        iU,
        iV,
        iW,
        iX,
        iY;

    }
}

