/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import org.opcfoundation.ua.builtintypes.UnsignedByte;

public enum EventNotifierClass {
    HistoryRead(2),
    HistoryWrite(3),
    SubscribeToEvents(0);

    public static EnumSet<EventNotifierClass> ALL;
    public static EnumSet<EventNotifierClass> NONE;
    private int f;

    public static UnsignedByte getMask(Collection<EventNotifierClass> object) {
        byte by = 0;
        object = object.iterator();
        while (object.hasNext()) {
            EventNotifierClass eventNotifierClass = (EventNotifierClass)((Object)object.next());
            by = (byte)(by | eventNotifierClass.getValue());
        }
        return UnsignedByte.getFromBits((byte)by);
    }

    public static UnsignedByte getMask(EventNotifierClass ... eventNotifierClassArray) {
        byte by = 0;
        for (EventNotifierClass eventNotifierClass : eventNotifierClassArray) {
            by = (byte)(by | eventNotifierClass.getValue());
        }
        return UnsignedByte.getFromBits((byte)by);
    }

    public static EnumSet<EventNotifierClass> getSet(byte by) {
        ArrayList<EventNotifierClass> arrayList = new ArrayList<EventNotifierClass>();
        for (EventNotifierClass eventNotifierClass : EventNotifierClass.values()) {
            if ((by & eventNotifierClass.getValue()) != eventNotifierClass.getValue()) continue;
            arrayList.add(eventNotifierClass);
        }
        if (arrayList.isEmpty()) {
            return NONE;
        }
        return EnumSet.copyOf(arrayList);
    }

    public static EnumSet<EventNotifierClass> getSet(UnsignedByte unsignedByte) {
        return EventNotifierClass.getSet(unsignedByte.byteValue());
    }

    private EventNotifierClass(int n3) {
        if (n3 < 0 || n3 > 7) {
            throw new IllegalArgumentException("bitNr must be between 0 and 7");
        }
        this.f = n3;
    }

    public final int getBitNr() {
        return this.f;
    }

    public final int getValue() {
        return 1 << this.f;
    }

    static {
        ALL = EnumSet.allOf(EventNotifierClass.class);
        NONE = EnumSet.noneOf(EventNotifierClass.class);
    }
}

