/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.nodes.UaVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.core.Identifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventData {
    public static final QualifiedName[] EVENT_TYPE_PATH = new QualifiedName[]{new QualifiedName("EventType")};
    public static final QualifiedName[] TIME_PATH = new QualifiedName[]{new QualifiedName("Time")};
    private static final Logger logger = LoggerFactory.getLogger(EventData.class);
    private final List<LocalizedText> comments = new ArrayList<LocalizedText>();
    private final byte[] ir;
    private UaType b;
    private final Map<List<QualifiedName>, Variant> is = new HashMap<List<QualifiedName>, Variant>();
    private final NodeId nodeId;

    public EventData(NodeId nodeId, byte[] byArray) {
        logger.debug("EventData: nodeId={}", (Object)nodeId);
        this.nodeId = nodeId;
        this.ir = byArray;
    }

    public EventData(UaNode uaNode, byte[] object) {
        logger.debug("EventData: node={}", (Object)uaNode);
        this.nodeId = uaNode.getNodeId();
        this.ir = object;
        EventData eventData = this;
        UaNode uaNode2 = uaNode;
        object = eventData;
        eventData.c(uaNode2, null);
        EventData eventData2 = this;
        uaNode2 = uaNode;
        object = eventData2;
        eventData2.b(uaNode2, null);
        logger.debug("EventData: eventTypeId={}", (Object)this.getEventTypeId());
    }

    public void addComment(LocalizedText localizedText) {
        this.comments.add(localizedText);
    }

    public LocalizedText[] getComments() {
        return this.comments.toArray(new LocalizedText[this.comments.size()]);
    }

    public byte[] getEventId() {
        return this.ir;
    }

    public UaType getEventType() {
        return this.b;
    }

    public NodeId getEventTypeId() {
        if (this.b == null) {
            Variant variant = this.getFieldValue(EVENT_TYPE_PATH);
            if (variant == null) {
                return NodeId.NULL;
            }
            return (NodeId)variant.asClass(NodeId.class, (Object)NodeId.NULL);
        }
        return this.b.getNodeId();
    }

    public Set<List<QualifiedName>> getFieldNames() {
        return this.is.keySet();
    }

    public Variant getFieldValue(List<QualifiedName> qualifiedName) {
        Variant variant = this.is.get(qualifiedName);
        if (variant == null && (qualifiedName = qualifiedName.get(0)).getNamespaceIndex() == 0 && "EventId".equals(qualifiedName.getName())) {
            return new Variant((Object)this.getEventId());
        }
        logger.debug(" getFieldValue return:{}", (Object)variant);
        return variant;
    }

    public Variant getFieldValue(QualifiedName[] qualifiedNameArray) {
        return this.getFieldValue(Arrays.asList(qualifiedNameArray));
    }

    public Variant[] getFieldValues(List<List<QualifiedName>> list) {
        logger.debug("getFieldList");
        int n2 = list.size();
        Variant[] variantArray = new Variant[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                List<QualifiedName> list2 = list.get(i2);
                variantArray[i2] = list2 != null ? this.getFieldValue(list2) : new Variant((Object)this.getNodeId());
                logger.debug("getFieldList: field={}; fieldValue={}", list2, (Object)variantArray[i2]);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                logger.warn("getFieldList: " + indexOutOfBoundsException);
            }
        }
        return variantArray;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public DateTime getTime() {
        Variant variant = this.getFieldValue(TIME_PATH);
        if (variant == null) {
            return DateTime.MIN_VALUE;
        }
        return (DateTime)variant.asClass(DateTime.class, (Object)DateTime.MIN_VALUE);
    }

    public void setEventType(UaType uaType) {
        this.b = uaType;
    }

    public void setFieldValue(List<QualifiedName> list, Variant variant) {
        this.is.put(list, variant);
    }

    public void setFieldValue(QualifiedName[] qualifiedNameArray, Variant variant) {
        this.setFieldValue(Arrays.asList(qualifiedNameArray), variant);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("EventData: " + Arrays.toString(this.ir));
        for (List<QualifiedName> list : this.is.keySet()) {
            stringBuilder.append("\n " + list + "=" + this.getFieldValue(list));
        }
        return stringBuilder.toString();
    }

    private void b(UaNode objectArray, List<QualifiedName> list) {
        objectArray = objectArray.getReferences(Identifiers.HasComponent, false);
        if (logger.isDebugEnabled()) {
            logger.debug("addComponentFields: components=" + Arrays.toString(objectArray));
        }
        for (Object object : objectArray) {
            object = ((UaReference)object).getTargetNode();
            ArrayList<QualifiedName> arrayList = new ArrayList<QualifiedName>();
            if (list != null) {
                arrayList.addAll(list);
            }
            arrayList.add(object.getBrowseName());
            if (object instanceof UaVariable) {
                Variant variant = EventData.b((UaVariable)(object = (UaVariable)object));
                if (variant != null && !variant.isEmpty()) {
                    this.setFieldValue(arrayList, variant);
                }
                this.c((UaNode)object, arrayList);
                continue;
            }
            this.b((UaNode)object, arrayList);
        }
    }

    private void c(UaNode objectArray, List<QualifiedName> list) {
        Object[] objectArray2 = objectArray.getProperties();
        if (logger.isDebugEnabled()) {
            logger.debug("addPropertyFields: node=" + objectArray.getBrowseName() + "; properties=" + (objectArray2 == null ? "null" : Arrays.toString(objectArray2)));
            logger.debug("basePath=" + (list == null ? "null" : list.toString()));
        }
        if (objectArray2 != null) {
            objectArray = objectArray2;
            int n2 = objectArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object = objectArray[i2];
                ArrayList<QualifiedName> arrayList = new ArrayList<QualifiedName>(1);
                if (list != null) {
                    arrayList.addAll(list);
                }
                arrayList.add(object.getBrowseName());
                object = EventData.b((UaVariable)object);
                logger.debug("browsePath={}; v={}", arrayList, object);
                if (object == null || object.isEmpty()) continue;
                this.setFieldValue(arrayList, (Variant)object);
            }
        }
    }

    private static Variant b(UaVariable uaVariable) {
        if (uaVariable == null) {
            return null;
        }
        if ((uaVariable = uaVariable.getValue()) == null || uaVariable.isNull()) {
            return null;
        }
        return uaVariable.getValue();
    }
}

